/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.checkers.declaration;

import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.AbstractKtSourceElement;
import org.jetbrains.kotlin.KtFakeSourceElementKind;
import org.jetbrains.kotlin.KtSourceElement;
import org.jetbrains.kotlin.KtSourceElementKind;
import org.jetbrains.kotlin.diagnostics.DiagnosticContext;
import org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticReportHelpersKt;
import org.jetbrains.kotlin.fir.analysis.checkers.FirHelpersKt;
import org.jetbrains.kotlin.fir.analysis.checkers.FirTypeRefSource;
import org.jetbrains.kotlin.fir.analysis.checkers.MppCheckerKind;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.checkers.declaration.FirDeclarationChecker;
import org.jetbrains.kotlin.fir.analysis.diagnostics.FirErrors;
import org.jetbrains.kotlin.fir.declarations.FirCallableDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirClass;
import org.jetbrains.kotlin.fir.declarations.FirDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirPropertyAccessor;
import org.jetbrains.kotlin.fir.declarations.FirTypeAlias;
import org.jetbrains.kotlin.fir.resolve.TypeExpansionUtilsKt;
import org.jetbrains.kotlin.fir.symbols.impl.FirClassLikeSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirRegularClassSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirTypeParameterSymbol;
import org.jetbrains.kotlin.fir.types.ConeClassLikeType;
import org.jetbrains.kotlin.fir.types.ConeKotlinType;
import org.jetbrains.kotlin.fir.types.ConeKotlinTypeConflictingProjection;
import org.jetbrains.kotlin.fir.types.ConeKotlinTypeProjectionIn;
import org.jetbrains.kotlin.fir.types.ConeKotlinTypeProjectionOut;
import org.jetbrains.kotlin.fir.types.ConeTypeProjection;
import org.jetbrains.kotlin.fir.types.FirResolvedTypeRef;
import org.jetbrains.kotlin.fir.types.FirTypeRef;
import org.jetbrains.kotlin.fir.types.TypeUtilsKt;
import org.jetbrains.kotlin.types.Variance;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001j\u0002`\u0003:\u0001\u000fB\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0004J \u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J \u0010\f\u001a\u00020\u00062\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirProjectionRelationChecker;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirDeclarationChecker;", "Lorg/jetbrains/kotlin/fir/declarations/FirDeclaration;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirBasicDeclarationChecker;", "()V", "check", "", "declaration", "context", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "reporter", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "checkTypeRef", "typeRef", "Lorg/jetbrains/kotlin/fir/types/FirTypeRef;", "ProjectionRelation", "checkers"})
@SourceDebugExtension(value={"SMAP\nFirProjectionRelationChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FirProjectionRelationChecker.kt\norg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirProjectionRelationChecker\n+ 2 FirTypeUtils.kt\norg/jetbrains/kotlin/fir/types/FirTypeUtilsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,102:1\n22#2,4:103\n1#3:107\n*S KotlinDebug\n*F\n+ 1 FirProjectionRelationChecker.kt\norg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirProjectionRelationChecker\n*L\n49#1:103,4\n*E\n"})
public final class FirProjectionRelationChecker
extends FirDeclarationChecker<FirDeclaration> {
    @NotNull
    public static final FirProjectionRelationChecker INSTANCE = new FirProjectionRelationChecker();

    private FirProjectionRelationChecker() {
        super(MppCheckerKind.Common);
    }

    @Override
    public void check(@NotNull FirDeclaration declaration, @NotNull CheckerContext context2, @NotNull DiagnosticReporter reporter2) {
        FirDeclaration firDeclaration;
        Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)reporter2, (String)"reporter");
        if (declaration instanceof FirPropertyAccessor) {
            return;
        }
        if (declaration instanceof FirCallableDeclaration) {
            this.checkTypeRef(((FirCallableDeclaration)declaration).getReturnTypeRef(), context2, reporter2);
        }
        if ((firDeclaration = declaration) instanceof FirClass) {
            for (FirTypeRef it : ((FirClass)declaration).getSuperTypeRefs()) {
                this.checkTypeRef(it, context2, reporter2);
            }
        } else if (firDeclaration instanceof FirTypeAlias) {
            this.checkTypeRef(((FirTypeAlias)declaration).getExpandedTypeRef(), context2, reporter2);
        }
    }

    private final void checkTypeRef(FirTypeRef typeRef, CheckerContext context2, DiagnosticReporter reporter2) {
        ConeClassLikeType type2;
        ConeClassLikeType coneClassLikeType;
        Object object = typeRef.getSource();
        if (!(object != null && (object = ((KtSourceElement)object).getKind()) != null ? !((KtSourceElementKind)object).getShouldSkipErrorTypeReporting() : false)) {
            return;
        }
        FirTypeRef $this$coneTypeSafe$iv = typeRef;
        boolean $i$f$coneTypeSafe = false;
        FirResolvedTypeRef firResolvedTypeRef = $this$coneTypeSafe$iv instanceof FirResolvedTypeRef ? (FirResolvedTypeRef)$this$coneTypeSafe$iv : null;
        ConeKotlinType coneKotlinType = firResolvedTypeRef != null ? firResolvedTypeRef.getType() : null;
        if (!(coneKotlinType instanceof ConeClassLikeType)) {
            coneKotlinType = null;
        }
        if ((coneClassLikeType = (type2 = (ConeClassLikeType)((ConeKotlinType)((ConeClassLikeType)coneKotlinType)))) == null || (coneClassLikeType = TypeExpansionUtilsKt.fullyExpandedType$default(coneClassLikeType, context2.getSession(), null, 2, null)) == null) {
            return;
        }
        ConeClassLikeType fullyExpandedType2 = coneClassLikeType;
        FirClassLikeSymbol<?> firClassLikeSymbol = TypeUtilsKt.toSymbol(fullyExpandedType2, context2.getSession());
        FirRegularClassSymbol firRegularClassSymbol = firClassLikeSymbol instanceof FirRegularClassSymbol ? (FirRegularClassSymbol)firClassLikeSymbol : null;
        if (firRegularClassSymbol == null) {
            return;
        }
        FirRegularClassSymbol declaration = firRegularClassSymbol;
        List<FirTypeParameterSymbol> typeParameters2 = declaration.getTypeParameterSymbols();
        ConeTypeProjection[] typeArguments = type2.getTypeArguments();
        int size = Math.min(typeParameters2.size(), typeArguments.length);
        List<FirTypeRefSource> list2 = FirHelpersKt.extractArgumentsTypeRefAndSource(typeRef);
        if (list2 == null) {
            return;
        }
        List<FirTypeRefSource> typeRefAndSourcesForArguments = list2;
        for (int it = 0; it < size; ++it) {
            FirTypeRef it2;
            FirTypeRefSource argTypeRefSource;
            ProjectionRelation projectionRelation;
            FirTypeParameterSymbol proto = typeParameters2.get(it);
            ConeTypeProjection actual = typeArguments[it];
            ConeTypeProjection fullyExpandedProjection = fullyExpandedType2.getTypeArguments()[it];
            Variance protoVariance = proto.getVariance();
            ProjectionRelation projectionRelation2 = fullyExpandedProjection instanceof ConeKotlinTypeConflictingProjection || actual instanceof ConeKotlinTypeProjectionIn && protoVariance == Variance.OUT_VARIANCE || actual instanceof ConeKotlinTypeProjectionOut && protoVariance == Variance.IN_VARIANCE ? ProjectionRelation.Conflicting : (projectionRelation = actual instanceof ConeKotlinTypeProjectionIn && protoVariance == Variance.IN_VARIANCE || actual instanceof ConeKotlinTypeProjectionOut && protoVariance == Variance.OUT_VARIANCE ? ProjectionRelation.Redundant : ProjectionRelation.None);
            if ((FirTypeRefSource)CollectionsKt.getOrNull(typeRefAndSourcesForArguments, (int)it) == null) continue;
            if (projectionRelation != ProjectionRelation.None) {
                KtSourceElement ktSourceElement = typeRef.getSource();
                if (!((ktSourceElement != null ? ktSourceElement.getKind() : null) instanceof KtFakeSourceElementKind)) {
                    KtSourceElement ktSourceElement2 = argTypeRefSource.getSource();
                    if (ktSourceElement2 == null) {
                        FirTypeRef firTypeRef = argTypeRefSource.getTypeRef();
                        ktSourceElement2 = firTypeRef != null ? firTypeRef.getSource() : null;
                    }
                    KtDiagnosticReportHelpersKt.reportOn$default(reporter2, (AbstractKtSourceElement)ktSourceElement2, projectionRelation == ProjectionRelation.Conflicting ? (!Intrinsics.areEqual((Object)type2, (Object)fullyExpandedType2) ? FirErrors.INSTANCE.getCONFLICTING_PROJECTION_IN_TYPEALIAS_EXPANSION() : FirErrors.INSTANCE.getCONFLICTING_PROJECTION()) : FirErrors.INSTANCE.getREDUNDANT_PROJECTION(), (Object)fullyExpandedType2, (DiagnosticContext)context2, null, 16, null);
                }
            }
            if (argTypeRefSource.getTypeRef() == null) continue;
            boolean bl = false;
            INSTANCE.checkTypeRef(it2, context2, reporter2);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0005\b\u0082\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005\u00a8\u0006\u0006"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirProjectionRelationChecker$ProjectionRelation;", "", "(Ljava/lang/String;I)V", "Conflicting", "Redundant", "None", "checkers"})
    private static final class ProjectionRelation
    extends Enum<ProjectionRelation> {
        public static final /* enum */ ProjectionRelation Conflicting = new ProjectionRelation();
        public static final /* enum */ ProjectionRelation Redundant = new ProjectionRelation();
        public static final /* enum */ ProjectionRelation None = new ProjectionRelation();
        private static final /* synthetic */ ProjectionRelation[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static ProjectionRelation[] values() {
            return (ProjectionRelation[])$VALUES.clone();
        }

        public static ProjectionRelation valueOf(String value2) {
            return Enum.valueOf(ProjectionRelation.class, value2);
        }

        @NotNull
        public static EnumEntries<ProjectionRelation> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = projectionRelationArray = new ProjectionRelation[]{ProjectionRelation.Conflicting, ProjectionRelation.Redundant, ProjectionRelation.None};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }
}

