/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.jvm.checkers.declaration;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.AbstractKtSourceElement;
import org.jetbrains.kotlin.diagnostics.DiagnosticContext;
import org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticFactory2;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticReportHelpersKt;
import org.jetbrains.kotlin.fir.analysis.checkers.MppCheckerKind;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.checkers.declaration.FirDeclarationChecker;
import org.jetbrains.kotlin.fir.analysis.diagnostics.jvm.FirJvmErrors;
import org.jetbrains.kotlin.fir.declarations.FirAnnotationUtilsKt;
import org.jetbrains.kotlin.fir.declarations.FirDeclaration;
import org.jetbrains.kotlin.fir.expressions.FirAnnotation;
import org.jetbrains.kotlin.fir.symbols.ConeClassLikeLookupTag;
import org.jetbrains.kotlin.fir.types.ConeClassLikeType;
import org.jetbrains.kotlin.fir.types.ConeKotlinType;
import org.jetbrains.kotlin.fir.types.FirResolvedTypeRef;
import org.jetbrains.kotlin.fir.types.FirTypeRef;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.JvmStandardClassIds;
import org.jetbrains.kotlin.name.StandardClassIds;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001j\u0002`\u0003B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0004J \u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016\u00a8\u0006\f"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/jvm/checkers/declaration/FirJvmRedundantRepeatableChecker;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirDeclarationChecker;", "Lorg/jetbrains/kotlin/fir/declarations/FirDeclaration;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirBasicDeclarationChecker;", "()V", "check", "", "declaration", "context", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "reporter", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "checkers.jvm"})
@SourceDebugExtension(value={"SMAP\nFirJvmRedundantRepeatableChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FirJvmRedundantRepeatableChecker.kt\norg/jetbrains/kotlin/fir/analysis/jvm/checkers/declaration/FirJvmRedundantRepeatableChecker\n+ 2 FirExpressionUtil.kt\norg/jetbrains/kotlin/fir/expressions/FirExpressionUtilKt\n*L\n1#1,40:1\n33#2:41\n30#2:42\n33#2:43\n30#2:44\n*S KotlinDebug\n*F\n+ 1 FirJvmRedundantRepeatableChecker.kt\norg/jetbrains/kotlin/fir/analysis/jvm/checkers/declaration/FirJvmRedundantRepeatableChecker\n*L\n32#1:41\n32#1:42\n33#1:43\n33#1:44\n*E\n"})
public final class FirJvmRedundantRepeatableChecker
extends FirDeclarationChecker<FirDeclaration> {
    @NotNull
    public static final FirJvmRedundantRepeatableChecker INSTANCE = new FirJvmRedundantRepeatableChecker();

    private FirJvmRedundantRepeatableChecker() {
        super(MppCheckerKind.Common);
    }

    @Override
    public void check(@NotNull FirDeclaration declaration, @NotNull CheckerContext context2, @NotNull DiagnosticReporter reporter2) {
        FirAnnotation javaRepeatable;
        Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)reporter2, (String)"reporter");
        FirAnnotation kotlinRepeatable = FirAnnotationUtilsKt.getAnnotationByClassId(declaration, StandardClassIds.Annotations.INSTANCE.getRepeatable(), context2.getSession());
        FirAnnotation firAnnotation = FirAnnotationUtilsKt.getAnnotationByClassId(declaration, JvmStandardClassIds.Annotations.INSTANCE.getJvmRepeatable(), context2.getSession());
        if (firAnnotation == null) {
            firAnnotation = javaRepeatable = FirAnnotationUtilsKt.getAnnotationByClassId(declaration, JvmStandardClassIds.Annotations.Java.INSTANCE.getRepeatable(), context2.getSession());
        }
        if (kotlinRepeatable != null && javaRepeatable != null) {
            Object object;
            Object object2;
            AbstractKtSourceElement abstractKtSourceElement = kotlinRepeatable.getSource();
            KtDiagnosticFactory2<FqName, FqName> ktDiagnosticFactory2 = FirJvmErrors.INSTANCE.getREDUNDANT_REPEATABLE_ANNOTATION();
            FirAnnotation $this$unexpandedClassId$iv = kotlinRepeatable;
            boolean $i$f$getUnexpandedClassId = false;
            FirAnnotation $this$unexpandedConeClassLikeType$iv$iv = $this$unexpandedClassId$iv;
            boolean $i$f$getUnexpandedConeClassLikeType = false;
            FirTypeRef firTypeRef = $this$unexpandedConeClassLikeType$iv$iv.getAnnotationTypeRef();
            FirResolvedTypeRef firResolvedTypeRef = firTypeRef instanceof FirResolvedTypeRef ? (FirResolvedTypeRef)firTypeRef : null;
            ConeKotlinType coneKotlinType = firResolvedTypeRef != null ? firResolvedTypeRef.getType() : null;
            Object object3 = coneKotlinType instanceof ConeClassLikeType ? (ConeClassLikeType)coneKotlinType : null;
            if ((object3 != null && (object3 = ((ConeClassLikeType)object3).getLookupTag()) != null ? ((ConeClassLikeLookupTag)object3).getClassId() : (object2 = null)) == null || (object2 = ((ClassId)object2).asSingleFqName()) == null) {
                object2 = FqName.ROOT;
            }
            Object object4 = object2;
            Intrinsics.checkNotNull((Object)object4);
            Object object5 = object4;
            $this$unexpandedClassId$iv = javaRepeatable;
            $i$f$getUnexpandedClassId = false;
            $this$unexpandedConeClassLikeType$iv$iv = $this$unexpandedClassId$iv;
            $i$f$getUnexpandedConeClassLikeType = false;
            firTypeRef = $this$unexpandedConeClassLikeType$iv$iv.getAnnotationTypeRef();
            FirResolvedTypeRef firResolvedTypeRef2 = firTypeRef instanceof FirResolvedTypeRef ? (FirResolvedTypeRef)firTypeRef : null;
            coneKotlinType = firResolvedTypeRef2 != null ? firResolvedTypeRef2.getType() : null;
            Object object6 = coneKotlinType instanceof ConeClassLikeType ? (ConeClassLikeType)coneKotlinType : null;
            if ((object6 != null && (object6 = ((ConeClassLikeType)object6).getLookupTag()) != null ? ((ConeClassLikeLookupTag)object6).getClassId() : (object = null)) == null || (object = ((ClassId)object).asSingleFqName()) == null) {
                object = FqName.ROOT;
            }
            object4 = object;
            Intrinsics.checkNotNull((Object)object4);
            KtDiagnosticReportHelpersKt.reportOn$default(reporter2, abstractKtSourceElement, ktDiagnosticFactory2, object5, object4, (DiagnosticContext)context2, null, 32, null);
        }
    }
}

