/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.ir.util;

import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.ir.IrElement;
import org.jetbrains.kotlin.ir.IrElementBase;
import org.jetbrains.kotlin.ir.IrStatement;
import org.jetbrains.kotlin.ir.declarations.IrDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrFile;
import org.jetbrains.kotlin.ir.declarations.IrFunction;
import org.jetbrains.kotlin.ir.expressions.IrContainerExpression;
import org.jetbrains.kotlin.ir.expressions.IrFunctionExpression;
import org.jetbrains.kotlin.ir.expressions.IrFunctionReference;
import org.jetbrains.kotlin.ir.expressions.IrInlinedFunctionBlock;
import org.jetbrains.kotlin.ir.expressions.IrPropertyReference;
import org.jetbrains.kotlin.ir.expressions.IrReturnableBlock;
import org.jetbrains.kotlin.ir.symbols.IrFileSymbol;
import org.jetbrains.kotlin.ir.symbols.IrFunctionSymbol;
import org.jetbrains.kotlin.ir.symbols.IrPropertySymbol;
import org.jetbrains.kotlin.ir.util.DumpIrTreeKt;
import org.jetbrains.kotlin.ir.util.IrUtilsKt;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u00006\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\u001a\n\u0010\u0013\u001a\u00020\u0014*\u00020\u0002\u001a\n\u0010\u0015\u001a\u00020\u0014*\u00020\u0002\"\u0015\u0010\u0000\u001a\u00020\u0001*\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\u0003\u0010\u0004\"\u001a\u0010\u0005\u001a\u0004\u0018\u00010\u0006*\u00020\u00028BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\b\"\u0017\u0010\u0005\u001a\u0004\u0018\u00010\u0006*\u00020\t8F\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\n\"\u0015\u0010\u000b\u001a\u00020\f*\u00020\f8F\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000e\"\u0017\u0010\u000f\u001a\u0004\u0018\u00010\u0010*\u00020\t8F\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006\u0016"}, d2={"inlineDeclaration", "Lorg/jetbrains/kotlin/ir/declarations/IrDeclaration;", "Lorg/jetbrains/kotlin/ir/expressions/IrInlinedFunctionBlock;", "getInlineDeclaration", "(Lorg/jetbrains/kotlin/ir/expressions/IrInlinedFunctionBlock;)Lorg/jetbrains/kotlin/ir/declarations/IrDeclaration;", "inlineFunction", "Lorg/jetbrains/kotlin/ir/declarations/IrFunction;", "getInlineFunction", "(Lorg/jetbrains/kotlin/ir/expressions/IrInlinedFunctionBlock;)Lorg/jetbrains/kotlin/ir/declarations/IrFunction;", "Lorg/jetbrains/kotlin/ir/expressions/IrReturnableBlock;", "(Lorg/jetbrains/kotlin/ir/expressions/IrReturnableBlock;)Lorg/jetbrains/kotlin/ir/declarations/IrFunction;", "innerInlinedBlockOrThis", "Lorg/jetbrains/kotlin/ir/expressions/IrContainerExpression;", "getInnerInlinedBlockOrThis", "(Lorg/jetbrains/kotlin/ir/expressions/IrContainerExpression;)Lorg/jetbrains/kotlin/ir/expressions/IrContainerExpression;", "sourceFileSymbol", "Lorg/jetbrains/kotlin/ir/symbols/IrFileSymbol;", "getSourceFileSymbol", "(Lorg/jetbrains/kotlin/ir/expressions/IrReturnableBlock;)Lorg/jetbrains/kotlin/ir/symbols/IrFileSymbol;", "isFunctionInlining", "", "isLambdaInlining", "ir.tree"})
@SourceDebugExtension(value={"SMAP\nIrInlineUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 IrInlineUtils.kt\norg/jetbrains/kotlin/ir/util/IrInlineUtilsKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,42:1\n1#2:43\n*E\n"})
public final class IrInlineUtilsKt {
    @NotNull
    public static final IrDeclaration getInlineDeclaration(@NotNull IrInlinedFunctionBlock $this$inlineDeclaration) {
        IrDeclaration irDeclaration2;
        Intrinsics.checkNotNullParameter((Object)$this$inlineDeclaration, (String)"<this>");
        IrElement element = $this$inlineDeclaration.getInlinedElement();
        if (element instanceof IrFunction) {
            irDeclaration2 = (IrDeclaration)element;
        } else if (element instanceof IrFunctionExpression) {
            irDeclaration2 = ((IrFunctionExpression)element).getFunction();
        } else if (element instanceof IrFunctionReference) {
            irDeclaration2 = ((IrFunctionSymbol)((IrFunctionReference)element).getSymbol()).getOwner();
        } else if (element instanceof IrPropertyReference) {
            irDeclaration2 = (IrDeclaration)((IrPropertySymbol)((IrPropertyReference)element).getSymbol()).getOwner();
        } else {
            throw new AssertionError((Object)("Not supported ir element for inlining " + DumpIrTreeKt.dump$default(element, null, 1, null)));
        }
        return irDeclaration2;
    }

    private static final IrFunction getInlineFunction(IrInlinedFunctionBlock $this$inlineFunction) {
        IrFunction irFunction;
        IrElement element = $this$inlineFunction.getInlinedElement();
        if (element instanceof IrFunction) {
            irFunction = (IrFunction)element;
        } else if (element instanceof IrFunctionExpression) {
            irFunction = ((IrFunctionExpression)element).getFunction();
        } else if (element instanceof IrFunctionReference) {
            IrFunction irFunction2;
            IrFunction it = irFunction2 = ((IrFunctionSymbol)((IrFunctionReference)element).getSymbol()).getOwner();
            boolean bl = false;
            irFunction = it.isInline() ? irFunction2 : null;
        } else {
            irFunction = null;
        }
        return irFunction;
    }

    public static final boolean isFunctionInlining(@NotNull IrInlinedFunctionBlock $this$isFunctionInlining) {
        Intrinsics.checkNotNullParameter((Object)$this$isFunctionInlining, (String)"<this>");
        return $this$isFunctionInlining.getInlinedElement() instanceof IrFunction;
    }

    public static final boolean isLambdaInlining(@NotNull IrInlinedFunctionBlock $this$isLambdaInlining) {
        Intrinsics.checkNotNullParameter((Object)$this$isLambdaInlining, (String)"<this>");
        return !IrInlineUtilsKt.isFunctionInlining($this$isLambdaInlining);
    }

    @NotNull
    public static final IrContainerExpression getInnerInlinedBlockOrThis(@NotNull IrContainerExpression $this$innerInlinedBlockOrThis) {
        Intrinsics.checkNotNullParameter((Object)$this$innerInlinedBlockOrThis, (String)"<this>");
        Object object = $this$innerInlinedBlockOrThis instanceof IrReturnableBlock ? (IrReturnableBlock)$this$innerInlinedBlockOrThis : null;
        IrStatement irStatement = object != null && (object = ((IrContainerExpression)object).getStatements()) != null ? (IrStatement)CollectionsKt.singleOrNull((List)object) : null;
        IrInlinedFunctionBlock irInlinedFunctionBlock = irStatement instanceof IrInlinedFunctionBlock ? (IrInlinedFunctionBlock)irStatement : null;
        return irInlinedFunctionBlock != null ? (IrContainerExpression)irInlinedFunctionBlock : $this$innerInlinedBlockOrThis;
    }

    @Nullable
    public static final IrFunction getInlineFunction(@NotNull IrReturnableBlock $this$inlineFunction) {
        Intrinsics.checkNotNullParameter((Object)$this$inlineFunction, (String)"<this>");
        Object object = CollectionsKt.singleOrNull($this$inlineFunction.getStatements());
        IrInlinedFunctionBlock irInlinedFunctionBlock = object instanceof IrInlinedFunctionBlock ? (IrInlinedFunctionBlock)object : null;
        return irInlinedFunctionBlock != null ? IrInlineUtilsKt.getInlineFunction(irInlinedFunctionBlock) : null;
    }

    @Nullable
    public static final IrFileSymbol getSourceFileSymbol(@NotNull IrReturnableBlock $this$sourceFileSymbol) {
        Intrinsics.checkNotNullParameter((Object)$this$sourceFileSymbol, (String)"<this>");
        IrElementBase irElementBase = IrInlineUtilsKt.getInlineFunction($this$sourceFileSymbol);
        return irElementBase != null && (irElementBase = IrUtilsKt.getFileOrNull((IrDeclaration)((Object)irElementBase))) != null ? ((IrFile)irElementBase).getSymbol() : null;
    }
}

