/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.checkers.expression;

import java.util.Collection;
import java.util.List;
import java.util.ListIterator;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.AbstractKtSourceElement;
import org.jetbrains.kotlin.KtSourceElement;
import org.jetbrains.kotlin.diagnostics.DiagnosticContext;
import org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticReportHelpersKt;
import org.jetbrains.kotlin.fir.ClassMembersKt;
import org.jetbrains.kotlin.fir.FirElement;
import org.jetbrains.kotlin.fir.analysis.checkers.MppCheckerKind;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.checkers.expression.FirExpressionChecker;
import org.jetbrains.kotlin.fir.analysis.checkers.expression.FirOptInUsageBaseChecker;
import org.jetbrains.kotlin.fir.analysis.diagnostics.FirErrors;
import org.jetbrains.kotlin.fir.declarations.FirDeclaration;
import org.jetbrains.kotlin.fir.expressions.FirQualifiedAccessExpression;
import org.jetbrains.kotlin.fir.expressions.FirResolvedQualifier;
import org.jetbrains.kotlin.fir.resolve.LookupTagUtilsKt;
import org.jetbrains.kotlin.fir.symbols.ConeClassLikeLookupTag;
import org.jetbrains.kotlin.fir.symbols.FirBasedSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirClassLikeSymbol;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001j\u0002`\u0003B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0004J \u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J \u0010\f\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002J \u0010\r\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002J)\u0010\u000e\u001a\u00020\u0006*\u0006\u0012\u0002\b\u00030\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0082\u0010\u00a8\u0006\u0012"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/checkers/expression/FirOptInUsageQualifierChecker;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/expression/FirExpressionChecker;", "Lorg/jetbrains/kotlin/fir/expressions/FirResolvedQualifier;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/expression/FirResolvedQualifierChecker;", "()V", "check", "", "expression", "context", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "reporter", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "checkMarkerUsedAsQualifier", "checkNotAcceptedExperimentalities", "checkContainingClasses", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirClassLikeSymbol;", "source", "Lorg/jetbrains/kotlin/KtSourceElement;", "checkers"})
@SourceDebugExtension(value={"SMAP\nFirOptInUsageQualifierChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FirOptInUsageQualifierChecker.kt\norg/jetbrains/kotlin/fir/analysis/checkers/expression/FirOptInUsageQualifierChecker\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,55:1\n533#2,6:56\n2622#2,3:62\n*S KotlinDebug\n*F\n+ 1 FirOptInUsageQualifierChecker.kt\norg/jetbrains/kotlin/fir/analysis/checkers/expression/FirOptInUsageQualifierChecker\n*L\n37#1:56,6\n47#1:62,3\n*E\n"})
public final class FirOptInUsageQualifierChecker
extends FirExpressionChecker<FirResolvedQualifier> {
    @NotNull
    public static final FirOptInUsageQualifierChecker INSTANCE = new FirOptInUsageQualifierChecker();

    private FirOptInUsageQualifierChecker() {
        super(MppCheckerKind.Common);
    }

    @Override
    public void check(@NotNull FirResolvedQualifier expression2, @NotNull CheckerContext context2, @NotNull DiagnosticReporter reporter2) {
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)reporter2, (String)"reporter");
        this.checkNotAcceptedExperimentalities(expression2, context2, reporter2);
        this.checkMarkerUsedAsQualifier(expression2, context2, reporter2);
    }

    private final void checkNotAcceptedExperimentalities(FirResolvedQualifier expression2, CheckerContext context2, DiagnosticReporter reporter2) {
        FirClassLikeSymbol<?> firClassLikeSymbol = expression2.getSymbol();
        if (firClassLikeSymbol == null) {
            return;
        }
        FirClassLikeSymbol<?> symbol2 = firClassLikeSymbol;
        FirOptInUsageBaseChecker $this$checkNotAcceptedExperimentalities_u24lambda_u240 = FirOptInUsageBaseChecker.INSTANCE;
        boolean bl = false;
        Set<FirOptInUsageBaseChecker.Experimentality> experimentalities = $this$checkNotAcceptedExperimentalities_u24lambda_u240.loadExperimentalities((FirBasedSymbol)symbol2, context2, false, null);
        FirOptInUsageBaseChecker.reportNotAcceptedExperimentalities$default($this$checkNotAcceptedExperimentalities_u24lambda_u240, experimentalities, expression2, context2, reporter2, null, 16, null);
    }

    private final void checkMarkerUsedAsQualifier(FirResolvedQualifier expression2, CheckerContext context2, DiagnosticReporter reporter2) {
        block3: {
            FirElement parentExpression;
            Object object;
            FirElement firElement;
            block2: {
                List<FirElement> containingElements;
                List<FirElement> $this$lastOrNull$iv = containingElements = context2.getContainingElements();
                boolean $i$f$lastOrNull = false;
                ListIterator<FirElement> iterator$iv = $this$lastOrNull$iv.listIterator($this$lastOrNull$iv.size());
                while (iterator$iv.hasPrevious()) {
                    FirElement element$iv;
                    FirElement it = element$iv = iterator$iv.previous();
                    boolean bl = false;
                    if (!(it instanceof FirQualifiedAccessExpression && Intrinsics.areEqual((Object)((FirQualifiedAccessExpression)it).getDispatchReceiver(), (Object)expression2))) continue;
                    firElement = element$iv;
                    break block2;
                }
                firElement = null;
            }
            if ((object = (parentExpression = (FirElement)firElement)) == null || (object = object.getSource()) == null) {
                return;
            }
            Object source = object;
            FirClassLikeSymbol<?> firClassLikeSymbol = expression2.getSymbol();
            if (firClassLikeSymbol == null) break block3;
            this.checkContainingClasses(firClassLikeSymbol, (KtSourceElement)source, context2, reporter2);
        }
    }

    private final void checkContainingClasses(FirClassLikeSymbol<?> $this$checkContainingClasses, KtSourceElement source, CheckerContext context2, DiagnosticReporter reporter2) {
        while (true) {
            Object object;
            if (FirOptInUsageBaseChecker.INSTANCE.isExperimentalMarker((FirClassLikeSymbol<?>)$this$checkContainingClasses, context2.getSession())) {
                boolean bl;
                block7: {
                    Iterable $this$none$iv = context2.getContainingDeclarations();
                    boolean $i$f$none = false;
                    if ($this$none$iv instanceof Collection && ((Collection)$this$none$iv).isEmpty()) {
                        bl = true;
                    } else {
                        for (Object element$iv : $this$none$iv) {
                            FirDeclaration it = (FirDeclaration)element$iv;
                            boolean bl2 = false;
                            if (!Intrinsics.areEqual(it.getSymbol(), (Object)$this$checkContainingClasses)) continue;
                            bl = false;
                            break block7;
                        }
                        bl = true;
                    }
                }
                if (bl) {
                    KtDiagnosticReportHelpersKt.reportOn$default(reporter2, (AbstractKtSourceElement)source, FirErrors.INSTANCE.getOPT_IN_MARKER_CAN_ONLY_BE_USED_AS_ANNOTATION_OR_ARGUMENT_IN_OPT_IN(), (DiagnosticContext)context2, null, 8, null);
                }
            }
            if ((object = ClassMembersKt.getContainingClassLookupTag($this$checkContainingClasses)) == null || (object = LookupTagUtilsKt.toSymbol((ConeClassLikeLookupTag)object, context2.getSession())) == null) {
                return;
            }
            Object containingClassSymbol = object;
            FirOptInUsageQualifierChecker firOptInUsageQualifierChecker = this_;
            Object object2 = source;
            CheckerContext checkerContext = context2;
            DiagnosticReporter diagnosticReporter = reporter2;
            FirOptInUsageQualifierChecker this_ = firOptInUsageQualifierChecker;
            $this$checkContainingClasses = containingClassSymbol;
            source = object2;
            context2 = checkerContext;
            reporter2 = diagnosticReporter;
        }
    }
}

