/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.java.deserialization;

import java.lang.constant.Constable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.LazyThreadSafetyMode;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.annotations.AnnotationUseSiteTarget;
import org.jetbrains.kotlin.fir.FirLanguageSettingsComponentKt;
import org.jetbrains.kotlin.fir.FirSession;
import org.jetbrains.kotlin.fir.deserialization.AbstractAnnotationDeserializer;
import org.jetbrains.kotlin.fir.expressions.FirAnnotation;
import org.jetbrains.kotlin.fir.expressions.FirExpression;
import org.jetbrains.kotlin.fir.expressions.FirLiteralExpression;
import org.jetbrains.kotlin.fir.expressions.builder.FirAnnotationBuilder;
import org.jetbrains.kotlin.fir.java.JavaUtilsKt;
import org.jetbrains.kotlin.fir.java.deserialization.JvmBinaryAnnotationDeserializerKt;
import org.jetbrains.kotlin.fir.java.deserialization.MemberAnnotations;
import org.jetbrains.kotlin.fir.types.ConeBuiltinTypeUtilsKt;
import org.jetbrains.kotlin.fir.types.FirTypeRef;
import org.jetbrains.kotlin.fir.types.FirTypeUtilsKt;
import org.jetbrains.kotlin.load.kotlin.AbstractBinaryClassAnnotationLoaderKt;
import org.jetbrains.kotlin.load.kotlin.KotlinClassFinder;
import org.jetbrains.kotlin.load.kotlin.KotlinJvmBinaryClass;
import org.jetbrains.kotlin.load.kotlin.MemberSignature;
import org.jetbrains.kotlin.metadata.ProtoBuf;
import org.jetbrains.kotlin.metadata.deserialization.Flags;
import org.jetbrains.kotlin.metadata.deserialization.NameResolver;
import org.jetbrains.kotlin.metadata.deserialization.ProtoBufUtilKt;
import org.jetbrains.kotlin.metadata.deserialization.ProtoTypeTableUtilKt;
import org.jetbrains.kotlin.metadata.deserialization.TypeTable;
import org.jetbrains.kotlin.metadata.jvm.JvmProtoBuf;
import org.jetbrains.kotlin.metadata.jvm.deserialization.JvmFlags;
import org.jetbrains.kotlin.metadata.jvm.deserialization.JvmMemberSignature;
import org.jetbrains.kotlin.metadata.jvm.deserialization.JvmProtoBufUtil;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.protobuf.GeneratedMessageLite;
import org.jetbrains.kotlin.protobuf.MessageLite;
import org.jetbrains.kotlin.serialization.deserialization.builtins.BuiltInSerializerProtocol;
import org.jetbrains.kotlin.serialization.deserialization.descriptors.DeserializedContainerSource;
import org.jetbrains.kotlin.types.ConstantValueKind;
import org.jetbrains.kotlin.utils.MetadataHelpersKt;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u00bc\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\b\u0010\b\u001a\u0004\u0018\u00010\t\u00a2\u0006\u0002\u0010\nJ\u001a\u0010\u001e\u001a\u00020\u001f2\b\u0010 \u001a\u0004\u0018\u00010!2\u0006\u0010\"\u001a\u00020#H\u0002J \u0010$\u001a\b\u0012\u0004\u0012\u00020&0%2\u0006\u0010'\u001a\u00020\u00182\b\b\u0002\u0010(\u001a\u00020\u0017H\u0002J6\u0010)\u001a\u0004\u0018\u00010\u00182\u0006\u0010*\u001a\u00020#2\u0006\u0010+\u001a\u00020,2\u0006\u0010-\u001a\u00020.2\b\b\u0002\u0010/\u001a\u0002002\b\b\u0002\u00101\u001a\u00020\u0017H\u0002J\u0010\u00102\u001a\u0002032\u0006\u00104\u001a\u00020\u0001H\u0016J4\u00105\u001a\u0004\u0018\u0001062\b\u00107\u001a\u0004\u0018\u0001082\u0006\u00109\u001a\u00020:2\u0006\u0010;\u001a\u00020<2\u0006\u0010+\u001a\u00020,2\u0006\u0010-\u001a\u00020.H\u0016J0\u0010=\u001a\b\u0012\u0004\u0012\u00020&0%2\b\u00107\u001a\u0004\u0018\u0001082\u0006\u0010>\u001a\u00020?2\u0006\u0010+\u001a\u00020,2\u0006\u0010-\u001a\u00020.H\u0016J8\u0010@\u001a\b\u0012\u0004\u0012\u00020&0%2\b\u00107\u001a\u0004\u0018\u0001082\u0006\u0010A\u001a\u00020#2\u0006\u0010+\u001a\u00020,2\u0006\u0010-\u001a\u00020.2\u0006\u0010/\u001a\u000200H\u0016J0\u0010B\u001a\b\u0012\u0004\u0012\u00020&0%2\b\u00107\u001a\u0004\u0018\u0001082\u0006\u0010C\u001a\u00020D2\u0006\u0010+\u001a\u00020,2\u0006\u0010-\u001a\u00020.H\u0016J:\u0010E\u001a\b\u0012\u0004\u0012\u00020&0%2\b\u00107\u001a\u0004\u0018\u0001082\u0006\u00109\u001a\u00020:2\b\u0010F\u001a\u0004\u0018\u00010!2\u0006\u0010+\u001a\u00020,2\u0006\u0010-\u001a\u00020.H\u0016J0\u0010G\u001a\b\u0012\u0004\u0012\u00020&0%2\b\u00107\u001a\u0004\u0018\u0001082\u0006\u00109\u001a\u00020:2\u0006\u0010+\u001a\u00020,2\u0006\u0010-\u001a\u00020.H\u0016J0\u0010H\u001a\b\u0012\u0004\u0012\u00020&0%2\b\u00107\u001a\u0004\u0018\u0001082\u0006\u00109\u001a\u00020:2\u0006\u0010+\u001a\u00020,2\u0006\u0010-\u001a\u00020.H\u0016J8\u0010I\u001a\b\u0012\u0004\u0012\u00020&0%2\b\u00107\u001a\u0004\u0018\u0001082\u0006\u00109\u001a\u00020:2\u0006\u0010+\u001a\u00020,2\u0006\u0010-\u001a\u00020.2\u0006\u0010J\u001a\u00020\u001fH\u0016J8\u0010K\u001a\b\u0012\u0004\u0012\u00020&0%2\b\u00107\u001a\u0004\u0018\u0001082\u0006\u00109\u001a\u00020:2\u0006\u0010+\u001a\u00020,2\u0006\u0010-\u001a\u00020.2\u0006\u0010L\u001a\u00020\u001fH\u0016J\u001e\u0010M\u001a\b\u0012\u0004\u0012\u00020&0%2\u0006\u0010N\u001a\u00020O2\u0006\u0010+\u001a\u00020,H\u0016J\u001e\u0010P\u001a\b\u0012\u0004\u0012\u00020&0%2\u0006\u0010Q\u001a\u00020R2\u0006\u0010+\u001a\u00020,H\u0016JR\u0010S\u001a\b\u0012\u0004\u0012\u00020&0%2\b\u00107\u001a\u0004\u0018\u0001082\u0006\u0010A\u001a\u00020#2\u0006\u0010T\u001a\u00020U2\b\u0010 \u001a\u0004\u0018\u00010!2\u0006\u0010+\u001a\u00020,2\u0006\u0010-\u001a\u00020.2\u0006\u0010/\u001a\u0002002\u0006\u0010V\u001a\u00020\u001fH\u0016R\u001b\u0010\u000b\u001a\u00020\f8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000f\u0010\u0010\u001a\u0004\b\r\u0010\u000eR\u001d\u0010\u0011\u001a\u0004\u0018\u00010\f8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0013\u0010\u0010\u001a\u0004\b\u0012\u0010\u000eR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0018\u0010\u0016\u001a\u00020\u0017*\u00020\u00188BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0019R$\u0010\u001a\u001a\u00020\u0017\"\u0004\b\u0000\u0010\u001b*\b\u0012\u0004\u0012\u0002H\u001b0\u001c8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u001d\u00a8\u0006W"}, d2={"Lorg/jetbrains/kotlin/fir/java/deserialization/JvmBinaryAnnotationDeserializer;", "Lorg/jetbrains/kotlin/fir/deserialization/AbstractAnnotationDeserializer;", "session", "Lorg/jetbrains/kotlin/fir/FirSession;", "kotlinBinaryClass", "Lorg/jetbrains/kotlin/load/kotlin/KotlinJvmBinaryClass;", "kotlinClassFinder", "Lorg/jetbrains/kotlin/load/kotlin/KotlinClassFinder;", "byteContent", "", "(Lorg/jetbrains/kotlin/fir/FirSession;Lorg/jetbrains/kotlin/load/kotlin/KotlinJvmBinaryClass;Lorg/jetbrains/kotlin/load/kotlin/KotlinClassFinder;[B)V", "annotationInfo", "Lorg/jetbrains/kotlin/fir/java/deserialization/MemberAnnotations;", "getAnnotationInfo", "()Lorg/jetbrains/kotlin/fir/java/deserialization/MemberAnnotations;", "annotationInfo$delegate", "Lkotlin/Lazy;", "annotationInfoForDefaultImpls", "getAnnotationInfoForDefaultImpls", "annotationInfoForDefaultImpls$delegate", "getSession", "()Lorg/jetbrains/kotlin/fir/FirSession;", "isDelegated", "", "Lorg/jetbrains/kotlin/load/kotlin/MemberSignature;", "(Lorg/jetbrains/kotlin/load/kotlin/MemberSignature;)Z", "isSignedNumber", "T", "Lorg/jetbrains/kotlin/types/ConstantValueKind;", "(Lorg/jetbrains/kotlin/types/ConstantValueKind;)Z", "computeJvmParameterIndexShift", "", "classProto", "Lorg/jetbrains/kotlin/metadata/ProtoBuf$Class;", "message", "Lorg/jetbrains/kotlin/protobuf/MessageLite;", "findJvmBinaryClassAndLoadMemberAnnotations", "", "Lorg/jetbrains/kotlin/fir/expressions/FirAnnotation;", "memberSignature", "searchInDefaultImpls", "getCallableSignature", "proto", "nameResolver", "Lorg/jetbrains/kotlin/metadata/deserialization/NameResolver;", "typeTable", "Lorg/jetbrains/kotlin/metadata/deserialization/TypeTable;", "kind", "Lorg/jetbrains/kotlin/fir/deserialization/AbstractAnnotationDeserializer$CallableKind;", "requireHasFieldFlagForField", "inheritAnnotationInfo", "", "parent", "loadAnnotationPropertyDefaultValue", "Lorg/jetbrains/kotlin/fir/expressions/FirExpression;", "containerSource", "Lorg/jetbrains/kotlin/serialization/deserialization/descriptors/DeserializedContainerSource;", "propertyProto", "Lorg/jetbrains/kotlin/metadata/ProtoBuf$Property;", "expectedPropertyType", "Lorg/jetbrains/kotlin/fir/types/FirTypeRef;", "loadConstructorAnnotations", "constructorProto", "Lorg/jetbrains/kotlin/metadata/ProtoBuf$Constructor;", "loadExtensionReceiverParameterAnnotations", "callableProto", "loadFunctionAnnotations", "functionProto", "Lorg/jetbrains/kotlin/metadata/ProtoBuf$Function;", "loadPropertyAnnotations", "containingClassProto", "loadPropertyBackingFieldAnnotations", "loadPropertyDelegatedFieldAnnotations", "loadPropertyGetterAnnotations", "getterFlags", "loadPropertySetterAnnotations", "setterFlags", "loadTypeAnnotations", "typeProto", "Lorg/jetbrains/kotlin/metadata/ProtoBuf$Type;", "loadTypeParameterAnnotations", "typeParameterProto", "Lorg/jetbrains/kotlin/metadata/ProtoBuf$TypeParameter;", "loadValueParameterAnnotations", "valueParameterProto", "Lorg/jetbrains/kotlin/metadata/ProtoBuf$ValueParameter;", "parameterIndex", "java"})
@SourceDebugExtension(value={"SMAP\nJvmBinaryAnnotationDeserializer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JvmBinaryAnnotationDeserializer.kt\norg/jetbrains/kotlin/fir/java/deserialization/JvmBinaryAnnotationDeserializer\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 addToStdlib.kt\norg/jetbrains/kotlin/utils/addToStdlib/AddToStdlibKt\n+ 5 FirAnnotationBuilder.kt\norg/jetbrains/kotlin/fir/expressions/builder/FirAnnotationBuilderKt\n*L\n1#1,371:1\n1547#2:372\n1618#2,3:373\n1547#2:376\n1618#2,3:377\n1547#2:382\n1618#2,2:383\n1620#2:389\n1547#2:390\n1618#2,2:391\n1620#2:397\n1547#2:398\n1618#2,2:399\n1620#2:405\n1#3:380\n226#4:381\n58#5,4:385\n58#5,4:393\n58#5,4:401\n*S KotlinDebug\n*F\n+ 1 JvmBinaryAnnotationDeserializer.kt\norg/jetbrains/kotlin/fir/java/deserialization/JvmBinaryAnnotationDeserializer\n*L\n66#1:372\n66#1:373,3\n71#1:376\n71#1:377,3\n110#1:382\n110#1:383,2\n110#1:389\n132#1:390\n132#1:391,2\n132#1:397\n151#1:398\n151#1:399,2\n151#1:405\n103#1:381\n111#1:385,4\n133#1:393,4\n152#1:401,4\n*E\n"})
public final class JvmBinaryAnnotationDeserializer
extends AbstractAnnotationDeserializer {
    @NotNull
    private final FirSession session;
    @NotNull
    private final Lazy annotationInfo$delegate;
    @NotNull
    private final Lazy annotationInfoForDefaultImpls$delegate;

    public JvmBinaryAnnotationDeserializer(@NotNull FirSession session2, @NotNull KotlinJvmBinaryClass kotlinBinaryClass, @NotNull KotlinClassFinder kotlinClassFinder, @Nullable byte[] byteContent) {
        Intrinsics.checkNotNullParameter((Object)session2, (String)"session");
        Intrinsics.checkNotNullParameter((Object)kotlinBinaryClass, (String)"kotlinBinaryClass");
        Intrinsics.checkNotNullParameter((Object)kotlinClassFinder, (String)"kotlinClassFinder");
        super(session2, BuiltInSerializerProtocol.INSTANCE);
        this.session = session2;
        this.annotationInfo$delegate = LazyKt.lazy((LazyThreadSafetyMode)LazyThreadSafetyMode.PUBLICATION, (Function0)((Function0)new Function0<MemberAnnotations>(this, kotlinBinaryClass, byteContent, kotlinClassFinder){
            final /* synthetic */ JvmBinaryAnnotationDeserializer this$0;
            final /* synthetic */ KotlinJvmBinaryClass $kotlinBinaryClass;
            final /* synthetic */ byte[] $byteContent;
            final /* synthetic */ KotlinClassFinder $kotlinClassFinder;
            {
                this.this$0 = $receiver;
                this.$kotlinBinaryClass = $kotlinBinaryClass;
                this.$byteContent = $byteContent;
                this.$kotlinClassFinder = $kotlinClassFinder;
                super(0);
            }

            public final MemberAnnotations invoke() {
                return JvmBinaryAnnotationDeserializerKt.access$loadMemberAnnotations(this.this$0.getSession(), this.$kotlinBinaryClass, this.$byteContent, this.$kotlinClassFinder);
            }
        }));
        this.annotationInfoForDefaultImpls$delegate = LazyKt.lazy((LazyThreadSafetyMode)LazyThreadSafetyMode.PUBLICATION, (Function0)((Function0)new Function0<MemberAnnotations>(kotlinBinaryClass, kotlinClassFinder, this){
            final /* synthetic */ KotlinJvmBinaryClass $kotlinBinaryClass;
            final /* synthetic */ KotlinClassFinder $kotlinClassFinder;
            final /* synthetic */ JvmBinaryAnnotationDeserializer this$0;
            {
                this.$kotlinBinaryClass = $kotlinBinaryClass;
                this.$kotlinClassFinder = $kotlinClassFinder;
                this.this$0 = $receiver;
                super(0);
            }

            public final MemberAnnotations invoke() {
                ClassId classId = this.$kotlinBinaryClass.getClassId();
                Name name2 = Name.identifier("DefaultImpls");
                Intrinsics.checkNotNullExpressionValue((Object)name2, (String)"identifier(...)");
                ClassId defaultImplsClassId = classId.createNestedClassId(name2);
                KotlinClassFinder.Result result2 = this.$kotlinClassFinder.findKotlinClassOrContent(defaultImplsClassId, MetadataHelpersKt.toMetadataVersion(FirLanguageSettingsComponentKt.getLanguageVersionSettings(this.this$0.getSession()).getLanguageVersion()));
                KotlinClassFinder.Result.KotlinClass kotlinClass = result2 instanceof KotlinClassFinder.Result.KotlinClass ? (KotlinClassFinder.Result.KotlinClass)result2 : null;
                if (kotlinClass == null) {
                    return null;
                }
                KotlinClassFinder.Result.KotlinClass kotlinClass2 = kotlinClass;
                KotlinJvmBinaryClass defaultImplsClass = kotlinClass2.component1();
                byte[] defaultImplsByteContent = kotlinClass2.component2();
                return JvmBinaryAnnotationDeserializerKt.access$loadMemberAnnotations(this.this$0.getSession(), defaultImplsClass, defaultImplsByteContent, this.$kotlinClassFinder);
            }
        }));
    }

    @NotNull
    public final FirSession getSession() {
        return this.session;
    }

    private final MemberAnnotations getAnnotationInfo() {
        Lazy lazy = this.annotationInfo$delegate;
        return (MemberAnnotations)lazy.getValue();
    }

    private final MemberAnnotations getAnnotationInfoForDefaultImpls() {
        Lazy lazy = this.annotationInfoForDefaultImpls$delegate;
        return (MemberAnnotations)lazy.getValue();
    }

    @Override
    public void inheritAnnotationInfo(@NotNull AbstractAnnotationDeserializer parent2) {
        Intrinsics.checkNotNullParameter((Object)parent2, (String)"parent");
        if (parent2 instanceof JvmBinaryAnnotationDeserializer) {
            this.getAnnotationInfo().getMemberAnnotations().putAll(((JvmBinaryAnnotationDeserializer)parent2).getAnnotationInfo().getMemberAnnotations());
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public List<FirAnnotation> loadTypeAnnotations(@NotNull ProtoBuf.Type typeProto, @NotNull NameResolver nameResolver2) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)typeProto, (String)"typeProto");
        Intrinsics.checkNotNullParameter((Object)nameResolver2, (String)"nameResolver");
        List list2 = typeProto.getExtension(JvmProtoBuf.typeAnnotation);
        if (list2 == null) {
            list2 = CollectionsKt.emptyList();
        }
        List annotations2 = list2;
        Iterable $this$map$iv = annotations2;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            ProtoBuf.Annotation annotation2 = (ProtoBuf.Annotation)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            AbstractAnnotationDeserializer abstractAnnotationDeserializer = this;
            Intrinsics.checkNotNull((Object)it);
            collection.add(AbstractAnnotationDeserializer.deserializeAnnotation$default(abstractAnnotationDeserializer, (ProtoBuf.Annotation)it, nameResolver2, null, 4, null));
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public List<FirAnnotation> loadTypeParameterAnnotations(@NotNull ProtoBuf.TypeParameter typeParameterProto, @NotNull NameResolver nameResolver2) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)typeParameterProto, (String)"typeParameterProto");
        Intrinsics.checkNotNullParameter((Object)nameResolver2, (String)"nameResolver");
        List list2 = typeParameterProto.getExtension(JvmProtoBuf.typeParameterAnnotation);
        if (list2 == null) {
            list2 = CollectionsKt.emptyList();
        }
        List annotations2 = list2;
        Iterable $this$map$iv = annotations2;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            ProtoBuf.Annotation annotation2 = (ProtoBuf.Annotation)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            AbstractAnnotationDeserializer abstractAnnotationDeserializer = this;
            Intrinsics.checkNotNull((Object)it);
            collection.add(AbstractAnnotationDeserializer.deserializeAnnotation$default(abstractAnnotationDeserializer, (ProtoBuf.Annotation)it, nameResolver2, null, 4, null));
        }
        return (List)destination$iv$iv;
    }

    @Override
    @NotNull
    public List<FirAnnotation> loadConstructorAnnotations(@Nullable DeserializedContainerSource containerSource, @NotNull ProtoBuf.Constructor constructorProto, @NotNull NameResolver nameResolver2, @NotNull TypeTable typeTable) {
        Intrinsics.checkNotNullParameter((Object)constructorProto, (String)"constructorProto");
        Intrinsics.checkNotNullParameter((Object)nameResolver2, (String)"nameResolver");
        Intrinsics.checkNotNullParameter((Object)typeTable, (String)"typeTable");
        MemberSignature memberSignature = JvmBinaryAnnotationDeserializer.getCallableSignature$default(this, constructorProto, nameResolver2, typeTable, null, false, 24, null);
        if (memberSignature == null) {
            return CollectionsKt.emptyList();
        }
        MemberSignature signature = memberSignature;
        return JvmBinaryAnnotationDeserializer.findJvmBinaryClassAndLoadMemberAnnotations$default(this, signature, false, 2, null);
    }

    @Override
    @NotNull
    public List<FirAnnotation> loadFunctionAnnotations(@Nullable DeserializedContainerSource containerSource, @NotNull ProtoBuf.Function functionProto, @NotNull NameResolver nameResolver2, @NotNull TypeTable typeTable) {
        Intrinsics.checkNotNullParameter((Object)functionProto, (String)"functionProto");
        Intrinsics.checkNotNullParameter((Object)nameResolver2, (String)"nameResolver");
        Intrinsics.checkNotNullParameter((Object)typeTable, (String)"typeTable");
        MemberSignature memberSignature = JvmBinaryAnnotationDeserializer.getCallableSignature$default(this, functionProto, nameResolver2, typeTable, null, false, 24, null);
        if (memberSignature == null) {
            return CollectionsKt.emptyList();
        }
        MemberSignature signature = memberSignature;
        return JvmBinaryAnnotationDeserializer.findJvmBinaryClassAndLoadMemberAnnotations$default(this, signature, false, 2, null);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public List<FirAnnotation> loadPropertyAnnotations(@Nullable DeserializedContainerSource containerSource, @NotNull ProtoBuf.Property propertyProto, @Nullable ProtoBuf.Class containingClassProto, @NotNull NameResolver nameResolver2, @NotNull TypeTable typeTable) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Constable constable;
        boolean classIsInterface;
        MemberSignature signature;
        block10: {
            block9: {
                Integer jvmClassFlags;
                Integer n;
                boolean bl;
                Intrinsics.checkNotNullParameter((Object)propertyProto, (String)"propertyProto");
                Intrinsics.checkNotNullParameter((Object)nameResolver2, (String)"nameResolver");
                Intrinsics.checkNotNullParameter((Object)typeTable, (String)"typeTable");
                MemberSignature memberSignature = AbstractBinaryClassAnnotationLoaderKt.getPropertySignature$default(propertyProto, nameResolver2, typeTable, false, true, false, 40, null);
                if (memberSignature == null) {
                    return CollectionsKt.emptyList();
                }
                signature = memberSignature;
                ProtoBuf.Class clazz = containingClassProto;
                if (clazz != null) {
                    ProtoBuf.Class it = clazz;
                    boolean bl2 = false;
                    bl = Flags.CLASS_KIND.get(it.getFlags()) == ProtoBuf.Class.Kind.INTERFACE;
                } else {
                    bl = false;
                }
                classIsInterface = bl;
                ProtoBuf.Class clazz2 = containingClassProto;
                boolean condition$iv = clazz2 != null ? clazz2.hasExtension(JvmProtoBuf.jvmClassFlags) : false;
                boolean $i$f$runIf = false;
                if (condition$iv) {
                    boolean bl3 = false;
                    ProtoBuf.Class clazz3 = containingClassProto;
                    n = clazz3 != null ? clazz3.getExtension(JvmProtoBuf.jvmClassFlags) : null;
                } else {
                    n = null;
                }
                if ((constable = (jvmClassFlags = n)) == null) break block9;
                int it = ((Number)((Object)constable)).intValue();
                boolean bl4 = false;
                Boolean bl5 = JvmFlags.INSTANCE.getIS_COMPILED_IN_COMPATIBILITY_MODE().get(it);
                constable = bl5;
                if (bl5 != null) break block10;
            }
            constable = Boolean.valueOf(true);
        }
        boolean allCompatibilityModeIsEnabled = (Boolean)constable;
        Iterable $i$f$runIf = this.findJvmBinaryClassAndLoadMemberAnnotations(signature, classIsInterface && allCompatibilityModeIsEnabled);
        boolean $i$f$map = false;
        void var12_17 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            FirAnnotationBuilder firAnnotationBuilder;
            FirAnnotation firAnnotation = (FirAnnotation)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            boolean $i$f$buildAnnotation = false;
            FirAnnotationBuilder $this$loadPropertyAnnotations_u24lambda_u246_u24lambda_u245 = firAnnotationBuilder = new FirAnnotationBuilder();
            boolean bl6 = false;
            $this$loadPropertyAnnotations_u24lambda_u246_u24lambda_u245.setAnnotationTypeRef(it.getAnnotationTypeRef());
            $this$loadPropertyAnnotations_u24lambda_u246_u24lambda_u245.setArgumentMapping(it.getArgumentMapping());
            $this$loadPropertyAnnotations_u24lambda_u246_u24lambda_u245.setUseSiteTarget(AnnotationUseSiteTarget.PROPERTY);
            collection.add(firAnnotationBuilder.build());
        }
        return (List)destination$iv$iv;
    }

    private final boolean isDelegated(MemberSignature $this$isDelegated) {
        return StringsKt.contains$default((CharSequence)$this$isDelegated.getSignature(), (CharSequence)"$delegate", (boolean)false, (int)2, null);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public List<FirAnnotation> loadPropertyBackingFieldAnnotations(@Nullable DeserializedContainerSource containerSource, @NotNull ProtoBuf.Property propertyProto, @NotNull NameResolver nameResolver2, @NotNull TypeTable typeTable) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)propertyProto, (String)"propertyProto");
        Intrinsics.checkNotNullParameter((Object)nameResolver2, (String)"nameResolver");
        Intrinsics.checkNotNullParameter((Object)typeTable, (String)"typeTable");
        MemberSignature memberSignature = AbstractBinaryClassAnnotationLoaderKt.getPropertySignature$default(propertyProto, nameResolver2, typeTable, true, false, false, 48, null);
        if (memberSignature == null) {
            return CollectionsKt.emptyList();
        }
        MemberSignature signature = memberSignature;
        if (this.isDelegated(signature)) {
            return CollectionsKt.emptyList();
        }
        Iterable $this$map$iv = JvmBinaryAnnotationDeserializer.findJvmBinaryClassAndLoadMemberAnnotations$default(this, signature, false, 2, null);
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            FirAnnotationBuilder firAnnotationBuilder;
            FirAnnotation firAnnotation = (FirAnnotation)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            boolean $i$f$buildAnnotation = false;
            FirAnnotationBuilder $this$loadPropertyBackingFieldAnnotations_u24lambda_u248_u24lambda_u247 = firAnnotationBuilder = new FirAnnotationBuilder();
            boolean bl2 = false;
            $this$loadPropertyBackingFieldAnnotations_u24lambda_u248_u24lambda_u247.setAnnotationTypeRef(it.getAnnotationTypeRef());
            $this$loadPropertyBackingFieldAnnotations_u24lambda_u248_u24lambda_u247.setArgumentMapping(it.getArgumentMapping());
            $this$loadPropertyBackingFieldAnnotations_u24lambda_u248_u24lambda_u247.setUseSiteTarget(AnnotationUseSiteTarget.FIELD);
            collection.add(firAnnotationBuilder.build());
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public List<FirAnnotation> loadPropertyDelegatedFieldAnnotations(@Nullable DeserializedContainerSource containerSource, @NotNull ProtoBuf.Property propertyProto, @NotNull NameResolver nameResolver2, @NotNull TypeTable typeTable) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)propertyProto, (String)"propertyProto");
        Intrinsics.checkNotNullParameter((Object)nameResolver2, (String)"nameResolver");
        Intrinsics.checkNotNullParameter((Object)typeTable, (String)"typeTable");
        MemberSignature memberSignature = AbstractBinaryClassAnnotationLoaderKt.getPropertySignature$default(propertyProto, nameResolver2, typeTable, true, false, false, 48, null);
        if (memberSignature == null) {
            return CollectionsKt.emptyList();
        }
        MemberSignature signature = memberSignature;
        if (!this.isDelegated(signature)) {
            return CollectionsKt.emptyList();
        }
        Iterable $this$map$iv = JvmBinaryAnnotationDeserializer.findJvmBinaryClassAndLoadMemberAnnotations$default(this, signature, false, 2, null);
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            FirAnnotationBuilder firAnnotationBuilder;
            FirAnnotation firAnnotation = (FirAnnotation)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            boolean $i$f$buildAnnotation = false;
            FirAnnotationBuilder $this$loadPropertyDelegatedFieldAnnotations_u24lambda_u2410_u24lambda_u249 = firAnnotationBuilder = new FirAnnotationBuilder();
            boolean bl2 = false;
            $this$loadPropertyDelegatedFieldAnnotations_u24lambda_u2410_u24lambda_u249.setAnnotationTypeRef(it.getAnnotationTypeRef());
            $this$loadPropertyDelegatedFieldAnnotations_u24lambda_u2410_u24lambda_u249.setArgumentMapping(it.getArgumentMapping());
            $this$loadPropertyDelegatedFieldAnnotations_u24lambda_u2410_u24lambda_u249.setUseSiteTarget(AnnotationUseSiteTarget.PROPERTY_DELEGATE_FIELD);
            collection.add(firAnnotationBuilder.build());
        }
        return (List)destination$iv$iv;
    }

    @Override
    @NotNull
    public List<FirAnnotation> loadPropertyGetterAnnotations(@Nullable DeserializedContainerSource containerSource, @NotNull ProtoBuf.Property propertyProto, @NotNull NameResolver nameResolver2, @NotNull TypeTable typeTable, int getterFlags) {
        Intrinsics.checkNotNullParameter((Object)propertyProto, (String)"propertyProto");
        Intrinsics.checkNotNullParameter((Object)nameResolver2, (String)"nameResolver");
        Intrinsics.checkNotNullParameter((Object)typeTable, (String)"typeTable");
        MemberSignature memberSignature = JvmBinaryAnnotationDeserializer.getCallableSignature$default(this, propertyProto, nameResolver2, typeTable, AbstractAnnotationDeserializer.CallableKind.PROPERTY_GETTER, false, 16, null);
        if (memberSignature == null) {
            return CollectionsKt.emptyList();
        }
        MemberSignature signature = memberSignature;
        return JvmBinaryAnnotationDeserializer.findJvmBinaryClassAndLoadMemberAnnotations$default(this, signature, false, 2, null);
    }

    @Override
    @NotNull
    public List<FirAnnotation> loadPropertySetterAnnotations(@Nullable DeserializedContainerSource containerSource, @NotNull ProtoBuf.Property propertyProto, @NotNull NameResolver nameResolver2, @NotNull TypeTable typeTable, int setterFlags) {
        Intrinsics.checkNotNullParameter((Object)propertyProto, (String)"propertyProto");
        Intrinsics.checkNotNullParameter((Object)nameResolver2, (String)"nameResolver");
        Intrinsics.checkNotNullParameter((Object)typeTable, (String)"typeTable");
        MemberSignature memberSignature = JvmBinaryAnnotationDeserializer.getCallableSignature$default(this, propertyProto, nameResolver2, typeTable, AbstractAnnotationDeserializer.CallableKind.PROPERTY_SETTER, false, 16, null);
        if (memberSignature == null) {
            return CollectionsKt.emptyList();
        }
        MemberSignature signature = memberSignature;
        return JvmBinaryAnnotationDeserializer.findJvmBinaryClassAndLoadMemberAnnotations$default(this, signature, false, 2, null);
    }

    @Override
    @NotNull
    public List<FirAnnotation> loadValueParameterAnnotations(@Nullable DeserializedContainerSource containerSource, @NotNull MessageLite callableProto, @NotNull ProtoBuf.ValueParameter valueParameterProto, @Nullable ProtoBuf.Class classProto2, @NotNull NameResolver nameResolver2, @NotNull TypeTable typeTable, @NotNull AbstractAnnotationDeserializer.CallableKind kind, int parameterIndex) {
        Intrinsics.checkNotNullParameter((Object)callableProto, (String)"callableProto");
        Intrinsics.checkNotNullParameter((Object)valueParameterProto, (String)"valueParameterProto");
        Intrinsics.checkNotNullParameter((Object)nameResolver2, (String)"nameResolver");
        Intrinsics.checkNotNullParameter((Object)typeTable, (String)"typeTable");
        Intrinsics.checkNotNullParameter((Object)((Object)kind), (String)"kind");
        MemberSignature memberSignature = JvmBinaryAnnotationDeserializer.getCallableSignature$default(this, callableProto, nameResolver2, typeTable, kind, false, 16, null);
        if (memberSignature == null) {
            return CollectionsKt.emptyList();
        }
        MemberSignature methodSignature = memberSignature;
        int index2 = parameterIndex + this.computeJvmParameterIndexShift(classProto2, callableProto);
        MemberSignature paramSignature = MemberSignature.Companion.fromMethodSignatureAndParameterIndex(methodSignature, index2);
        return JvmBinaryAnnotationDeserializer.findJvmBinaryClassAndLoadMemberAnnotations$default(this, paramSignature, false, 2, null);
    }

    @Override
    @NotNull
    public List<FirAnnotation> loadExtensionReceiverParameterAnnotations(@Nullable DeserializedContainerSource containerSource, @NotNull MessageLite callableProto, @NotNull NameResolver nameResolver2, @NotNull TypeTable typeTable, @NotNull AbstractAnnotationDeserializer.CallableKind kind) {
        Intrinsics.checkNotNullParameter((Object)callableProto, (String)"callableProto");
        Intrinsics.checkNotNullParameter((Object)nameResolver2, (String)"nameResolver");
        Intrinsics.checkNotNullParameter((Object)typeTable, (String)"typeTable");
        Intrinsics.checkNotNullParameter((Object)((Object)kind), (String)"kind");
        MemberSignature memberSignature = JvmBinaryAnnotationDeserializer.getCallableSignature$default(this, callableProto, nameResolver2, typeTable, kind, false, 16, null);
        if (memberSignature == null) {
            return CollectionsKt.emptyList();
        }
        MemberSignature methodSignature = memberSignature;
        MemberSignature paramSignature = MemberSignature.Companion.fromMethodSignatureAndParameterIndex(methodSignature, 0);
        return JvmBinaryAnnotationDeserializer.findJvmBinaryClassAndLoadMemberAnnotations$default(this, paramSignature, false, 2, null);
    }

    @Override
    @Nullable
    public FirExpression loadAnnotationPropertyDefaultValue(@Nullable DeserializedContainerSource containerSource, @NotNull ProtoBuf.Property propertyProto, @NotNull FirTypeRef expectedPropertyType, @NotNull NameResolver nameResolver2, @NotNull TypeTable typeTable) {
        Intrinsics.checkNotNullParameter((Object)propertyProto, (String)"propertyProto");
        Intrinsics.checkNotNullParameter((Object)expectedPropertyType, (String)"expectedPropertyType");
        Intrinsics.checkNotNullParameter((Object)nameResolver2, (String)"nameResolver");
        Intrinsics.checkNotNullParameter((Object)typeTable, (String)"typeTable");
        MemberSignature memberSignature = JvmBinaryAnnotationDeserializer.getCallableSignature$default(this, propertyProto, nameResolver2, typeTable, AbstractAnnotationDeserializer.CallableKind.PROPERTY_GETTER, false, 16, null);
        if (memberSignature == null) {
            return null;
        }
        MemberSignature signature = memberSignature;
        FirExpression firExpr = this.getAnnotationInfo().getAnnotationMethodsDefaultValues().get(signature);
        return firExpr instanceof FirLiteralExpression && ConeBuiltinTypeUtilsKt.isUnsignedType(FirTypeUtilsKt.getConeType(expectedPropertyType)) && this.isSignedNumber(((FirLiteralExpression)firExpr).getKind()) ? JavaUtilsKt.createConstantIfAny(((FirLiteralExpression)firExpr).getValue(), this.session, true) : firExpr;
    }

    private final <T> boolean isSignedNumber(ConstantValueKind<T> $this$isSignedNumber) {
        return $this$isSignedNumber instanceof ConstantValueKind.Byte || $this$isSignedNumber instanceof ConstantValueKind.Short || $this$isSignedNumber instanceof ConstantValueKind.Int || $this$isSignedNumber instanceof ConstantValueKind.Long;
    }

    private final int computeJvmParameterIndexShift(ProtoBuf.Class classProto2, MessageLite message2) {
        int n;
        MessageLite messageLite = message2;
        if (messageLite instanceof ProtoBuf.Function) {
            n = ProtoTypeTableUtilKt.hasReceiver((ProtoBuf.Function)message2) ? 1 : 0;
        } else if (messageLite instanceof ProtoBuf.Property) {
            n = ProtoTypeTableUtilKt.hasReceiver((ProtoBuf.Property)message2) ? 1 : 0;
        } else if (messageLite instanceof ProtoBuf.Constructor) {
            boolean bl;
            boolean bl2 = bl = classProto2 != null;
            if (_Assertions.ENABLED && !bl) {
                boolean $i$a$-assert-JvmBinaryAnnotationDeserializer$computeJvmParameterIndexShift$22 = false;
                String $i$a$-assert-JvmBinaryAnnotationDeserializer$computeJvmParameterIndexShift$22 = "Constructor call without information about enclosing Class: " + message2;
                throw new AssertionError((Object)$i$a$-assert-JvmBinaryAnnotationDeserializer$computeJvmParameterIndexShift$22);
            }
            ProtoBuf.Class clazz = classProto2;
            Intrinsics.checkNotNull((Object)clazz);
            ProtoBuf.Class.Kind kind = Flags.CLASS_KIND.get(clazz.getFlags());
            if (kind == null) {
                kind = ProtoBuf.Class.Kind.CLASS;
            }
            ProtoBuf.Class.Kind kind2 = kind;
            Boolean bl3 = Flags.IS_INNER.get(classProto2.getFlags());
            Intrinsics.checkNotNullExpressionValue((Object)bl3, (String)"get(...)");
            boolean isInner2 = bl3;
            n = kind2 == ProtoBuf.Class.Kind.ENUM_CLASS ? 2 : (isInner2 ? 1 : 0);
        } else {
            throw new UnsupportedOperationException("Unsupported message: " + message2.getClass());
        }
        return n;
    }

    private final MemberSignature getCallableSignature(MessageLite proto, NameResolver nameResolver2, TypeTable typeTable, AbstractAnnotationDeserializer.CallableKind kind, boolean requireHasFieldFlagForField) {
        MemberSignature memberSignature;
        MessageLite messageLite = proto;
        if (messageLite instanceof ProtoBuf.Constructor) {
            JvmMemberSignature.Method method = JvmProtoBufUtil.INSTANCE.getJvmConstructorSignature((ProtoBuf.Constructor)proto, nameResolver2, typeTable);
            if (method == null) {
                return null;
            }
            memberSignature = MemberSignature.Companion.fromJvmMemberSignature(method);
        } else if (messageLite instanceof ProtoBuf.Function) {
            JvmMemberSignature.Method method = JvmProtoBufUtil.INSTANCE.getJvmMethodSignature((ProtoBuf.Function)proto, nameResolver2, typeTable);
            if (method == null) {
                return null;
            }
            JvmMemberSignature.Method signature = method;
            memberSignature = MemberSignature.Companion.fromJvmMemberSignature(signature);
        } else if (messageLite instanceof ProtoBuf.Property) {
            GeneratedMessageLite.ExtendableMessage extendableMessage = (GeneratedMessageLite.ExtendableMessage)proto;
            GeneratedMessageLite.GeneratedExtension<ProtoBuf.Property, JvmProtoBuf.JvmPropertySignature> generatedExtension = JvmProtoBuf.propertySignature;
            Intrinsics.checkNotNullExpressionValue(generatedExtension, (String)"propertySignature");
            JvmProtoBuf.JvmPropertySignature jvmPropertySignature = ProtoBufUtilKt.getExtensionOrNull(extendableMessage, generatedExtension);
            if (jvmPropertySignature == null) {
                return null;
            }
            JvmProtoBuf.JvmPropertySignature signature = jvmPropertySignature;
            switch (WhenMappings.$EnumSwitchMapping$0[kind.ordinal()]) {
                case 1: {
                    if (signature.hasGetter()) {
                        JvmProtoBuf.JvmMethodSignature jvmMethodSignature = signature.getGetter();
                        Intrinsics.checkNotNullExpressionValue((Object)jvmMethodSignature, (String)"getGetter(...)");
                        memberSignature = MemberSignature.Companion.fromMethod(nameResolver2, jvmMethodSignature);
                        break;
                    }
                    memberSignature = null;
                    break;
                }
                case 2: {
                    if (signature.hasSetter()) {
                        JvmProtoBuf.JvmMethodSignature jvmMethodSignature = signature.getSetter();
                        Intrinsics.checkNotNullExpressionValue((Object)jvmMethodSignature, (String)"getSetter(...)");
                        memberSignature = MemberSignature.Companion.fromMethod(nameResolver2, jvmMethodSignature);
                        break;
                    }
                    memberSignature = null;
                    break;
                }
                case 3: {
                    memberSignature = AbstractBinaryClassAnnotationLoaderKt.getPropertySignature$default((ProtoBuf.Property)proto, nameResolver2, typeTable, true, false, requireHasFieldFlagForField, 16, null);
                    break;
                }
                default: {
                    memberSignature = null;
                    break;
                }
            }
        } else {
            memberSignature = null;
        }
        return memberSignature;
    }

    static /* synthetic */ MemberSignature getCallableSignature$default(JvmBinaryAnnotationDeserializer jvmBinaryAnnotationDeserializer, MessageLite messageLite, NameResolver nameResolver2, TypeTable typeTable, AbstractAnnotationDeserializer.CallableKind callableKind, boolean bl, int n, Object object) {
        if ((n & 8) != 0) {
            callableKind = AbstractAnnotationDeserializer.CallableKind.OTHERS;
        }
        if ((n & 0x10) != 0) {
            bl = false;
        }
        return jvmBinaryAnnotationDeserializer.getCallableSignature(messageLite, nameResolver2, typeTable, callableKind, bl);
    }

    private final List<FirAnnotation> findJvmBinaryClassAndLoadMemberAnnotations(MemberSignature memberSignature, boolean searchInDefaultImpls) {
        MemberAnnotations info;
        List list2;
        MemberAnnotations memberAnnotations;
        if (searchInDefaultImpls) {
            memberAnnotations = this.getAnnotationInfoForDefaultImpls();
            if (memberAnnotations == null) {
                return CollectionsKt.emptyList();
            }
        } else {
            memberAnnotations = this.getAnnotationInfo();
        }
        if ((list2 = (info = memberAnnotations).getMemberAnnotations().get(memberSignature)) == null) {
            list2 = CollectionsKt.emptyList();
        }
        return list2;
    }

    static /* synthetic */ List findJvmBinaryClassAndLoadMemberAnnotations$default(JvmBinaryAnnotationDeserializer jvmBinaryAnnotationDeserializer, MemberSignature memberSignature, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        return jvmBinaryAnnotationDeserializer.findJvmBinaryClassAndLoadMemberAnnotations(memberSignature, bl);
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[AbstractAnnotationDeserializer.CallableKind.values().length];
            try {
                nArray[AbstractAnnotationDeserializer.CallableKind.PROPERTY_GETTER.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[AbstractAnnotationDeserializer.CallableKind.PROPERTY_SETTER.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[AbstractAnnotationDeserializer.CallableKind.PROPERTY.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

