/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.java.enhancement;

import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.fir.FirSession;
import org.jetbrains.kotlin.fir.declarations.FirCallableDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirRegularClass;
import org.jetbrains.kotlin.fir.declarations.FirSimpleFunction;
import org.jetbrains.kotlin.fir.java.enhancement.FirSignatureEnhancement;
import org.jetbrains.kotlin.fir.java.enhancement.JavaCompilerRequiredAnnotationEnhancementProvider;
import org.jetbrains.kotlin.fir.resolve.transformers.plugin.CompilerRequiredAnnotationEnhancementProvider;
import org.jetbrains.kotlin.fir.symbols.impl.FirClassSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirEnumEntrySymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirVariableSymbol;
import org.jetbrains.kotlin.name.JvmStandardClassIds;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J$\u0010\u0003\u001a\u00020\u00042\n\u0010\u0005\u001a\u0006\u0012\u0002\b\u00030\u00062\u0006\u0010\u0007\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\tH\u0016\u00a8\u0006\n"}, d2={"Lorg/jetbrains/kotlin/fir/java/enhancement/JavaCompilerRequiredAnnotationEnhancementProvider;", "Lorg/jetbrains/kotlin/fir/resolve/transformers/plugin/CompilerRequiredAnnotationEnhancementProvider;", "()V", "enhance", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirEnumEntrySymbol;", "enumSymbol", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirClassSymbol;", "enumEntrySymbol", "session", "Lorg/jetbrains/kotlin/fir/FirSession;", "java"})
public final class JavaCompilerRequiredAnnotationEnhancementProvider
extends CompilerRequiredAnnotationEnhancementProvider {
    @NotNull
    public static final JavaCompilerRequiredAnnotationEnhancementProvider INSTANCE = new JavaCompilerRequiredAnnotationEnhancementProvider();

    private JavaCompilerRequiredAnnotationEnhancementProvider() {
    }

    @Override
    @NotNull
    public FirEnumEntrySymbol enhance(@NotNull FirClassSymbol<?> enumSymbol, @NotNull FirEnumEntrySymbol enumEntrySymbol, @NotNull FirSession session2) {
        Intrinsics.checkNotNullParameter(enumSymbol, (String)"enumSymbol");
        Intrinsics.checkNotNullParameter((Object)enumEntrySymbol, (String)"enumEntrySymbol");
        Intrinsics.checkNotNullParameter((Object)session2, (String)"session");
        Object e = enumSymbol.getFir();
        FirRegularClass firRegularClass = e instanceof FirRegularClass ? (FirRegularClass)e : null;
        if (firRegularClass == null) {
            return enumEntrySymbol;
        }
        FirRegularClass firRegularClass2 = firRegularClass;
        if (!Intrinsics.areEqual((Object)enumSymbol.getClassId(), (Object)JvmStandardClassIds.Annotations.Java.INSTANCE.getElementType())) {
            return enumEntrySymbol;
        }
        FirVariableSymbol<?> firVariableSymbol = new FirSignatureEnhancement(firRegularClass2, session2, (Function1<? super FirSimpleFunction, ? extends List<? extends FirCallableDeclaration>>)((Function1)enhance.1.INSTANCE)).enhancedProperty(enumEntrySymbol, enumEntrySymbol.getName());
        Intrinsics.checkNotNull(firVariableSymbol, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.fir.symbols.impl.FirEnumEntrySymbol");
        return (FirEnumEntrySymbol)firVariableSymbol;
    }
}

