/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.js.inline.clean;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IndexedValue;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.js.backend.ast.JsClass;
import org.jetbrains.kotlin.js.backend.ast.JsExpression;
import org.jetbrains.kotlin.js.backend.ast.JsExpressionStatement;
import org.jetbrains.kotlin.js.backend.ast.JsFunction;
import org.jetbrains.kotlin.js.backend.ast.JsInvocation;
import org.jetbrains.kotlin.js.backend.ast.JsNameRef;
import org.jetbrains.kotlin.js.backend.ast.JsStatement;
import org.jetbrains.kotlin.js.backend.ast.JsSuperRef;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0006\u0010\u0005\u001a\u00020\u0006J\f\u0010\u0007\u001a\u00020\u0006*\u00020\bH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lorg/jetbrains/kotlin/js/inline/clean/TrivialConstructorRemoval;", "", "klass", "Lorg/jetbrains/kotlin/js/backend/ast/JsClass;", "(Lorg/jetbrains/kotlin/js/backend/ast/JsClass;)V", "apply", "", "isTrivial", "Lorg/jetbrains/kotlin/js/backend/ast/JsFunction;", "js.translator"})
@SourceDebugExtension(value={"SMAP\nTrivialConstructorRemoval.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TrivialConstructorRemoval.kt\norg/jetbrains/kotlin/js/inline/clean/TrivialConstructorRemoval\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,30:1\n1724#2,2:31\n1724#2,3:33\n1726#2:36\n*S KotlinDebug\n*F\n+ 1 TrivialConstructorRemoval.kt\norg/jetbrains/kotlin/js/inline/clean/TrivialConstructorRemoval\n*L\n23#1:31,2\n27#1:33,3\n23#1:36\n*E\n"})
public final class TrivialConstructorRemoval {
    @NotNull
    private final JsClass klass;

    public TrivialConstructorRemoval(@NotNull JsClass klass) {
        Intrinsics.checkNotNullParameter((Object)klass, (String)"klass");
        this.klass = klass;
    }

    public final boolean apply() {
        JsFunction jsFunction = this.klass.getConstructor();
        if (!(jsFunction != null ? this.isTrivial(jsFunction) : false)) {
            return false;
        }
        this.klass.setConstructor(null);
        return true;
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isTrivial(JsFunction $this$isTrivial) {
        boolean bl;
        List<JsStatement> list2 = $this$isTrivial.getBody().getStatements();
        Intrinsics.checkNotNullExpressionValue(list2, (String)"getStatements(...)");
        Iterable $this$all$iv = list2;
        boolean $i$f$all = false;
        if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
            return true;
        }
        Iterator iterator2 = $this$all$iv.iterator();
        do {
            boolean bl2;
            void $this$all$iv2;
            JsInvocation invocation;
            JsExpressionStatement expressionStatement;
            if (!iterator2.hasNext()) return true;
            Object element$iv = iterator2.next();
            JsStatement statement2 = (JsStatement)element$iv;
            boolean bl3 = false;
            JsExpressionStatement jsExpressionStatement = expressionStatement = statement2 instanceof JsExpressionStatement ? (JsExpressionStatement)statement2 : null;
            Object object = jsExpressionStatement != null ? jsExpressionStatement.getExpression() : null;
            JsInvocation jsInvocation = invocation = object instanceof JsInvocation ? (JsInvocation)object : null;
            if (!((jsInvocation != null ? jsInvocation.getQualifier() : null) instanceof JsSuperRef)) return false;
            if (invocation.getArguments().size() != $this$isTrivial.getParameters().size()) return false;
            List<JsExpression> list3 = invocation.getArguments();
            Intrinsics.checkNotNullExpressionValue(list3, (String)"getArguments(...)");
            object = CollectionsKt.withIndex((Iterable)list3);
            boolean $i$f$all2 = false;
            if ($this$all$iv2 instanceof Collection && ((Collection)$this$all$iv2).isEmpty()) {
                bl2 = true;
            } else {
                for (Object element$iv2 : $this$all$iv2) {
                    IndexedValue indexedValue = (IndexedValue)element$iv2;
                    boolean bl4 = false;
                    int index2 = indexedValue.component1();
                    JsExpression argument2 = (JsExpression)indexedValue.component2();
                    if (!(argument2 instanceof JsNameRef)) return false;
                    if (((JsNameRef)argument2).getName() != $this$isTrivial.getParameters().get(index2).getName()) return false;
                    boolean bl5 = true;
                    if (bl5) continue;
                    return false;
                }
                bl2 = true;
            }
            if (!bl2) return false;
            bl = true;
        } while (bl);
        return false;
    }
}

