/*
 * Decompiled with CFR 0.152.
 */
package javaslang.collection;

import java.math.BigInteger;
import java.util.Comparator;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import javaslang.Tuple2;
import javaslang.Tuple3;
import javaslang.Value;
import javaslang.collection.AbstractIterator;
import javaslang.collection.Comparators;
import javaslang.collection.Foldable;
import javaslang.collection.Iterator;
import javaslang.collection.Map;
import javaslang.collection.Stream;
import javaslang.control.Option;

public interface Traversable<T>
extends Foldable<T>,
Value<T> {
    @Deprecated
    public static <T> int hash(Iterable<? extends T> objects) {
        int hashCode2 = 1;
        for (T o : objects) {
            hashCode2 = 31 * hashCode2 + Objects.hashCode(o);
        }
        return hashCode2;
    }

    public static <T> Traversable<T> narrow(Traversable<? extends T> traversable) {
        return traversable;
    }

    default public Option<Double> average() {
        if (this.isEmpty()) {
            return Option.none();
        }
        Stream objects = this.isTraversableAgain() ? this : this.toStream();
        T o = objects.head();
        if (o instanceof Number) {
            Stream numbers = objects;
            double d = o instanceof Integer || o instanceof Long || o instanceof Byte || o instanceof BigInteger || o instanceof Short ? numbers.toJavaStream().mapToLong(Number::longValue).average().getAsDouble() : numbers.toJavaStream().mapToDouble(Number::doubleValue).average().getAsDouble();
            return Option.some(d);
        }
        throw new UnsupportedOperationException("not numeric");
    }

    default public boolean containsAll(Iterable<? extends T> elements) {
        Objects.requireNonNull(elements, "elements is null");
        for (T element : elements) {
            if (this.contains(element)) continue;
            return false;
        }
        return true;
    }

    default public int count(Predicate<? super T> predicate) {
        Objects.requireNonNull(predicate, "predicate is null");
        return this.foldLeft(0, (i2, t) -> predicate.test(t) ? i2 + 1 : i2);
    }

    public Traversable<T> distinct();

    public Traversable<T> distinctBy(Comparator<? super T> var1);

    public <U> Traversable<T> distinctBy(Function<? super T, ? extends U> var1);

    public Traversable<T> drop(long var1);

    public Traversable<T> dropRight(long var1);

    public Traversable<T> dropUntil(Predicate<? super T> var1);

    public Traversable<T> dropWhile(Predicate<? super T> var1);

    default public boolean existsUnique(Predicate<? super T> predicate) {
        Objects.requireNonNull(predicate, "predicate is null");
        boolean exists = false;
        for (Object t : this) {
            if (!predicate.test(t)) continue;
            if (exists) {
                return false;
            }
            exists = true;
        }
        return exists;
    }

    public Traversable<T> filter(Predicate<? super T> var1);

    default public Option<T> find(Predicate<? super T> predicate) {
        Objects.requireNonNull(predicate, "predicate is null");
        for (Object a : this) {
            if (!predicate.test(a)) continue;
            return Option.some(a);
        }
        return Option.none();
    }

    default public Option<T> findLast(Predicate<? super T> predicate) {
        Objects.requireNonNull(predicate, "predicate is null");
        return this.iterator().findLast(predicate);
    }

    public <U> Traversable<U> flatMap(Function<? super T, ? extends Iterable<? extends U>> var1);

    @Override
    default public <U> U foldLeft(U zero, BiFunction<? super U, ? super T, ? extends U> f) {
        Objects.requireNonNull(f, "f is null");
        U xs = zero;
        for (Object x : this) {
            xs = f.apply(xs, x);
        }
        return xs;
    }

    @Override
    public <U> U foldRight(U var1, BiFunction<? super T, ? super U, ? extends U> var2);

    @Override
    default public T get() {
        return (T)this.iterator().next();
    }

    public <C> Map<C, ? extends Traversable<T>> groupBy(Function<? super T, ? extends C> var1);

    public Iterator<? extends Traversable<T>> grouped(long var1);

    public boolean hasDefiniteSize();

    public T head();

    default public Option<T> headOption() {
        return this.isEmpty() ? Option.none() : Option.some(this.head());
    }

    public Traversable<T> init();

    default public Option<? extends Traversable<T>> initOption() {
        return this.isEmpty() ? Option.none() : Option.some(this.init());
    }

    @Override
    default public boolean isEmpty() {
        return this.length() == 0;
    }

    @Override
    default public boolean isSingleValued() {
        return false;
    }

    public boolean isTraversableAgain();

    @Override
    default public Iterator<T> iterator() {
        final Traversable that = this;
        return new AbstractIterator<T>(){
            Traversable<T> traversable;
            {
                this.traversable = that;
            }

            @Override
            public boolean hasNext() {
                return !this.traversable.isEmpty();
            }

            @Override
            public T getNext() {
                Object result2 = this.traversable.head();
                this.traversable = this.traversable.tail();
                return result2;
            }
        };
    }

    default public T last() {
        if (this.isEmpty()) {
            throw new NoSuchElementException("last of empty Traversable");
        }
        java.util.Iterator it = this.iterator();
        T result2 = null;
        while (it.hasNext()) {
            result2 = (T)it.next();
        }
        return result2;
    }

    default public Option<T> lastOption() {
        return this.isEmpty() ? Option.none() : Option.some(this.last());
    }

    public int length();

    @Override
    public <U> Traversable<U> map(Function<? super T, ? extends U> var1);

    default public Option<T> max() {
        Stream ts;
        Stream stream = ts = this.isTraversableAgain() ? this : this.toStream();
        if (this.isEmpty()) {
            return Option.none();
        }
        return ts.maxBy(Comparators.naturalComparator());
    }

    default public Option<T> maxBy(Comparator<? super T> comparator) {
        Objects.requireNonNull(comparator, "comparator is null");
        if (this.isEmpty()) {
            return Option.none();
        }
        Object value2 = this.reduce((t1, t2) -> comparator.compare(t1, t2) >= 0 ? t1 : t2);
        return Option.some(value2);
    }

    default public <U extends Comparable<? super U>> Option<T> maxBy(Function<? super T, ? extends U> f) {
        Objects.requireNonNull(f, "f is null");
        if (this.isEmpty()) {
            return Option.none();
        }
        java.util.Iterator iter = this.iterator();
        Object tm = iter.next();
        Comparable um = (Comparable)f.apply(tm);
        while (iter.hasNext()) {
            Object t = iter.next();
            Comparable u = (Comparable)f.apply(t);
            if (u.compareTo(um) <= 0) continue;
            um = u;
            tm = t;
        }
        return Option.some(tm);
    }

    default public Option<T> min() {
        Stream ts;
        Stream stream = ts = this.isTraversableAgain() ? this : this.toStream();
        if (this.isEmpty()) {
            return Option.none();
        }
        return ts.minBy(Comparators.naturalComparator());
    }

    default public Option<T> minBy(Comparator<? super T> comparator) {
        Objects.requireNonNull(comparator, "comparator is null");
        if (this.isEmpty()) {
            return Option.none();
        }
        Object value2 = this.reduce((t1, t2) -> comparator.compare(t1, t2) <= 0 ? t1 : t2);
        return Option.some(value2);
    }

    default public <U extends Comparable<? super U>> Option<T> minBy(Function<? super T, ? extends U> f) {
        Objects.requireNonNull(f, "f is null");
        if (this.isEmpty()) {
            return Option.none();
        }
        java.util.Iterator iter = this.iterator();
        Object tm = iter.next();
        Comparable um = (Comparable)f.apply(tm);
        while (iter.hasNext()) {
            Object t = iter.next();
            Comparable u = (Comparable)f.apply(t);
            if (u.compareTo(um) >= 0) continue;
            um = u;
            tm = t;
        }
        return Option.some(tm);
    }

    default public String mkString() {
        return this.mkString("", "", "");
    }

    default public String mkString(CharSequence delimiter) {
        return this.mkString("", delimiter, "");
    }

    default public String mkString(CharSequence prefix, CharSequence delimiter, CharSequence suffix) {
        StringBuilder builder2 = new StringBuilder(prefix);
        this.iterator().map(String::valueOf).intersperse(String.valueOf(delimiter)).forEach(builder2::append);
        return builder2.append(suffix).toString();
    }

    default public boolean nonEmpty() {
        return !this.isEmpty();
    }

    public Tuple2<? extends Traversable<T>, ? extends Traversable<T>> partition(Predicate<? super T> var1);

    @Override
    public Traversable<T> peek(Consumer<? super T> var1);

    default public Number product() {
        if (this.isEmpty()) {
            return 1;
        }
        java.util.Iterator iter = this.iterator();
        Object o = iter.next();
        if (o instanceof Number) {
            Number head = (Number)o;
            java.util.Iterator numbers = iter;
            if (head instanceof Integer || head instanceof Long || head instanceof Byte || head instanceof BigInteger || head instanceof Short) {
                return numbers.toJavaStream().mapToLong(Number::longValue).reduce(head.longValue(), (l1, l2) -> l1 * l2);
            }
            return numbers.toJavaStream().mapToDouble(Number::doubleValue).reduce(head.doubleValue(), (d1, d2) -> d1 * d2);
        }
        throw new UnsupportedOperationException("not numeric");
    }

    @Override
    default public T reduceLeft(BiFunction<? super T, ? super T, ? extends T> op) {
        Objects.requireNonNull(op, "op is null");
        if (this.isEmpty()) {
            throw new NoSuchElementException("reduceLeft on Nil");
        }
        return this.tail().foldLeft(this.head(), op);
    }

    @Override
    default public Option<T> reduceLeftOption(BiFunction<? super T, ? super T, ? extends T> op) {
        Objects.requireNonNull(op, "op is null");
        return this.isEmpty() ? Option.none() : Option.some(this.reduceLeft(op));
    }

    @Override
    default public T reduceRight(BiFunction<? super T, ? super T, ? extends T> op) {
        Objects.requireNonNull(op, "op is null");
        if (this.isEmpty()) {
            throw new NoSuchElementException("reduceRight on empty");
        }
        return this.iterator().reduceRight(op);
    }

    @Override
    default public Option<T> reduceRightOption(BiFunction<? super T, ? super T, ? extends T> op) {
        Objects.requireNonNull(op, "op is null");
        return this.isEmpty() ? Option.none() : Option.some(this.reduceRight(op));
    }

    public Traversable<T> replace(T var1, T var2);

    public Traversable<T> replaceAll(T var1, T var2);

    public Traversable<T> retainAll(Iterable<? extends T> var1);

    public Traversable<T> scan(T var1, BiFunction<? super T, ? super T, ? extends T> var2);

    public <U> Traversable<U> scanLeft(U var1, BiFunction<? super U, ? super T, ? extends U> var2);

    public <U> Traversable<U> scanRight(U var1, BiFunction<? super T, ? super U, ? extends U> var2);

    default public int size() {
        return this.length();
    }

    public Iterator<? extends Traversable<T>> sliding(long var1);

    public Iterator<? extends Traversable<T>> sliding(long var1, long var3);

    public Tuple2<? extends Traversable<T>, ? extends Traversable<T>> span(Predicate<? super T> var1);

    default public Number sum() {
        if (this.isEmpty()) {
            return 0;
        }
        java.util.Iterator iter = this.iterator();
        Object o = iter.next();
        if (o instanceof Number) {
            Number head = (Number)o;
            java.util.Iterator numbers = iter;
            if (head instanceof Integer || head instanceof Long || head instanceof Byte || head instanceof BigInteger || head instanceof Short) {
                return numbers.foldLeft(head.longValue(), (n1, n2) -> n1 + n2.longValue());
            }
            return numbers.foldLeft(head.doubleValue(), (n1, n2) -> n1 + n2.doubleValue());
        }
        throw new UnsupportedOperationException("not numeric");
    }

    public Traversable<T> tail();

    public Option<? extends Traversable<T>> tailOption();

    public Traversable<T> take(long var1);

    public Traversable<T> takeRight(long var1);

    public Traversable<T> takeUntil(Predicate<? super T> var1);

    public Traversable<T> takeWhile(Predicate<? super T> var1);

    public <T1, T2> Tuple2<? extends Traversable<T1>, ? extends Traversable<T2>> unzip(Function<? super T, Tuple2<? extends T1, ? extends T2>> var1);

    public <T1, T2, T3> Tuple3<? extends Traversable<T1>, ? extends Traversable<T2>, ? extends Traversable<T3>> unzip3(Function<? super T, Tuple3<? extends T1, ? extends T2, ? extends T3>> var1);

    public <U> Traversable<Tuple2<T, U>> zip(Iterable<? extends U> var1);

    public <U> Traversable<Tuple2<T, U>> zipAll(Iterable<? extends U> var1, T var2, U var3);

    public Traversable<Tuple2<T, Long>> zipWithIndex();
}

