/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.cli.jvm;

import com.intellij.mock.MockProject;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.project.Project;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.backend.common.phaser.CompilerPhase;
import org.jetbrains.kotlin.backend.jvm.JvmPhasesKt;
import org.jetbrains.kotlin.cli.common.CLICompiler;
import org.jetbrains.kotlin.cli.common.CLIConfigurationKeys;
import org.jetbrains.kotlin.cli.common.CLITool;
import org.jetbrains.kotlin.cli.common.CommonCompilerPerformanceManager;
import org.jetbrains.kotlin.cli.common.CreatePhaseConfigKt;
import org.jetbrains.kotlin.cli.common.ExitCode;
import org.jetbrains.kotlin.cli.common.UtilsKt;
import org.jetbrains.kotlin.cli.common.arguments.CommonCompilerArguments;
import org.jetbrains.kotlin.cli.common.arguments.K2JVMCompilerArguments;
import org.jetbrains.kotlin.cli.common.extensions.ScriptEvaluationExtension;
import org.jetbrains.kotlin.cli.common.extensions.ShellExtension;
import org.jetbrains.kotlin.cli.common.messages.CompilerMessageSeverity;
import org.jetbrains.kotlin.cli.common.messages.MessageCollector;
import org.jetbrains.kotlin.cli.common.messages.MessageUtil;
import org.jetbrains.kotlin.cli.common.messages.OutputMessageUtil;
import org.jetbrains.kotlin.cli.common.modules.ModuleChunk;
import org.jetbrains.kotlin.cli.common.profiling.ProfilingCompilerPerformanceManager;
import org.jetbrains.kotlin.cli.jvm.JvmArgumentsKt;
import org.jetbrains.kotlin.cli.jvm.K2JVMCompilerKt;
import org.jetbrains.kotlin.cli.jvm.compiler.EnvironmentConfigFiles;
import org.jetbrains.kotlin.cli.jvm.compiler.FirKotlinToJvmBytecodeCompiler;
import org.jetbrains.kotlin.cli.jvm.compiler.KotlinCoreEnvironment;
import org.jetbrains.kotlin.cli.jvm.compiler.KotlinToJVMBytecodeCompiler;
import org.jetbrains.kotlin.cli.jvm.compiler.KotlinToJVMBytecodeCompilerKt;
import org.jetbrains.kotlin.cli.jvm.compiler.VfsBasedProjectEnvironment;
import org.jetbrains.kotlin.cli.jvm.compiler.pipeline.CompilerPipelineKt;
import org.jetbrains.kotlin.cli.jvm.config.ClassicFrontendSpecificJvmConfigurationKeys;
import org.jetbrains.kotlin.cli.jvm.config.JvmContentRootsKt;
import org.jetbrains.kotlin.codegen.CompilationException;
import org.jetbrains.kotlin.config.CommonConfigurationKeys;
import org.jetbrains.kotlin.config.CompilerConfiguration;
import org.jetbrains.kotlin.config.JVMConfigurationKeys;
import org.jetbrains.kotlin.config.Services;
import org.jetbrains.kotlin.incremental.components.EnumWhenTracker;
import org.jetbrains.kotlin.incremental.components.ExpectActualTracker;
import org.jetbrains.kotlin.incremental.components.ImportTracker;
import org.jetbrains.kotlin.incremental.components.InlineConstTracker;
import org.jetbrains.kotlin.incremental.components.LookupTracker;
import org.jetbrains.kotlin.load.java.JavaClassesTracker;
import org.jetbrains.kotlin.load.kotlin.incremental.components.IncrementalCompilationComponents;
import org.jetbrains.kotlin.metadata.deserialization.BinaryVersion;
import org.jetbrains.kotlin.metadata.jvm.deserialization.JvmMetadataVersion;
import org.jetbrains.kotlin.modules.Module;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.utils.KotlinPaths;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000l\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0015\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010!\n\u0002\b\u0003\u0018\u0000 &2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0002&'B\u0005\u00a2\u0006\u0002\u0010\u0003J\b\u0010\b\u001a\u00020\u0002H\u0016J*\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0014J\u0018\u0010\u0017\u001a\u00020\u00052\u0006\u0010\u0018\u001a\u00020\u00022\u0006\u0010\u0019\u001a\u00020\u001aH\u0014J*\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u0018\u001a\u00020\u00022\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000b\u001a\u00020\f2\b\u0010\u001d\u001a\u0004\u0018\u00010\u001eH\u0014J\b\u0010\u001f\u001a\u00020\u0012H\u0016J\b\u0010 \u001a\u00020!H\u0002J \u0010\"\u001a\u00020#2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0018\u001a\u00020\u00022\u0006\u0010\u0019\u001a\u00020\u001aH\u0014J\u001a\u0010$\u001a\u00020#*\b\u0012\u0004\u0012\u00020\u00120%2\u0006\u0010\u0018\u001a\u00020\u0002H\u0014R\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006("}, d2={"Lorg/jetbrains/kotlin/cli/jvm/K2JVMCompiler;", "Lorg/jetbrains/kotlin/cli/common/CLICompiler;", "Lorg/jetbrains/kotlin/cli/common/arguments/K2JVMCompilerArguments;", "()V", "defaultPerformanceManager", "Lorg/jetbrains/kotlin/cli/common/CommonCompilerPerformanceManager;", "getDefaultPerformanceManager", "()Lorg/jetbrains/kotlin/cli/common/CommonCompilerPerformanceManager;", "createArguments", "createCoreEnvironment", "Lorg/jetbrains/kotlin/cli/jvm/compiler/KotlinCoreEnvironment;", "rootDisposable", "Lcom/intellij/openapi/Disposable;", "configuration", "Lorg/jetbrains/kotlin/config/CompilerConfiguration;", "messageCollector", "Lorg/jetbrains/kotlin/cli/common/messages/MessageCollector;", "targetDescription", "", "createMetadataVersion", "Lorg/jetbrains/kotlin/metadata/deserialization/BinaryVersion;", "versionArray", "", "createPerformanceManager", "arguments", "services", "Lorg/jetbrains/kotlin/config/Services;", "doExecute", "Lorg/jetbrains/kotlin/cli/common/ExitCode;", "paths", "Lorg/jetbrains/kotlin/utils/KotlinPaths;", "executableScriptFileName", "isUseOldBackendAllowed", "", "setupPlatformSpecificArgumentsAndServices", "", "addPlatformOptions", "", "Companion", "K2JVMCompilerPerformanceManager", "cli"})
@SourceDebugExtension(value={"SMAP\nK2JVMCompiler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 K2JVMCompiler.kt\norg/jetbrains/kotlin/cli/jvm/K2JVMCompiler\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,326:1\n1#2:327\n1557#3:328\n1628#3,3:329\n*S KotlinDebug\n*F\n+ 1 K2JVMCompiler.kt\norg/jetbrains/kotlin/cli/jvm/K2JVMCompiler\n*L\n138#1:328\n138#1:329,3\n*E\n"})
public final class K2JVMCompiler
extends CLICompiler<K2JVMCompilerArguments> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final CommonCompilerPerformanceManager defaultPerformanceManager = new K2JVMCompilerPerformanceManager();

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    protected ExitCode doExecute(@NotNull K2JVMCompilerArguments arguments2, @NotNull CompilerConfiguration configuration2, @NotNull Disposable rootDisposable, @Nullable KotlinPaths paths) {
        Intrinsics.checkNotNullParameter((Object)arguments2, (String)"arguments");
        Intrinsics.checkNotNullParameter((Object)configuration2, (String)"configuration");
        Intrinsics.checkNotNullParameter((Object)rootDisposable, (String)"rootDisposable");
        MessageCollector messageCollector2 = configuration2.getNotNull(CLIConfigurationKeys.MESSAGE_COLLECTOR_KEY);
        Intrinsics.checkNotNullExpressionValue((Object)messageCollector2, (String)"getNotNull(...)");
        MessageCollector messageCollector3 = messageCollector2;
        configuration2.put(CLIConfigurationKeys.PHASE_CONFIG, CreatePhaseConfigKt.createPhaseConfig((CompilerPhase)JvmPhasesKt.getJvmPhases(), arguments2, messageCollector3));
        if (!JvmArgumentsKt.configureJdkHome(configuration2, arguments2)) {
            return ExitCode.COMPILATION_ERROR;
        }
        configuration2.put(JVMConfigurationKeys.DISABLE_STANDARD_SCRIPT_DEFINITION, arguments2.getDisableStandardScript());
        ExitCode pluginLoadResult = this.loadPlugins(paths, (CommonCompilerArguments)arguments2, configuration2);
        if (pluginLoadResult != ExitCode.OK) {
            return pluginLoadResult;
        }
        String string2 = arguments2.getModuleName();
        if (string2 == null) {
            string2 = "main";
        }
        String moduleName = string2;
        configuration2.put(CommonConfigurationKeys.MODULE_NAME, moduleName);
        JvmArgumentsKt.configureJavaModulesContentRoots(configuration2, arguments2);
        JvmArgumentsKt.configureStandardLibs(configuration2, paths, arguments2);
        JvmArgumentsKt.configureAdvancedJvmOptions(configuration2, arguments2);
        JvmArgumentsKt.configureKlibPaths(configuration2, arguments2);
        if (arguments2.getBuildFile() == null && !arguments2.getVersion() && !arguments2.getAllowNoSourceFiles() && (arguments2.getScript() || arguments2.getExpression() != null || arguments2.getFreeArgs().isEmpty())) {
            Object v5;
            KotlinCoreEnvironment.ProjectEnvironment projectEnvironment2;
            block29: {
                JvmArgumentsKt.configureContentRootsFromClassPath(configuration2, arguments2);
                JvmContentRootsKt.configureJdkClasspathRoots(configuration2);
                if (arguments2.getScript() && arguments2.getFreeArgs().isEmpty()) {
                    MessageCollector.report$default(messageCollector3, CompilerMessageSeverity.ERROR, "Specify script source path to evaluate", null, 4, null);
                    return ExitCode.COMPILATION_ERROR;
                }
                projectEnvironment2 = new KotlinCoreEnvironment.ProjectEnvironment(rootDisposable, KotlinCoreEnvironment.Companion.getOrCreateApplicationEnvironmentForProduction(rootDisposable, configuration2), configuration2);
                projectEnvironment2.registerExtensionsFromPlugins(configuration2);
                if (arguments2.getUseOldBackend()) {
                    MessageCollector.report$default(messageCollector3, CompilerMessageSeverity.WARNING, "-Xuse-old-backend is no longer supported. Please migrate to the new JVM IR backend", null, 4, null);
                }
                if (arguments2.getScript() || arguments2.getExpression() != null) {
                    Object v3;
                    block28: {
                        MockProject mockProject = projectEnvironment2.getProject();
                        Intrinsics.checkNotNullExpressionValue((Object)mockProject, (String)"getProject(...)");
                        Iterable iterable = ScriptEvaluationExtension.Companion.getInstances((Project)mockProject);
                        for (Object t : iterable) {
                            ScriptEvaluationExtension it = (ScriptEvaluationExtension)t;
                            boolean bl = false;
                            if (!it.isAccepted(arguments2)) continue;
                            v3 = t;
                            break block28;
                        }
                        v3 = null;
                    }
                    ScriptEvaluationExtension scriptingEvaluator = v3;
                    if (scriptingEvaluator == null) {
                        MessageCollector.report$default(messageCollector3, CompilerMessageSeverity.ERROR, "Unable to evaluate script, no scripting plugin loaded", null, 4, null);
                        return ExitCode.COMPILATION_ERROR;
                    }
                    return scriptingEvaluator.eval(arguments2, configuration2, projectEnvironment2);
                }
                MockProject mockProject = projectEnvironment2.getProject();
                Intrinsics.checkNotNullExpressionValue((Object)mockProject, (String)"getProject(...)");
                Iterable iterable = ShellExtension.Companion.getInstances((Project)mockProject);
                for (Object t : iterable) {
                    ShellExtension it = (ShellExtension)t;
                    boolean bl = false;
                    if (!it.isAccepted(arguments2)) continue;
                    v5 = t;
                    break block29;
                }
                v5 = null;
            }
            ShellExtension shell = v5;
            if (shell == null) {
                MessageCollector.report$default(messageCollector3, CompilerMessageSeverity.ERROR, "Unable to run REPL, no scripting plugin loaded", null, 4, null);
                return ExitCode.COMPILATION_ERROR;
            }
            return shell.run(arguments2, configuration2, projectEnvironment2);
        }
        if (arguments2.getUseOldBackend()) {
            CompilerMessageSeverity severity = this.isUseOldBackendAllowed() ? CompilerMessageSeverity.WARNING : CompilerMessageSeverity.ERROR;
            MessageCollector.report$default(messageCollector3, severity, "-Xuse-old-backend is no longer supported. Please migrate to the new JVM IR backend", null, 4, null);
            if (severity == CompilerMessageSeverity.ERROR) {
                return ExitCode.COMPILATION_ERROR;
            }
        }
        MessageCollector.report$default(messageCollector3, CompilerMessageSeverity.LOGGING, "Configuring the compilation environment", null, 4, null);
        try {
            void $this$mapTo$iv$iv;
            File file2;
            String string3 = arguments2.getBuildFile();
            if (string3 != null) {
                String it = string3;
                boolean bl = false;
                file2 = new File(it);
            } else {
                file2 = null;
            }
            File buildFile = file2;
            ModuleChunk moduleChunk = K2JVMCompilerKt.configureModuleChunk(configuration2, arguments2, buildFile);
            List<Module> list2 = moduleChunk.getModules();
            Intrinsics.checkNotNullExpressionValue(list2, (String)"getModules(...)");
            List<Module> chunk = list2;
            KotlinToJVMBytecodeCompilerKt.configureSourceRoots(configuration2, chunk, buildFile);
            JvmContentRootsKt.configureJdkClasspathRoots(configuration2);
            Iterable $this$map$iv = chunk;
            boolean $i$f$map = false;
            Iterable it = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void input;
                Module module2 = (Module)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(input.getModuleName() + '-' + input.getModuleType());
            }
            List names2 = (List)destination$iv$iv;
            boolean bl = false;
            String string4 = (String)CollectionsKt.singleOrNull((List)names2);
            if (string4 == null) {
                string4 = CollectionsKt.joinToString$default((Iterable)names2, null, null, null, (int)0, null, null, (int)63, null);
            }
            String targetDescription = string4;
            if (chunk.size() == 1 && configuration2.getBoolean(CommonConfigurationKeys.USE_FIR) && configuration2.getBoolean(CommonConfigurationKeys.USE_LIGHT_TREE)) {
                if (messageCollector3.hasErrors()) {
                    return ExitCode.COMPILATION_ERROR;
                }
                VfsBasedProjectEnvironment projectEnvironment3 = CompilerPipelineKt.createProjectEnvironment(configuration2, rootDisposable, EnvironmentConfigFiles.JVM_CONFIG_FILES, messageCollector3);
                if (messageCollector3.hasErrors()) {
                    return ExitCode.COMPILATION_ERROR;
                }
                if (!FirKotlinToJvmBytecodeCompiler.INSTANCE.checkNotSupportedPlugins(configuration2, messageCollector3)) {
                    return ExitCode.COMPILATION_ERROR;
                }
                Object object = CollectionsKt.single(chunk);
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"single(...)");
                CompilerPipelineKt.compileModulesUsingFrontendIrAndLightTree(projectEnvironment3, configuration2, messageCollector3, buildFile, (Module)object, targetDescription, !arguments2.getAllowNoSourceFiles(), arguments2.getVersion());
            } else {
                KotlinCoreEnvironment kotlinCoreEnvironment = this.createCoreEnvironment(rootDisposable, configuration2, messageCollector3, targetDescription);
                if (kotlinCoreEnvironment == null) {
                    return ExitCode.COMPILATION_ERROR;
                }
                KotlinCoreEnvironment environment2 = kotlinCoreEnvironment;
                boolean it2 = JvmArgumentsKt.registerJavacIfNeeded(environment2, arguments2);
                boolean bl2 = false;
                if (!it2) {
                    return ExitCode.COMPILATION_ERROR;
                }
                if (environment2.getSourceFiles().isEmpty() && !arguments2.getAllowNoSourceFiles() && buildFile == null) {
                    if (arguments2.getVersion()) {
                        return ExitCode.OK;
                    }
                    MessageCollector.report$default(messageCollector3, CompilerMessageSeverity.ERROR, "No source files", null, 4, null);
                    return ExitCode.COMPILATION_ERROR;
                }
                KotlinToJVMBytecodeCompiler.INSTANCE.compileModules$cli(environment2, buildFile, chunk);
            }
            return ExitCode.OK;
        }
        catch (CompilationException e) {
            String string5 = OutputMessageUtil.renderException(e);
            Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"renderException(...)");
            messageCollector3.report(CompilerMessageSeverity.EXCEPTION, string5, MessageUtil.psiElementToMessageLocation(e.getElement()));
            return ExitCode.INTERNAL_ERROR;
        }
    }

    @Override
    protected void addPlatformOptions(@NotNull List<String> $this$addPlatformOptions, @NotNull K2JVMCompilerArguments arguments2) {
        Intrinsics.checkNotNullParameter($this$addPlatformOptions, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)arguments2, (String)"arguments");
        String[] stringArray = arguments2.getScriptTemplates();
        boolean bl = stringArray != null ? !(stringArray.length == 0) : false;
        if (bl) {
            StringBuilder stringBuilder2 = new StringBuilder().append("plugin:kotlin.scripting:script-templates=");
            Object[] objectArray = arguments2.getScriptTemplates();
            Intrinsics.checkNotNull((Object)objectArray);
            $this$addPlatformOptions.add(stringBuilder2.append(ArraysKt.joinToString$default((Object[])objectArray, (CharSequence)",", null, null, (int)0, null, null, (int)62, null)).toString());
        }
        String[] stringArray2 = arguments2.getScriptResolverEnvironment();
        boolean bl2 = stringArray2 != null ? !(stringArray2.length == 0) : false;
        if (bl2) {
            StringBuilder stringBuilder3 = new StringBuilder().append("plugin:kotlin.scripting:script-resolver-environment=");
            Object[] objectArray = arguments2.getScriptResolverEnvironment();
            Intrinsics.checkNotNull((Object)objectArray);
            $this$addPlatformOptions.add(stringBuilder3.append(ArraysKt.joinToString$default((Object[])objectArray, (CharSequence)",", null, null, (int)0, null, null, (int)62, null)).toString());
        }
    }

    private final KotlinCoreEnvironment createCoreEnvironment(Disposable rootDisposable, CompilerConfiguration configuration2, MessageCollector messageCollector2, String targetDescription) {
        KotlinCoreEnvironment environment2;
        block1: {
            if (messageCollector2.hasErrors()) {
                return null;
            }
            environment2 = KotlinCoreEnvironment.Companion.createForProduction(rootDisposable, configuration2, EnvironmentConfigFiles.JVM_CONFIG_FILES);
            List<KtFile> sourceFiles = environment2.getSourceFiles();
            CommonCompilerPerformanceManager commonCompilerPerformanceManager = configuration2.get(CLIConfigurationKeys.PERF_MANAGER);
            if (commonCompilerPerformanceManager == null) break block1;
            commonCompilerPerformanceManager.notifyCompilerInitialized(sourceFiles.size(), environment2.countLinesOfCode(sourceFiles), targetDescription);
        }
        return messageCollector2.hasErrors() ? null : environment2;
    }

    @Override
    protected void setupPlatformSpecificArgumentsAndServices(@NotNull CompilerConfiguration configuration2, @NotNull K2JVMCompilerArguments arguments2, @NotNull Services services) {
        Intrinsics.checkNotNullParameter((Object)configuration2, (String)"configuration");
        Intrinsics.checkNotNullParameter((Object)arguments2, (String)"arguments");
        Intrinsics.checkNotNullParameter((Object)services, (String)"services");
        CompilerConfiguration $this$setupPlatformSpecificArgumentsAndServices_u24lambda_u246 = configuration2;
        boolean bl = false;
        if (UtilsKt.incrementalCompilationIsEnabled(arguments2)) {
            $this$setupPlatformSpecificArgumentsAndServices_u24lambda_u246.putIfNotNull(CommonConfigurationKeys.LOOKUP_TRACKER, services.get(LookupTracker.class));
            $this$setupPlatformSpecificArgumentsAndServices_u24lambda_u246.putIfNotNull(CommonConfigurationKeys.EXPECT_ACTUAL_TRACKER, services.get(ExpectActualTracker.class));
            $this$setupPlatformSpecificArgumentsAndServices_u24lambda_u246.putIfNotNull(CommonConfigurationKeys.INLINE_CONST_TRACKER, services.get(InlineConstTracker.class));
            $this$setupPlatformSpecificArgumentsAndServices_u24lambda_u246.putIfNotNull(CommonConfigurationKeys.ENUM_WHEN_TRACKER, services.get(EnumWhenTracker.class));
            $this$setupPlatformSpecificArgumentsAndServices_u24lambda_u246.putIfNotNull(CommonConfigurationKeys.IMPORT_TRACKER, services.get(ImportTracker.class));
            $this$setupPlatformSpecificArgumentsAndServices_u24lambda_u246.putIfNotNull(JVMConfigurationKeys.INCREMENTAL_COMPILATION_COMPONENTS, services.get(IncrementalCompilationComponents.class));
            $this$setupPlatformSpecificArgumentsAndServices_u24lambda_u246.putIfNotNull(ClassicFrontendSpecificJvmConfigurationKeys.JAVA_CLASSES_TRACKER, services.get(JavaClassesTracker.class));
        }
        JvmArgumentsKt.setupJvmSpecificArguments($this$setupPlatformSpecificArgumentsAndServices_u24lambda_u246, arguments2);
    }

    @Override
    @NotNull
    public K2JVMCompilerArguments createArguments() {
        K2JVMCompilerArguments k2JVMCompilerArguments;
        K2JVMCompilerArguments $this$createArguments_u24lambda_u247 = k2JVMCompilerArguments = new K2JVMCompilerArguments();
        boolean bl = false;
        if (System.getenv("KOTLIN_REPORT_PERF") != null) {
            $this$createArguments_u24lambda_u247.setReportPerf(true);
        }
        return k2JVMCompilerArguments;
    }

    @Override
    @NotNull
    public String executableScriptFileName() {
        return "kotlinc-jvm";
    }

    @Override
    @NotNull
    protected BinaryVersion createMetadataVersion(@NotNull int[] versionArray) {
        Intrinsics.checkNotNullParameter((Object)versionArray, (String)"versionArray");
        return new JvmMetadataVersion(Arrays.copyOf(versionArray, versionArray.length));
    }

    @Override
    @NotNull
    public CommonCompilerPerformanceManager getDefaultPerformanceManager() {
        return this.defaultPerformanceManager;
    }

    @Override
    @NotNull
    protected CommonCompilerPerformanceManager createPerformanceManager(@NotNull K2JVMCompilerArguments arguments2, @NotNull Services services) {
        Intrinsics.checkNotNullParameter((Object)arguments2, (String)"arguments");
        Intrinsics.checkNotNullParameter((Object)services, (String)"services");
        CommonCompilerPerformanceManager externalManager = services.get(CommonCompilerPerformanceManager.class);
        if (externalManager != null) {
            return externalManager;
        }
        String string2 = arguments2.getProfileCompilerCommand();
        if (string2 == null) {
            return this.getDefaultPerformanceManager();
        }
        String argument2 = string2;
        return ProfilingCompilerPerformanceManager.Companion.create(argument2);
    }

    private final boolean isUseOldBackendAllowed() {
        return K2JVMCompiler.class.getClassLoader().getResource("META-INF/unsafe-allow-use-old-backend") != null;
    }

    @JvmStatic
    public static final void main(@NotNull String[] args) {
        Companion.main(args);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001b\u0010\u0003\u001a\u00020\u00042\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006H\u0007\u00a2\u0006\u0002\u0010\b\u00a8\u0006\t"}, d2={"Lorg/jetbrains/kotlin/cli/jvm/K2JVMCompiler$Companion;", "", "()V", "main", "", "args", "", "", "([Ljava/lang/String;)V", "cli"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        public final void main(@NotNull String[] args) {
            Intrinsics.checkNotNullParameter((Object)args, (String)"args");
            CLITool.Companion.doMain(new K2JVMCompiler(), args);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Lorg/jetbrains/kotlin/cli/jvm/K2JVMCompiler$K2JVMCompilerPerformanceManager;", "Lorg/jetbrains/kotlin/cli/common/CommonCompilerPerformanceManager;", "()V", "cli"})
    protected static final class K2JVMCompilerPerformanceManager
    extends CommonCompilerPerformanceManager {
        public K2JVMCompilerPerformanceManager() {
            super("Kotlin to JVM Compiler");
        }
    }
}

