/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.native.checkers;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.fir.FirPlatformSpecificCastChecker;
import org.jetbrains.kotlin.fir.FirSession;
import org.jetbrains.kotlin.fir.analysis.native.checkers.FirNativeHelpersKt;
import org.jetbrains.kotlin.fir.symbols.impl.FirRegularClassSymbol;
import org.jetbrains.kotlin.fir.types.ConeKotlinType;
import org.jetbrains.kotlin.fir.types.TypeUtilsKt;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002J \u0010\t\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\bH\u0016\u00a8\u0006\f"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/native/checkers/FirNativeCastChecker;", "Lorg/jetbrains/kotlin/fir/FirPlatformSpecificCastChecker;", "()V", "isCastToAForwardDeclaration", "", "session", "Lorg/jetbrains/kotlin/fir/FirSession;", "forwardDeclarationType", "Lorg/jetbrains/kotlin/fir/types/ConeKotlinType;", "shouldSuppressImpossibleCast", "fromType", "toType", "checkers.native"})
public final class FirNativeCastChecker
extends FirPlatformSpecificCastChecker {
    @NotNull
    public static final FirNativeCastChecker INSTANCE = new FirNativeCastChecker();

    private FirNativeCastChecker() {
    }

    @Override
    public boolean shouldSuppressImpossibleCast(@NotNull FirSession session2, @NotNull ConeKotlinType fromType, @NotNull ConeKotlinType toType) {
        Intrinsics.checkNotNullParameter((Object)session2, (String)"session");
        Intrinsics.checkNotNullParameter((Object)fromType, (String)"fromType");
        Intrinsics.checkNotNullParameter((Object)toType, (String)"toType");
        return this.isCastToAForwardDeclaration(session2, toType);
    }

    private final boolean isCastToAForwardDeclaration(FirSession session2, ConeKotlinType forwardDeclarationType) {
        FirRegularClassSymbol firRegularClassSymbol = TypeUtilsKt.toRegularClassSymbol(forwardDeclarationType, session2);
        return (firRegularClassSymbol != null ? FirNativeHelpersKt.forwardDeclarationKindOrNull(firRegularClassSymbol) : null) != null;
    }
}

