/*
 * Decompiled with CFR 0.152.
 */
package org.jline.builtins;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.PathMatcher;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import java.util.stream.Stream;
import org.jline.builtins.Source;
import org.jline.builtins.Styles;
import org.jline.utils.AttributedString;
import org.jline.utils.AttributedStringBuilder;
import org.jline.utils.AttributedStyle;
import org.jline.utils.Log;
import org.jline.utils.StyleResolver;

public class SyntaxHighlighter {
    public static final String REGEX_TOKEN_NAME = "[A-Z_]+";
    public static final String TYPE_NANORCTHEME = ".nanorctheme";
    public static final String DEFAULT_NANORC_FILE = "jnanorc";
    protected static final String DEFAULT_LESSRC_FILE = "jlessrc";
    protected static final String COMMAND_INCLUDE = "include";
    protected static final String COMMAND_THEME = "theme";
    private static final String TOKEN_NANORC = "NANORC";
    private final Path nanorc;
    private final String syntaxName;
    private final String nanorcUrl;
    private final Map<String, List<HighlightRule>> rules = new HashMap<String, List<HighlightRule>>();
    private Path currentTheme;
    private boolean startEndHighlight;
    private int ruleStartId = 0;
    private Parser parser;

    private SyntaxHighlighter() {
        this(null, null, null);
    }

    private SyntaxHighlighter(String nanorcUrl) {
        this(null, null, nanorcUrl);
    }

    private SyntaxHighlighter(Path nanorc, String syntaxName) {
        this(nanorc, syntaxName, null);
    }

    private SyntaxHighlighter(Path nanorc, String syntaxName, String nanorcUrl) {
        this.nanorc = nanorc;
        this.syntaxName = syntaxName;
        this.nanorcUrl = nanorcUrl;
        HashMap defaultRules = new HashMap();
        defaultRules.put(TOKEN_NANORC, new ArrayList());
        this.rules.putAll(defaultRules);
    }

    protected static SyntaxHighlighter build(List<Path> syntaxFiles, String file2, String syntaxName) {
        return SyntaxHighlighter.build(syntaxFiles, file2, syntaxName, false);
    }

    protected static SyntaxHighlighter build(List<Path> syntaxFiles, String file2, String syntaxName, boolean ignoreErrors) {
        SyntaxHighlighter out;
        block14: {
            out = new SyntaxHighlighter();
            HashMap<String, String> colorTheme = new HashMap<String, String>();
            try {
                if (syntaxName == null || !syntaxName.equals("none")) {
                    for (Path p : syntaxFiles) {
                        try {
                            if (colorTheme.isEmpty() && p.getFileName().toString().endsWith(TYPE_NANORCTHEME)) {
                                out.setCurrentTheme(p);
                                BufferedReader reader = new BufferedReader(new FileReader(p.toFile()));
                                try {
                                    String line;
                                    while ((line = reader.readLine()) != null) {
                                        if ((line = line.trim()).length() <= 0 || line.startsWith("#")) continue;
                                        List<String> parts2 = Arrays.asList(line.split("\\s+", 2));
                                        colorTheme.put(parts2.get(0), parts2.get(1));
                                    }
                                    continue;
                                }
                                finally {
                                    reader.close();
                                    continue;
                                }
                            }
                            NanorcParser nanorcParser = new NanorcParser(p, syntaxName, file2, colorTheme);
                            nanorcParser.parse();
                            if (nanorcParser.matches()) {
                                out.addRules(nanorcParser.getHighlightRules());
                                out.setParser(nanorcParser.getParser());
                                return out;
                            }
                            if (!nanorcParser.isDefault()) continue;
                            out.addRules(nanorcParser.getHighlightRules());
                        }
                        catch (IOException iOException) {}
                    }
                }
            }
            catch (PatternSyntaxException e) {
                if (ignoreErrors) break block14;
                throw e;
            }
        }
        return out;
    }

    public static SyntaxHighlighter build(Path nanorc, String syntaxName) {
        SyntaxHighlighter out = new SyntaxHighlighter(nanorc, syntaxName);
        ArrayList<Path> syntaxFiles = new ArrayList<Path>();
        try {
            try (BufferedReader reader = new BufferedReader(new FileReader(nanorc.toFile()));){
                String line;
                while ((line = reader.readLine()) != null) {
                    if ((line = line.trim()).length() <= 0 || line.startsWith("#")) continue;
                    List<String> parts2 = RuleSplitter.split(line);
                    if (parts2.get(0).equals(COMMAND_INCLUDE)) {
                        SyntaxHighlighter.nanorcInclude(parts2.get(1), syntaxFiles);
                        continue;
                    }
                    if (!parts2.get(0).equals(COMMAND_THEME)) continue;
                    SyntaxHighlighter.nanorcTheme(parts2.get(1), syntaxFiles);
                }
            }
            SyntaxHighlighter sh = SyntaxHighlighter.build(syntaxFiles, null, syntaxName);
            out.addRules(sh.rules);
            out.setParser(sh.parser);
            out.setCurrentTheme(sh.currentTheme);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return out;
    }

    protected static void nanorcInclude(String parameter2, List<Path> syntaxFiles) throws IOException {
        SyntaxHighlighter.addFiles(parameter2, s -> s.forEach(syntaxFiles::add));
    }

    protected static void nanorcTheme(String parameter2, List<Path> syntaxFiles) throws IOException {
        SyntaxHighlighter.addFiles(parameter2, s -> s.findFirst().ifPresent(p -> syntaxFiles.add(0, (Path)p)));
    }

    protected static void addFiles(String parameter2, Consumer<Stream<Path>> consumer) throws IOException {
        if (parameter2.contains("*") || parameter2.contains("?")) {
            PathMatcher pathMatcher = FileSystems.getDefault().getPathMatcher("glob:" + parameter2);
            try (Stream<Path> pathStream = Files.walk(Paths.get(new File(parameter2).getParent(), new String[0]), new FileVisitOption[0]);){
                consumer.accept(pathStream.filter(pathMatcher::matches));
            }
        } else {
            consumer.accept(Stream.of(Paths.get(parameter2, new String[0])));
        }
    }

    public static SyntaxHighlighter build(String nanorcUrl) {
        SyntaxHighlighter out = new SyntaxHighlighter(nanorcUrl);
        try {
            InputStream inputStream = nanorcUrl.startsWith("classpath:") ? new Source.ResourceSource(nanorcUrl.substring(10), null).read() : new Source.URLSource(new URI(nanorcUrl).toURL(), null).read();
            NanorcParser parser = new NanorcParser(inputStream, null, null);
            parser.parse();
            out.addRules(parser.getHighlightRules());
        }
        catch (IOException | URISyntaxException exception) {
            // empty catch block
        }
        return out;
    }

    private void addRules(Map<String, List<HighlightRule>> rules) {
        this.rules.putAll(rules);
    }

    public void setCurrentTheme(Path currentTheme) {
        this.currentTheme = currentTheme;
    }

    public Path getCurrentTheme() {
        return this.currentTheme;
    }

    public void setParser(Parser parser) {
        this.parser = parser;
    }

    public SyntaxHighlighter reset() {
        this.ruleStartId = 0;
        this.startEndHighlight = false;
        if (this.parser != null) {
            this.parser.reset();
        }
        return this;
    }

    public void refresh() {
        SyntaxHighlighter sh;
        if (this.nanorc != null && this.syntaxName != null) {
            sh = SyntaxHighlighter.build(this.nanorc, this.syntaxName);
        } else if (this.nanorcUrl != null) {
            sh = SyntaxHighlighter.build(this.nanorcUrl);
        } else {
            throw new IllegalStateException("Not possible to refresh highlighter!");
        }
        this.rules.clear();
        this.addRules(sh.rules);
        this.parser = sh.parser;
        this.currentTheme = sh.currentTheme;
    }

    public AttributedString highlight(String string2) {
        return this.splitAndHighlight(new AttributedString(string2));
    }

    public AttributedString highlight(AttributedStringBuilder asb) {
        return this.splitAndHighlight(asb.toAttributedString());
    }

    public AttributedString highlight(AttributedString attributedString) {
        return this.splitAndHighlight(attributedString);
    }

    private AttributedString splitAndHighlight(AttributedString attributedString) {
        AttributedStringBuilder asb = new AttributedStringBuilder();
        boolean first = true;
        for (AttributedString line : attributedString.columnSplitLength(Integer.MAX_VALUE)) {
            if (!first) {
                asb.append("\n");
            }
            List<Object> tokens = new ArrayList();
            if (this.parser != null) {
                this.parser.parse(line);
                tokens = this.parser.getTokens();
            }
            if (tokens.isEmpty()) {
                asb.append(this._highlight(line, this.rules.get(TOKEN_NANORC)));
            } else {
                int pos = 0;
                for (ParsedToken t : tokens) {
                    if (t.getStart() > pos) {
                        AttributedStringBuilder head = this._highlight(line.columnSubSequence(pos, t.getStart() + 1), this.rules.get(TOKEN_NANORC));
                        asb.append(head.columnSubSequence(0, head.length() - 1));
                    }
                    asb.append(this._highlight(line.columnSubSequence(t.getStart(), t.getEnd()), this.rules.get(t.getName()), t.getStartWith(), line.columnSubSequence(t.getEnd(), line.length())));
                    pos = t.getEnd();
                }
                if (pos < line.length()) {
                    asb.append(this._highlight(line.columnSubSequence(pos, line.length()), this.rules.get(TOKEN_NANORC)));
                }
            }
            first = false;
        }
        return asb.toAttributedString();
    }

    private AttributedStringBuilder _highlight(AttributedString line, List<HighlightRule> rules) {
        return this._highlight(line, rules, null, null);
    }

    private AttributedStringBuilder _highlight(AttributedString line, List<HighlightRule> rules, CharSequence startWith, CharSequence continueAs) {
        AttributedStringBuilder asb = new AttributedStringBuilder();
        asb.append(line);
        if (rules.isEmpty()) {
            return asb;
        }
        int startId = this.ruleStartId;
        boolean endHighlight = this.startEndHighlight;
        block6: for (int i2 = startId; i2 < (endHighlight ? startId + 1 : rules.size()); ++i2) {
            HighlightRule rule = rules.get(i2);
            switch (rule.getType().ordinal()) {
                case 0: {
                    asb.styleMatches(rule.getPattern(), rule.getStyle());
                    continue block6;
                }
                case 1: {
                    boolean done2 = false;
                    Matcher start = rule.getStart().matcher(asb.toAttributedString());
                    Matcher end = rule.getEnd().matcher(asb.toAttributedString());
                    while (!done2) {
                        AttributedStringBuilder a = new AttributedStringBuilder();
                        if (this.startEndHighlight && this.ruleStartId == i2) {
                            if (end.find()) {
                                this.ruleStartId = 0;
                                this.startEndHighlight = false;
                                a.append(asb.columnSubSequence(0, end.end()), rule.getStyle());
                                a.append(this._highlight(asb.columnSubSequence(end.end(), asb.length()).toAttributedString(), rules));
                            } else {
                                a.append(asb, rule.getStyle());
                                done2 = true;
                            }
                            asb = a;
                            continue;
                        }
                        if (start.find()) {
                            a.append(asb.columnSubSequence(0, start.start()));
                            if (end.find()) {
                                a.append(asb.columnSubSequence(start.start(), end.end()), rule.getStyle());
                                a.append(asb.columnSubSequence(end.end(), asb.length()));
                            } else {
                                this.ruleStartId = i2;
                                this.startEndHighlight = true;
                                a.append(asb.columnSubSequence(start.start(), asb.length()), rule.getStyle());
                                done2 = true;
                            }
                            asb = a;
                            continue;
                        }
                        done2 = true;
                    }
                    continue block6;
                }
                case 2: {
                    if (startWith == null || !startWith.toString().startsWith(rule.getStartWith())) continue block6;
                    asb.styleMatches(rule.getPattern(), rule.getStyle());
                    continue block6;
                }
                case 3: {
                    if (continueAs == null || !continueAs.toString().matches(rule.getContinueAs() + ".*")) continue block6;
                    asb.styleMatches(rule.getPattern(), rule.getStyle());
                }
            }
        }
        return asb;
    }

    private static class NanorcParser {
        private static final String DEFAULT_SYNTAX = "default";
        private final String name;
        private final String target;
        private final Map<String, List<HighlightRule>> highlightRules = new HashMap<String, List<HighlightRule>>();
        private final BufferedReader reader;
        private Map<String, String> colorTheme = new HashMap<String, String>();
        private boolean matches = false;
        private String syntaxName = "unknown";
        private Parser parser;

        public NanorcParser(Path file2, String name2, String target, Map<String, String> colorTheme) throws IOException {
            this(new Source.PathSource(file2, null).read(), name2, target);
            this.colorTheme = colorTheme;
        }

        public NanorcParser(InputStream in, String name2, String target) {
            this.reader = new BufferedReader(new InputStreamReader(in, StandardCharsets.UTF_8));
            this.name = name2;
            this.target = target;
            this.highlightRules.put(SyntaxHighlighter.TOKEN_NANORC, new ArrayList());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void parse() throws IOException {
            int idx = 0;
            try {
                String line;
                block3: while ((line = this.reader.readLine()) != null) {
                    int n;
                    String key;
                    ++idx;
                    if ((line = line.trim()).length() <= 0 || line.startsWith("#")) continue;
                    List<String> parts2 = RuleSplitter.split(this.fixRegexes(line));
                    if (parts2.get(0).equals("syntax")) {
                        this.syntaxName = parts2.get(1);
                        ArrayList<Pattern> filePatterns = new ArrayList<Pattern>();
                        if (this.name != null) {
                            if (!this.name.equals(this.syntaxName)) return;
                            this.matches = true;
                            continue;
                        }
                        if (this.target != null) {
                            for (int i2 = 2; i2 < parts2.size(); ++i2) {
                                filePatterns.add(Pattern.compile(parts2.get(i2)));
                            }
                            for (Pattern p : filePatterns) {
                                if (!p.matcher(this.target).find()) continue;
                                this.matches = true;
                                break;
                            }
                            if (this.matches || this.syntaxName.equals(DEFAULT_SYNTAX)) continue;
                            return;
                        }
                        this.matches = true;
                        continue;
                    }
                    if (parts2.get(0).startsWith("$")) {
                        key = this.themeKey(parts2.get(0));
                        if (this.colorTheme.containsKey(key)) {
                            if (this.parser == null) {
                                this.parser = new Parser();
                            }
                            String[] args = parts2.get(1).split(",\\s*");
                            boolean validKey = true;
                            if (key.startsWith("$BLOCK_COMMENT")) {
                                this.parser.setBlockCommentDelimiters(key, args);
                            } else if (key.startsWith("$LINE_COMMENT")) {
                                this.parser.setLineCommentDelimiters(key, args);
                            } else if (key.startsWith("$BALANCED_DELIMITERS")) {
                                this.parser.setBalancedDelimiters(key, args);
                            } else {
                                Log.warn("Unknown token type: ", key);
                                validKey = false;
                            }
                            if (!validKey) continue;
                            if (!this.highlightRules.containsKey(key)) {
                                this.highlightRules.put(key, new ArrayList());
                            }
                            String[] stringArray = this.colorTheme.get(key).split("\\\\n");
                            n = stringArray.length;
                            int n2 = 0;
                            while (true) {
                                if (n2 >= n) continue block3;
                                String l = stringArray[n2];
                                this.addHighlightRule(RuleSplitter.split(this.fixRegexes(l)), ++idx, key);
                                ++n2;
                            }
                        }
                        Log.warn("Unknown token type: ", key);
                        continue;
                    }
                    if (this.addHighlightRule(parts2, idx, SyntaxHighlighter.TOKEN_NANORC) || !parts2.get(0).matches("\\+[A-Z_]+")) continue;
                    key = this.themeKey(parts2.get(0));
                    String theme = this.colorTheme.get(key);
                    if (theme != null) {
                        String[] stringArray = theme.split("\\\\n");
                        int n3 = stringArray.length;
                        n = 0;
                        while (true) {
                            if (n >= n3) continue block3;
                            String l = stringArray[n];
                            this.addHighlightRule(RuleSplitter.split(this.fixRegexes(l)), ++idx, SyntaxHighlighter.TOKEN_NANORC);
                            ++n;
                        }
                    }
                    Log.warn("Unknown token type: ", key);
                }
                return;
            }
            finally {
                this.reader.close();
            }
        }

        private String fixRegexes(String line) {
            return line.replaceAll("\\\\<", "\\\\b").replaceAll("\\\\>", "\\\\b").replaceAll("\\[:alnum:]", "\\\\p{Alnum}").replaceAll("\\[:alpha:]", "\\\\p{Alpha}").replaceAll("\\[:blank:]", "\\\\p{Blank}").replaceAll("\\[:cntrl:]", "\\\\p{Cntrl}").replaceAll("\\[:digit:]", "\\\\p{Digit}").replaceAll("\\[:graph:]", "\\\\p{Graph}").replaceAll("\\[:lower:]", "\\\\p{Lower}").replaceAll("\\[:print:]", "\\\\p{Print}").replaceAll("\\[:punct:]", "\\\\p{Punct}").replaceAll("\\[:space:]", "\\\\s").replaceAll("\\[:upper:]", "\\\\p{Upper}").replaceAll("\\[:xdigit:]", "\\\\p{XDigit}");
        }

        private boolean addHighlightRule(List<String> parts2, int idx, String tokenName) {
            boolean out = true;
            if (parts2.get(0).equals("color")) {
                this.addHighlightRule(this.syntaxName + idx, parts2, false, tokenName);
            } else if (parts2.get(0).equals("icolor")) {
                this.addHighlightRule(this.syntaxName + idx, parts2, true, tokenName);
            } else if (parts2.get(0).matches("[A-Z_]+[:]?")) {
                String key = this.themeKey(parts2.get(0));
                String theme = this.colorTheme.get(key);
                if (theme != null) {
                    parts2.set(0, "color");
                    parts2.add(1, theme);
                    this.addHighlightRule(this.syntaxName + idx, parts2, false, tokenName);
                } else {
                    Log.warn("Unknown token type: ", key);
                }
            } else if (parts2.get(0).matches("~[A-Z_]+[:]?")) {
                String key = this.themeKey(parts2.get(0));
                String theme = this.colorTheme.get(key);
                if (theme != null) {
                    parts2.set(0, "icolor");
                    parts2.add(1, theme);
                    this.addHighlightRule(this.syntaxName + idx, parts2, true, tokenName);
                } else {
                    Log.warn("Unknown token type: ", key);
                }
            } else {
                out = false;
            }
            return out;
        }

        private String themeKey(String key) {
            int keyEnd;
            if (key.startsWith("+")) {
                return key;
            }
            int n = keyEnd = key.endsWith(":") ? key.length() - 1 : key.length();
            if (key.startsWith("~")) {
                return key.substring(1, keyEnd);
            }
            return key.substring(0, keyEnd);
        }

        public boolean matches() {
            return this.matches;
        }

        public Parser getParser() {
            return this.parser;
        }

        public Map<String, List<HighlightRule>> getHighlightRules() {
            return this.highlightRules;
        }

        public boolean isDefault() {
            return this.syntaxName.equals(DEFAULT_SYNTAX);
        }

        private void addHighlightRule(String reference2, List<String> parts2, boolean caseInsensitive, String tokenName) {
            HashMap<String, String> spec = new HashMap<String, String>();
            spec.put(reference2, parts2.get(1));
            Styles.StyleCompiler sh = new Styles.StyleCompiler(spec, true);
            AttributedStyle style = new StyleResolver(sh::getStyle).resolve("." + reference2);
            if (HighlightRule.evalRuleType(parts2) == HighlightRule.RuleType.PATTERN) {
                if (parts2.size() == 2) {
                    this.highlightRules.get(tokenName).add(new HighlightRule(style, this.doPattern(".*", caseInsensitive)));
                } else {
                    for (int i2 = 2; i2 < parts2.size(); ++i2) {
                        this.highlightRules.get(tokenName).add(new HighlightRule(style, this.doPattern(parts2.get(i2), caseInsensitive)));
                    }
                }
            } else if (HighlightRule.evalRuleType(parts2) == HighlightRule.RuleType.START_END) {
                String s = parts2.get(2);
                String e = parts2.get(3);
                this.highlightRules.get(tokenName).add(new HighlightRule(style, this.doPattern(s.substring(7, s.length() - 1), caseInsensitive), this.doPattern(e.substring(5, e.length() - 1), caseInsensitive)));
            } else if (HighlightRule.evalRuleType(parts2) == HighlightRule.RuleType.PARSER_START_WITH) {
                this.highlightRules.get(tokenName).add(new HighlightRule(HighlightRule.RuleType.PARSER_START_WITH, style, parts2.get(2).substring(10)));
            } else if (HighlightRule.evalRuleType(parts2) == HighlightRule.RuleType.PARSER_CONTINUE_AS) {
                this.highlightRules.get(tokenName).add(new HighlightRule(HighlightRule.RuleType.PARSER_CONTINUE_AS, style, parts2.get(2).substring(11)));
            }
        }

        private Pattern doPattern(String regex, boolean caseInsensitive) {
            return caseInsensitive ? Pattern.compile(regex, 2) : Pattern.compile(regex);
        }
    }

    private static class Parser {
        private static final char escapeChar = '\\';
        private String blockCommentTokenName;
        private BlockCommentDelimiters blockCommentDelimiters;
        private String lineCommentTokenName;
        private String[] lineCommentDelimiters;
        private String balancedDelimiterTokenName;
        private String[] balancedDelimiters;
        private String balancedDelimiter;
        private List<ParsedToken> tokens;
        private CharSequence startWith;
        private int tokenStart = 0;
        private boolean blockComment;
        private boolean lineComment;
        private boolean balancedQuoted;

        public void setBlockCommentDelimiters(String tokenName, String[] args) {
            try {
                this.blockCommentTokenName = tokenName;
                this.blockCommentDelimiters = new BlockCommentDelimiters(args);
            }
            catch (Exception e) {
                Log.warn(e.getMessage());
            }
        }

        public void setLineCommentDelimiters(String tokenName, String[] args) {
            this.lineCommentTokenName = tokenName;
            this.lineCommentDelimiters = args;
        }

        public void setBalancedDelimiters(String tokenName, String[] args) {
            this.balancedDelimiterTokenName = tokenName;
            this.balancedDelimiters = args;
        }

        public void reset() {
            this.startWith = null;
            this.blockComment = false;
            this.lineComment = false;
            this.balancedQuoted = false;
            this.tokenStart = 0;
        }

        public void parse(CharSequence line) {
            if (line == null) {
                return;
            }
            this.tokens = new ArrayList<ParsedToken>();
            if (this.blockComment || this.balancedQuoted) {
                this.tokenStart = 0;
            }
            for (int i2 = 0; i2 < line.length(); ++i2) {
                if (this.isEscapeChar(line, i2) || this.isEscaped(line, i2)) continue;
                if (!(this.blockComment || this.lineComment || this.balancedQuoted)) {
                    if (this.blockCommentDelimiters != null && this.isDelimiter(line, i2, this.blockCommentDelimiters.getStart())) {
                        this.blockComment = true;
                        this.tokenStart = i2;
                        this.startWith = this.startWithSubstring(line, i2);
                        i2 = i2 + this.blockCommentDelimiters.getStart().length() - 1;
                        continue;
                    }
                    if (this.isLineCommentDelimiter(line, i2)) {
                        this.lineComment = true;
                        this.tokenStart = i2;
                        this.startWith = this.startWithSubstring(line, i2);
                        break;
                    }
                    this.balancedDelimiter = this.balancedDelimiter(line, i2);
                    if (this.balancedDelimiter == null) continue;
                    this.balancedQuoted = true;
                    this.tokenStart = i2;
                    this.startWith = this.startWithSubstring(line, i2);
                    i2 = i2 + this.balancedDelimiter.length() - 1;
                    continue;
                }
                if (this.blockComment) {
                    if (!this.isDelimiter(line, i2, this.blockCommentDelimiters.getEnd())) continue;
                    this.blockComment = false;
                    i2 = i2 + this.blockCommentDelimiters.getEnd().length() - 1;
                    this.tokens.add(new ParsedToken(this.blockCommentTokenName, this.startWith, this.tokenStart, i2 + 1));
                    continue;
                }
                if (!this.balancedQuoted || !this.isDelimiter(line, i2, this.balancedDelimiter)) continue;
                this.balancedQuoted = false;
                if ((i2 = i2 + this.balancedDelimiter.length() - 1) - this.tokenStart + 1 <= 2 * this.balancedDelimiter.length()) continue;
                this.tokens.add(new ParsedToken(this.balancedDelimiterTokenName, this.startWith, this.tokenStart, i2 + 1));
            }
            if (this.blockComment) {
                this.tokens.add(new ParsedToken(this.blockCommentTokenName, this.startWith, this.tokenStart, line.length()));
            } else if (this.lineComment) {
                this.lineComment = false;
                this.tokens.add(new ParsedToken(this.lineCommentTokenName, this.startWith, this.tokenStart, line.length()));
            } else if (this.balancedQuoted) {
                this.tokens.add(new ParsedToken(this.balancedDelimiterTokenName, this.startWith, this.tokenStart, line.length()));
            }
        }

        private CharSequence startWithSubstring(CharSequence line, int pos) {
            return line.subSequence(pos, Math.min(pos + 5, line.length()));
        }

        public List<ParsedToken> getTokens() {
            return this.tokens;
        }

        private String balancedDelimiter(CharSequence buffer, int pos) {
            if (this.balancedDelimiters != null) {
                for (String delimiter : this.balancedDelimiters) {
                    if (!this.isDelimiter(buffer, pos, delimiter)) continue;
                    return delimiter;
                }
            }
            return null;
        }

        private boolean isDelimiter(CharSequence buffer, int pos, String delimiter) {
            if (pos < 0 || delimiter == null) {
                return false;
            }
            int length = delimiter.length();
            if (length <= buffer.length() - pos) {
                for (int i2 = 0; i2 < length; ++i2) {
                    if (delimiter.charAt(i2) == buffer.charAt(pos + i2)) continue;
                    return false;
                }
                return true;
            }
            return false;
        }

        private boolean isLineCommentDelimiter(CharSequence buffer, int pos) {
            if (this.lineCommentDelimiters != null) {
                for (String delimiter : this.lineCommentDelimiters) {
                    if (!this.isDelimiter(buffer, pos, delimiter)) continue;
                    return true;
                }
            }
            return false;
        }

        private boolean isEscapeChar(char ch) {
            return '\\' == ch;
        }

        private boolean isEscapeChar(CharSequence buffer, int pos) {
            if (pos < 0) {
                return false;
            }
            char ch = buffer.charAt(pos);
            return this.isEscapeChar(ch) && !this.isEscaped(buffer, pos);
        }

        private boolean isEscaped(CharSequence buffer, int pos) {
            if (pos <= 0) {
                return false;
            }
            return this.isEscapeChar(buffer, pos - 1);
        }
    }

    protected static class RuleSplitter {
        protected RuleSplitter() {
        }

        protected static List<String> split(String s) {
            ArrayList<String> out = new ArrayList<String>();
            if (s.length() == 0) {
                return out;
            }
            boolean depth = false;
            StringBuilder sb = new StringBuilder();
            for (int i2 = 0; i2 < s.length(); ++i2) {
                char c;
                block6: {
                    block4: {
                        int nextChar;
                        block5: {
                            c = s.charAt(i2);
                            if (c != '\"') break block4;
                            if (depth) break block5;
                            depth = true;
                            break block6;
                        }
                        int n = nextChar = i2 < s.length() - 1 ? (int)s.charAt(i2 + 1) : 32;
                        if (nextChar != 32) break block6;
                        depth = false;
                        break block6;
                    }
                    if (c == ' ' && !depth && sb.length() > 0) {
                        out.add(RuleSplitter.stripQuotes(sb.toString()));
                        sb = new StringBuilder();
                        continue;
                    }
                }
                if (sb.length() <= 0 && (c == ' ' || c == '\t')) continue;
                sb.append(c);
            }
            if (sb.length() > 0) {
                out.add(RuleSplitter.stripQuotes(sb.toString()));
            }
            return out;
        }

        private static String stripQuotes(String s) {
            String out = s.trim();
            if (s.startsWith("\"") && s.endsWith("\"")) {
                out = s.substring(1, s.length() - 1);
            }
            return out;
        }
    }

    private static class ParsedToken {
        private final String name;
        private final CharSequence startWith;
        private final int start;
        private final int end;

        public ParsedToken(String name2, CharSequence startWith, int start, int end) {
            this.name = name2;
            this.startWith = startWith;
            this.start = start;
            this.end = end;
        }

        public String getName() {
            return this.name;
        }

        public CharSequence getStartWith() {
            return this.startWith;
        }

        public int getStart() {
            return this.start;
        }

        public int getEnd() {
            return this.end;
        }
    }

    private static class HighlightRule {
        private final RuleType type;
        private Pattern pattern;
        private final AttributedStyle style;
        private Pattern start;
        private Pattern end;
        private String startWith;
        private String continueAs;

        public HighlightRule(AttributedStyle style, Pattern pattern) {
            this.type = RuleType.PATTERN;
            this.pattern = pattern;
            this.style = style;
        }

        public HighlightRule(AttributedStyle style, Pattern start, Pattern end) {
            this.type = RuleType.START_END;
            this.style = style;
            this.start = start;
            this.end = end;
        }

        public HighlightRule(RuleType parserRuleType, AttributedStyle style, String value2) {
            this.type = parserRuleType;
            this.style = style;
            this.pattern = Pattern.compile(".*");
            if (parserRuleType == RuleType.PARSER_START_WITH) {
                this.startWith = value2;
            } else if (parserRuleType == RuleType.PARSER_CONTINUE_AS) {
                this.continueAs = value2;
            } else {
                throw new IllegalArgumentException("Bad RuleType: " + (Object)((Object)parserRuleType));
            }
        }

        public RuleType getType() {
            return this.type;
        }

        public AttributedStyle getStyle() {
            return this.style;
        }

        public Pattern getPattern() {
            if (this.type == RuleType.START_END) {
                throw new IllegalAccessError();
            }
            return this.pattern;
        }

        public Pattern getStart() {
            if (this.type == RuleType.PATTERN) {
                throw new IllegalAccessError();
            }
            return this.start;
        }

        public Pattern getEnd() {
            if (this.type == RuleType.PATTERN) {
                throw new IllegalAccessError();
            }
            return this.end;
        }

        public String getStartWith() {
            return this.startWith;
        }

        public String getContinueAs() {
            return this.continueAs;
        }

        public static RuleType evalRuleType(List<String> colorCfg) {
            RuleType out = null;
            if (colorCfg.get(0).equals("color") || colorCfg.get(0).equals("icolor")) {
                out = RuleType.PATTERN;
                if (colorCfg.size() == 3) {
                    if (colorCfg.get(2).startsWith("startWith=")) {
                        out = RuleType.PARSER_START_WITH;
                    } else if (colorCfg.get(2).startsWith("continueAs=")) {
                        out = RuleType.PARSER_CONTINUE_AS;
                    }
                } else if (colorCfg.size() == 4 && colorCfg.get(2).startsWith("start=") && colorCfg.get(3).startsWith("end=")) {
                    out = RuleType.START_END;
                }
            }
            return out;
        }

        public String toString() {
            return "{type:" + (Object)((Object)this.type) + ", startWith: " + this.startWith + ", continueAs: " + this.continueAs + ", start: " + this.start + ", end: " + this.end + ", pattern: " + this.pattern + "}";
        }

        public static enum RuleType {
            PATTERN,
            START_END,
            PARSER_START_WITH,
            PARSER_CONTINUE_AS;

        }
    }

    private static class BlockCommentDelimiters {
        private final String start;
        private final String end;

        public BlockCommentDelimiters(String[] args) {
            if (args.length != 2 || args[0] == null || args[1] == null || args[0].isEmpty() || args[1].isEmpty() || args[0].equals(args[1])) {
                throw new IllegalArgumentException("Bad block comment delimiters!");
            }
            this.start = args[0];
            this.end = args[1];
        }

        public String getStart() {
            return this.start;
        }

        public String getEnd() {
            return this.end;
        }
    }
}

