/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.analysis.low.level.api.fir.caches;

import com.intellij.openapi.application.ApplicationManager;
import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.util.Collection;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.analysis.low.level.api.fir.LLFirInternals;
import org.jetbrains.kotlin.analysis.low.level.api.fir.caches.SoftReferenceWithCleanup;
import org.jetbrains.kotlin.analysis.low.level.api.fir.caches.SoftValueCleaner;

@LLFirInternals
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0007\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u0002*\b\b\u0001\u0010\u0003*\u00020\u00022\u00020\u0002B\u001f\u0012\u0018\u0010\u0004\u001a\u0014\u0012\u0004\u0012\u00028\u0001\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00010\u00060\u0005\u00a2\u0006\u0002\u0010\u0007J\u0006\u0010\u0015\u001a\u00020\u0016J3\u0010\u0017\u001a\u0004\u0018\u00018\u00012\u0006\u0010\u0018\u001a\u00028\u00002\u001c\u0010\u0019\u001a\u0018\u0012\u0004\u0012\u00028\u0000\u0012\u0006\u0012\u0004\u0018\u00018\u0001\u0012\u0006\u0012\u0004\u0018\u00018\u00010\u001a\u00a2\u0006\u0002\u0010\u001bJ'\u0010\u001c\u001a\u00028\u00012\u0006\u0010\u0018\u001a\u00028\u00002\u0012\u0010\u0019\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u0005\u00a2\u0006\u0002\u0010\u001dJ)\u0010\u001e\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\n2\u0006\u0010\u0018\u001a\u00028\u00002\u0006\u0010\u001f\u001a\u00028\u0001H\u0002\u00a2\u0006\u0002\u0010 J\u0018\u0010!\u001a\u0004\u0018\u00018\u00012\u0006\u0010\u0018\u001a\u00028\u0000H\u0086\u0002\u00a2\u0006\u0002\u0010\"J\u0006\u0010#\u001a\u00020$J\b\u0010%\u001a\u00020\u0016H\u0002J\u001d\u0010&\u001a\u0004\u0018\u00018\u00012\u0006\u0010\u0018\u001a\u00028\u00002\u0006\u0010\u001f\u001a\u00028\u0001\u00a2\u0006\u0002\u0010'J\u0015\u0010(\u001a\u0004\u0018\u00018\u00012\u0006\u0010\u0018\u001a\u00028\u0000\u00a2\u0006\u0002\u0010\"J\b\u0010)\u001a\u00020*H\u0016J\u0018\u0010+\u001a\u00020\u0016*\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\nH\u0002R&\u0010\b\u001a\u001a\u0012\u0004\u0012\u00028\u0000\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\u0004\u001a\u0014\u0012\u0004\u0012\u00028\u0001\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00010\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u000b\u001a\b\u0012\u0004\u0012\u00028\u00000\f8F\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000eR\u0014\u0010\u000f\u001a\b\u0012\u0004\u0012\u00028\u00010\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0011\u001a\u00020\u00128F\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0014\u00a8\u0006,"}, d2={"Lorg/jetbrains/kotlin/analysis/low/level/api/fir/caches/CleanableSoftValueCache;", "K", "", "V", "getCleaner", "Lkotlin/Function1;", "Lorg/jetbrains/kotlin/analysis/low/level/api/fir/caches/SoftValueCleaner;", "(Lkotlin/jvm/functions/Function1;)V", "backingMap", "Ljava/util/concurrent/ConcurrentHashMap;", "Lorg/jetbrains/kotlin/analysis/low/level/api/fir/caches/SoftReferenceWithCleanup;", "keys", "", "getKeys", "()Ljava/util/Set;", "referenceQueue", "Ljava/lang/ref/ReferenceQueue;", "size", "", "getSize", "()I", "clear", "", "compute", "key", "computeValue", "Lkotlin/Function2;", "(Ljava/lang/Object;Lkotlin/jvm/functions/Function2;)Ljava/lang/Object;", "computeIfAbsent", "(Ljava/lang/Object;Lkotlin/jvm/functions/Function1;)Ljava/lang/Object;", "createSoftReference", "value", "(Ljava/lang/Object;Ljava/lang/Object;)Lorg/jetbrains/kotlin/analysis/low/level/api/fir/caches/SoftReferenceWithCleanup;", "get", "(Ljava/lang/Object;)Ljava/lang/Object;", "isEmpty", "", "processQueue", "put", "(Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;", "remove", "toString", "", "performCleanup", "low-level-api-fir"})
@SourceDebugExtension(value={"SMAP\nCleanableSoftValueCache.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CleanableSoftValueCache.kt\norg/jetbrains/kotlin/analysis/low/level/api/fir/caches/CleanableSoftValueCache\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,282:1\n1#2:283\n1863#3,2:284\n*S KotlinDebug\n*F\n+ 1 CleanableSoftValueCache.kt\norg/jetbrains/kotlin/analysis/low/level/api/fir/caches/CleanableSoftValueCache\n*L\n210#1:284,2\n*E\n"})
public final class CleanableSoftValueCache<K, V> {
    @NotNull
    private final Function1<V, SoftValueCleaner<V>> getCleaner;
    @NotNull
    private final ConcurrentHashMap<K, SoftReferenceWithCleanup<K, V>> backingMap;
    @NotNull
    private final ReferenceQueue<V> referenceQueue;

    public CleanableSoftValueCache(@NotNull Function1<? super V, ? extends SoftValueCleaner<V>> getCleaner) {
        Intrinsics.checkNotNullParameter(getCleaner, (String)"getCleaner");
        this.getCleaner = getCleaner;
        this.backingMap = new ConcurrentHashMap();
        this.referenceQueue = new ReferenceQueue();
    }

    private final void processQueue() {
        while (this.referenceQueue.poll() != null) {
            Reference<V> ref;
            if (!(ref instanceof SoftReferenceWithCleanup)) {
                String string2 = "Check failed.";
                throw new IllegalStateException(string2.toString());
            }
            SoftReferenceWithCleanup cfr_ignored_0 = (SoftReferenceWithCleanup)ref;
            boolean wasRemoved = this.backingMap.remove(((SoftReferenceWithCleanup)ref).getKey(), ref);
            if (!wasRemoved) continue;
            this.performCleanup((SoftReferenceWithCleanup)ref);
        }
    }

    @Nullable
    public final V get(@NotNull K key) {
        Intrinsics.checkNotNullParameter(key, (String)"key");
        SoftReferenceWithCleanup<K, V> softReferenceWithCleanup = this.backingMap.get(key);
        return (V)(softReferenceWithCleanup != null ? softReferenceWithCleanup.get() : null);
    }

    @NotNull
    public final V computeIfAbsent(@NotNull K key, @NotNull Function1<? super K, ? extends V> computeValue) {
        Intrinsics.checkNotNullParameter(key, (String)"key");
        Intrinsics.checkNotNullParameter(computeValue, (String)"computeValue");
        V v = this.get(key);
        if (v != null) {
            V it = v;
            boolean bl = false;
            return it;
        }
        V v2 = this.compute(key, (Function2)new Function2<K, V, V>(computeValue, key){
            final /* synthetic */ Function1<K, V> $computeValue;
            final /* synthetic */ K $key;
            {
                this.$computeValue = $computeValue;
                this.$key = $key;
                super(2);
            }

            public final V invoke(K k, V currentValue) {
                Intrinsics.checkNotNullParameter(k, (String)"<anonymous parameter 0>");
                Object object = currentValue;
                if (object == null) {
                    object = this.$computeValue.invoke(this.$key);
                }
                return object;
            }
        });
        if (v2 == null) {
            throw new IllegalStateException("`computeIfAbsent` should always return a non-null value.".toString());
        }
        return v2;
    }

    @Nullable
    public final V compute(@NotNull K key, @NotNull Function2<? super K, ? super V, ? extends V> computeValue) {
        Intrinsics.checkNotNullParameter(key, (String)"key");
        Intrinsics.checkNotNullParameter(computeValue, (String)"computeValue");
        Ref.ObjectRef newValue = new Ref.ObjectRef();
        Ref.ObjectRef removedRef = new Ref.ObjectRef();
        SoftReferenceWithCleanup newRef2 = this.backingMap.compute(key, (arg_0, arg_1) -> CleanableSoftValueCache.compute$lambda$1((Function2)new Function2<K, SoftReferenceWithCleanup<K, V>, SoftReferenceWithCleanup<K, V>>(newValue, computeValue, key, removedRef, this){
            final /* synthetic */ Ref.ObjectRef<V> $newValue;
            final /* synthetic */ Function2<K, V, V> $computeValue;
            final /* synthetic */ K $key;
            final /* synthetic */ Ref.ObjectRef<SoftReferenceWithCleanup<K, V>> $removedRef;
            final /* synthetic */ CleanableSoftValueCache<K, V> this$0;
            {
                this.$newValue = $newValue;
                this.$computeValue = $computeValue;
                this.$key = $key;
                this.$removedRef = $removedRef;
                this.this$0 = $receiver;
                super(2);
            }

            public final SoftReferenceWithCleanup<K, V> invoke(K k, SoftReferenceWithCleanup<K, V> currentRef) {
                SoftReferenceWithCleanup softReferenceWithCleanup;
                Intrinsics.checkNotNullParameter(k, (String)"<anonymous parameter 0>");
                SoftReferenceWithCleanup softReferenceWithCleanup2 = currentRef;
                T currentValue = softReferenceWithCleanup2 != null ? softReferenceWithCleanup2.get() : null;
                this.$newValue.element = this.$computeValue.invoke(this.$key, currentValue);
                if (this.$newValue.element == null) {
                    this.$removedRef.element = currentRef;
                    softReferenceWithCleanup = null;
                } else if (this.$newValue.element == currentValue) {
                    softReferenceWithCleanup = currentRef;
                } else {
                    this.$removedRef.element = currentRef;
                    Object object = this.$newValue.element;
                    Intrinsics.checkNotNull((Object)object);
                    softReferenceWithCleanup = CleanableSoftValueCache.access$createSoftReference(this.this$0, this.$key, object);
                }
                return softReferenceWithCleanup;
            }
        }, arg_0, arg_1));
        SoftReferenceWithCleanup softReferenceWithCleanup = (SoftReferenceWithCleanup)removedRef.element;
        if (softReferenceWithCleanup != null) {
            this.performCleanup(softReferenceWithCleanup);
        }
        this.processQueue();
        SoftReferenceWithCleanup softReferenceWithCleanup2 = newRef2;
        if (!((softReferenceWithCleanup2 != null ? softReferenceWithCleanup2.get() : null) == newValue.element)) {
            boolean bl = false;
            String string2 = "The newly computed value was already garbage-collected before the end of the `compute` function.";
            throw new IllegalArgumentException(string2.toString());
        }
        return (V)newValue.element;
    }

    @Nullable
    public final V put(@NotNull K key, @NotNull V value2) {
        Intrinsics.checkNotNullParameter(key, (String)"key");
        Intrinsics.checkNotNullParameter(value2, (String)"value");
        Ref.ObjectRef oldValue = new Ref.ObjectRef();
        Ref.ObjectRef removedRef = new Ref.ObjectRef();
        this.backingMap.compute(key, (arg_0, arg_1) -> CleanableSoftValueCache.put$lambda$3((Function2)new Function2<K, SoftReferenceWithCleanup<K, V>, SoftReferenceWithCleanup<K, V>>(oldValue, value2, removedRef, this, key){
            final /* synthetic */ Ref.ObjectRef<V> $oldValue;
            final /* synthetic */ V $value;
            final /* synthetic */ Ref.ObjectRef<SoftReferenceWithCleanup<K, V>> $removedRef;
            final /* synthetic */ CleanableSoftValueCache<K, V> this$0;
            final /* synthetic */ K $key;
            {
                this.$oldValue = $oldValue;
                this.$value = $value;
                this.$removedRef = $removedRef;
                this.this$0 = $receiver;
                this.$key = $key;
                super(2);
            }

            public final SoftReferenceWithCleanup<K, V> invoke(K k, SoftReferenceWithCleanup<K, V> currentRef) {
                Intrinsics.checkNotNullParameter(k, (String)"<anonymous parameter 0>");
                SoftReferenceWithCleanup<K, V> softReferenceWithCleanup = currentRef;
                T currentValue = softReferenceWithCleanup != null ? softReferenceWithCleanup.get() : null;
                this.$oldValue.element = currentValue;
                if (this.$value == currentValue) {
                    return currentRef;
                }
                this.$removedRef.element = currentRef;
                return CleanableSoftValueCache.access$createSoftReference(this.this$0, this.$key, this.$value);
            }
        }, arg_0, arg_1));
        SoftReferenceWithCleanup softReferenceWithCleanup = (SoftReferenceWithCleanup)removedRef.element;
        if (softReferenceWithCleanup != null) {
            this.performCleanup(softReferenceWithCleanup);
        }
        this.processQueue();
        return (V)oldValue.element;
    }

    @Nullable
    public final V remove(@NotNull K key) {
        SoftReferenceWithCleanup<K, V> ref;
        Intrinsics.checkNotNullParameter(key, (String)"key");
        SoftReferenceWithCleanup<K, V> softReferenceWithCleanup = ref = this.backingMap.remove(key);
        if (softReferenceWithCleanup != null) {
            this.performCleanup(softReferenceWithCleanup);
        }
        this.processQueue();
        SoftReferenceWithCleanup<K, V> softReferenceWithCleanup2 = ref;
        return (V)(softReferenceWithCleanup2 != null ? softReferenceWithCleanup2.get() : null);
    }

    public final void clear() {
        ApplicationManager.getApplication().assertWriteAccessAllowed();
        Collection<SoftReferenceWithCleanup<K, V>> collection = this.backingMap.values();
        Intrinsics.checkNotNullExpressionValue(collection, (String)"<get-values>(...)");
        Iterable $this$forEach$iv = collection;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            SoftReferenceWithCleanup it = (SoftReferenceWithCleanup)element$iv;
            boolean bl = false;
            Intrinsics.checkNotNull((Object)it);
            this.performCleanup(it);
        }
        this.backingMap.clear();
        this.processQueue();
    }

    public final int getSize() {
        this.processQueue();
        return this.backingMap.size();
    }

    public final boolean isEmpty() {
        this.processQueue();
        return this.backingMap.isEmpty();
    }

    @NotNull
    public final Set<K> getKeys() {
        this.processQueue();
        Set set = this.backingMap.keySet();
        Intrinsics.checkNotNullExpressionValue((Object)set, (String)"<get-keys>(...)");
        return CollectionsKt.toSet((Iterable)set);
    }

    @NotNull
    public String toString() {
        return Reflection.getOrCreateKotlinClass(this.getClass()).getSimpleName() + " size:" + this.getSize();
    }

    private final SoftReferenceWithCleanup<K, V> createSoftReference(K key, V value2) {
        return new SoftReferenceWithCleanup<K, V>(key, value2, (SoftValueCleaner)this.getCleaner.invoke(value2), this.referenceQueue);
    }

    private final void performCleanup(SoftReferenceWithCleanup<K, V> $this$performCleanup) {
        $this$performCleanup.getCleaner().cleanUp($this$performCleanup.get());
    }

    private static final SoftReferenceWithCleanup compute$lambda$1(Function2 $tmp0, Object p0, Object p1) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (SoftReferenceWithCleanup)$tmp0.invoke(p0, p1);
    }

    private static final SoftReferenceWithCleanup put$lambda$3(Function2 $tmp0, Object p0, Object p1) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (SoftReferenceWithCleanup)$tmp0.invoke(p0, p1);
    }

    public static final /* synthetic */ SoftReferenceWithCleanup access$createSoftReference(CleanableSoftValueCache $this, Object key, Object value2) {
        return $this.createSoftReference(key, value2);
    }
}

