/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.cli.jvm.compiler;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.VirtualFileSystem;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import java.io.File;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.cli.common.CLIConfigurationKeys;
import org.jetbrains.kotlin.cli.common.config.ContentRootsKt;
import org.jetbrains.kotlin.cli.common.config.KotlinSourceRoot;
import org.jetbrains.kotlin.cli.common.messages.CompilerMessageLocation;
import org.jetbrains.kotlin.cli.common.messages.CompilerMessageSeverity;
import org.jetbrains.kotlin.cli.common.messages.MessageCollector;
import org.jetbrains.kotlin.cli.jvm.compiler.KotlinCoreEnvironment;
import org.jetbrains.kotlin.config.CompilerConfiguration;
import org.jetbrains.kotlin.config.CompilerConfigurationKey;
import org.jetbrains.kotlin.config.JVMConfigurationKeys;
import org.jetbrains.kotlin.extensions.CompilerConfigurationExtension;
import org.jetbrains.kotlin.extensions.PreprocessedFileCreator;
import org.jetbrains.kotlin.idea.KotlinFileType;
import org.jetbrains.kotlin.modules.Module;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.resolve.multiplatform.IsCommonSourceKt;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000h\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\u001a6\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r2\n\b\u0002\u0010\u000f\u001a\u0004\u0018\u00010\u0010\u001a\u001e\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u000e0\r2\u0006\u0010\b\u001a\u00020\t2\b\u0010\u0000\u001a\u0004\u0018\u00010\u0001\u001a\u001c\u0010\u0012\u001a\u00020\t*\u00020\t2\u0006\u0010\u0013\u001a\u00020\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\u0016\u001a]\u0010\u0017\u001a\u00020\u0018*\b\u0012\u0004\u0012\u00020\u000e0\r2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\n\b\u0002\u0010\u000f\u001a\u0004\u0018\u00010\u00102/\u0010\u0019\u001a+\u0012\u0004\u0012\u00020\u001b\u0012\u0004\u0012\u00020\u001c\u0012\u0015\u0012\u0013\u0018\u00010\u001d\u00a2\u0006\f\b\u001e\u0012\b\b\u001f\u0012\u0004\b\b( \u0012\u0004\u0012\u00020\u00180\u001a\u001a&\u0010!\u001a\u00020\u0018*\u00020\t2\u0006\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020\u001d2\n\b\u0002\u0010%\u001a\u0004\u0018\u00010\u0010\"\u0015\u0010\u0000\u001a\u00020\u0001*\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\u0003\u0010\u0004\u00a8\u0006&"}, d2={"messageCollector", "Lorg/jetbrains/kotlin/cli/common/messages/MessageCollector;", "Lorg/jetbrains/kotlin/cli/jvm/compiler/KotlinCoreEnvironment;", "getMessageCollector", "(Lorg/jetbrains/kotlin/cli/jvm/compiler/KotlinCoreEnvironment;)Lorg/jetbrains/kotlin/cli/common/messages/MessageCollector;", "createSourceFilesFromSourceRoots", "", "Lorg/jetbrains/kotlin/psi/KtFile;", "configuration", "Lorg/jetbrains/kotlin/config/CompilerConfiguration;", "project", "Lcom/intellij/openapi/project/Project;", "sourceRoots", "", "Lorg/jetbrains/kotlin/cli/common/config/KotlinSourceRoot;", "reportLocation", "Lorg/jetbrains/kotlin/cli/common/messages/CompilerMessageLocation;", "getSourceRootsCheckingForDuplicates", "applyModuleProperties", "module", "Lorg/jetbrains/kotlin/modules/Module;", "buildFile", "Ljava/io/File;", "forAllFiles", "", "body", "Lkotlin/Function3;", "Lcom/intellij/openapi/vfs/VirtualFile;", "", "", "Lkotlin/ParameterName;", "name", "moduleName", "report", "severity", "Lorg/jetbrains/kotlin/cli/common/messages/CompilerMessageSeverity;", "message", "location", "cli-base"})
@SourceDebugExtension(value={"SMAP\ncoreEnvironmentUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 coreEnvironmentUtils.kt\norg/jetbrains/kotlin/cli/jvm/compiler/CoreEnvironmentUtilsKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,153:1\n1#2:154\n*E\n"})
public final class CoreEnvironmentUtilsKt {
    public static final void report(@NotNull CompilerConfiguration $this$report, @NotNull CompilerMessageSeverity severity, @NotNull String message2, @Nullable CompilerMessageLocation location) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)$this$report, (String)"<this>");
            Intrinsics.checkNotNullParameter((Object)((Object)severity), (String)"severity");
            Intrinsics.checkNotNullParameter((Object)message2, (String)"message");
            MessageCollector messageCollector2 = $this$report.get(CLIConfigurationKeys.MESSAGE_COLLECTOR_KEY);
            if (messageCollector2 == null) break block0;
            messageCollector2.report(severity, message2, location);
        }
    }

    public static /* synthetic */ void report$default(CompilerConfiguration compilerConfiguration, CompilerMessageSeverity compilerMessageSeverity, String string2, CompilerMessageLocation compilerMessageLocation, int n, Object object) {
        if ((n & 4) != 0) {
            compilerMessageLocation = null;
        }
        CoreEnvironmentUtilsKt.report(compilerConfiguration, compilerMessageSeverity, string2, compilerMessageLocation);
    }

    public static final void forAllFiles(@NotNull List<KotlinSourceRoot> $this$forAllFiles, @NotNull CompilerConfiguration configuration2, @NotNull Project project, @Nullable CompilerMessageLocation reportLocation, @NotNull Function3<? super VirtualFile, ? super Boolean, ? super String, Unit> body2) {
        Intrinsics.checkNotNullParameter($this$forAllFiles, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)configuration2, (String)"configuration");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter(body2, (String)"body");
        VirtualFileSystem localFileSystem = VirtualFileManager.getInstance().getFileSystem("file");
        HashSet<VirtualFile> processedFiles = new HashSet<VirtualFile>();
        PreprocessedFileCreator virtualFileCreator = new PreprocessedFileCreator(project);
        Ref.BooleanRef pluginsConfigured = new Ref.BooleanRef();
        for (KotlinSourceRoot kotlinSourceRoot : $this$forAllFiles) {
            String sourceRootPath = kotlinSourceRoot.component1();
            boolean isCommon = kotlinSourceRoot.component2();
            String hmppModuleName = kotlinSourceRoot.component3();
            File sourceRoot = new File(sourceRootPath);
            VirtualFile vFile = localFileSystem.findFileByPath(FilesKt.normalize((File)sourceRoot).getPath());
            if (vFile == null) {
                String message2 = "Source file or directory not found: " + sourceRootPath;
                File buildFilePath = configuration2.get(JVMConfigurationKeys.MODULE_XML_FILE);
                if (buildFilePath != null && Logger.isInitialized()) {
                    Logger.getInstance(KotlinCoreEnvironment.class).warn(message2 + "\n\nbuild file path: " + buildFilePath + "\ncontent:\n" + FilesKt.readText$default((File)buildFilePath, null, (int)1, null));
                }
                CoreEnvironmentUtilsKt.report(configuration2, CompilerMessageSeverity.ERROR, message2, reportLocation);
                continue;
            }
            if (!vFile.isDirectory() && !Intrinsics.areEqual((Object)vFile.getExtension(), (Object)"kt")) {
                CoreEnvironmentUtilsKt.forAllFiles$ensurePluginsConfigured(pluginsConfigured, project);
                if (!Intrinsics.areEqual((Object)vFile.getFileType(), (Object)((Object)KotlinFileType.INSTANCE))) {
                    CoreEnvironmentUtilsKt.report(configuration2, CompilerMessageSeverity.ERROR, "Source entry is not a Kotlin file: " + sourceRootPath, reportLocation);
                    continue;
                }
            }
            for (File file2 : FilesKt.walkTopDown((File)sourceRoot)) {
                VirtualFile virtualFile2;
                VirtualFile virtualFile3;
                if (!file2.isFile()) continue;
                File file3 = file2.getAbsoluteFile();
                Intrinsics.checkNotNullExpressionValue((Object)file3, (String)"getAbsoluteFile(...)");
                if (localFileSystem.findFileByPath(FilesKt.normalize((File)file3).getPath()) != null) {
                    VirtualFile p0;
                    boolean bl = false;
                    virtualFile3 = virtualFileCreator.create(p0);
                } else {
                    virtualFile3 = null;
                }
                if ((virtualFile2 = virtualFile3) == null || !processedFiles.add(virtualFile2)) continue;
                if (!Intrinsics.areEqual((Object)virtualFile2.getExtension(), (Object)"kt")) {
                    CoreEnvironmentUtilsKt.forAllFiles$ensurePluginsConfigured(pluginsConfigured, project);
                }
                if (!Intrinsics.areEqual((Object)virtualFile2.getExtension(), (Object)"kt") && !Intrinsics.areEqual((Object)virtualFile2.getFileType(), (Object)((Object)KotlinFileType.INSTANCE))) continue;
                body2.invoke((Object)virtualFile2, (Object)isCommon, (Object)hmppModuleName);
            }
        }
    }

    public static /* synthetic */ void forAllFiles$default(List list2, CompilerConfiguration compilerConfiguration, Project project, CompilerMessageLocation compilerMessageLocation, Function3 function3, int n, Object object) {
        if ((n & 4) != 0) {
            compilerMessageLocation = null;
        }
        CoreEnvironmentUtilsKt.forAllFiles(list2, compilerConfiguration, project, compilerMessageLocation, (Function3<? super VirtualFile, ? super Boolean, ? super String, Unit>)function3);
    }

    @NotNull
    public static final List<KtFile> createSourceFilesFromSourceRoots(@NotNull CompilerConfiguration configuration2, @NotNull Project project, @NotNull List<KotlinSourceRoot> sourceRoots, @Nullable CompilerMessageLocation reportLocation) {
        Intrinsics.checkNotNullParameter((Object)configuration2, (String)"configuration");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter(sourceRoots, (String)"sourceRoots");
        PsiManager psiManager2 = PsiManager.getInstance((Project)project);
        Intrinsics.checkNotNullExpressionValue((Object)psiManager2, (String)"getInstance(...)");
        PsiManager psiManager3 = psiManager2;
        List result2 = new ArrayList();
        CoreEnvironmentUtilsKt.forAllFiles(sourceRoots, configuration2, project, reportLocation, (Function3<? super VirtualFile, ? super Boolean, ? super String, Unit>)((Function3)new Function3<VirtualFile, Boolean, String, Unit>(psiManager3, (List<KtFile>)result2){
            final /* synthetic */ PsiManager $psiManager;
            final /* synthetic */ List<KtFile> $result;
            {
                this.$psiManager = $psiManager;
                this.$result = $result;
                super(3);
            }

            public final void invoke(VirtualFile virtualFile2, boolean isCommon, String moduleName) {
                block2: {
                    Intrinsics.checkNotNullParameter((Object)virtualFile2, (String)"virtualFile");
                    PsiFile psiFile = this.$psiManager.findFile(virtualFile2);
                    if (psiFile == null) break block2;
                    PsiFile psiFile2 = psiFile;
                    List<KtFile> list2 = this.$result;
                    PsiFile it = psiFile2;
                    boolean bl = false;
                    if (it instanceof KtFile) {
                        IsCommonSourceKt.setCommonSource((KtFile)it, isCommon);
                        if (moduleName != null) {
                            IsCommonSourceKt.setHmppModuleName((KtFile)it, moduleName);
                        }
                        list2.add((KtFile)it);
                    }
                }
            }
        }));
        return result2;
    }

    public static /* synthetic */ List createSourceFilesFromSourceRoots$default(CompilerConfiguration compilerConfiguration, Project project, List list2, CompilerMessageLocation compilerMessageLocation, int n, Object object) {
        if ((n & 8) != 0) {
            compilerMessageLocation = null;
        }
        return CoreEnvironmentUtilsKt.createSourceFilesFromSourceRoots(compilerConfiguration, project, list2, compilerMessageLocation);
    }

    @NotNull
    public static final MessageCollector getMessageCollector(@NotNull KotlinCoreEnvironment $this$messageCollector) {
        Intrinsics.checkNotNullParameter((Object)$this$messageCollector, (String)"<this>");
        MessageCollector messageCollector2 = $this$messageCollector.getConfiguration().getNotNull(CLIConfigurationKeys.MESSAGE_COLLECTOR_KEY);
        Intrinsics.checkNotNullExpressionValue((Object)messageCollector2, (String)"getNotNull(...)");
        return messageCollector2;
    }

    @NotNull
    public static final CompilerConfiguration applyModuleProperties(@NotNull CompilerConfiguration $this$applyModuleProperties, @NotNull Module module2, @Nullable File buildFile) {
        CompilerConfiguration compilerConfiguration;
        Intrinsics.checkNotNullParameter((Object)$this$applyModuleProperties, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)module2, (String)"module");
        CompilerConfiguration $this$applyModuleProperties_u24lambda_u241 = compilerConfiguration = $this$applyModuleProperties.copy();
        boolean bl = false;
        if (buildFile != null) {
            CompilerConfigurationKey<File> compilerConfigurationKey = JVMConfigurationKeys.OUTPUT_DIRECTORY;
            Intrinsics.checkNotNullExpressionValue(compilerConfigurationKey, (String)"OUTPUT_DIRECTORY");
            CoreEnvironmentUtilsKt.applyModuleProperties$lambda$1$checkKeyIsNull($this$applyModuleProperties_u24lambda_u241, compilerConfigurationKey, "OUTPUT_DIRECTORY");
            CompilerConfigurationKey<File> compilerConfigurationKey2 = JVMConfigurationKeys.OUTPUT_JAR;
            Intrinsics.checkNotNullExpressionValue(compilerConfigurationKey2, (String)"OUTPUT_JAR");
            CoreEnvironmentUtilsKt.applyModuleProperties$lambda$1$checkKeyIsNull($this$applyModuleProperties_u24lambda_u241, compilerConfigurationKey2, "OUTPUT_JAR");
            $this$applyModuleProperties_u24lambda_u241.put(JVMConfigurationKeys.OUTPUT_DIRECTORY, new File(module2.getOutputDirectory()));
        }
        CompilerConfiguration compilerConfiguration2 = compilerConfiguration;
        Intrinsics.checkNotNullExpressionValue((Object)compilerConfiguration2, (String)"apply(...)");
        return compilerConfiguration2;
    }

    @NotNull
    public static final List<KotlinSourceRoot> getSourceRootsCheckingForDuplicates(@NotNull CompilerConfiguration configuration2, @Nullable MessageCollector messageCollector2) {
        Intrinsics.checkNotNullParameter((Object)configuration2, (String)"configuration");
        HashSet<String> uniqueSourceRoots = new HashSet<String>();
        List result2 = new ArrayList();
        for (KotlinSourceRoot root : ContentRootsKt.getKotlinSourceRoots(configuration2)) {
            if (!uniqueSourceRoots.add(root.getPath())) {
                MessageCollector messageCollector3 = messageCollector2;
                if (messageCollector3 != null) {
                    MessageCollector.report$default(messageCollector3, CompilerMessageSeverity.STRONG_WARNING, "Duplicate source root: " + root.getPath(), null, 4, null);
                }
            }
            result2.add(root);
        }
        return result2;
    }

    private static final void forAllFiles$ensurePluginsConfigured(Ref.BooleanRef pluginsConfigured, Project $project) {
        if (!pluginsConfigured.element) {
            for (CompilerConfigurationExtension extension : CompilerConfigurationExtension.Companion.getInstances($project)) {
                extension.updateFileRegistry();
            }
            pluginsConfigured.element = true;
        }
    }

    private static final void applyModuleProperties$lambda$1$checkKeyIsNull(CompilerConfiguration $this_apply, CompilerConfigurationKey<?> key, String name2) {
        boolean bl;
        boolean bl2 = bl = $this_apply.get(key) == null;
        if (_Assertions.ENABLED && !bl) {
            boolean bl3 = false;
            String string2 = name2 + " should be null, when buildFile is used";
            throw new AssertionError((Object)string2);
        }
    }
}

