/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.jvm.checkers.declaration;

import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.AbstractKtSourceElement;
import org.jetbrains.kotlin.descriptors.Modality;
import org.jetbrains.kotlin.diagnostics.DiagnosticContext;
import org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticReportHelpersKt;
import org.jetbrains.kotlin.fir.ClassMembersKt;
import org.jetbrains.kotlin.fir.analysis.checkers.FirHelpersKt;
import org.jetbrains.kotlin.fir.analysis.checkers.MppCheckerKind;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.checkers.declaration.FirDeclarationChecker;
import org.jetbrains.kotlin.fir.analysis.diagnostics.jvm.FirJvmErrors;
import org.jetbrains.kotlin.fir.declarations.DeprecationUtilsKt;
import org.jetbrains.kotlin.fir.declarations.FirCallableDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirMemberDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirRegularClass;
import org.jetbrains.kotlin.fir.declarations.FirSimpleFunction;
import org.jetbrains.kotlin.fir.resolve.ResolveUtilsKt;
import org.jetbrains.kotlin.fir.scopes.jvm.SignatureUtilsKt;
import org.jetbrains.kotlin.fir.symbols.impl.FirNamedFunctionSymbol;
import org.jetbrains.kotlin.load.java.SpecialGenericSignatures;
import org.jetbrains.kotlin.name.Name;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001j\u0002`\u0003B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0004J \u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u00022\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/jvm/checkers/declaration/FirAccidentalOverrideClashChecker;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirDeclarationChecker;", "Lorg/jetbrains/kotlin/fir/declarations/FirSimpleFunction;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirSimpleFunctionChecker;", "()V", "namesPossibleForRenamedBuiltin", "", "Lorg/jetbrains/kotlin/name/Name;", "check", "", "declaration", "context", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "reporter", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "checkers.jvm"})
@SourceDebugExtension(value={"SMAP\nFirAccidentalOverrideClashChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FirAccidentalOverrideClashChecker.kt\norg/jetbrains/kotlin/fir/analysis/jvm/checkers/declaration/FirAccidentalOverrideClashChecker\n+ 2 FirStatusUtils.kt\norg/jetbrains/kotlin/fir/declarations/utils/FirStatusUtilsKt\n*L\n1#1,61:1\n40#2:62\n*S KotlinDebug\n*F\n+ 1 FirAccidentalOverrideClashChecker.kt\norg/jetbrains/kotlin/fir/analysis/jvm/checkers/declaration/FirAccidentalOverrideClashChecker\n*L\n32#1:62\n*E\n"})
public final class FirAccidentalOverrideClashChecker
extends FirDeclarationChecker<FirSimpleFunction> {
    @NotNull
    public static final FirAccidentalOverrideClashChecker INSTANCE = new FirAccidentalOverrideClashChecker();
    @NotNull
    private static final Set<Name> namesPossibleForRenamedBuiltin = CollectionsKt.toSet((Iterable)SpecialGenericSignatures.Companion.getJVM_SHORT_NAME_TO_BUILTIN_SHORT_NAMES_MAP().values());

    private FirAccidentalOverrideClashChecker() {
        super(MppCheckerKind.Platform);
    }

    @Override
    public void check(@NotNull FirSimpleFunction declaration, @NotNull CheckerContext context2, @NotNull DiagnosticReporter reporter2) {
        Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)reporter2, (String)"reporter");
        FirMemberDeclaration $this$isOverride$iv = declaration;
        boolean $i$f$isOverride = false;
        if (!$this$isOverride$iv.getStatus().isOverride()) {
            return;
        }
        Name name2 = declaration.getName();
        boolean mayBeRenamedBuiltIn = namesPossibleForRenamedBuiltin.contains(name2);
        boolean mayBeSameAsBuiltInWithErasedParameters = SpecialGenericSignatures.Companion.getSameAsBuiltinMethodWithErasedValueParameters(name2);
        if (!mayBeRenamedBuiltIn && !mayBeSameAsBuiltInWithErasedParameters) {
            return;
        }
        FirRegularClass firRegularClass = ResolveUtilsKt.getContainingClass(declaration, context2.getSession());
        if (firRegularClass == null) {
            return;
        }
        FirRegularClass containingClass = firRegularClass;
        Ref.BooleanRef reported = new Ref.BooleanRef();
        FirHelpersKt.unsubstitutedScope(containingClass, context2).processFunctionsByName(name2, (Function1<? super FirNamedFunctionSymbol, Unit>)((Function1)new Function1<FirNamedFunctionSymbol, Unit>(reported, declaration, mayBeRenamedBuiltIn, reporter2, context2){
            final /* synthetic */ Ref.BooleanRef $reported;
            final /* synthetic */ FirSimpleFunction $declaration;
            final /* synthetic */ boolean $mayBeRenamedBuiltIn;
            final /* synthetic */ DiagnosticReporter $reporter;
            final /* synthetic */ CheckerContext $context;
            {
                this.$reported = $reported;
                this.$declaration = $declaration;
                this.$mayBeRenamedBuiltIn = $mayBeRenamedBuiltIn;
                this.$reporter = $reporter;
                this.$context = $context;
                super(1);
            }

            public final void invoke(FirNamedFunctionSymbol it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                FirSimpleFunction hiddenFir = (FirSimpleFunction)it.getFir();
                if (!this.$reported.element && Intrinsics.areEqual((Object)DeprecationUtilsKt.isHiddenToOvercomeSignatureClash(hiddenFir), (Object)true)) {
                    Modality modality$iv;
                    FirMemberDeclaration $this$isFinal$iv = hiddenFir;
                    boolean $i$f$isFinal = false;
                    Modality modality = $this$isFinal$iv.getStatus().getModality();
                    if (!(modality == null ? true : (modality$iv = modality) == Modality.FINAL) && Intrinsics.areEqual((Object)SignatureUtilsKt.computeJvmDescriptor$default(this.$declaration, null, false, null, 7, null), (Object)SignatureUtilsKt.computeJvmDescriptor$default(hiddenFir, null, false, null, 7, null))) {
                        FirCallableDeclaration firCallableDeclaration = ClassMembersKt.getInitialSignatureAttr(hiddenFir);
                        FirSimpleFunction firSimpleFunction = firCallableDeclaration instanceof FirSimpleFunction ? (FirSimpleFunction)firCallableDeclaration : null;
                        if (firSimpleFunction == null) {
                            return;
                        }
                        FirSimpleFunction regularBase = firSimpleFunction;
                        String description2 = this.$mayBeRenamedBuiltIn ? "a renamed function" : "a function with erased parameters";
                        KtDiagnosticReportHelpersKt.reportOn$default(this.$reporter, (AbstractKtSourceElement)this.$declaration.getSource(), FirJvmErrors.INSTANCE.getACCIDENTAL_OVERRIDE_CLASH_BY_JVM_SIGNATURE(), (Object)it, (Object)description2, (Object)regularBase.getSymbol(), (DiagnosticContext)this.$context, null, 64, null);
                        this.$reported.element = true;
                    }
                }
            }
        }));
    }
}

