/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.analysis.providers;

import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.search.GlobalSearchScope;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.analysis.api.KtAnalysisSession;
import org.jetbrains.kotlin.analysis.api.symbols.KtClassLikeSymbol;
import org.jetbrains.kotlin.analysis.api.symbols.KtConstructorSymbol;
import org.jetbrains.kotlin.analysis.api.symbols.KtEnumEntrySymbol;
import org.jetbrains.kotlin.analysis.api.symbols.KtFunctionLikeSymbol;
import org.jetbrains.kotlin.analysis.api.symbols.KtPropertyGetterSymbol;
import org.jetbrains.kotlin.analysis.api.symbols.KtPropertySetterSymbol;
import org.jetbrains.kotlin.analysis.api.symbols.KtPropertySymbol;
import org.jetbrains.kotlin.analysis.api.symbols.KtSymbol;
import org.jetbrains.kotlin.analysis.api.symbols.KtVariableLikeSymbol;
import org.jetbrains.kotlin.analysis.providers.KotlinPsiDeclarationProvider;
import org.jetbrains.kotlin.analysis.providers.KotlinPsiDeclarationProviderKt;
import org.jetbrains.kotlin.analysis.providers.PsiDeclarationAndKtSymbolEqualityChecker;
import org.jetbrains.kotlin.name.ClassId;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001a\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u001a\u0010\t\u001a\u0004\u0018\u00010\u00042\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u001c\u0010\f\u001a\u0004\u0018\u00010\u0004*\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0007\u001a\u00020\bJ\u001e\u0010\u0010\u001a\u0004\u0018\u00010\u0004*\u00020\r2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u001e\u0010\u0013\u001a\u0004\u0018\u00010\u0004*\u00020\r2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u001e\u0010\u0016\u001a\u0004\u0018\u00010\u0004*\u00020\r2\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u0014\u0010\u0019\u001a\u00020\u001a*\u00020\u000f2\u0006\u0010\u0007\u001a\u00020\bH\u0002\u00a8\u0006\u001b"}, d2={"Lorg/jetbrains/kotlin/analysis/providers/DecompiledPsiDeclarationProvider;", "", "()V", "providePsiForClass", "Lcom/intellij/psi/PsiElement;", "classLikeSymbol", "Lorg/jetbrains/kotlin/analysis/api/symbols/KtClassLikeSymbol;", "project", "Lcom/intellij/openapi/project/Project;", "providePsiForEnumEntry", "enumEntrySymbol", "Lorg/jetbrains/kotlin/analysis/api/symbols/KtEnumEntrySymbol;", "findPsi", "Lorg/jetbrains/kotlin/analysis/api/KtAnalysisSession;", "ktSymbol", "Lorg/jetbrains/kotlin/analysis/api/symbols/KtSymbol;", "providePsiForConstructor", "constructorSymbol", "Lorg/jetbrains/kotlin/analysis/api/symbols/KtConstructorSymbol;", "providePsiForFunction", "functionLikeSymbol", "Lorg/jetbrains/kotlin/analysis/api/symbols/KtFunctionLikeSymbol;", "providePsiForProperty", "variableLikeSymbol", "Lorg/jetbrains/kotlin/analysis/api/symbols/KtVariableLikeSymbol;", "scope", "Lcom/intellij/psi/search/GlobalSearchScope;", "symbol-light-classes"})
@SourceDebugExtension(value={"SMAP\nDecompiledPsiDeclarationProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DecompiledPsiDeclarationProvider.kt\norg/jetbrains/kotlin/analysis/providers/DecompiledPsiDeclarationProvider\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,113:1\n295#2,2:114\n808#2,11:117\n295#2,2:128\n1#3:116\n*S KotlinDebug\n*F\n+ 1 DecompiledPsiDeclarationProvider.kt\norg/jetbrains/kotlin/analysis/providers/DecompiledPsiDeclarationProvider\n*L\n72#1:114,2\n76#1:117,11\n76#1:128,2\n*E\n"})
public final class DecompiledPsiDeclarationProvider {
    @NotNull
    public static final DecompiledPsiDeclarationProvider INSTANCE = new DecompiledPsiDeclarationProvider();

    private DecompiledPsiDeclarationProvider() {
    }

    @Nullable
    public final PsiElement findPsi(@NotNull KtAnalysisSession $this$findPsi, @NotNull KtSymbol ktSymbol, @NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)$this$findPsi, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)ktSymbol, (String)"ktSymbol");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        KtSymbol ktSymbol2 = ktSymbol;
        return ktSymbol2 instanceof KtConstructorSymbol ? this.providePsiForConstructor($this$findPsi, (KtConstructorSymbol)ktSymbol, project) : (ktSymbol2 instanceof KtFunctionLikeSymbol ? this.providePsiForFunction($this$findPsi, (KtFunctionLikeSymbol)ktSymbol, project) : (ktSymbol2 instanceof KtEnumEntrySymbol ? this.providePsiForEnumEntry((KtEnumEntrySymbol)ktSymbol, project) : (ktSymbol2 instanceof KtVariableLikeSymbol ? this.providePsiForProperty($this$findPsi, (KtVariableLikeSymbol)ktSymbol, project) : (ktSymbol2 instanceof KtClassLikeSymbol ? this.providePsiForClass((KtClassLikeSymbol)ktSymbol, project) : null))));
    }

    private final PsiElement providePsiForConstructor(KtAnalysisSession $this$providePsiForConstructor, KtConstructorSymbol constructorSymbol, Project project) {
        PsiElement psiElement;
        Object object;
        PsiClass psiClass;
        Collection<PsiClass> collection;
        ClassId classId = constructorSymbol.getContainingClassIdIfNonLocal();
        if (classId == null) {
            return null;
        }
        ClassId classId2 = classId;
        Object[] objectArray = KotlinPsiDeclarationProviderKt.createPsiDeclarationProvider(project, this.scope(constructorSymbol, project));
        if (objectArray == null || (collection = objectArray.getClassesByClassId(classId2)) == null || (psiClass = (PsiClass)CollectionsKt.firstOrNull((Iterable)collection)) == null || (object = psiClass.getConstructors()) == null) {
            return null;
        }
        Object[] candidates2 = object;
        if (candidates2.length == 1) {
            psiElement = (PsiElement)ArraysKt.single((Object[])candidates2);
        } else {
            Object object2;
            block5: {
                objectArray = candidates2;
                int n = objectArray.length;
                for (int j = 0; j < n; ++j) {
                    Object psiMethod = object = objectArray[j];
                    boolean bl = false;
                    Intrinsics.checkNotNull((Object)psiMethod);
                    if (!PsiDeclarationAndKtSymbolEqualityChecker.INSTANCE.representsTheSameDeclaration($this$providePsiForConstructor, (PsiMethod)psiMethod, constructorSymbol)) continue;
                    object2 = object;
                    break block5;
                }
                object2 = null;
            }
            psiElement = (PsiElement)object2;
        }
        return psiElement;
    }

    private final PsiElement providePsiForFunction(KtAnalysisSession $this$providePsiForFunction, KtFunctionLikeSymbol functionLikeSymbol, Project project) {
        PsiElement psiElement;
        Collection<PsiMethod> candidates2;
        KotlinPsiDeclarationProvider kotlinPsiDeclarationProvider = KotlinPsiDeclarationProviderKt.createPsiDeclarationProvider(project, this.scope(functionLikeSymbol, project));
        Collection<PsiMethod> collection = candidates2 = kotlinPsiDeclarationProvider != null ? kotlinPsiDeclarationProvider.getFunctions(functionLikeSymbol) : null;
        boolean bl = collection != null ? collection.size() == 1 : false;
        if (bl) {
            psiElement = (PsiElement)CollectionsKt.single((Iterable)candidates2);
        } else {
            PsiMethod psiMethod;
            Collection<PsiMethod> collection2 = candidates2;
            if (collection2 != null) {
                Object v4;
                block5: {
                    Iterable iterable = collection2;
                    for (Object t : iterable) {
                        PsiMethod psiMethod2 = (PsiMethod)t;
                        boolean bl2 = false;
                        if (!PsiDeclarationAndKtSymbolEqualityChecker.INSTANCE.representsTheSameDeclaration($this$providePsiForFunction, psiMethod2, functionLikeSymbol)) continue;
                        v4 = t;
                        break block5;
                    }
                    v4 = null;
                }
                psiMethod = v4;
            } else {
                psiMethod = null;
            }
            psiElement = (PsiElement)psiMethod;
        }
        return psiElement;
    }

    /*
     * WARNING - void declaration
     */
    private final PsiElement providePsiForProperty(KtAnalysisSession $this$providePsiForProperty, KtVariableLikeSymbol variableLikeSymbol, Project project) {
        Object psiMember;
        Collection<PsiMember> candidates2;
        KotlinPsiDeclarationProvider kotlinPsiDeclarationProvider = KotlinPsiDeclarationProviderKt.createPsiDeclarationProvider(project, this.scope(variableLikeSymbol, project));
        Collection<PsiMember> collection = candidates2 = kotlinPsiDeclarationProvider != null ? kotlinPsiDeclarationProvider.getProperties(variableLikeSymbol) : null;
        boolean bl = collection != null ? collection.size() == 1 : false;
        if (bl) {
            return (PsiElement)CollectionsKt.single((Iterable)candidates2);
        }
        if (candidates2 != null) {
            Object v2;
            block9: {
                Iterable $this$firstOrNull$iv = candidates2;
                boolean $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    psiMember = (PsiMember)element$iv;
                    boolean bl2 = false;
                    if (!(psiMember instanceof PsiField)) continue;
                    v2 = element$iv;
                    break block9;
                }
                v2 = null;
            }
            kotlinPsiDeclarationProvider = v2;
            if (kotlinPsiDeclarationProvider != null) {
                KotlinPsiDeclarationProvider it = kotlinPsiDeclarationProvider;
                boolean bl3 = false;
                return (PsiElement)it;
            }
        }
        if (variableLikeSymbol instanceof KtPropertySymbol) {
            KtPropertyGetterSymbol getterSymbol = ((KtPropertySymbol)variableLikeSymbol).getGetter();
            KtPropertySetterSymbol setterSymbol = ((KtPropertySymbol)variableLikeSymbol).getSetter();
            if (candidates2 != null) {
                Object v3;
                block10: {
                    void $this$filterIsInstanceTo$iv$iv;
                    Iterable $this$filterIsInstance$iv = candidates2;
                    boolean $i$f$filterIsInstance = false;
                    psiMember = $this$filterIsInstance$iv;
                    Collection destination$iv$iv = new ArrayList();
                    boolean $i$f$filterIsInstanceTo = false;
                    for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
                        if (!(element$iv$iv instanceof PsiMethod)) continue;
                        destination$iv$iv.add(element$iv$iv);
                    }
                    Iterable $this$firstOrNull$iv = (List)destination$iv$iv;
                    boolean $i$f$firstOrNull = false;
                    for (Object element$iv : $this$firstOrNull$iv) {
                        PsiMethod psiMethod = (PsiMethod)element$iv;
                        boolean bl4 = false;
                        if (!(getterSymbol != null && PsiDeclarationAndKtSymbolEqualityChecker.INSTANCE.representsTheSameDeclaration($this$providePsiForProperty, psiMethod, getterSymbol) || setterSymbol != null && PsiDeclarationAndKtSymbolEqualityChecker.INSTANCE.representsTheSameDeclaration($this$providePsiForProperty, psiMethod, setterSymbol))) continue;
                        v3 = element$iv;
                        break block10;
                    }
                    v3 = null;
                }
                PsiMethod psiMethod = v3;
                if (psiMethod != null) {
                    PsiMethod it = psiMethod;
                    boolean bl5 = false;
                    return (PsiElement)it;
                }
            }
        }
        Collection<PsiMember> collection2 = candidates2;
        return (PsiElement)(collection2 != null ? (PsiMember)CollectionsKt.firstOrNull((Iterable)collection2) : null);
    }

    private final PsiElement providePsiForClass(KtClassLikeSymbol classLikeSymbol, Project project) {
        PsiClass psiClass;
        ClassId classId = classLikeSymbol.getClassIdIfNonLocal();
        if (classId != null) {
            Collection<PsiClass> collection;
            ClassId it = classId;
            boolean bl = false;
            KotlinPsiDeclarationProvider kotlinPsiDeclarationProvider = KotlinPsiDeclarationProviderKt.createPsiDeclarationProvider(project, INSTANCE.scope(classLikeSymbol, project));
            psiClass = kotlinPsiDeclarationProvider != null && (collection = kotlinPsiDeclarationProvider.getClassesByClassId(it)) != null ? (PsiClass)CollectionsKt.firstOrNull((Iterable)collection) : null;
        } else {
            psiClass = null;
        }
        return (PsiElement)psiClass;
    }

    private final PsiElement providePsiForEnumEntry(KtEnumEntrySymbol enumEntrySymbol, Project project) {
        Object object;
        block3: {
            PsiClass psiClass;
            Object[] objectArray;
            ClassId classId = enumEntrySymbol.getContainingEnumClassIdIfNonLocal();
            if (classId == null) {
                return null;
            }
            ClassId classId2 = classId;
            KotlinPsiDeclarationProvider kotlinPsiDeclarationProvider = KotlinPsiDeclarationProviderKt.createPsiDeclarationProvider(project, this.scope(enumEntrySymbol, project));
            if (kotlinPsiDeclarationProvider == null || (objectArray = kotlinPsiDeclarationProvider.getClassesByClassId(classId2)) == null || (psiClass = (PsiClass)CollectionsKt.firstOrNull((Iterable)((Iterable)objectArray))) == null) {
                return null;
            }
            PsiClass psiClass2 = psiClass;
            PsiField[] psiFieldArray = psiClass2.getFields();
            Intrinsics.checkNotNullExpressionValue((Object)psiFieldArray, (String)"getFields(...)");
            for (Object object2 : (Object[])psiFieldArray) {
                PsiField it = (PsiField)object2;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.getName(), (Object)enumEntrySymbol.getName().asString())) continue;
                object = object2;
                break block3;
            }
            object = null;
        }
        return (PsiElement)object;
    }

    private final GlobalSearchScope scope(KtSymbol $this$scope, Project project) {
        GlobalSearchScope globalSearchScope = GlobalSearchScope.allScope((Project)project);
        Intrinsics.checkNotNullExpressionValue((Object)globalSearchScope, (String)"allScope(...)");
        return globalSearchScope;
    }
}

