/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.light.classes.symbol.modifierLists;

import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.util.IncorrectOperationException;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.asJava.classes.ImplUtilsKt;
import org.jetbrains.kotlin.asJava.elements.KtLightAbstractAnnotation;
import org.jetbrains.kotlin.asJava.elements.KtLightElement;
import org.jetbrains.kotlin.asJava.elements.KtLightElementBase;
import org.jetbrains.kotlin.light.classes.symbol.SymbolLightUtilsKt;
import org.jetbrains.kotlin.light.classes.symbol.annotations.AnnotationsBox;
import org.jetbrains.kotlin.light.classes.symbol.modifierLists.ModifiersBox;
import org.jetbrains.kotlin.psi.KtModifierList;
import org.jetbrains.kotlin.psi.KtModifierListOwner;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0088\u0001\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0001\n\u0002\b\u0006\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b0\u0018\u0000*\u0016\b\u0000\u0010\u0001 \u0001*\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00040\u00022\u00020\u00052\u00020\u00062\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00040\u0002B!\b\u0004\u0012\u0006\u0010\b\u001a\u00028\u0000\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\f\u00a2\u0006\u0004\b\r\u0010\u000eJ\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\r\u0010\u0019\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010\u0010J\u0012\u0010\u001a\u001a\u00020\u001b2\b\u0010\u001c\u001a\u0004\u0018\u00010\u001dH\u0016J\b\u0010\u001e\u001a\u00020\u001bH\u0016J\b\u0010\u001f\u001a\u00020 H\u0016J\u0013\u0010&\u001a\u00020\u001b2\b\u0010'\u001a\u0004\u0018\u00010(H\u0096\u0002J\b\u0010)\u001a\u00020*H\u0016J\u0018\u0010+\u001a\u00020,2\u0006\u0010-\u001a\u00020 2\u0006\u0010.\u001a\u00020\u001bH\u0016J\u0018\u0010/\u001a\u00020,2\u0006\u0010-\u001a\u00020 2\u0006\u0010.\u001a\u00020\u001bH\u0016J\u0010\u00100\u001a\u00020\u001b2\u0006\u0010-\u001a\u00020 H\u0016J\u0010\u00101\u001a\u00020\u001b2\u0006\u0010-\u001a\u00020 H\u0016J\u0013\u00102\u001a\b\u0012\u0004\u0012\u00020403H\u0016\u00a2\u0006\u0002\u00105J\u0013\u00106\u001a\b\u0012\u0004\u0012\u00020403H\u0016\u00a2\u0006\u0002\u00105J\u0012\u00107\u001a\u0004\u0018\u0001042\u0006\u00108\u001a\u00020 H\u0016J\u0010\u00109\u001a\u00020\u001b2\u0006\u00108\u001a\u00020 H\u0016J\u0010\u0010:\u001a\u0002042\u0006\u00108\u001a\u00020 H\u0016R\u0016\u0010\b\u001a\u00028\u0000X\u0084\u0004\u00a2\u0006\n\n\u0002\u0010\u0011\u001a\u0004\b\u000f\u0010\u0010R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0016\u001a\u0004\u0018\u00010\u00078VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0018R\u001a\u0010!\u001a\b\u0012\u0004\u0012\u00020#0\"8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b$\u0010%\u0082\u0001\u0002;<\u00a8\u0006="}, d2={"Lorg/jetbrains/kotlin/light/classes/symbol/modifierLists/SymbolLightModifierList;", "T", "Lorg/jetbrains/kotlin/asJava/elements/KtLightElement;", "Lorg/jetbrains/kotlin/psi/KtModifierListOwner;", "Lcom/intellij/psi/PsiModifierListOwner;", "Lorg/jetbrains/kotlin/asJava/elements/KtLightElementBase;", "Lcom/intellij/psi/PsiModifierList;", "Lorg/jetbrains/kotlin/psi/KtModifierList;", "owner", "modifiersBox", "Lorg/jetbrains/kotlin/light/classes/symbol/modifierLists/ModifiersBox;", "annotationsBox", "Lorg/jetbrains/kotlin/light/classes/symbol/annotations/AnnotationsBox;", "<init>", "(Lorg/jetbrains/kotlin/asJava/elements/KtLightElement;Lorg/jetbrains/kotlin/light/classes/symbol/modifierLists/ModifiersBox;Lorg/jetbrains/kotlin/light/classes/symbol/annotations/AnnotationsBox;)V", "getOwner", "()Lorg/jetbrains/kotlin/asJava/elements/KtLightElement;", "Lorg/jetbrains/kotlin/asJava/elements/KtLightElement;", "accept", "", "visitor", "Lcom/intellij/psi/PsiElementVisitor;", "kotlinOrigin", "getKotlinOrigin", "()Lorg/jetbrains/kotlin/psi/KtModifierList;", "getParent", "isEquivalentTo", "", "another", "Lcom/intellij/psi/PsiElement;", "isWritable", "toString", "", "givenAnnotations", "", "Lorg/jetbrains/kotlin/asJava/elements/KtLightAbstractAnnotation;", "getGivenAnnotations", "()Ljava/util/List;", "equals", "other", "", "hashCode", "", "setModifierProperty", "", "name", "value", "checkSetModifierProperty", "hasExplicitModifier", "hasModifierProperty", "getAnnotations", "", "Lcom/intellij/psi/PsiAnnotation;", "()[Lcom/intellij/psi/PsiAnnotation;", "getApplicableAnnotations", "findAnnotation", "qualifiedName", "hasAnnotation", "addAnnotation", "Lorg/jetbrains/kotlin/light/classes/symbol/modifierLists/SymbolLightClassModifierList;", "Lorg/jetbrains/kotlin/light/classes/symbol/modifierLists/SymbolLightMemberModifierList;", "symbol-light-classes"})
public abstract class SymbolLightModifierList<T extends KtLightElement<? extends KtModifierListOwner, ? extends PsiModifierListOwner>>
extends KtLightElementBase
implements PsiModifierList,
KtLightElement<KtModifierList, PsiModifierListOwner> {
    @NotNull
    private final T owner;
    @NotNull
    private final ModifiersBox modifiersBox;
    @NotNull
    private final AnnotationsBox annotationsBox;

    private SymbolLightModifierList(T owner, ModifiersBox modifiersBox, AnnotationsBox annotationsBox) {
        super((PsiElement)owner);
        this.owner = owner;
        this.modifiersBox = modifiersBox;
        this.annotationsBox = annotationsBox;
    }

    @NotNull
    protected final T getOwner() {
        return this.owner;
    }

    public void accept(@NotNull PsiElementVisitor visitor2) {
        Intrinsics.checkNotNullParameter((Object)visitor2, (String)"visitor");
        if (visitor2 instanceof JavaElementVisitor) {
            ((JavaElementVisitor)visitor2).visitModifierList((PsiModifierList)this);
        } else {
            visitor2.visitElement((PsiElement)this);
        }
    }

    @Override
    @Nullable
    public KtModifierList getKotlinOrigin() {
        KtModifierListOwner ktModifierListOwner = (KtModifierListOwner)this.owner.getKotlinOrigin();
        return ktModifierListOwner != null ? ktModifierListOwner.getModifierList() : null;
    }

    @NotNull
    public T getParent() {
        return this.owner;
    }

    @Override
    public boolean isEquivalentTo(@Nullable PsiElement another) {
        return another instanceof SymbolLightModifierList && Intrinsics.areEqual(this.owner, ((SymbolLightModifierList)another).owner);
    }

    @Override
    public boolean isWritable() {
        return false;
    }

    @Override
    @NotNull
    public String toString() {
        return "Light modifier list of " + this.owner;
    }

    @Override
    @NotNull
    public List<KtLightAbstractAnnotation> getGivenAnnotations() {
        SymbolLightUtilsKt.invalidAccess(this);
        throw null;
    }

    public boolean equals(@Nullable Object other) {
        return this == other || other instanceof SymbolLightModifierList && Intrinsics.areEqual((Object)((SymbolLightModifierList)other).getKotlinOrigin(), (Object)this.getKotlinOrigin());
    }

    public int hashCode() {
        KtModifierList ktModifierList = this.getKotlinOrigin();
        return ktModifierList != null ? ktModifierList.hashCode() : 0;
    }

    @NotNull
    public Void setModifierProperty(@NotNull String name2, boolean value2) {
        Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
        ImplUtilsKt.cannotModify(this);
        throw null;
    }

    @NotNull
    public Void checkSetModifierProperty(@NotNull String name2, boolean value2) {
        Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
        throw new IncorrectOperationException();
    }

    public boolean hasExplicitModifier(@NotNull String name2) {
        Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
        return this.hasModifierProperty(name2);
    }

    public boolean hasModifierProperty(@NotNull String name2) {
        Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
        return this.modifiersBox.hasModifier(name2);
    }

    @NotNull
    public PsiAnnotation[] getAnnotations() {
        return this.annotationsBox.annotationsArray(this);
    }

    @NotNull
    public PsiAnnotation[] getApplicableAnnotations() {
        return this.getAnnotations();
    }

    @Nullable
    public PsiAnnotation findAnnotation(@NotNull String qualifiedName) {
        Intrinsics.checkNotNullParameter((Object)qualifiedName, (String)"qualifiedName");
        return this.annotationsBox.findAnnotation(this, qualifiedName);
    }

    public boolean hasAnnotation(@NotNull String qualifiedName) {
        Intrinsics.checkNotNullParameter((Object)qualifiedName, (String)"qualifiedName");
        return this.annotationsBox.hasAnnotation(this, qualifiedName);
    }

    @NotNull
    public PsiAnnotation addAnnotation(@NotNull String qualifiedName) {
        Intrinsics.checkNotNullParameter((Object)qualifiedName, (String)"qualifiedName");
        throw new UnsupportedOperationException();
    }

    public /* synthetic */ SymbolLightModifierList(KtLightElement owner, ModifiersBox modifiersBox, AnnotationsBox annotationsBox, DefaultConstructorMarker $constructor_marker) {
        this(owner, modifiersBox, annotationsBox);
    }
}

