/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.scripting.definitions;

import com.intellij.openapi.util.UserDataHolderBase;
import com.intellij.openapi.util.io.FileUtilRt;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kotlin.Deprecated;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmClassMappingKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KClass;
import kotlin.script.experimental.api.KotlinType;
import kotlin.script.experimental.api.ScriptCompilationConfiguration;
import kotlin.script.experimental.api.ScriptCompilationKt;
import kotlin.script.experimental.api.ScriptEvaluationConfiguration;
import kotlin.script.experimental.api.SourceCode;
import kotlin.script.experimental.host.ConfigurationFromTemplateKt;
import kotlin.script.experimental.host.ScriptingHostConfiguration;
import kotlin.script.experimental.jvm.JvmScriptingHostConfigurationKt;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.scripting.definitions.KotlinScriptDefinition;
import org.jetbrains.kotlin.scripting.definitions.KotlinScriptDefinitionAdapterFromNewAPI;
import org.jetbrains.kotlin.scripting.definitions.ScriptCompilationConfigurationFromDefinition;
import org.jetbrains.kotlin.scripting.definitions.ScriptCompilationConfigurationFromDefinitionKt;
import org.jetbrains.kotlin.scripting.definitions.ScriptEvaluationConfigurationFromDefinition;
import org.jetbrains.kotlin.scripting.definitions.StandardScriptDefinition;
import org.jetbrains.kotlin.scripting.resolve.KotlinScriptDefinitionFromAnnotatedTemplate;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\b\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u001c\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\b\r\b&\u0018\u0000 L2\u00020\u0001:\u0007FGHIJKLB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H&J\u001c\u0010C\u001a\u0004\u0018\u0001HD\"\n\b\u0000\u0010D\u0018\u0001*\u00020\u0005H\u0086\b\u00a2\u0006\u0002\u0010\bJ\b\u0010E\u001a\u00020\u001aH\u0016R\u001a\u0010\u0004\u001a\u00020\u00058&X\u00a7\u0004\u00a2\u0006\f\u0012\u0004\b\u0006\u0010\u0003\u001a\u0004\b\u0007\u0010\bR\u0012\u0010\t\u001a\u00020\nX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR\u0012\u0010\r\u001a\u00020\u000eX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010R\u0014\u0010\u0011\u001a\u0004\u0018\u00010\u0012X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0014R\u0012\u0010\u0019\u001a\u00020\u001aX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\u001cR\u0012\u0010\u001d\u001a\u00020\u001aX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001e\u0010\u001cR\u0014\u0010\u001f\u001a\u00020\u001aX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010\u001cR\u0012\u0010!\u001a\u00020\u001aX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\"\u0010\u001cR\u0014\u0010#\u001a\u0004\u0018\u00010$X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b%\u0010&R\u0014\u0010'\u001a\u00020\u001a8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b(\u0010\u001cR\u0014\u0010)\u001a\u00020\u0016X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b)\u0010*R\u001a\u0010+\u001a\u00020,X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b-\u0010.\"\u0004\b/\u00100R\u0014\u00101\u001a\u00020\u00168VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b2\u0010*R\u0014\u00103\u001a\u00020\u00168VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b4\u0010*R\u0012\u00105\u001a\u000206X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b7\u00108R\u001a\u00109\u001a\b\u0012\u0004\u0012\u00020\u001a0:X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b;\u0010<R\u0018\u0010=\u001a\b\u0012\u0004\u0012\u00020\u001a0:X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b>\u0010<R\u0018\u0010?\u001a\b\u0012\u0004\u0012\u00020\u001a0@X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\bA\u0010B\u00a8\u0006M"}, d2={"Lorg/jetbrains/kotlin/scripting/definitions/ScriptDefinition;", "Lcom/intellij/openapi/util/UserDataHolderBase;", "<init>", "()V", "legacyDefinition", "Lorg/jetbrains/kotlin/scripting/definitions/KotlinScriptDefinition;", "getLegacyDefinition$annotations", "getLegacyDefinition", "()Lorg/jetbrains/kotlin/scripting/definitions/KotlinScriptDefinition;", "hostConfiguration", "Lkotlin/script/experimental/host/ScriptingHostConfiguration;", "getHostConfiguration", "()Lkotlin/script/experimental/host/ScriptingHostConfiguration;", "compilationConfiguration", "Lkotlin/script/experimental/api/ScriptCompilationConfiguration;", "getCompilationConfiguration", "()Lkotlin/script/experimental/api/ScriptCompilationConfiguration;", "evaluationConfiguration", "Lkotlin/script/experimental/api/ScriptEvaluationConfiguration;", "getEvaluationConfiguration", "()Lkotlin/script/experimental/api/ScriptEvaluationConfiguration;", "isScript", "", "script", "Lkotlin/script/experimental/api/SourceCode;", "fileExtension", "", "getFileExtension", "()Ljava/lang/String;", "name", "getName", "defaultClassName", "getDefaultClassName", "definitionId", "getDefinitionId", "contextClassLoader", "Ljava/lang/ClassLoader;", "getContextClassLoader", "()Ljava/lang/ClassLoader;", "platform", "getPlatform", "isDefault", "()Z", "order", "", "getOrder", "()I", "setOrder", "(I)V", "canAutoReloadScriptConfigurationsBeSwitchedOff", "getCanAutoReloadScriptConfigurationsBeSwitchedOff", "canDefinitionBeSwitchedOff", "getCanDefinitionBeSwitchedOff", "baseClassType", "Lkotlin/script/experimental/api/KotlinType;", "getBaseClassType", "()Lkotlin/script/experimental/api/KotlinType;", "defaultCompilerOptions", "", "getDefaultCompilerOptions", "()Ljava/lang/Iterable;", "compilerOptions", "getCompilerOptions", "annotationsForSamWithReceivers", "", "getAnnotationsForSamWithReceivers", "()Ljava/util/List;", "asLegacyOrNull", "T", "toString", "FromLegacy", "FromLegacyTemplate", "FromConfigurationsBase", "FromConfigurations", "FromNewDefinition", "FromTemplate", "Companion", "kotlin-scripting-compiler-impl"})
public abstract class ScriptDefinition
extends UserDataHolderBase {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String defaultClassName;
    private final boolean isDefault;
    private int order = Integer.MAX_VALUE;
    @NotNull
    private final Iterable<String> defaultCompilerOptions = CollectionsKt.emptyList();

    public ScriptDefinition() {
        this.defaultClassName = "Script";
    }

    @NotNull
    public abstract KotlinScriptDefinition getLegacyDefinition();

    @Deprecated(message="Use configurations instead")
    public static /* synthetic */ void getLegacyDefinition$annotations() {
    }

    @NotNull
    public abstract ScriptingHostConfiguration getHostConfiguration();

    @NotNull
    public abstract ScriptCompilationConfiguration getCompilationConfiguration();

    @Nullable
    public abstract ScriptEvaluationConfiguration getEvaluationConfiguration();

    public abstract boolean isScript(@NotNull SourceCode var1);

    @NotNull
    public abstract String getFileExtension();

    @NotNull
    public abstract String getName();

    @NotNull
    public String getDefaultClassName() {
        return this.defaultClassName;
    }

    @NotNull
    public abstract String getDefinitionId();

    @Nullable
    public abstract ClassLoader getContextClassLoader();

    @NotNull
    public String getPlatform() {
        return "JVM";
    }

    public boolean isDefault() {
        return this.isDefault;
    }

    public final int getOrder() {
        return this.order;
    }

    public final void setOrder(int n) {
        this.order = n;
    }

    public boolean getCanAutoReloadScriptConfigurationsBeSwitchedOff() {
        return true;
    }

    public boolean getCanDefinitionBeSwitchedOff() {
        return true;
    }

    @NotNull
    public abstract KotlinType getBaseClassType();

    @NotNull
    public Iterable<String> getDefaultCompilerOptions() {
        return this.defaultCompilerOptions;
    }

    @NotNull
    public abstract Iterable<String> getCompilerOptions();

    @NotNull
    public abstract List<String> getAnnotationsForSamWithReceivers();

    public final /* synthetic */ <T extends KotlinScriptDefinition> T asLegacyOrNull() {
        KotlinScriptDefinition kotlinScriptDefinition;
        boolean $i$f$asLegacyOrNull = false;
        if (this instanceof FromLegacy) {
            KotlinScriptDefinition kotlinScriptDefinition2 = ((FromLegacy)this).getLegacyDefinition();
            Intrinsics.reifiedOperationMarker((int)2, (String)"T");
            kotlinScriptDefinition = kotlinScriptDefinition2;
        } else {
            kotlinScriptDefinition = null;
        }
        return (T)((Object)kotlinScriptDefinition);
    }

    @NotNull
    public String toString() {
        return "ScriptDefinition(" + this.getName() + ')';
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007\u00a8\u0006\b"}, d2={"Lorg/jetbrains/kotlin/scripting/definitions/ScriptDefinition$Companion;", "", "<init>", "()V", "getDefault", "Lorg/jetbrains/kotlin/scripting/definitions/ScriptDefinition$FromConfigurations;", "hostConfiguration", "Lkotlin/script/experimental/host/ScriptingHostConfiguration;", "kotlin-scripting-compiler-impl"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final FromConfigurations getDefault(@NotNull ScriptingHostConfiguration hostConfiguration) {
            Intrinsics.checkNotNullParameter((Object)hostConfiguration, (String)"hostConfiguration");
            ScriptCompilationConfigurationFromDefinition scriptCompilationConfigurationFromDefinition = new ScriptCompilationConfigurationFromDefinition(hostConfiguration, StandardScriptDefinition.INSTANCE);
            ScriptEvaluationConfigurationFromDefinition scriptEvaluationConfigurationFromDefinition = new ScriptEvaluationConfigurationFromDefinition(hostConfiguration, StandardScriptDefinition.INSTANCE);
            return new FromConfigurations(hostConfiguration, scriptCompilationConfigurationFromDefinition, scriptEvaluationConfigurationFromDefinition){
                private final boolean isDefault;
                {
                    this.isDefault = true;
                }

                public boolean isDefault() {
                    return this.isDefault;
                }
            };
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001c\n\u0002\u0010\u000e\n\u0002\b\u000b\b\u0016\u0018\u00002\u00020\u0001B1\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u0012\u000e\b\u0002\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t\u00a2\u0006\u0004\b\u000b\u0010\fR\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0016\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u001a\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014\u00a8\u0006\u0015"}, d2={"Lorg/jetbrains/kotlin/scripting/definitions/ScriptDefinition$FromConfigurations;", "Lorg/jetbrains/kotlin/scripting/definitions/ScriptDefinition$FromConfigurationsBase;", "hostConfiguration", "Lkotlin/script/experimental/host/ScriptingHostConfiguration;", "compilationConfiguration", "Lkotlin/script/experimental/api/ScriptCompilationConfiguration;", "evaluationConfiguration", "Lkotlin/script/experimental/api/ScriptEvaluationConfiguration;", "defaultCompilerOptions", "", "", "<init>", "(Lkotlin/script/experimental/host/ScriptingHostConfiguration;Lkotlin/script/experimental/api/ScriptCompilationConfiguration;Lkotlin/script/experimental/api/ScriptEvaluationConfiguration;Ljava/lang/Iterable;)V", "getHostConfiguration", "()Lkotlin/script/experimental/host/ScriptingHostConfiguration;", "getCompilationConfiguration", "()Lkotlin/script/experimental/api/ScriptCompilationConfiguration;", "getEvaluationConfiguration", "()Lkotlin/script/experimental/api/ScriptEvaluationConfiguration;", "getDefaultCompilerOptions", "()Ljava/lang/Iterable;", "kotlin-scripting-compiler-impl"})
    public static class FromConfigurations
    extends FromConfigurationsBase {
        @NotNull
        private final ScriptingHostConfiguration hostConfiguration;
        @NotNull
        private final ScriptCompilationConfiguration compilationConfiguration;
        @Nullable
        private final ScriptEvaluationConfiguration evaluationConfiguration;
        @NotNull
        private final Iterable<String> defaultCompilerOptions;

        public FromConfigurations(@NotNull ScriptingHostConfiguration hostConfiguration, @NotNull ScriptCompilationConfiguration compilationConfiguration, @Nullable ScriptEvaluationConfiguration evaluationConfiguration, @NotNull Iterable<String> defaultCompilerOptions) {
            Intrinsics.checkNotNullParameter((Object)hostConfiguration, (String)"hostConfiguration");
            Intrinsics.checkNotNullParameter((Object)compilationConfiguration, (String)"compilationConfiguration");
            Intrinsics.checkNotNullParameter(defaultCompilerOptions, (String)"defaultCompilerOptions");
            this.hostConfiguration = hostConfiguration;
            this.compilationConfiguration = compilationConfiguration;
            this.evaluationConfiguration = evaluationConfiguration;
            this.defaultCompilerOptions = defaultCompilerOptions;
        }

        public /* synthetic */ FromConfigurations(ScriptingHostConfiguration scriptingHostConfiguration, ScriptCompilationConfiguration scriptCompilationConfiguration, ScriptEvaluationConfiguration scriptEvaluationConfiguration, Iterable iterable, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 8) != 0) {
                iterable = CollectionsKt.emptyList();
            }
            this(scriptingHostConfiguration, scriptCompilationConfiguration, scriptEvaluationConfiguration, iterable);
        }

        @Override
        @NotNull
        public ScriptingHostConfiguration getHostConfiguration() {
            return this.hostConfiguration;
        }

        @Override
        @NotNull
        public ScriptCompilationConfiguration getCompilationConfiguration() {
            return this.compilationConfiguration;
        }

        @Override
        @Nullable
        public ScriptEvaluationConfiguration getEvaluationConfiguration() {
            return this.evaluationConfiguration;
        }

        @Override
        @NotNull
        public Iterable<String> getDefaultCompilerOptions() {
            return this.defaultCompilerOptions;
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u001c\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0004\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\b&\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J\u0013\u00102\u001a\u00020\u00142\b\u00103\u001a\u0004\u0018\u000104H\u0096\u0002J\b\u00105\u001a\u000206H\u0016R!\u0010\u0004\u001a\u00020\u00058VX\u0096\u0084\u0002\u00a2\u0006\u0012\n\u0004\b\t\u0010\n\u0012\u0004\b\u0006\u0010\u0003\u001a\u0004\b\u0007\u0010\bR\u001d\u0010\u000b\u001a\u0004\u0018\u00010\f8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000f\u0010\n\u001a\u0004\b\r\u0010\u000eR\u001d\u0010\u0010\u001a\u0004\u0018\u00010\f8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0012\u0010\n\u001a\u0004\b\u0011\u0010\u000eR\u0014\u0010\u0017\u001a\u00020\f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u000eR\u0014\u0010\u0019\u001a\u00020\f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u000eR\u0014\u0010\u001b\u001a\u00020\f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001c\u0010\u000eR\u0014\u0010\u001d\u001a\u00020\f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001e\u0010\u000eR\u001d\u0010\u001f\u001a\u0004\u0018\u00010 8VX\u0096\u0084\u0002\u00a2\u0006\f\n\u0004\b#\u0010\n\u001a\u0004\b!\u0010\"R\u0014\u0010$\u001a\u00020\f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b%\u0010\u000eR\u0014\u0010&\u001a\u00020'8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b(\u0010)R\u001a\u0010*\u001a\b\u0012\u0004\u0012\u00020\f0+8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b,\u0010-R\u001a\u0010.\u001a\b\u0012\u0004\u0012\u00020\f0/8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b0\u00101\u00a8\u00067"}, d2={"Lorg/jetbrains/kotlin/scripting/definitions/ScriptDefinition$FromConfigurationsBase;", "Lorg/jetbrains/kotlin/scripting/definitions/ScriptDefinition;", "<init>", "()V", "legacyDefinition", "Lorg/jetbrains/kotlin/scripting/definitions/KotlinScriptDefinitionAdapterFromNewAPI;", "getLegacyDefinition$annotations", "getLegacyDefinition", "()Lorg/jetbrains/kotlin/scripting/definitions/KotlinScriptDefinitionAdapterFromNewAPI;", "legacyDefinition$delegate", "Lkotlin/Lazy;", "filePathPattern", "", "getFilePathPattern", "()Ljava/lang/String;", "filePathPattern$delegate", "fileNamePattern", "getFileNamePattern", "fileNamePattern$delegate", "isScript", "", "script", "Lkotlin/script/experimental/api/SourceCode;", "fileExtension", "getFileExtension", "name", "getName", "defaultClassName", "getDefaultClassName", "definitionId", "getDefinitionId", "contextClassLoader", "Ljava/lang/ClassLoader;", "getContextClassLoader", "()Ljava/lang/ClassLoader;", "contextClassLoader$delegate", "platform", "getPlatform", "baseClassType", "Lkotlin/script/experimental/api/KotlinType;", "getBaseClassType", "()Lkotlin/script/experimental/api/KotlinType;", "compilerOptions", "", "getCompilerOptions", "()Ljava/lang/Iterable;", "annotationsForSamWithReceivers", "", "getAnnotationsForSamWithReceivers", "()Ljava/util/List;", "equals", "other", "", "hashCode", "", "kotlin-scripting-compiler-impl"})
    @SourceDebugExtension(value={"SMAP\nScriptDefinition.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ScriptDefinition.kt\norg/jetbrains/kotlin/scripting/definitions/ScriptDefinition$FromConfigurationsBase\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,237:1\n1#2:238\n1557#3:239\n1628#3,3:240\n*S KotlinDebug\n*F\n+ 1 ScriptDefinition.kt\norg/jetbrains/kotlin/scripting/definitions/ScriptDefinition$FromConfigurationsBase\n*L\n186#1:239\n186#1:240,3\n*E\n"})
    public static abstract class FromConfigurationsBase
    extends ScriptDefinition {
        @NotNull
        private final Lazy legacyDefinition$delegate = LazyKt.lazy(() -> FromConfigurationsBase.legacyDefinition_delegate$lambda$0(this));
        @NotNull
        private final Lazy filePathPattern$delegate = LazyKt.lazy(() -> FromConfigurationsBase.filePathPattern_delegate$lambda$2(this));
        @NotNull
        private final Lazy fileNamePattern$delegate = LazyKt.lazy(() -> FromConfigurationsBase.fileNamePattern_delegate$lambda$4(this));
        @NotNull
        private final Lazy contextClassLoader$delegate = LazyKt.lazy(() -> FromConfigurationsBase.contextClassLoader_delegate$lambda$6(this));

        @Override
        @NotNull
        public KotlinScriptDefinitionAdapterFromNewAPI getLegacyDefinition() {
            Lazy lazy = this.legacyDefinition$delegate;
            return (KotlinScriptDefinitionAdapterFromNewAPI)((Object)lazy.getValue());
        }

        public static /* synthetic */ void getLegacyDefinition$annotations() {
        }

        @Nullable
        public final String getFilePathPattern() {
            Lazy lazy = this.filePathPattern$delegate;
            return (String)lazy.getValue();
        }

        @Nullable
        public final String getFileNamePattern() {
            Lazy lazy = this.fileNamePattern$delegate;
            return (String)lazy.getValue();
        }

        @Override
        public boolean isScript(@NotNull SourceCode script) {
            Intrinsics.checkNotNullParameter((Object)script, (String)"script");
            String extension = '.' + this.getFileExtension();
            String string2 = script.getLocationId();
            if (string2 == null) {
                return false;
            }
            String location = string2;
            String string3 = FileUtilRt.toSystemIndependentName((String)location);
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"toSystemIndependentName(...)");
            String systemIndependentName = string3;
            String string4 = script.getName();
            if (!(string4 != null ? StringsKt.endsWith$default((String)string4, (String)extension, (boolean)false, (int)2, null) : false) && !StringsKt.endsWith$default((String)location, (String)extension, (boolean)false, (int)2, null)) {
                return false;
            }
            if (this.getFilePathPattern() != null) {
                String string5 = this.getFilePathPattern();
                Intrinsics.checkNotNull((Object)string5);
                return new Regex(string5).matches((CharSequence)systemIndependentName);
            }
            if (this.getFileNamePattern() != null) {
                String string6 = this.getFileNamePattern();
                Intrinsics.checkNotNull((Object)string6);
                return new Regex(string6).matches((CharSequence)StringsKt.substringAfterLast$default((String)systemIndependentName, (char)'/', null, (int)2, null));
            }
            return true;
        }

        @Override
        @NotNull
        public String getFileExtension() {
            String string2 = this.getCompilationConfiguration().get(ScriptCompilationKt.getFileExtension(ScriptCompilationConfiguration.Companion));
            Intrinsics.checkNotNull((Object)string2);
            return string2;
        }

        @Override
        @NotNull
        public String getName() {
            String string2;
            block4: {
                block3: {
                    String string3;
                    string2 = this.getCompilationConfiguration().get(ScriptCompilationKt.getDisplayName(ScriptCompilationConfiguration.Companion));
                    if (string2 == null) break block3;
                    String it = string3 = string2;
                    boolean bl = false;
                    string2 = !StringsKt.isBlank((CharSequence)it) ? string3 : null;
                    if (string2 != null) break block4;
                }
                KotlinType kotlinType = this.getCompilationConfiguration().get(ScriptCompilationKt.getBaseClass(ScriptCompilationConfiguration.Companion));
                Intrinsics.checkNotNull((Object)kotlinType);
                string2 = StringsKt.substringAfterLast$default((String)kotlinType.getTypeName(), (char)'.', null, (int)2, null);
            }
            return string2;
        }

        @Override
        @NotNull
        public String getDefaultClassName() {
            String string2 = this.getCompilationConfiguration().get(ScriptCompilationKt.getDefaultIdentifier(ScriptCompilationConfiguration.Companion));
            if (string2 == null) {
                string2 = super.getDefaultClassName();
            }
            return string2;
        }

        @Override
        @NotNull
        public String getDefinitionId() {
            KotlinType kotlinType = this.getCompilationConfiguration().get(ScriptCompilationKt.getBaseClass(ScriptCompilationConfiguration.Companion));
            Intrinsics.checkNotNull((Object)kotlinType);
            return kotlinType.getTypeName();
        }

        @Override
        @Nullable
        public ClassLoader getContextClassLoader() {
            Lazy lazy = this.contextClassLoader$delegate;
            return (ClassLoader)lazy.getValue();
        }

        @Override
        @NotNull
        public String getPlatform() {
            String string2 = this.getCompilationConfiguration().get(ScriptCompilationConfigurationFromDefinitionKt.getPlatform(ScriptCompilationConfiguration.Companion));
            if (string2 == null) {
                string2 = super.getPlatform();
            }
            return string2;
        }

        @Override
        @NotNull
        public KotlinType getBaseClassType() {
            KotlinType kotlinType = this.getCompilationConfiguration().get(ScriptCompilationKt.getBaseClass(ScriptCompilationConfiguration.Companion));
            Intrinsics.checkNotNull((Object)kotlinType);
            return kotlinType;
        }

        @Override
        @NotNull
        public Iterable<String> getCompilerOptions() {
            List list = this.getCompilationConfiguration().get(ScriptCompilationKt.getCompilerOptions(ScriptCompilationConfiguration.Companion));
            if (list == null) {
                list = CollectionsKt.emptyList();
            }
            return list;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        @NotNull
        public List<String> getAnnotationsForSamWithReceivers() {
            void $this$mapTo$iv$iv;
            List list = this.getCompilationConfiguration().get(ScriptCompilationConfigurationFromDefinitionKt.getAnnotationsForSamWithReceivers(ScriptCompilationConfiguration.Companion));
            if (list == null) {
                list = CollectionsKt.emptyList();
            }
            Iterable $this$map$iv = list;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                KotlinType kotlinType = (KotlinType)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(it.getTypeName());
            }
            return (List)destination$iv$iv;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(@Nullable Object other) {
            if (this == other) return true;
            if (!(other instanceof FromConfigurationsBase)) return false;
            FromConfigurationsBase fromConfigurationsBase = (FromConfigurationsBase)((Object)other);
            if (fromConfigurationsBase == null) return false;
            FromConfigurationsBase it = fromConfigurationsBase;
            boolean bl = false;
            if (!Intrinsics.areEqual((Object)this.getCompilationConfiguration(), (Object)it.getCompilationConfiguration())) return false;
            if (!Intrinsics.areEqual((Object)this.getEvaluationConfiguration(), (Object)it.getEvaluationConfiguration())) return false;
            return true;
        }

        public int hashCode() {
            ScriptEvaluationConfiguration scriptEvaluationConfiguration = this.getEvaluationConfiguration();
            return this.getCompilationConfiguration().hashCode() + 37 * (scriptEvaluationConfiguration != null ? scriptEvaluationConfiguration.hashCode() : 0);
        }

        private static final KotlinScriptDefinitionAdapterFromNewAPI legacyDefinition_delegate$lambda$0(FromConfigurationsBase this$0) {
            return new KotlinScriptDefinitionAdapterFromNewAPI(this$0.getCompilationConfiguration(), this$0.getHostConfiguration());
        }

        private static final String filePathPattern_delegate$lambda$2(FromConfigurationsBase this$0) {
            String string2;
            String string3 = this$0.getCompilationConfiguration().get(ScriptCompilationKt.getFilePathPattern(ScriptCompilationConfiguration.Companion));
            if (string3 != null) {
                String string4;
                String it = string4 = string3;
                boolean bl = false;
                string2 = !StringsKt.isBlank((CharSequence)it) ? string4 : null;
            } else {
                string2 = null;
            }
            return string2;
        }

        private static final String fileNamePattern_delegate$lambda$4(FromConfigurationsBase this$0) {
            String string2;
            String string3 = this$0.getCompilationConfiguration().get(ScriptCompilationKt.getFileNamePattern(ScriptCompilationConfiguration.Companion));
            if (string3 != null) {
                String string4;
                String it = string4 = string3;
                boolean bl = false;
                string2 = !StringsKt.isBlank((CharSequence)it) ? string4 : null;
            } else {
                string2 = null;
            }
            return string2;
        }

        private static final ClassLoader contextClassLoader_delegate$lambda$6(FromConfigurationsBase this$0) {
            Object object = this$0.getCompilationConfiguration().get(ScriptCompilationKt.getBaseClass(ScriptCompilationConfiguration.Companion));
            if (object == null || (object = ((KotlinType)object).getFromClass()) == null || (object = JvmClassMappingKt.getJavaClass(object)) == null || (object = ((Class)object).getClassLoader()) == null) {
                object = this$0.getHostConfiguration().get(JvmScriptingHostConfigurationKt.getBaseClassLoader(JvmScriptingHostConfigurationKt.getJvm(ScriptingHostConfiguration.Companion)));
            }
            return object;
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001c\n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\b\u0004\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\b\u0016\u0018\u00002\u00020\u0001B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u000e\b\u0002\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\u0004\b\t\u0010\nJ\u0010\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001fH\u0016J\u0013\u00107\u001a\u00020\u001d2\b\u00108\u001a\u0004\u0018\u000109H\u0096\u0002J\b\u0010:\u001a\u00020;H\u0016R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u001a\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u001b\u0010\u0011\u001a\u00020\u00128VX\u0096\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0015\u0010\u0016\u001a\u0004\b\u0013\u0010\u0014R\u001b\u0010\u0017\u001a\u00020\u00188VX\u0096\u0084\u0002\u00a2\u0006\f\n\u0004\b\u001b\u0010\u0016\u001a\u0004\b\u0019\u0010\u001aR\u0014\u0010 \u001a\u00020\b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b!\u0010\"R\u0014\u0010#\u001a\u00020\b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b$\u0010\"R\u0014\u0010%\u001a\u00020\b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b&\u0010\"R\u0014\u0010'\u001a\u00020\b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b(\u0010\"R\u0016\u0010)\u001a\u0004\u0018\u00010*8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b+\u0010,R\u0014\u0010-\u001a\u00020.8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b/\u00100R\u001a\u00101\u001a\b\u0012\u0004\u0012\u00020\b0\u00078VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b2\u0010\u0010R\u001a\u00103\u001a\b\u0012\u0004\u0012\u00020\b048VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b5\u00106\u00a8\u0006<"}, d2={"Lorg/jetbrains/kotlin/scripting/definitions/ScriptDefinition$FromLegacy;", "Lorg/jetbrains/kotlin/scripting/definitions/ScriptDefinition;", "hostConfiguration", "Lkotlin/script/experimental/host/ScriptingHostConfiguration;", "legacyDefinition", "Lorg/jetbrains/kotlin/scripting/definitions/KotlinScriptDefinition;", "defaultCompilerOptions", "", "", "<init>", "(Lkotlin/script/experimental/host/ScriptingHostConfiguration;Lorg/jetbrains/kotlin/scripting/definitions/KotlinScriptDefinition;Ljava/lang/Iterable;)V", "getHostConfiguration", "()Lkotlin/script/experimental/host/ScriptingHostConfiguration;", "getLegacyDefinition", "()Lorg/jetbrains/kotlin/scripting/definitions/KotlinScriptDefinition;", "getDefaultCompilerOptions", "()Ljava/lang/Iterable;", "compilationConfiguration", "Lkotlin/script/experimental/api/ScriptCompilationConfiguration;", "getCompilationConfiguration", "()Lkotlin/script/experimental/api/ScriptCompilationConfiguration;", "compilationConfiguration$delegate", "Lkotlin/Lazy;", "evaluationConfiguration", "Lorg/jetbrains/kotlin/scripting/definitions/ScriptEvaluationConfigurationFromDefinition;", "getEvaluationConfiguration", "()Lorg/jetbrains/kotlin/scripting/definitions/ScriptEvaluationConfigurationFromDefinition;", "evaluationConfiguration$delegate", "isScript", "", "script", "Lkotlin/script/experimental/api/SourceCode;", "fileExtension", "getFileExtension", "()Ljava/lang/String;", "name", "getName", "definitionId", "getDefinitionId", "platform", "getPlatform", "contextClassLoader", "Ljava/lang/ClassLoader;", "getContextClassLoader", "()Ljava/lang/ClassLoader;", "baseClassType", "Lkotlin/script/experimental/api/KotlinType;", "getBaseClassType", "()Lkotlin/script/experimental/api/KotlinType;", "compilerOptions", "getCompilerOptions", "annotationsForSamWithReceivers", "", "getAnnotationsForSamWithReceivers", "()Ljava/util/List;", "equals", "other", "", "hashCode", "", "kotlin-scripting-compiler-impl"})
    @SourceDebugExtension(value={"SMAP\nScriptDefinition.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ScriptDefinition.kt\norg/jetbrains/kotlin/scripting/definitions/ScriptDefinition$FromLegacy\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,237:1\n1#2:238\n*E\n"})
    public static class FromLegacy
    extends ScriptDefinition {
        @NotNull
        private final ScriptingHostConfiguration hostConfiguration;
        @NotNull
        private final KotlinScriptDefinition legacyDefinition;
        @NotNull
        private final Iterable<String> defaultCompilerOptions;
        @NotNull
        private final Lazy compilationConfiguration$delegate;
        @NotNull
        private final Lazy evaluationConfiguration$delegate;

        public FromLegacy(@NotNull ScriptingHostConfiguration hostConfiguration, @NotNull KotlinScriptDefinition legacyDefinition, @NotNull Iterable<String> defaultCompilerOptions) {
            Intrinsics.checkNotNullParameter((Object)hostConfiguration, (String)"hostConfiguration");
            Intrinsics.checkNotNullParameter((Object)((Object)legacyDefinition), (String)"legacyDefinition");
            Intrinsics.checkNotNullParameter(defaultCompilerOptions, (String)"defaultCompilerOptions");
            this.hostConfiguration = hostConfiguration;
            this.legacyDefinition = legacyDefinition;
            this.defaultCompilerOptions = defaultCompilerOptions;
            this.compilationConfiguration$delegate = LazyKt.lazy(() -> FromLegacy.compilationConfiguration_delegate$lambda$0(this));
            this.evaluationConfiguration$delegate = LazyKt.lazy(() -> FromLegacy.evaluationConfiguration_delegate$lambda$1(this));
        }

        public /* synthetic */ FromLegacy(ScriptingHostConfiguration scriptingHostConfiguration, KotlinScriptDefinition kotlinScriptDefinition, Iterable iterable, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 4) != 0) {
                iterable = CollectionsKt.emptyList();
            }
            this(scriptingHostConfiguration, kotlinScriptDefinition, iterable);
        }

        @Override
        @NotNull
        public ScriptingHostConfiguration getHostConfiguration() {
            return this.hostConfiguration;
        }

        @Override
        @NotNull
        public KotlinScriptDefinition getLegacyDefinition() {
            return this.legacyDefinition;
        }

        @Override
        @NotNull
        public Iterable<String> getDefaultCompilerOptions() {
            return this.defaultCompilerOptions;
        }

        @Override
        @NotNull
        public ScriptCompilationConfiguration getCompilationConfiguration() {
            Lazy lazy = this.compilationConfiguration$delegate;
            return (ScriptCompilationConfiguration)lazy.getValue();
        }

        @Override
        @NotNull
        public ScriptEvaluationConfigurationFromDefinition getEvaluationConfiguration() {
            Lazy lazy = this.evaluationConfiguration$delegate;
            return (ScriptEvaluationConfigurationFromDefinition)lazy.getValue();
        }

        @Override
        public boolean isScript(@NotNull SourceCode script) {
            boolean bl;
            Intrinsics.checkNotNullParameter((Object)script, (String)"script");
            String string2 = script.getName();
            if (string2 != null) {
                String it = string2;
                boolean bl2 = false;
                bl = this.getLegacyDefinition().isScript(it);
            } else {
                bl = this.isDefault();
            }
            return bl;
        }

        @Override
        @NotNull
        public String getFileExtension() {
            return this.getLegacyDefinition().getFileExtension();
        }

        @Override
        @NotNull
        public String getName() {
            return this.getLegacyDefinition().getName();
        }

        @Override
        @NotNull
        public String getDefinitionId() {
            String string2 = Reflection.getOrCreateKotlinClass(((Object)((Object)this.getLegacyDefinition())).getClass()).getQualifiedName();
            if (string2 == null) {
                string2 = "unknown";
            }
            return string2;
        }

        @Override
        @NotNull
        public String getPlatform() {
            return this.getLegacyDefinition().getPlatform();
        }

        @Override
        @Nullable
        public ClassLoader getContextClassLoader() {
            return JvmClassMappingKt.getJavaClass(this.getLegacyDefinition().getTemplate()).getClassLoader();
        }

        @Override
        @NotNull
        public KotlinType getBaseClassType() {
            return new KotlinType(this.getLegacyDefinition().getTemplate(), false, 2, null);
        }

        @Override
        @NotNull
        public Iterable<String> getCompilerOptions() {
            Iterable iterable = this.getLegacyDefinition().getAdditionalCompilerArguments();
            if (iterable == null) {
                iterable = CollectionsKt.emptyList();
            }
            return iterable;
        }

        @Override
        @NotNull
        public List<String> getAnnotationsForSamWithReceivers() {
            return this.getLegacyDefinition().getAnnotationsForSamWithReceivers();
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(@Nullable Object other) {
            if (this == other) return true;
            FromLegacy fromLegacy = other instanceof FromLegacy ? (FromLegacy)((Object)other) : null;
            if (!Intrinsics.areEqual((Object)((Object)this.getLegacyDefinition()), (Object)((Object)(fromLegacy != null ? fromLegacy.getLegacyDefinition() : null)))) return false;
            return true;
        }

        public int hashCode() {
            return this.getLegacyDefinition().hashCode();
        }

        private static final ScriptCompilationConfigurationFromDefinition compilationConfiguration_delegate$lambda$0(FromLegacy this$0) {
            return new ScriptCompilationConfigurationFromDefinition(this$0.getHostConfiguration(), this$0.getLegacyDefinition());
        }

        private static final ScriptEvaluationConfigurationFromDefinition evaluationConfiguration_delegate$lambda$1(FromLegacy this$0) {
            return new ScriptEvaluationConfigurationFromDefinition(this$0.getHostConfiguration(), this$0.getLegacyDefinition());
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001c\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0016\u0018\u00002\u00020\u0001B;\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\u0010\u0004\u001a\u0006\u0012\u0002\b\u00030\u0005\u0012\u000e\b\u0002\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u0012\u000e\b\u0002\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n\u00a2\u0006\u0004\b\f\u0010\r\u00a8\u0006\u000e"}, d2={"Lorg/jetbrains/kotlin/scripting/definitions/ScriptDefinition$FromLegacyTemplate;", "Lorg/jetbrains/kotlin/scripting/definitions/ScriptDefinition$FromLegacy;", "hostConfiguration", "Lkotlin/script/experimental/host/ScriptingHostConfiguration;", "template", "Lkotlin/reflect/KClass;", "templateClasspath", "", "Ljava/io/File;", "defaultCompilerOptions", "", "", "<init>", "(Lkotlin/script/experimental/host/ScriptingHostConfiguration;Lkotlin/reflect/KClass;Ljava/util/List;Ljava/lang/Iterable;)V", "kotlin-scripting-compiler-impl"})
    public static class FromLegacyTemplate
    extends FromLegacy {
        public FromLegacyTemplate(@NotNull ScriptingHostConfiguration hostConfiguration, @NotNull KClass<?> template, @NotNull List<? extends File> templateClasspath, @NotNull Iterable<String> defaultCompilerOptions) {
            Intrinsics.checkNotNullParameter((Object)hostConfiguration, (String)"hostConfiguration");
            Intrinsics.checkNotNullParameter(template, (String)"template");
            Intrinsics.checkNotNullParameter(templateClasspath, (String)"templateClasspath");
            Intrinsics.checkNotNullParameter(defaultCompilerOptions, (String)"defaultCompilerOptions");
            Function0<Map<String, Object>> function0 = hostConfiguration.get(ScriptCompilationConfigurationFromDefinitionKt.getGetEnvironment(ScriptingHostConfiguration.Companion));
            super(hostConfiguration, new KotlinScriptDefinitionFromAnnotatedTemplate(template, function0 != null ? (Map)function0.invoke() : null, templateClasspath), defaultCompilerOptions);
        }

        public /* synthetic */ FromLegacyTemplate(ScriptingHostConfiguration scriptingHostConfiguration, KClass kClass, List list, Iterable iterable, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 4) != 0) {
                list = CollectionsKt.emptyList();
            }
            if ((n & 8) != 0) {
                iterable = CollectionsKt.emptyList();
            }
            this(scriptingHostConfiguration, kClass, list, iterable);
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001c\n\u0002\u0010\u000e\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0016\u0018\u00002\u00020\u0001B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u000e\b\u0002\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\u0004\b\t\u0010\nR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0014\u0010\r\u001a\u00020\u00038VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000fR\u0014\u0010\u0010\u001a\u00020\u00118VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013R\u0014\u0010\u0014\u001a\u00020\u00158VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0017\u00a8\u0006\u0018"}, d2={"Lorg/jetbrains/kotlin/scripting/definitions/ScriptDefinition$FromNewDefinition;", "Lorg/jetbrains/kotlin/scripting/definitions/ScriptDefinition$FromConfigurationsBase;", "baseHostConfiguration", "Lkotlin/script/experimental/host/ScriptingHostConfiguration;", "definition", "Lkotlin/script/experimental/host/ScriptDefinition;", "defaultCompilerOptions", "", "", "<init>", "(Lkotlin/script/experimental/host/ScriptingHostConfiguration;Lkotlin/script/experimental/host/ScriptDefinition;Ljava/lang/Iterable;)V", "getDefaultCompilerOptions", "()Ljava/lang/Iterable;", "hostConfiguration", "getHostConfiguration", "()Lkotlin/script/experimental/host/ScriptingHostConfiguration;", "compilationConfiguration", "Lkotlin/script/experimental/api/ScriptCompilationConfiguration;", "getCompilationConfiguration", "()Lkotlin/script/experimental/api/ScriptCompilationConfiguration;", "evaluationConfiguration", "Lkotlin/script/experimental/api/ScriptEvaluationConfiguration;", "getEvaluationConfiguration", "()Lkotlin/script/experimental/api/ScriptEvaluationConfiguration;", "kotlin-scripting-compiler-impl"})
    public static class FromNewDefinition
    extends FromConfigurationsBase {
        @NotNull
        private final ScriptingHostConfiguration baseHostConfiguration;
        @NotNull
        private final kotlin.script.experimental.host.ScriptDefinition definition;
        @NotNull
        private final Iterable<String> defaultCompilerOptions;

        public FromNewDefinition(@NotNull ScriptingHostConfiguration baseHostConfiguration, @NotNull kotlin.script.experimental.host.ScriptDefinition definition, @NotNull Iterable<String> defaultCompilerOptions) {
            Intrinsics.checkNotNullParameter((Object)baseHostConfiguration, (String)"baseHostConfiguration");
            Intrinsics.checkNotNullParameter((Object)definition, (String)"definition");
            Intrinsics.checkNotNullParameter(defaultCompilerOptions, (String)"defaultCompilerOptions");
            this.baseHostConfiguration = baseHostConfiguration;
            this.definition = definition;
            this.defaultCompilerOptions = defaultCompilerOptions;
        }

        public /* synthetic */ FromNewDefinition(ScriptingHostConfiguration scriptingHostConfiguration, kotlin.script.experimental.host.ScriptDefinition scriptDefinition, Iterable iterable, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 4) != 0) {
                iterable = CollectionsKt.emptyList();
            }
            this(scriptingHostConfiguration, scriptDefinition, iterable);
        }

        @Override
        @NotNull
        public Iterable<String> getDefaultCompilerOptions() {
            return this.defaultCompilerOptions;
        }

        @Override
        @NotNull
        public ScriptingHostConfiguration getHostConfiguration() {
            ScriptingHostConfiguration scriptingHostConfiguration = this.definition.getCompilationConfiguration().get(ScriptCompilationKt.getHostConfiguration(ScriptCompilationConfiguration.Companion));
            if (scriptingHostConfiguration == null) {
                scriptingHostConfiguration = this.baseHostConfiguration;
            }
            return scriptingHostConfiguration;
        }

        @Override
        @NotNull
        public ScriptCompilationConfiguration getCompilationConfiguration() {
            return this.definition.getCompilationConfiguration();
        }

        @Override
        @NotNull
        public ScriptEvaluationConfiguration getEvaluationConfiguration() {
            return this.definition.getEvaluationConfiguration();
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001c\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0016\u0018\u00002\u00020\u0001B9\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\u0010\u0004\u001a\u0006\u0012\u0002\b\u00030\u0005\u0012\f\b\u0002\u0010\u0006\u001a\u0006\u0012\u0002\b\u00030\u0005\u0012\u000e\b\u0002\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b\u00a2\u0006\u0004\b\n\u0010\u000b\u00a8\u0006\f"}, d2={"Lorg/jetbrains/kotlin/scripting/definitions/ScriptDefinition$FromTemplate;", "Lorg/jetbrains/kotlin/scripting/definitions/ScriptDefinition$FromNewDefinition;", "baseHostConfiguration", "Lkotlin/script/experimental/host/ScriptingHostConfiguration;", "template", "Lkotlin/reflect/KClass;", "contextClass", "defaultCompilerOptions", "", "", "<init>", "(Lkotlin/script/experimental/host/ScriptingHostConfiguration;Lkotlin/reflect/KClass;Lkotlin/reflect/KClass;Ljava/lang/Iterable;)V", "kotlin-scripting-compiler-impl"})
    public static class FromTemplate
    extends FromNewDefinition {
        public FromTemplate(@NotNull ScriptingHostConfiguration baseHostConfiguration, @NotNull KClass<?> template, @NotNull KClass<?> contextClass, @NotNull Iterable<String> defaultCompilerOptions) {
            Intrinsics.checkNotNullParameter((Object)baseHostConfiguration, (String)"baseHostConfiguration");
            Intrinsics.checkNotNullParameter(template, (String)"template");
            Intrinsics.checkNotNullParameter(contextClass, (String)"contextClass");
            Intrinsics.checkNotNullParameter(defaultCompilerOptions, (String)"defaultCompilerOptions");
            super(baseHostConfiguration, ConfigurationFromTemplateKt.createScriptDefinitionFromTemplate$default(new KotlinType(template, false, 2, null), baseHostConfiguration, contextClass, null, null, 24, null), defaultCompilerOptions);
        }

        public /* synthetic */ FromTemplate(ScriptingHostConfiguration scriptingHostConfiguration, KClass kClass, KClass kClass2, Iterable iterable, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 4) != 0) {
                kClass2 = Reflection.getOrCreateKotlinClass(ScriptCompilationConfiguration.class);
            }
            if ((n & 8) != 0) {
                iterable = CollectionsKt.emptyList();
            }
            this(scriptingHostConfiguration, kClass, kClass2, iterable);
        }
    }
}

