/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.diagnostic;

import com.intellij.openapi.diagnostic.Attachment;
import com.intellij.openapi.diagnostic.ExceptionWithAttachments;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ExceptionUtil;
import com.intellij.util.Function;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.Nullable;

public class DefaultLogger
extends Logger {
    public DefaultLogger(String category) {
    }

    @Override
    public boolean isDebugEnabled() {
        return false;
    }

    @Override
    public void debug(String message) {
    }

    @Override
    public void debug(Throwable t) {
    }

    @Override
    public void info(String message) {
    }

    @Override
    public void info(String message, Throwable t) {
    }

    @Override
    public void warn(@NonNls String message, @Nullable Throwable t) {
        t = DefaultLogger.checkException((Throwable)t);
        System.err.println("WARN: " + message);
        if (t != null) {
            t.printStackTrace(System.err);
        }
    }

    @Override
    public void error(String message, @Nullable Throwable t, String ... details) {
        if (details == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "details", "com/intellij/openapi/diagnostic/DefaultLogger", "error"));
        }
        t = DefaultLogger.checkException((Throwable)t);
        message = message + DefaultLogger.attachmentsToString(t);
        System.err.println("ERROR: " + message);
        if (t != null) {
            t.printStackTrace(System.err);
        }
        if (details.length > 0) {
            System.out.println("details: ");
            for (String detail : details) {
                System.out.println(detail);
            }
        }
        AssertionError error = new AssertionError((Object)message);
        ((Throwable)((Object)error)).initCause(t);
        throw error;
    }

    public static String attachmentsToString(@Nullable Throwable t) {
        Throwable rootCause;
        Throwable throwable = rootCause = t == null ? null : ExceptionUtil.getRootCause(t);
        if (rootCause instanceof ExceptionWithAttachments) {
            return "\nAttachments:" + StringUtil.join(((ExceptionWithAttachments)((Object)rootCause)).getAttachments(), new Function<Attachment, String>(){

                @Override
                public String fun(Attachment attachment) {
                    return attachment.getPath() + "\n" + attachment.getDisplayText();
                }
            }, "\n----\n");
        }
        return "";
    }
}

