/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util;

import com.intellij.util.ArrayFactory;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.text.CharArrayCharSequence;
import java.io.File;
import java.lang.reflect.Array;
import java.util.Collection;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ArrayUtil
extends ArrayUtilRt {
    public static final short[] EMPTY_SHORT_ARRAY = ArrayUtilRt.EMPTY_SHORT_ARRAY;
    public static final char[] EMPTY_CHAR_ARRAY = ArrayUtilRt.EMPTY_CHAR_ARRAY;
    public static final byte[] EMPTY_BYTE_ARRAY = ArrayUtilRt.EMPTY_BYTE_ARRAY;
    public static final int[] EMPTY_INT_ARRAY = ArrayUtilRt.EMPTY_INT_ARRAY;
    public static final boolean[] EMPTY_BOOLEAN_ARRAY = ArrayUtilRt.EMPTY_BOOLEAN_ARRAY;
    public static final Object[] EMPTY_OBJECT_ARRAY = ArrayUtilRt.EMPTY_OBJECT_ARRAY;
    public static final String[] EMPTY_STRING_ARRAY = ArrayUtilRt.EMPTY_STRING_ARRAY;
    public static final Class[] EMPTY_CLASS_ARRAY = ArrayUtilRt.EMPTY_CLASS_ARRAY;
    public static final long[] EMPTY_LONG_ARRAY = ArrayUtilRt.EMPTY_LONG_ARRAY;
    public static final Collection[] EMPTY_COLLECTION_ARRAY = ArrayUtilRt.EMPTY_COLLECTION_ARRAY;
    public static final File[] EMPTY_FILE_ARRAY = ArrayUtilRt.EMPTY_FILE_ARRAY;
    public static final Runnable[] EMPTY_RUNNABLE_ARRAY = ArrayUtilRt.EMPTY_RUNNABLE_ARRAY;
    public static final CharSequence EMPTY_CHAR_SEQUENCE = new CharArrayCharSequence(EMPTY_CHAR_ARRAY);
    public static final ArrayFactory<String> STRING_ARRAY_FACTORY = new ArrayFactory<String>(){

        @NotNull
        public String[] create(int count) {
            String[] stringArray = ArrayUtil.newStringArray((int)count);
            if (stringArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/ArrayUtil$1", "create"));
            }
            return stringArray;
        }
    };
    public static final ArrayFactory<Object> OBJECT_ARRAY_FACTORY = new ArrayFactory<Object>(){

        @Override
        @NotNull
        public Object[] create(int count) {
            Object[] objectArray = ArrayUtil.newObjectArray(count);
            if (objectArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/ArrayUtil$2", "create"));
            }
            return objectArray;
        }
    };

    @NotNull
    @Contract(pure=true)
    public static int[] realloc(@NotNull int[] array, int newSize) {
        if (array == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "array", "com/intellij/util/ArrayUtil", "realloc"));
        }
        if (newSize == 0) {
            if (EMPTY_INT_ARRAY == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/ArrayUtil", "realloc"));
            }
            return EMPTY_INT_ARRAY;
        }
        int oldSize = array.length;
        if (oldSize == newSize) {
            if (array == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/ArrayUtil", "realloc"));
            }
            return array;
        }
        int[] result = new int[newSize];
        System.arraycopy(array, 0, result, 0, Math.min(oldSize, newSize));
        if (result == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/ArrayUtil", "realloc"));
        }
        return result;
    }

    @NotNull
    @Contract(pure=true)
    public static <T> T[] realloc(@NotNull T[] array, int newSize, @NotNull ArrayFactory<T> factory) {
        if (array == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "array", "com/intellij/util/ArrayUtil", "realloc"));
        }
        if (factory == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "factory", "com/intellij/util/ArrayUtil", "realloc"));
        }
        int oldSize = array.length;
        if (oldSize == newSize) {
            if (array == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/ArrayUtil", "realloc"));
            }
            return array;
        }
        T[] result = factory.create(newSize);
        if (newSize == 0) {
            if (result == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/ArrayUtil", "realloc"));
            }
            return result;
        }
        System.arraycopy(array, 0, result, 0, Math.min(oldSize, newSize));
        if (result == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/ArrayUtil", "realloc"));
        }
        return result;
    }

    @NotNull
    @Contract(pure=true)
    public static int[] append(@NotNull int[] array, int value) {
        if (array == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "array", "com/intellij/util/ArrayUtil", "append"));
        }
        array = ArrayUtil.realloc(array, array.length + 1);
        array[array.length - 1] = value;
        if (array == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/ArrayUtil", "append"));
        }
        return array;
    }

    @NotNull
    @Contract(pure=true)
    public static <T> T[] toObjectArray(@NotNull Collection<T> collection, @NotNull Class<T> aClass) {
        if (collection == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "collection", "com/intellij/util/ArrayUtil", "toObjectArray"));
        }
        if (aClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aClass", "com/intellij/util/ArrayUtil", "toObjectArray"));
        }
        Object[] array = (Object[])Array.newInstance(aClass, collection.size());
        Object[] objectArray = collection.toArray(array);
        if (objectArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/ArrayUtil", "toObjectArray"));
        }
        return objectArray;
    }

    @NotNull
    @Contract(pure=true)
    public static <T> T[] append(@NotNull T[] src, @Nullable T element) {
        if (src == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "src", "com/intellij/util/ArrayUtil", "append"));
        }
        T[] TArray = ArrayUtil.append(src, element, src.getClass().getComponentType());
        if (TArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/ArrayUtil", "append"));
        }
        return TArray;
    }

    @NotNull
    @Contract(pure=true)
    public static <T> T[] prepend(T element, @NotNull T[] array) {
        if (array == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "array", "com/intellij/util/ArrayUtil", "prepend"));
        }
        T[] TArray = ArrayUtil.prepend(element, array, array.getClass().getComponentType());
        if (TArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/ArrayUtil", "prepend"));
        }
        return TArray;
    }

    @NotNull
    @Contract(pure=true)
    public static <T> T[] prepend(T element, @NotNull T[] array, @NotNull Class<T> type) {
        if (array == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "array", "com/intellij/util/ArrayUtil", "prepend"));
        }
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/util/ArrayUtil", "prepend"));
        }
        int length = array.length;
        Object[] result = (Object[])Array.newInstance(type, length + 1);
        System.arraycopy(array, 0, result, 1, length);
        result[0] = element;
        if (result == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/ArrayUtil", "prepend"));
        }
        return result;
    }

    @NotNull
    @Contract(pure=true)
    public static <T> T[] append(@NotNull T[] src, T element, @NotNull ArrayFactory<T> factory) {
        if (src == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "src", "com/intellij/util/ArrayUtil", "append"));
        }
        if (factory == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "factory", "com/intellij/util/ArrayUtil", "append"));
        }
        int length = src.length;
        T[] result = factory.create(length + 1);
        System.arraycopy(src, 0, result, 0, length);
        result[length] = element;
        if (result == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/ArrayUtil", "append"));
        }
        return result;
    }

    @NotNull
    @Contract(pure=true)
    public static <T> T[] append(@NotNull T[] src, @Nullable T element, @NotNull Class<T> componentType) {
        if (src == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "src", "com/intellij/util/ArrayUtil", "append"));
        }
        if (componentType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "componentType", "com/intellij/util/ArrayUtil", "append"));
        }
        int length = src.length;
        Object[] result = (Object[])Array.newInstance(componentType, length + 1);
        System.arraycopy(src, 0, result, 0, length);
        result[length] = element;
        if (result == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/ArrayUtil", "append"));
        }
        return result;
    }

    @NotNull
    @Contract(pure=true)
    public static <T> T[] remove(@NotNull T[] src, int idx) {
        if (src == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "src", "com/intellij/util/ArrayUtil", "remove"));
        }
        int length = src.length;
        if (idx < 0 || idx >= length) {
            throw new IllegalArgumentException("invalid index: " + idx);
        }
        Object[] result = (Object[])Array.newInstance(src.getClass().getComponentType(), length - 1);
        System.arraycopy(src, 0, result, 0, idx);
        System.arraycopy(src, idx + 1, result, idx, length - idx - 1);
        if (result == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/ArrayUtil", "remove"));
        }
        return result;
    }

    @NotNull
    @Contract(pure=true)
    public static <T> T[] remove(@NotNull T[] src, int idx, @NotNull ArrayFactory<T> factory) {
        if (src == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "src", "com/intellij/util/ArrayUtil", "remove"));
        }
        if (factory == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "factory", "com/intellij/util/ArrayUtil", "remove"));
        }
        int length = src.length;
        if (idx < 0 || idx >= length) {
            throw new IllegalArgumentException("invalid index: " + idx);
        }
        T[] result = factory.create(length - 1);
        System.arraycopy(src, 0, result, 0, idx);
        System.arraycopy(src, idx + 1, result, idx, length - idx - 1);
        if (result == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/ArrayUtil", "remove"));
        }
        return result;
    }

    @NotNull
    @Contract(pure=true)
    public static int[] remove(@NotNull int[] src, int idx) {
        if (src == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "src", "com/intellij/util/ArrayUtil", "remove"));
        }
        int length = src.length;
        if (idx < 0 || idx >= length) {
            throw new IllegalArgumentException("invalid index: " + idx);
        }
        int[] result = ArrayUtil.newIntArray(src.length - 1);
        System.arraycopy(src, 0, result, 0, idx);
        System.arraycopy(src, idx + 1, result, idx, length - idx - 1);
        if (result == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/ArrayUtil", "remove"));
        }
        return result;
    }

    @Contract(pure=true)
    public static int indexOf(@NotNull int[] ints, int value) {
        if (ints == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ints", "com/intellij/util/ArrayUtil", "indexOf"));
        }
        for (int i = 0; i < ints.length; ++i) {
            if (ints[i] != value) continue;
            return i;
        }
        return -1;
    }

    @Contract(pure=true)
    public static boolean contains(@Nullable String s, String ... strings) {
        if (strings == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "strings", "com/intellij/util/ArrayUtil", "contains"));
        }
        if (s == null) {
            for (String str : strings) {
                if (str != null) continue;
                return true;
            }
        } else {
            for (String str : strings) {
                if (!s.equals(str)) continue;
                return true;
            }
        }
        return false;
    }

    @NotNull
    @Contract(pure=true)
    public static int[] newIntArray(int count) {
        int[] nArray = count == 0 ? EMPTY_INT_ARRAY : new int[count];
        if (nArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/ArrayUtil", "newIntArray"));
        }
        return nArray;
    }

    @NotNull
    @Contract(pure=true)
    public static Object[] newObjectArray(int count) {
        Object[] objectArray = count == 0 ? EMPTY_OBJECT_ARRAY : new Object[count];
        if (objectArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/ArrayUtil", "newObjectArray"));
        }
        return objectArray;
    }

    @NotNull
    @Contract(pure=true)
    public static <E> E[] ensureExactSize(int count, @NotNull E[] sample) {
        if (sample == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sample", "com/intellij/util/ArrayUtil", "ensureExactSize"));
        }
        if (count == sample.length) {
            if (sample == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/ArrayUtil", "ensureExactSize"));
            }
            return sample;
        }
        Object[] array = (Object[])Array.newInstance(sample.getClass().getComponentType(), count);
        if (array == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/ArrayUtil", "ensureExactSize"));
        }
        return array;
    }
}

