/*
 * Decompiled with CFR 0.152.
 */
package lombok.ast;

import java.util.ArrayList;
import java.util.List;
import lombok.ast.AbstractNode;
import lombok.ast.AstException;
import lombok.ast.AstVisitor;
import lombok.ast.Block;
import lombok.ast.DescribedNode;
import lombok.ast.Identifier;
import lombok.ast.LabelledStatementTemplate;
import lombok.ast.Node;
import lombok.ast.Statement;

public class LabelledStatement
extends AbstractNode
implements Statement,
DescribedNode {
    private AbstractNode label = this.adopt(new Identifier());
    private AbstractNode statement = null;

    @Override
    public Block upToBlock() {
        if (!(this.getParent() instanceof Block)) {
            return null;
        }
        Block out = (Block)this.getParent();
        if (!out.rawContents().contains(this)) {
            return null;
        }
        return out;
    }

    public Identifier astLabel() {
        if (!(this.label instanceof Identifier)) {
            return null;
        }
        return (Identifier)this.label;
    }

    public LabelledStatement astLabel(Identifier label) {
        return this.rawLabel(label);
    }

    private LabelledStatement rawLabel(Node label) {
        if (label == this.label) {
            return this;
        }
        if (label != null) {
            this.adopt((AbstractNode)label);
        }
        if (this.label != null) {
            this.disown(this.label);
        }
        this.label = (AbstractNode)label;
        return this;
    }

    public Statement astStatement() {
        if (!(this.statement instanceof Statement)) {
            return null;
        }
        return (Statement)((Object)this.statement);
    }

    public LabelledStatement astStatement(Statement statement) {
        if (statement == null) {
            throw new NullPointerException("statement is mandatory");
        }
        return this.rawStatement(statement);
    }

    public Node rawStatement() {
        return this.statement;
    }

    public LabelledStatement rawStatement(Node statement) {
        if (statement == this.statement) {
            return this;
        }
        if (statement != null) {
            this.adopt((AbstractNode)statement);
        }
        if (this.statement != null) {
            this.disown(this.statement);
        }
        this.statement = (AbstractNode)statement;
        return this;
    }

    @Override
    public List<Node> getChildren() {
        ArrayList<Node> result = new ArrayList<Node>();
        if (this.label != null) {
            result.add(this.label);
        }
        if (this.statement != null) {
            result.add(this.statement);
        }
        return result;
    }

    @Override
    public boolean replaceChild(Node original, Node replacement) throws AstException {
        if (this.label == original) {
            if (replacement instanceof Identifier) {
                this.astLabel((Identifier)replacement);
                return true;
            }
            throw new AstException(this, String.format("Cannot replace node: replacement must be of type %s but is of type %s", "Identifier", replacement == null ? "null" : replacement.getClass().getName()));
        }
        if (this.statement == original) {
            this.rawStatement(replacement);
            return true;
        }
        return false;
    }

    @Override
    public boolean detach(Node child) {
        if (this.label == child) {
            this.disown((AbstractNode)child);
            this.label = null;
            return true;
        }
        if (this.statement == child) {
            this.disown((AbstractNode)child);
            this.statement = null;
            return true;
        }
        return false;
    }

    @Override
    public void accept(AstVisitor visitor) {
        if (visitor.visitLabelledStatement(this)) {
            return;
        }
        if (this.label != null) {
            this.label.accept(visitor);
        }
        if (this.statement != null) {
            this.statement.accept(visitor);
        }
        visitor.afterVisitLabelledStatement(this);
        visitor.endVisit(this);
    }

    @Override
    public LabelledStatement copy() {
        LabelledStatement result = new LabelledStatement();
        if (this.label != null) {
            result.rawLabel(this.label.copy());
        }
        if (this.statement != null) {
            result.rawStatement(this.statement.copy());
        }
        return result;
    }

    @Override
    public String getDescription() {
        return LabelledStatementTemplate.getDescription(this);
    }
}

