/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.common.rendering.api;

import com.google.common.base.Strings;
import java.io.Serializable;
import java.util.Objects;

public class ResourceNamespace
implements Comparable<ResourceNamespace>,
Serializable {
    public static final ResourceNamespace ANDROID = new ResourceNamespace("http://schemas.android.com/apk/res/android", "android");
    public static final ResourceNamespace RES_AUTO = new ResAutoNamespace();
    public static final ResourceNamespace TOOLS = new ToolsNamespace();
    public static final ResourceNamespace TODO = RES_AUTO;
    private final String uri;
    private final String packageName;

    public static ResourceNamespace fromPackageName(String packageName) {
        assert (!Strings.isNullOrEmpty((String)packageName));
        if (packageName.equals("android")) {
            return ANDROID;
        }
        return new ResourceNamespace("http://schemas.android.com/apk/res/" + packageName, packageName);
    }

    @Deprecated
    public static ResourceNamespace fromBoolean(boolean isFramework) {
        return isFramework ? ANDROID : TODO;
    }

    public static ResourceNamespace fromNamespacePrefix(String prefix, ResourceNamespace defaultNamespace, Resolver resolver) {
        if (Strings.isNullOrEmpty((String)prefix)) {
            return defaultNamespace;
        }
        String uri = resolver.prefixToUri(prefix);
        if (uri != null) {
            String packageName;
            if (uri.equals("http://schemas.android.com/apk/res-auto")) {
                return RES_AUTO;
            }
            if (uri.equals("http://schemas.android.com/tools")) {
                return TOOLS;
            }
            if (uri.startsWith("http://schemas.android.com/apk/res/") && !(packageName = uri.substring("http://schemas.android.com/apk/res/".length())).isEmpty()) {
                return new ResourceNamespace("http://schemas.android.com/apk/res/" + packageName, packageName);
            }
            return null;
        }
        return ResourceNamespace.fromPackageName(prefix);
    }

    private ResourceNamespace(String uri, String packageName) {
        this.uri = uri;
        this.packageName = packageName;
    }

    public String getPackageName() {
        return this.packageName;
    }

    public String getXmlNamespaceUri() {
        return this.uri;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ResourceNamespace that = (ResourceNamespace)o;
        return Objects.equals(this.packageName, that.packageName);
    }

    public int hashCode() {
        return this.uri.hashCode();
    }

    public String toString() {
        return this.uri.substring("http://schemas.android.com/".length());
    }

    @Override
    public int compareTo(ResourceNamespace other) {
        return this.uri.compareTo(other.uri);
    }

    private static class ToolsNamespace
    extends ResourceNamespace {
        private ToolsNamespace() {
            super("http://schemas.android.com/tools", null);
        }
    }

    private static class ResAutoNamespace
    extends ResourceNamespace {
        private ResAutoNamespace() {
            super("http://schemas.android.com/apk/res-auto", null);
        }
    }

    @FunctionalInterface
    public static interface Resolver {
        public static final Resolver EMPTY_RESOLVER = prefix -> null;

        public String prefixToUri(String var1);
    }
}

