/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.common.rendering.api;

import com.android.ide.common.rendering.api.ResourceNamespace;
import com.android.resources.ResourceType;
import com.android.resources.ResourceUrl;
import com.google.common.base.MoreObjects;
import java.io.Serializable;

public class ResourceReference
implements Serializable {
    private final ResourceType mResourceType;
    private final ResourceNamespace mNamespace;
    private final String mName;

    public ResourceReference(ResourceNamespace namespace, ResourceType resourceType, String name) {
        this.mNamespace = namespace;
        this.mResourceType = resourceType;
        this.mName = name;
    }

    @Deprecated
    public ResourceReference(String name, boolean isFramework) {
        this(ResourceNamespace.fromBoolean(isFramework), ResourceType.LAYOUT, name);
    }

    @Deprecated
    public ResourceReference(ResourceType type, String name, boolean isFramework) {
        this(ResourceNamespace.fromBoolean(isFramework), type, name);
    }

    public final String getName() {
        return this.mName;
    }

    public ResourceType getResourceType() {
        return this.mResourceType;
    }

    public ResourceNamespace getNamespace() {
        return this.mNamespace;
    }

    @Deprecated
    public final boolean isFramework() {
        return this.mNamespace == ResourceNamespace.ANDROID;
    }

    public ResourceUrl getResourceUrl() {
        return ResourceUrl.create(this.mNamespace.getPackageName(), this.mResourceType, this.mName);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ResourceReference reference = (ResourceReference)o;
        if (this.mResourceType != reference.mResourceType) {
            return false;
        }
        if (!this.mNamespace.equals(reference.mNamespace)) {
            return false;
        }
        return this.mName.equals(reference.mName);
    }

    public int hashCode() {
        int result = this.mResourceType.hashCode();
        result = 31 * result + this.mNamespace.hashCode();
        result = 31 * result + this.mName.hashCode();
        return result;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("namespace", (Object)this.mNamespace).add("type", (Object)this.mResourceType).add("name", (Object)this.mName).toString();
    }
}

