/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.common.rendering.api;

import com.android.ide.common.rendering.api.ResourceNamespace;
import com.android.ide.common.rendering.api.ResourceReference;
import com.android.resources.ResourceType;
import com.android.resources.ResourceUrl;
import com.google.common.base.MoreObjects;
import java.util.Objects;

public class ResourceValue
extends ResourceReference {
    private final String mLibraryName;
    protected String mValue;
    protected ResourceNamespace.Resolver mNamespaceResolver = ResourceNamespace.Resolver.EMPTY_RESOLVER;

    @Deprecated
    public ResourceValue(ResourceType type, String name, String value, boolean isFramework) {
        this(ResourceNamespace.fromBoolean(isFramework), type, name, value);
    }

    public ResourceValue(ResourceReference reference, String value, String libraryName) {
        this(reference.getNamespace(), reference.getResourceType(), reference.getName(), value, libraryName);
    }

    public ResourceValue(ResourceReference reference, String value) {
        this(reference, value, null);
    }

    public ResourceValue(ResourceNamespace namespace, ResourceType type, String name, String value) {
        this(namespace, type, name, value, null);
    }

    public ResourceValue(ResourceNamespace namespace, ResourceType type, String name, String value, String libraryName) {
        super(namespace, type, name);
        this.mValue = value;
        this.mLibraryName = libraryName;
    }

    public String getLibraryName() {
        return this.mLibraryName;
    }

    public boolean isUserDefined() {
        return !this.isFramework() && this.mLibraryName == null;
    }

    public String getValue() {
        return this.mValue;
    }

    public ResourceReference getReference() {
        if (this.mValue == null) {
            return null;
        }
        ResourceUrl url = ResourceUrl.parse(this.mValue);
        if (url == null) {
            return null;
        }
        return url.resolve(this.getNamespace(), this.mNamespaceResolver);
    }

    public String getRawXmlValue() {
        return this.getValue();
    }

    public void setValue(String value) {
        this.mValue = value;
    }

    public void replaceWith(ResourceValue value) {
        this.mValue = value.mValue;
    }

    public void setNamespaceLookup(ResourceNamespace.Resolver resolver) {
        this.mNamespaceResolver = resolver;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ResourceValue that = (ResourceValue)o;
        return Objects.equals(this.mLibraryName, that.mLibraryName) && Objects.equals(this.mValue, that.mValue);
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + Objects.hashCode(this.mLibraryName);
        result = 31 * result + Objects.hashCode(this.mValue);
        return result;
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("namespace", (Object)this.getNamespace()).add("type", (Object)this.getResourceType()).add("name", (Object)this.getName()).add("value", (Object)this.mValue).toString();
    }
}

