/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.common.rendering.api;

import com.android.ide.common.rendering.api.ItemResourceValue;
import com.android.ide.common.rendering.api.ResourceNamespace;
import com.android.ide.common.rendering.api.ResourceReference;
import com.android.ide.common.rendering.api.ResourceValue;
import com.android.resources.ResourceType;
import com.android.resources.ResourceUrl;
import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Table;
import java.util.Collection;

public final class StyleResourceValue
extends ResourceValue {
    private String mParentStyle;
    private final Table<ResourceNamespace, String, ItemResourceValue> mItems = HashBasedTable.create();

    public StyleResourceValue(ResourceReference reference, String parentStyle, String libraryName) {
        super(reference, null, libraryName);
        assert (reference.getResourceType() == ResourceType.STYLE);
        this.mParentStyle = parentStyle;
    }

    public String getParentStyleName() {
        return this.mParentStyle;
    }

    public ResourceReference getParentStyle() {
        if (this.mParentStyle != null) {
            ResourceUrl url = ResourceUrl.parseStyleParentReference(this.mParentStyle);
            if (url == null) {
                return null;
            }
            return url.resolve(this.getNamespace(), this.mNamespaceResolver);
        }
        int lastDot = this.getName().lastIndexOf(46);
        if (lastDot != -1) {
            String parent = this.getName().substring(0, lastDot);
            if (parent.isEmpty()) {
                return null;
            }
            return new ResourceReference(this.getNamespace(), ResourceType.STYLE, parent);
        }
        return null;
    }

    public ItemResourceValue getItem(ResourceNamespace namespace, String name) {
        return (ItemResourceValue)this.mItems.get((Object)namespace, (Object)name);
    }

    public ItemResourceValue getItem(ResourceReference attr) {
        assert (attr.getResourceType() == ResourceType.ATTR);
        return (ItemResourceValue)this.mItems.get((Object)attr.getNamespace(), (Object)attr.getName());
    }

    public void addItem(ItemResourceValue item) {
        ResourceReference attr = item.getAttr();
        if (attr == null) {
            return;
        }
        this.mItems.put((Object)attr.getNamespace(), (Object)attr.getName(), (Object)item);
    }

    @Override
    public void replaceWith(ResourceValue style) {
        assert (style instanceof StyleResourceValue) : style.getClass() + " is not StyleResourceValue";
        super.replaceWith(style);
        if (style instanceof StyleResourceValue) {
            this.mItems.clear();
            this.mItems.putAll(((StyleResourceValue)style).mItems);
        }
    }

    public Collection<ItemResourceValue> getDefinedItems() {
        return this.mItems.values();
    }
}

