/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.common.rendering.api;

import com.android.ide.common.rendering.api.ResourceNamespace;
import com.android.ide.common.rendering.api.ResourceReference;
import com.android.ide.common.rendering.api.ResourceValue;
import com.android.resources.ResourceType;
import com.android.resources.ResourceUrl;
import com.google.common.base.MoreObjects;
import org.jetbrains.annotations.Nullable;

public class ItemResourceValue
extends ResourceValue {
    private final String attributeName;

    public ItemResourceValue(ResourceNamespace namespace, String attributeName, @Nullable String value, @Nullable String libraryName) {
        super(namespace, ResourceType.STYLE_ITEM, "<item>", value, libraryName);
        this.attributeName = attributeName;
    }

    public String getAttrName() {
        return this.attributeName;
    }

    @Nullable
    public ResourceReference getAttr() {
        ResourceUrl url = ResourceUrl.parseAttrReference(this.attributeName);
        if (url == null) {
            return null;
        }
        return url.resolve(this.getNamespace(), this.mNamespaceResolver);
    }

    @Override
    @Deprecated
    public String getName() {
        ResourceUrl url = ResourceUrl.parseAttrReference(this.attributeName);
        if (url != null) {
            return url.name;
        }
        return this.attributeName;
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("namespace", (Object)this.getNamespace()).add("attribute", (Object)this.attributeName).add("value", (Object)this.getValue()).toString();
    }
}

