/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.common.rendering.api;

import com.android.ide.common.rendering.api.ResourceNamespace;
import com.android.ide.common.rendering.api.ResourceReference;
import com.android.ide.common.rendering.api.ResourceValueTemp;
import com.android.resources.ResourceType;
import com.android.resources.ResourceUrl;
import com.android.utils.HashCodes;
import com.google.common.base.MoreObjects;
import java.util.Objects;

public class ResourceValue
implements ResourceValueTemp {
    private final ResourceType resourceType;
    private final ResourceNamespace namespace;
    private final String name;
    private final String libraryName;
    private String value;
    protected ResourceNamespace.Resolver mNamespaceResolver = ResourceNamespace.Resolver.EMPTY_RESOLVER;

    @Deprecated
    public ResourceValue(ResourceType type, String name, String value, boolean isFramework) {
        this(ResourceNamespace.fromBoolean(isFramework), type, name, value);
    }

    public ResourceValue(ResourceReference reference, String value, String libraryName) {
        this(reference.getNamespace(), reference.getResourceType(), reference.getName(), value, libraryName);
    }

    public ResourceValue(ResourceReference reference, String value) {
        this(reference, value, null);
    }

    public ResourceValue(ResourceNamespace namespace, ResourceType type, String name, String value) {
        this(namespace, type, name, value, null);
    }

    public ResourceValue(ResourceNamespace namespace, ResourceType type, String name, String value, String libraryName) {
        this.namespace = namespace;
        this.resourceType = type;
        this.name = name;
        this.value = value;
        this.libraryName = libraryName;
    }

    @Override
    public ResourceType getResourceType() {
        return this.resourceType;
    }

    @Override
    public ResourceNamespace getNamespace() {
        return this.namespace;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getLibraryName() {
        return this.libraryName;
    }

    @Override
    public boolean isUserDefined() {
        return !this.isFramework() && this.libraryName == null;
    }

    @Override
    public boolean isFramework() {
        return this.namespace == ResourceNamespace.ANDROID;
    }

    @Override
    public String getValue() {
        return this.value;
    }

    @Override
    public ResourceReference asReference() {
        return new ResourceReference(this.namespace, this.resourceType, this.name);
    }

    @Override
    public ResourceUrl getResourceUrl() {
        return this.asReference().getResourceUrl();
    }

    @Override
    public ResourceReference getReference() {
        if (this.value == null) {
            return null;
        }
        ResourceUrl url = ResourceUrl.parse(this.value);
        if (url == null) {
            return null;
        }
        return url.resolve(this.getNamespace(), this.mNamespaceResolver);
    }

    @Override
    public String getRawXmlValue() {
        return this.getValue();
    }

    @Override
    public void setValue(String value) {
        this.value = value;
    }

    @Override
    public void replaceWith(ResourceValue value) {
        this.value = value.value;
    }

    @Override
    public ResourceNamespace.Resolver getNamespaceResolver() {
        return this.mNamespaceResolver;
    }

    @Override
    public void setNamespaceResolver(ResourceNamespace.Resolver resolver) {
        this.mNamespaceResolver = resolver;
    }

    @Override
    @Deprecated
    public void setNamespaceLookup(final ResourceNamespace.Resolver resolver) {
        this.setNamespaceResolver(new ResourceNamespace.Resolver(){

            @Override
            public String uriToPrefix(String namespaceUri) {
                return null;
            }

            @Override
            public String prefixToUri(String namespacePrefix) {
                return resolver.prefixToUri(namespacePrefix);
            }
        });
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ResourceValue that = (ResourceValue)o;
        return this.resourceType == that.resourceType && Objects.equals(this.namespace, that.namespace) && Objects.equals(this.name, that.name) && Objects.equals(this.libraryName, that.libraryName) && Objects.equals(this.value, that.value);
    }

    public int hashCode() {
        return HashCodes.mix((int)this.resourceType.hashCode(), (int)this.namespace.hashCode(), (int)this.name.hashCode(), (int)Objects.hashCode(this.libraryName), (int)Objects.hashCode(this.value));
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("namespace", (Object)this.getNamespace()).add("type", (Object)this.getResourceType()).add("name", (Object)this.getName()).add("value", (Object)this.getValue()).toString();
    }
}

