/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.common.rendering.api;

import com.android.ide.common.rendering.api.ResourceNamespace;
import com.android.ide.common.rendering.api.ResourceReference;
import com.android.ide.common.rendering.api.ResourceValueImpl;
import com.android.resources.ResourceType;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class ArrayResourceValue
extends ResourceValueImpl
implements Iterable<String> {
    private final List<String> mItems = new ArrayList<String>();

    public ArrayResourceValue(ResourceReference reference, String libraryName) {
        super(reference, null, libraryName);
        assert (reference.getResourceType() == ResourceType.ARRAY);
    }

    public ArrayResourceValue(ResourceNamespace namespace, ResourceType type, String name, String libraryName) {
        super(namespace, type, name, null, libraryName);
        assert (type == ResourceType.ARRAY);
    }

    public void addElement(String value) {
        this.mItems.add(value);
    }

    public int getElementCount() {
        return this.mItems.size();
    }

    public String getElement(int index) {
        return this.mItems.get(index);
    }

    @Override
    public Iterator<String> iterator() {
        return this.mItems.iterator();
    }

    protected int getDefaultIndex() {
        return 0;
    }

    @Override
    public String getValue() {
        if (super.getValue() == null && !this.mItems.isEmpty()) {
            return this.mItems.get(this.getDefaultIndex());
        }
        return super.getValue();
    }
}

