/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.common.rendering.api;

import com.android.ide.common.rendering.api.ResourceNamespace;
import com.android.ide.common.rendering.api.ResourceReference;
import com.android.ide.common.rendering.api.ResourceValue;
import com.android.ide.common.rendering.api.ResourceValueImpl;
import com.android.ide.common.rendering.api.StyleItemResourceValue;
import com.android.ide.common.rendering.api.StyleItemResourceValueImpl;
import com.android.resources.ResourceType;
import com.android.resources.ResourceUrl;
import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Table;
import java.util.Collection;

public abstract class StyleResourceValue
extends ResourceValueImpl {
    private String mParentStyle;
    private final Table<ResourceNamespace, String, StyleItemResourceValue> mItems = HashBasedTable.create();

    public StyleResourceValue(ResourceReference reference, String parentStyle, String libraryName) {
        super(reference, null, libraryName);
        assert (reference.getResourceType() == ResourceType.STYLE);
        this.mParentStyle = parentStyle;
    }

    public StyleResourceValue(ResourceNamespace namespace, ResourceType type, String name, String parentStyle, String libraryName) {
        super(namespace, type, name, null, libraryName);
        assert (type == ResourceType.STYLE);
        this.mParentStyle = parentStyle;
    }

    public String getParentStyleName() {
        return this.mParentStyle;
    }

    public ResourceReference getParentStyle() {
        if (this.mParentStyle != null) {
            ResourceUrl url = ResourceUrl.parseStyleParentReference(this.mParentStyle);
            if (url == null) {
                return null;
            }
            return url.resolve(this.getNamespace(), this.mNamespaceResolver);
        }
        int lastDot = this.getName().lastIndexOf(46);
        if (lastDot != -1) {
            String parent = this.getName().substring(0, lastDot);
            if (parent.isEmpty()) {
                return null;
            }
            return ResourceReference.style(this.getNamespace(), parent);
        }
        return null;
    }

    public StyleItemResourceValueImpl getItem(ResourceNamespace namespace, String name) {
        return (StyleItemResourceValueImpl)this.mItems.get((Object)namespace, (Object)name);
    }

    public StyleItemResourceValueImpl getItem(ResourceReference attr) {
        assert (attr.getResourceType() == ResourceType.ATTR);
        return (StyleItemResourceValueImpl)this.mItems.get((Object)attr.getNamespace(), (Object)attr.getName());
    }

    public void addItem(StyleItemResourceValue item) {
        ResourceReference attr = item.getAttr();
        if (attr == null) {
            return;
        }
        this.mItems.put((Object)attr.getNamespace(), (Object)attr.getName(), (Object)item);
    }

    @Override
    public void replaceWith(ResourceValue style) {
        assert (style instanceof StyleResourceValue) : style.getClass() + " is not StyleResourceValue";
        super.replaceWith(style);
        if (style instanceof StyleResourceValue) {
            this.mItems.clear();
            this.mItems.putAll(((StyleResourceValue)style).mItems);
        }
    }

    public Collection<StyleItemResourceValue> getDefinedItems() {
        return this.mItems.values();
    }
}

