/*
 * Decompiled with CFR 0.152.
 */
package com.android.resources;

import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public enum ResourceType {
    ANIM("anim", "Animation", new String[0]),
    ANIMATOR("animator", "Animator", new String[0]),
    ARRAY("array", "Array", "string-array", "integer-array"),
    ATTR("attr", "Attr", new String[0]),
    BOOL("bool", "Boolean", new String[0]),
    COLOR("color", "Color", new String[0]),
    DECLARE_STYLEABLE("declare-styleable", "Declare Styleable", new String[0]),
    DIMEN("dimen", "Dimension", new String[0]),
    DRAWABLE("drawable", "Drawable", new String[0]),
    FONT("font", "Font", new String[0]),
    FRACTION("fraction", "Fraction", new String[0]),
    ID("id", "ID", new String[0]),
    INTEGER("integer", "Integer", new String[0]),
    INTERPOLATOR("interpolator", "Interpolator", new String[0]),
    LAYOUT("layout", "Layout", new String[0]),
    MENU("menu", "Menu", new String[0]),
    MIPMAP("mipmap", "Mip Map", new String[0]),
    NAVIGATION("navigation", "Navigation", new String[0]),
    PLURALS("plurals", "Plurals", new String[0]),
    RAW("raw", "Raw", new String[0]),
    STRING("string", "String", new String[0]),
    STYLE("style", "Style", new String[0]),
    STYLEABLE("styleable", "Styleable", new String[0]),
    TRANSITION("transition", "Transition", new String[0]),
    XML("xml", "XML", new String[0]),
    PUBLIC("public", "###", new String[0]),
    AAPT("_aapt", "Aapt Attribute", new String[0]),
    STYLE_ITEM("item", "Style Item", new String[0]),
    SAMPLE_DATA("sample", "Sample data", new String[0]);

    public static final Set<ResourceType> REFERENCEABLE_TYPES;
    private static final Map<String, ResourceType> sNameToType;
    private final String mName;
    private final String mDisplayName;
    private final String[] mAlternateXmlNames;

    private ResourceType(String name, String displayName, String ... alternateXmlNames) {
        this.mName = name;
        this.mDisplayName = displayName;
        this.mAlternateXmlNames = alternateXmlNames;
    }

    public String getName() {
        return this.mName;
    }

    public String getDisplayName() {
        return this.mDisplayName;
    }

    public static ResourceType getEnum(String name) {
        return sNameToType.get(name);
    }

    public String toString() {
        return this.getName();
    }

    static {
        ResourceType[] values = ResourceType.values();
        int size = 0;
        for (ResourceType type : values) {
            ++size;
            if (type.mAlternateXmlNames == null) continue;
            size += type.mAlternateXmlNames.length;
        }
        sNameToType = new HashMap<String, ResourceType>(2 * size);
        for (ResourceType type : values) {
            sNameToType.put(type.getName(), type);
            if (type.mAlternateXmlNames == null) continue;
            for (String alternateName : type.mAlternateXmlNames) {
                sNameToType.put(alternateName, type);
            }
        }
        EnumSet<ResourceType> referenceableTypes = EnumSet.allOf(ResourceType.class);
        referenceableTypes.remove((Object)ATTR);
        referenceableTypes.remove((Object)STYLEABLE);
        referenceableTypes.remove((Object)PUBLIC);
        referenceableTypes.remove((Object)AAPT);
        referenceableTypes.remove((Object)SAMPLE_DATA);
        REFERENCEABLE_TYPES = Collections.unmodifiableSet(referenceableTypes);
    }
}

