/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.common.rendering.api;

import com.android.ide.common.rendering.api.ResourceNamespace;
import com.android.ide.common.rendering.api.ResourceReference;
import com.android.ide.common.rendering.api.ResourceValue;
import com.android.ide.common.rendering.api.ResourceValueImpl;
import com.android.ide.common.rendering.api.StyleItemResourceValue;
import com.android.ide.common.rendering.api.StyleResourceValue;
import com.android.resources.ResourceType;
import com.android.resources.ResourceUrl;
import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Table;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;

public class StyleResourceValueImpl
extends ResourceValueImpl
implements StyleResourceValue {
    private String mParentStyle;
    private final Table<ResourceNamespace, String, StyleItemResourceValue> mItems = HashBasedTable.create();

    public StyleResourceValueImpl(ResourceReference reference, String parentStyle, String libraryName) {
        super(reference, null, libraryName);
        assert (reference.getResourceType() == ResourceType.STYLE);
        this.mParentStyle = parentStyle;
    }

    public StyleResourceValueImpl(ResourceNamespace namespace, ResourceType type, String name, String parentStyle, String libraryName) {
        super(namespace, type, name, null, libraryName);
        assert (type == ResourceType.STYLE);
        this.mParentStyle = parentStyle;
    }

    @Override
    public String getParentStyleName() {
        return this.mParentStyle;
    }

    @Override
    public ResourceReference getParentStyle() {
        if (this.mParentStyle != null) {
            ResourceUrl url = ResourceUrl.parseStyleParentReference(this.mParentStyle);
            if (url == null) {
                return null;
            }
            return url.resolve(this.getNamespace(), this.mNamespaceResolver);
        }
        int lastDot = this.getName().lastIndexOf(46);
        if (lastDot >= 0) {
            String parent = this.getName().substring(0, lastDot);
            if (parent.isEmpty()) {
                return null;
            }
            return ResourceReference.style(this.getNamespace(), parent);
        }
        return null;
    }

    @Override
    public StyleItemResourceValue getItem(ResourceNamespace namespace, String name) {
        return (StyleItemResourceValue)this.mItems.get((Object)namespace, (Object)name);
    }

    @Override
    public StyleItemResourceValue getItem(ResourceReference attr) {
        assert (attr.getResourceType() == ResourceType.ATTR);
        return (StyleItemResourceValue)this.mItems.get((Object)attr.getNamespace(), (Object)attr.getName());
    }

    @Override
    public void addItem(@NotNull StyleItemResourceValue item) {
        ResourceReference attr = item.getAttr();
        if (attr == null) {
            return;
        }
        this.mItems.put((Object)attr.getNamespace(), (Object)attr.getName(), (Object)item);
    }

    @Override
    public void replaceWith(ResourceValue style) {
        assert (style instanceof StyleResourceValueImpl) : style.getClass() + " is not StyleResourceValue";
        super.replaceWith(style);
        if (style instanceof StyleResourceValueImpl) {
            this.mItems.clear();
            this.mItems.putAll(((StyleResourceValueImpl)style).mItems);
        }
    }

    @Override
    @NotNull
    public Collection<StyleItemResourceValue> getDefinedItems() {
        return this.mItems.values();
    }
}

