/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.common.rendering.api;

import com.android.ide.common.rendering.api.ResourceNamespace;
import com.android.ide.common.rendering.api.ResourceReference;
import com.android.ide.common.rendering.api.ResourceValue;
import com.android.ide.common.rendering.api.StyleItemResourceValue;
import com.android.resources.ResourceUrl;
import java.util.Collection;

public interface StyleResourceValue
extends ResourceValue {
    public String getParentStyleName();

    default public ResourceReference getParentStyle() {
        String parentStyleName = this.getParentStyleName();
        if (parentStyleName != null) {
            ResourceUrl url = ResourceUrl.parseStyleParentReference(parentStyleName);
            if (url == null) {
                return null;
            }
            return url.resolve(this.getNamespace(), this.getNamespaceResolver());
        }
        String styleName = this.getName();
        int lastDot = styleName.lastIndexOf(46);
        if (lastDot >= 0) {
            String parent = styleName.substring(0, lastDot);
            if (parent.isEmpty()) {
                return null;
            }
            return ResourceReference.style(this.getNamespace(), parent);
        }
        return null;
    }

    public StyleItemResourceValue getItem(ResourceNamespace var1, String var2);

    public StyleItemResourceValue getItem(ResourceReference var1);

    public Collection<StyleItemResourceValue> getDefinedItems();
}

