/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.common.rendering.api;

import com.android.ide.common.rendering.api.AssetRepository;
import com.android.ide.common.rendering.api.HardwareConfig;
import com.android.ide.common.rendering.api.IImageFactory;
import com.android.ide.common.rendering.api.ILayoutLog;
import com.android.ide.common.rendering.api.LayoutlibCallback;
import com.android.ide.common.rendering.api.RenderResources;
import com.android.ide.common.rendering.api.ResourceValue;
import com.android.ide.common.rendering.api.SessionParams;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Callable;

public abstract class RenderParams {
    public static final long DEFAULT_TIMEOUT = 250L;
    private final Object mProjectKey;
    private HardwareConfig mHardwareConfig;
    private final RenderResources mRenderResources;
    private final LayoutlibCallback mLayoutlibCallback;
    private final int mMinSdkVersion;
    private final int mTargetSdkVersion;
    private int mUiMode = 0;
    private float mFontScale = 1.0f;
    private final ILayoutLog mLog;
    private boolean mSetTransparentBackground;
    private long mTimeout;
    private AssetRepository mAssetRepository;
    private IImageFactory mImageFactory;
    private ResourceValue mAppIcon;
    private String mAppLabel;
    private String mLocale;
    private String mActivityName;
    private boolean mForceNoDecor;
    private boolean mSupportsRtl;
    private Callable<Boolean> mLayoutValidationEnabledChecker = () -> false;
    private Map<SessionParams.Key, Object> mFlags;
    private boolean mEnableQuickStep;

    public RenderParams(Object projectKey, HardwareConfig hardwareConfig, RenderResources renderResources, LayoutlibCallback layoutlibCallback, int minSdkVersion, int targetSdkVersion, ILayoutLog log) {
        this.mProjectKey = projectKey;
        this.mHardwareConfig = hardwareConfig;
        this.mRenderResources = renderResources;
        this.mLayoutlibCallback = layoutlibCallback;
        this.mMinSdkVersion = minSdkVersion;
        this.mTargetSdkVersion = targetSdkVersion;
        this.mLog = log;
        this.mSetTransparentBackground = false;
        this.mTimeout = 250L;
    }

    public RenderParams(RenderParams params) {
        this.mProjectKey = params.mProjectKey;
        this.mHardwareConfig = params.mHardwareConfig;
        this.mRenderResources = params.mRenderResources;
        this.mAssetRepository = params.mAssetRepository;
        this.mLayoutlibCallback = params.mLayoutlibCallback;
        this.mMinSdkVersion = params.mMinSdkVersion;
        this.mTargetSdkVersion = params.mTargetSdkVersion;
        this.mUiMode = params.mUiMode;
        this.mLog = params.mLog;
        this.mSetTransparentBackground = params.mSetTransparentBackground;
        this.mTimeout = params.mTimeout;
        this.mImageFactory = params.mImageFactory;
        this.mAppIcon = params.mAppIcon;
        this.mAppLabel = params.mAppLabel;
        this.mLocale = params.mLocale;
        this.mActivityName = params.mActivityName;
        this.mForceNoDecor = params.mForceNoDecor;
        this.mSupportsRtl = params.mSupportsRtl;
        if (params.mFlags != null) {
            this.mFlags = new HashMap<SessionParams.Key, Object>(params.mFlags);
        }
        this.mEnableQuickStep = params.mEnableQuickStep;
        this.mFontScale = params.mFontScale;
        this.mLayoutValidationEnabledChecker = params.mLayoutValidationEnabledChecker;
    }

    public void setTransparentBackground() {
        this.mSetTransparentBackground = true;
    }

    public void setTimeout(long timeout) {
        this.mTimeout = timeout;
    }

    public void setImageFactory(IImageFactory imageFactory) {
        this.mImageFactory = imageFactory;
    }

    public void setLayoutValidationChecker(Callable<Boolean> checker) {
        this.mLayoutValidationEnabledChecker = checker;
    }

    public void setAppIcon(ResourceValue appIcon) {
        this.mAppIcon = appIcon;
    }

    public void setAppLabel(String appLabel) {
        this.mAppLabel = appLabel;
    }

    public void setLocale(String locale) {
        this.mLocale = locale;
    }

    public void setActivityName(String activityName) {
        this.mActivityName = activityName;
    }

    public void setForceNoDecor() {
        this.mForceNoDecor = true;
    }

    public void setRtlSupport(boolean supportsRtl) {
        this.mSupportsRtl = supportsRtl;
    }

    public void setAssetRepository(AssetRepository assetRepository) {
        this.mAssetRepository = assetRepository;
    }

    public void setQuickStep(boolean quickStep) {
        this.mEnableQuickStep = quickStep;
    }

    public void setFontScale(float fontScale) {
        this.mFontScale = fontScale;
    }

    public float getFontScale() {
        return this.mFontScale;
    }

    public void setUiMode(int uiMode) {
        this.mUiMode = uiMode;
    }

    public int getUiMode() {
        return this.mUiMode;
    }

    public Object getProjectKey() {
        return this.mProjectKey;
    }

    public HardwareConfig getHardwareConfig() {
        return this.mHardwareConfig;
    }

    public void setHardwareConfig(HardwareConfig hardware) {
        this.mHardwareConfig = hardware;
    }

    public int getMinSdkVersion() {
        return this.mMinSdkVersion;
    }

    public int getTargetSdkVersion() {
        return this.mTargetSdkVersion;
    }

    public RenderResources getResources() {
        return this.mRenderResources;
    }

    public AssetRepository getAssets() {
        return this.mAssetRepository;
    }

    public LayoutlibCallback getLayoutlibCallback() {
        return this.mLayoutlibCallback;
    }

    public ILayoutLog getLog() {
        return this.mLog;
    }

    public boolean isTransparentBackground() {
        return this.mSetTransparentBackground;
    }

    public long getTimeout() {
        return this.mTimeout;
    }

    public IImageFactory getImageFactory() {
        return this.mImageFactory;
    }

    public boolean isLayoutValidationEnabled() {
        try {
            return this.mLayoutValidationEnabledChecker.call();
        }
        catch (Exception e) {
            return false;
        }
    }

    public final ResourceValue getAppIcon() {
        return this.mAppIcon;
    }

    public final String getAppLabel() {
        return this.mAppLabel;
    }

    public final String getLocale() {
        return this.mLocale;
    }

    public final String getActivityName() {
        return this.mActivityName;
    }

    public final boolean isForceNoDecor() {
        return this.mForceNoDecor;
    }

    public final boolean isRtlSupported() {
        return this.mSupportsRtl;
    }

    public final boolean isQuickStepEnabled() {
        return this.mEnableQuickStep;
    }

    public <T> void setFlag(SessionParams.Key<T> key, T value) {
        if (this.mFlags == null) {
            this.mFlags = new HashMap<SessionParams.Key, Object>();
        }
        this.mFlags.put(key, value);
    }

    public <T> T getFlag(SessionParams.Key<T> key) {
        return (T)(this.mFlags == null ? null : this.mFlags.get(key));
    }
}

