/*
 * Copyright (C) 2011 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.android.tools.lint.detector.api;

import com.google.common.annotations.Beta;

/**
 * A simple offset-based position *
 * <p>
 * <b>NOTE: This is not a public or final API; if you rely on this be prepared
 * to adjust your code for the next tools release.</b>
 */
@Beta
public class DefaultPosition extends Position {
    /** The line number (0-based where the first line is line 0) */
    private final int line;

    /**
     * The column number (where the first character on the line is 0), or -1 if
     * unknown
     */
    private final int column;

    /** The character offset */
    private final int offset;

    /**
     * Creates a new {@link DefaultPosition}
     *
     * @param line the 0-based line number, or -1 if unknown
     * @param column the 0-based column number, or -1 if unknown
     * @param offset the offset, or -1 if unknown
     */
    public DefaultPosition(int line, int column, int offset) {
        this.line = line;
        this.column = column;
        this.offset = offset;
    }

    @Override
    public int getLine() {
        return line;
    }

    @Override
    public int getOffset() {
        return offset;
    }

    @Override
    public int getColumn() {
        return column;
    }
}
