/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.detector.api;

import com.android.tools.lint.client.api.JavaEvaluator;
import com.android.tools.lint.client.api.JavaParser;
import com.android.tools.lint.client.api.LintDriver;
import com.android.tools.lint.client.api.UastParser;
import com.android.tools.lint.detector.api.Context;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.LintFix;
import com.android.tools.lint.detector.api.Location;
import com.android.tools.lint.detector.api.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiCompiledElement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiEnumConstant;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiLabeledStatement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiSwitchStatement;
import java.io.File;
import java.util.Collections;
import java.util.Iterator;
import lombok.ast.AnnotationElement;
import lombok.ast.AnnotationMethodDeclaration;
import lombok.ast.ClassDeclaration;
import lombok.ast.ConstructorDeclaration;
import lombok.ast.ConstructorInvocation;
import lombok.ast.EnumConstant;
import lombok.ast.Expression;
import lombok.ast.LabelledStatement;
import lombok.ast.MethodDeclaration;
import lombok.ast.MethodInvocation;
import lombok.ast.Node;
import lombok.ast.Position;
import lombok.ast.TypeDeclaration;
import lombok.ast.VariableReference;
import org.jetbrains.uast.UCallExpression;
import org.jetbrains.uast.UClass;
import org.jetbrains.uast.UDeclaration;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UEnumConstant;
import org.jetbrains.uast.UField;
import org.jetbrains.uast.UFile;
import org.jetbrains.uast.UMethod;
import org.jetbrains.uast.UReferenceExpression;
import org.jetbrains.uast.USwitchExpression;
import org.jetbrains.uast.UastContext;
import org.jetbrains.uast.UastUtils;

public class JavaContext
extends Context {
    static final String SUPPRESS_COMMENT_PREFIX = "//noinspection ";
    @Deprecated
    private Node compilationUnit;
    private PsiFile psiFile;
    private UFile uastFile;
    private UastParser uastParser;
    private JavaParser parser;
    private boolean testSource;

    public JavaContext(LintDriver driver, Project project, Project main, File file) {
        super(driver, project, main, file);
    }

    public Location getLocation(Node node) {
        return this.parser.getLocation(this, node);
    }

    public Location getRangeLocation(Node from, int fromDelta, Node to, int toDelta) {
        return this.parser.getRangeLocation(this, from, fromDelta, to, toDelta);
    }

    public Location getRangeLocation(PsiElement from, int fromDelta, PsiElement to, int toDelta) {
        if (this.uastParser != null) {
            return this.uastParser.getRangeLocation(this, from, fromDelta, to, toDelta);
        }
        return this.parser.getRangeLocation(this, from, fromDelta, to, toDelta);
    }

    public Location getRangeLocation(UElement from, int fromDelta, UElement to, int toDelta) {
        return this.uastParser.getRangeLocation(this, from, fromDelta, to, toDelta);
    }

    public Location getRangeLocation(UDeclaration from, int fromDelta, UDeclaration to, int toDelta) {
        return this.uastParser.getRangeLocation(this, (PsiElement)from, fromDelta, (PsiElement)to, toDelta);
    }

    public Location getRangeLocation(PsiElement from, int fromDelta, int length) {
        if (this.uastParser != null) {
            return this.uastParser.getRangeLocation(this, from, fromDelta, fromDelta + length);
        }
        return this.parser.getRangeLocation(this, from, fromDelta, fromDelta + length);
    }

    public Location getRangeLocation(UElement from, int fromDelta, int length) {
        return this.uastParser.getRangeLocation(this, from, fromDelta, fromDelta + length);
    }

    public Location getNameLocation(Node node) {
        return this.parser.getNameLocation(this, node);
    }

    public Location getNameLocation(PsiElement element) {
        if (this.uastParser != null) {
            if (element instanceof PsiSwitchStatement) {
                return this.uastParser.getRangeLocation(this, element, 0, 6);
            }
            return this.uastParser.getNameLocation(this, element);
        }
        if (element instanceof PsiSwitchStatement) {
            return this.parser.getRangeLocation(this, element, 0, 6);
        }
        return this.parser.getNameLocation(this, element);
    }

    public Location getNameLocation(UElement element) {
        if (element instanceof USwitchExpression) {
            return this.uastParser.getRangeLocation(this, element, 0, 6);
        }
        return this.uastParser.getNameLocation(this, element);
    }

    public Location getNameLocation(UClass cls) {
        return this.getNameLocation((UElement)cls);
    }

    public Location getNameLocation(UMethod cls) {
        return this.getNameLocation((UElement)cls);
    }

    public Location getLocation(PsiElement node) {
        if (this.uastParser != null) {
            return this.uastParser.getLocation(this, node);
        }
        return this.parser.getLocation(this, node);
    }

    public Location getLocation(UElement element) {
        if (element instanceof UCallExpression) {
            return this.uastParser.getCallLocation(this, (UCallExpression)element, true, true);
        }
        return this.uastParser.getLocation(this, element);
    }

    public Location getLocation(UMethod element) {
        return this.uastParser.getLocation(this, (PsiElement)element);
    }

    public Location getLocation(UField element) {
        return this.uastParser.getLocation(this, (PsiElement)element);
    }

    public Location getCallLocation(UCallExpression call, boolean includeReceiver, boolean includeArguments) {
        return this.uastParser.getCallLocation(this, call, includeReceiver, includeArguments);
    }

    public JavaParser getParser() {
        return this.parser;
    }

    public UastParser getUastParser() {
        return this.uastParser;
    }

    public JavaEvaluator getEvaluator() {
        return this.uastParser != null ? this.uastParser.getEvaluator() : this.parser.getEvaluator();
    }

    public Node getCompilationUnit() {
        return this.compilationUnit;
    }

    public void setCompilationUnit(Node compilationUnit) {
        this.compilationUnit = compilationUnit;
    }

    @Deprecated
    public PsiJavaFile getJavaFile() {
        if (this.psiFile instanceof PsiJavaFile) {
            return (PsiJavaFile)this.psiFile;
        }
        return null;
    }

    public PsiFile getPsiFile() {
        return this.psiFile;
    }

    public void setJavaFile(PsiFile javaFile) {
        this.psiFile = javaFile;
    }

    public void setUastParser(UastParser uastParser) {
        this.uastParser = uastParser;
    }

    public void setParser(JavaParser parser) {
        this.parser = parser;
    }

    public UFile getUastFile() {
        return this.uastFile;
    }

    public void setUastFile(UFile uastFile) {
        this.uastFile = uastFile;
    }

    @Override
    public void report(Issue issue, Location location, String message) {
        if (this.driver.isSuppressed(this, issue, (PsiElement)this.psiFile)) {
            return;
        }
        super.report(issue, location, message);
    }

    @Deprecated
    public void report(Issue issue, Node scope, Location location, String message) {
        if (scope != null && this.driver.isSuppressed(this, issue, scope)) {
            return;
        }
        super.report(issue, location, message);
    }

    public void report(Issue issue, PsiElement scope, Location location, String message) {
        this.report(issue, scope, location, message, null);
    }

    public void report(Issue issue, PsiElement scope, Location location, String message, LintFix quickfixData) {
        if (scope != null && this.driver.isSuppressed(this, issue, scope)) {
            return;
        }
        super.doReport(issue, location, message, quickfixData);
    }

    @Deprecated
    public void report(Issue issue, PsiElement scope, Location location, String message, Object quickfixData) {
        this.report(issue, scope, location, message);
    }

    public void report(Issue issue, UElement scope, Location location, String message) {
        this.report(issue, scope, location, message, null);
    }

    public void report(Issue issue, UElement scope, Location location, String message, LintFix quickfixData) {
        if (scope != null && this.driver.isSuppressed(this, issue, scope)) {
            return;
        }
        super.doReport(issue, location, message, quickfixData);
    }

    @Deprecated
    public void report(Issue issue, UElement scope, Location location, String message, Object quickfixData) {
        this.report(issue, scope, location, message);
    }

    public void report(Issue issue, UClass scopeClass, Location location, String message) {
        this.report(issue, (UElement)scopeClass, location, message);
    }

    public void report(Issue issue, UClass scopeClass, Location location, String message, LintFix quickfixData) {
        this.report(issue, (UElement)scopeClass, location, message, quickfixData);
    }

    public void report(Issue issue, UMethod scopeClass, Location location, String message) {
        this.report(issue, (UElement)scopeClass, location, message);
    }

    public void report(Issue issue, UMethod scopeClass, Location location, String message, LintFix quickfixData) {
        this.report(issue, (UElement)scopeClass, location, message, quickfixData);
    }

    public void report(Issue issue, UField scopeClass, Location location, String message) {
        this.report(issue, (UElement)scopeClass, location, message);
    }

    public void report(Issue issue, UField scopeClass, Location location, String message, LintFix quickfixData) {
        this.report(issue, (UElement)scopeClass, location, message, quickfixData);
    }

    @Deprecated
    public void report(Issue issue, Node scope, Location location, String message, Object data) {
        this.report(issue, scope, location, message);
    }

    @Deprecated
    public static Node findSurroundingMethod(Node scope) {
        while (scope != null) {
            Class<?> type = scope.getClass();
            if (type == MethodDeclaration.class || type == ConstructorDeclaration.class) {
                return scope;
            }
            scope = scope.getParent();
        }
        return null;
    }

    @Deprecated
    public static ClassDeclaration findSurroundingClass(Node scope) {
        while (scope != null) {
            Class<?> type = scope.getClass();
            if (type == ClassDeclaration.class) {
                return (ClassDeclaration)scope;
            }
            scope = scope.getParent();
        }
        return null;
    }

    @Override
    protected String getSuppressCommentPrefix() {
        return SUPPRESS_COMMENT_PREFIX;
    }

    @Deprecated
    public boolean isSuppressedWithComment(Node scope, Issue issue) {
        CharSequence contents = this.getContents();
        assert (contents != null);
        Position position = scope.getPosition();
        if (position == null) {
            return false;
        }
        int start = position.getStart();
        return this.isSuppressedWithComment(start, issue);
    }

    public boolean isSuppressedWithComment(PsiElement scope, Issue issue) {
        if (scope instanceof PsiCompiledElement) {
            return false;
        }
        CharSequence contents = this.getContents();
        assert (contents != null);
        TextRange textRange = scope.getTextRange();
        if (textRange == null) {
            return false;
        }
        int start = textRange.getStartOffset();
        return this.isSuppressedWithComment(start, issue);
    }

    public boolean isSuppressedWithComment(UElement scope, Issue issue) {
        PsiElement psi = scope.getPsi();
        return psi != null && this.isSuppressedWithComment(psi, issue);
    }

    @Deprecated
    public Location.Handle createLocationHandle(Node node) {
        return this.parser.createLocationHandle(this, node);
    }

    @Deprecated
    public JavaParser.ResolvedNode resolve(Node node) {
        return this.parser.resolve(this, node);
    }

    @Deprecated
    public JavaParser.ResolvedClass findClass(String fullyQualifiedName) {
        return this.parser.findClass(this, fullyQualifiedName);
    }

    @Deprecated
    public JavaParser.TypeDescriptor getType(Node node) {
        return this.parser.getType(this, node);
    }

    @Deprecated
    public static String getMethodName(Node call) {
        if (call instanceof MethodInvocation) {
            return ((MethodInvocation)call).astName().astValue();
        }
        if (call instanceof ConstructorInvocation) {
            return ((ConstructorInvocation)call).astTypeReference().getTypeName();
        }
        if (call instanceof EnumConstant) {
            return ((EnumConstant)call).astName().astValue();
        }
        return null;
    }

    public static String getMethodName(PsiElement call) {
        if (call instanceof PsiMethodCallExpression) {
            return ((PsiMethodCallExpression)call).getMethodExpression().getReferenceName();
        }
        if (call instanceof PsiNewExpression) {
            PsiJavaCodeReferenceElement classReference = ((PsiNewExpression)call).getClassReference();
            if (classReference != null) {
                return classReference.getReferenceName();
            }
            return null;
        }
        if (call instanceof PsiEnumConstant) {
            return ((PsiEnumConstant)call).getName();
        }
        return null;
    }

    public static String getMethodName(UElement call) {
        if (call instanceof UEnumConstant) {
            return ((UEnumConstant)call).getName();
        }
        if (call instanceof UCallExpression) {
            String methodName = ((UCallExpression)call).getMethodName();
            if (methodName != null) {
                return methodName;
            }
            return UastUtils.getQualifiedName((UReferenceExpression)((UCallExpression)call).getClassReference());
        }
        return null;
    }

    @Deprecated
    public static Node findNameNode(Node node) {
        if (node instanceof TypeDeclaration) {
            return ((TypeDeclaration)node).astName();
        }
        if (node instanceof MethodDeclaration) {
            return ((MethodDeclaration)node).astMethodName();
        }
        if (node instanceof ConstructorDeclaration) {
            return ((ConstructorDeclaration)node).astTypeName();
        }
        if (node instanceof MethodInvocation) {
            return ((MethodInvocation)node).astName();
        }
        if (node instanceof ConstructorInvocation) {
            return ((ConstructorInvocation)node).astTypeReference();
        }
        if (node instanceof EnumConstant) {
            return ((EnumConstant)node).astName();
        }
        if (node instanceof AnnotationElement) {
            return ((AnnotationElement)node).astName();
        }
        if (node instanceof AnnotationMethodDeclaration) {
            return ((AnnotationMethodDeclaration)node).astMethodName();
        }
        if (node instanceof VariableReference) {
            return ((VariableReference)node).astIdentifier();
        }
        if (node instanceof LabelledStatement) {
            return ((LabelledStatement)node).astLabel();
        }
        return null;
    }

    public static PsiElement findNameElement(PsiElement element) {
        if (element instanceof PsiClass) {
            if (element instanceof PsiAnonymousClass) {
                return ((PsiAnonymousClass)element).getBaseClassReference();
            }
            return ((PsiClass)element).getNameIdentifier();
        }
        if (element instanceof PsiMethod) {
            return ((PsiMethod)element).getNameIdentifier();
        }
        if (element instanceof PsiMethodCallExpression) {
            return ((PsiMethodCallExpression)element).getMethodExpression().getReferenceNameElement();
        }
        if (element instanceof PsiNewExpression) {
            return ((PsiNewExpression)element).getClassReference();
        }
        if (element instanceof PsiField) {
            return ((PsiField)element).getNameIdentifier();
        }
        if (element instanceof PsiAnnotation) {
            return ((PsiAnnotation)element).getNameReferenceElement();
        }
        if (element instanceof PsiReferenceExpression) {
            return ((PsiReferenceExpression)element).getReferenceNameElement();
        }
        if (element instanceof PsiLabeledStatement) {
            return ((PsiLabeledStatement)element).getLabelIdentifier();
        }
        return null;
    }

    public static UElement findNameElement(UElement element) {
        if (element instanceof UDeclaration) {
            return ((UDeclaration)element).getUastAnchor();
        }
        if (element instanceof UCallExpression) {
            return ((UCallExpression)element).getMethodIdentifier();
        }
        return null;
    }

    @Deprecated
    public static Iterator<Expression> getParameters(Node call) {
        if (call instanceof MethodInvocation) {
            return ((MethodInvocation)call).astArguments().iterator();
        }
        if (call instanceof ConstructorInvocation) {
            return ((ConstructorInvocation)call).astArguments().iterator();
        }
        if (call instanceof EnumConstant) {
            return ((EnumConstant)call).astArguments().iterator();
        }
        return Collections.emptyIterator();
    }

    @Deprecated
    public static Node getParameter(Node call, int parameter) {
        Iterator<Expression> iterator = JavaContext.getParameters(call);
        for (int i = 0; i < parameter - 1; ++i) {
            if (!iterator.hasNext()) {
                return null;
            }
            iterator.next();
        }
        return iterator.hasNext() ? (Node)iterator.next() : null;
    }

    @Deprecated
    public boolean isContextMethod(MethodInvocation node) {
        JavaParser.ResolvedMethod method;
        JavaParser.ResolvedClass containingClass;
        JavaParser.ResolvedNode resolved = this.resolve((Node)node);
        return resolved instanceof JavaParser.ResolvedMethod && (containingClass = (method = (JavaParser.ResolvedMethod)resolved).getContainingClass()).isSubclassOf("android.content.Context", false);
    }

    @Deprecated
    public static <T extends Node> T getParentOfType(Node element, Class<T> clz) {
        return JavaContext.getParentOfType(element, clz, true);
    }

    @Deprecated
    public static <T extends Node> T getParentOfType(Node element, Class<T> clz, boolean strict) {
        if (element == null) {
            return null;
        }
        if (strict) {
            element = element.getParent();
        }
        while (element != null) {
            if (clz.isInstance(element)) {
                return (T)element;
            }
            element = element.getParent();
        }
        return null;
    }

    @Deprecated
    public static <T extends Node> T getParentOfType(Node element, Class<T> clz, boolean strict, Class<? extends Node> ... terminators) {
        if (element == null) {
            return null;
        }
        if (strict) {
            element = element.getParent();
        }
        while (element != null && !clz.isInstance(element)) {
            for (Class<? extends Node> terminator : terminators) {
                if (!terminator.isInstance(element)) continue;
                return null;
            }
            element = element.getParent();
        }
        return (T)element;
    }

    @Deprecated
    public static <T extends Node> T getNextSiblingOfType(Node sibling, Class<T> clz) {
        if (sibling == null) {
            return null;
        }
        Node parent = sibling.getParent();
        if (parent == null) {
            return null;
        }
        Iterator iterator = parent.getChildren().iterator();
        while (iterator.hasNext() && iterator.next() != sibling) {
        }
        while (iterator.hasNext()) {
            Node child = (Node)iterator.next();
            if (!clz.isInstance(child)) continue;
            return (T)child;
        }
        return null;
    }

    @Deprecated
    public static Node getArgumentNode(MethodInvocation call, int index) {
        int i = 0;
        for (Expression parameter : call.astArguments()) {
            if (i == index) {
                return parameter;
            }
            ++i;
        }
        throw new IllegalArgumentException(Integer.toString(index));
    }

    public boolean isTestSource() {
        return this.testSource;
    }

    public void setTestSource(boolean testSource) {
        this.testSource = testSource;
    }

    public UastContext getUastContext() {
        return this.uastParser.getUastContext();
    }
}

