/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.detector.api;

import com.android.builder.model.AndroidArtifact;
import com.android.builder.model.AndroidProject;
import com.android.builder.model.ApiVersion;
import com.android.builder.model.BuildTypeContainer;
import com.android.builder.model.ProductFlavorContainer;
import com.android.builder.model.SourceProvider;
import com.android.builder.model.SourceProviderContainer;
import com.android.builder.model.Variant;
import com.android.ide.common.rendering.api.ItemResourceValue;
import com.android.ide.common.rendering.api.ResourceValue;
import com.android.ide.common.rendering.api.StyleResourceValue;
import com.android.ide.common.repository.GradleVersion;
import com.android.ide.common.res2.AbstractResourceRepository;
import com.android.ide.common.res2.ResourceItem;
import com.android.ide.common.resources.configuration.FolderConfiguration;
import com.android.ide.common.resources.configuration.LocaleQualifier;
import com.android.resources.FolderTypeRelationship;
import com.android.resources.ResourceFolderType;
import com.android.resources.ResourceType;
import com.android.resources.ResourceUrl;
import com.android.sdklib.AndroidVersion;
import com.android.sdklib.IAndroidTarget;
import com.android.sdklib.SdkVersionInfo;
import com.android.tools.lint.client.api.LintClient;
import com.android.tools.lint.detector.api.CharSequences;
import com.android.tools.lint.detector.api.ClassContext;
import com.android.tools.lint.detector.api.Location;
import com.android.tools.lint.detector.api.Project;
import com.android.tools.lint.detector.api.XmlContext;
import com.android.utils.PositionXmlParser;
import com.android.utils.SdkUtils;
import com.android.utils.XmlUtils;
import com.google.common.annotations.Beta;
import com.google.common.base.Charsets;
import com.google.common.base.Objects;
import com.google.common.base.Splitter;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.google.common.io.ByteStreams;
import com.intellij.ide.util.JavaAnonymousClassesHelper;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiCallExpression;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiLiteral;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParenthesizedExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.util.ClassUtil;
import com.intellij.psi.util.PsiTreeUtil;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLConnection;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharacterCodingException;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import lombok.ast.ImportDeclaration;
import lombok.ast.Node;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UFile;
import org.jetbrains.uast.UParenthesizedExpression;
import org.jetbrains.uast.UastUtils;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.FieldNode;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

@Beta
public class LintUtils {
    private static final String UTF_16 = "UTF_16";
    private static final String UTF_16LE = "UTF_16LE";
    public static boolean sTryPrefixLookup = true;

    private LintUtils() {
    }

    public static String getInternalName(PsiClass psiClass) {
        PsiClass parent;
        if (psiClass instanceof PsiAnonymousClass && (parent = (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)psiClass, PsiClass.class)) != null) {
            String internalName = LintUtils.getInternalName(parent);
            if (internalName == null) {
                return null;
            }
            return internalName + JavaAnonymousClassesHelper.getName((PsiAnonymousClass)((PsiAnonymousClass)psiClass));
        }
        String sig = ClassUtil.getJVMClassName((PsiClass)psiClass);
        if (sig == null) {
            String qualifiedName = psiClass.getQualifiedName();
            if (qualifiedName != null) {
                return ClassContext.getInternalName(qualifiedName);
            }
            return null;
        }
        if (sig.indexOf(46) != -1) {
            sig = ClassContext.getInternalName(sig);
        }
        return sig;
    }

    public static String getInternalMethodName(PsiMethod method) {
        if (method.isConstructor()) {
            return "<init>";
        }
        return method.getName();
    }

    public static PsiElement getCallName(PsiCallExpression expression) {
        PsiElement firstChild = expression.getFirstChild();
        while (firstChild != null) {
            if (firstChild instanceof PsiWhiteSpace) {
                firstChild = firstChild.getNextSibling();
                continue;
            }
            if (!(firstChild instanceof PsiParenthesizedExpression)) break;
            firstChild = ((PsiParenthesizedExpression)firstChild).getExpression();
        }
        if (firstChild != null) {
            PsiElement lastChild = firstChild.getLastChild();
            while (lastChild != null) {
                if (lastChild instanceof PsiWhiteSpace) {
                    lastChild = lastChild.getPrevSibling();
                    continue;
                }
                if (!(lastChild instanceof PsiParenthesizedExpression)) break;
                lastChild = ((PsiParenthesizedExpression)lastChild).getExpression();
            }
            return lastChild;
        }
        return null;
    }

    public static String formatList(List<String> strings, int maxItems) {
        StringBuilder sb = new StringBuilder(20 * strings.size());
        int n = strings.size();
        for (int i = 0; i < n; ++i) {
            if (sb.length() > 0) {
                sb.append(", ");
            }
            sb.append(strings.get(i));
            if (maxItems <= 0 || i != maxItems - 1 || n <= maxItems) continue;
            sb.append(String.format("... (%1$d more)", n - i - 1));
            break;
        }
        return sb.toString();
    }

    public static boolean isFileBasedResourceType(ResourceType type) {
        List folderTypes = FolderTypeRelationship.getRelatedFolders((ResourceType)type);
        for (ResourceFolderType folderType : folderTypes) {
            if (folderType == ResourceFolderType.VALUES) continue;
            return type != ResourceType.ID;
        }
        return false;
    }

    public static boolean isXmlFile(File file) {
        return SdkUtils.endsWithIgnoreCase((String)file.getPath(), (String)".xml");
    }

    public static boolean isBitmapFile(File file) {
        String path = file.getPath();
        return LintUtils.endsWith(path, ".png") || LintUtils.endsWith(path, ".jpg") || LintUtils.endsWith(path, ".gif") || LintUtils.endsWith(path, ".jpeg") || LintUtils.endsWith(path, ".webp");
    }

    public static boolean endsWith(String string, String suffix) {
        return string.regionMatches(true, string.length() - suffix.length(), suffix, 0, suffix.length());
    }

    public static boolean startsWith(String string, String prefix, int offset) {
        return string.regionMatches(true, offset, prefix, 0, prefix.length());
    }

    public static String getBaseName(String fileName) {
        int extension = fileName.indexOf(46);
        if (extension > 0) {
            return fileName.substring(0, extension);
        }
        return fileName;
    }

    public static String describeCounts(int errorCount, int warningCount, boolean comma, boolean capitalize) {
        if (errorCount == 0 && warningCount == 0) {
            if (capitalize) {
                return "No errors or warnings";
            }
            return "no errors or warnings";
        }
        String errors = LintUtils.pluralize(errorCount, "error");
        String warnings = LintUtils.pluralize(warningCount, "warning");
        if (errorCount == 0) {
            return String.format("%1$d %2$s", warningCount, warnings);
        }
        if (warningCount == 0) {
            return String.format("%1$d %2$s", errorCount, errors);
        }
        String conjunction = comma ? "," : " and";
        return String.format("%1$d %2$s%3$s %4$d %5$s", errorCount, errors, conjunction, warningCount, warnings);
    }

    private static String pluralize(int count, String one) {
        if (count == 1) {
            return one;
        }
        return one + "s";
    }

    public static List<Element> getChildren(org.w3c.dom.Node node) {
        NodeList childNodes = node.getChildNodes();
        ArrayList<Element> children = new ArrayList<Element>(childNodes.getLength());
        int n = childNodes.getLength();
        for (int i = 0; i < n; ++i) {
            org.w3c.dom.Node child = childNodes.item(i);
            if (child.getNodeType() != 1) continue;
            children.add((Element)child);
        }
        return children;
    }

    public static int getChildCount(org.w3c.dom.Node node) {
        return XmlUtils.getSubTagCount((org.w3c.dom.Node)node);
    }

    public static boolean isRootElement(Element element) {
        return element == element.getOwnerDocument().getDocumentElement();
    }

    public static String getFieldName(String styleName) {
        int n = styleName.length();
        for (int i = 0; i < n; ++i) {
            char c = styleName.charAt(i);
            if (c != '.' && c != '-' && c != ':') continue;
            return styleName.replace('.', '_').replace('-', '_').replace(':', '_');
        }
        return styleName;
    }

    public static String stripIdPrefix(String id) {
        if (id == null) {
            return "";
        }
        if (id.startsWith("@+id/")) {
            return id.substring("@+id/".length());
        }
        if (id.startsWith("@id/")) {
            return id.substring("@id/".length());
        }
        return id;
    }

    public static boolean idReferencesMatch(String id1, String id2) {
        if (id1 == null || id2 == null || id1.isEmpty() || id2.isEmpty()) {
            return false;
        }
        if (id1.startsWith("@+id/")) {
            if (id2.startsWith("@+id/")) {
                return id1.equals(id2);
            }
            assert (id2.startsWith("@id/")) : id2;
            return id1.length() - id2.length() == "@+id/".length() - "@id/".length() && id1.regionMatches("@+id/".length(), id2, "@id/".length(), id2.length() - "@id/".length());
        }
        assert (id1.startsWith("@id/")) : id1;
        if (id2.startsWith("@id/")) {
            return id1.equals(id2);
        }
        assert (id2.startsWith("@+id/"));
        return id2.length() - id1.length() == "@+id/".length() - "@id/".length() && id2.regionMatches("@+id/".length(), id1, "@id/".length(), id1.length() - "@id/".length());
    }

    public static String getFileNameWithParent(LintClient client, File file) {
        return client.getDisplayPath(new File(file.getParentFile().getName(), file.getName()));
    }

    public static boolean isEditableTo(String s, String t, int max) {
        return LintUtils.editDistance(s, t, max) <= max;
    }

    public static int editDistance(String s, String t) {
        return LintUtils.editDistance(s, t, Integer.MAX_VALUE);
    }

    public static int editDistance(String s, String t, int max) {
        int j;
        if (s.equals(t)) {
            return 0;
        }
        if (Math.abs(s.length() - t.length()) > max) {
            return Integer.MAX_VALUE;
        }
        int m = s.length();
        int n = t.length();
        int[][] d = new int[m + 1][n + 1];
        for (int i = 0; i <= m; ++i) {
            d[i][0] = i;
        }
        for (j = 0; j <= n; ++j) {
            d[0][j] = j;
        }
        for (j = 1; j <= n; ++j) {
            for (int i = 1; i <= m; ++i) {
                if (s.charAt(i - 1) == t.charAt(j - 1)) {
                    d[i][j] = d[i - 1][j - 1];
                    continue;
                }
                int deletion = d[i - 1][j] + 1;
                int insertion = d[i][j - 1] + 1;
                int substitution = d[i - 1][j - 1] + 1;
                d[i][j] = Math.min(deletion, Math.min(insertion, substitution));
            }
        }
        return d[m][n];
    }

    public static boolean assertionsEnabled() {
        boolean assertionsEnabled = false;
        if (!$assertionsDisabled) {
            assertionsEnabled = true;
            if (!true) {
                throw new AssertionError();
            }
        }
        return assertionsEnabled;
    }

    public static String getLayoutName(File layoutFile) {
        String name = layoutFile.getName();
        int dotIndex = name.indexOf(46);
        if (dotIndex != -1) {
            name = name.substring(0, dotIndex);
        }
        return name;
    }

    public static Iterable<String> splitPath(String path) {
        if (path.indexOf(59) != -1) {
            return Splitter.on((char)';').omitEmptyStrings().trimResults().split((CharSequence)path);
        }
        ArrayList<String> combined = new ArrayList<String>();
        Iterables.addAll(combined, (Iterable)Splitter.on((char)':').omitEmptyStrings().trimResults().split((CharSequence)path));
        int n = combined.size();
        for (int i = 0; i < n; ++i) {
            String p = (String)combined.get(i);
            if (p.length() != 1 || i >= n - 1 || !Character.isLetter(p.charAt(0)) || ((String)combined.get(i + 1)).isEmpty() || ((String)combined.get(i + 1)).charAt(0) != '\\') continue;
            combined.set(i, p + ':' + (String)combined.get(i + 1));
            combined.remove(i + 1);
            --n;
        }
        return combined;
    }

    public static File getCommonParent(List<File> files) {
        int fileCount = files.size();
        if (fileCount == 0) {
            return null;
        }
        if (fileCount == 1) {
            return files.get(0);
        }
        if (fileCount == 2) {
            return LintUtils.getCommonParent(files.get(0), files.get(1));
        }
        File common = files.get(0);
        for (int i = 1; i < fileCount; ++i) {
            if ((common = LintUtils.getCommonParent(common, files.get(i))) != null) continue;
            return null;
        }
        return common;
    }

    public static File getCommonParent(File file1, File file2) {
        if (file1.equals(file2)) {
            return file1;
        }
        if (file1.getPath().startsWith(file2.getPath())) {
            return file2;
        }
        if (file2.getPath().startsWith(file1.getPath())) {
            return file1;
        }
        for (File first = file1.getParentFile(); first != null; first = first.getParentFile()) {
            for (File second = file2.getParentFile(); second != null; second = second.getParentFile()) {
                if (!first.equals(second)) continue;
                return first;
            }
        }
        return null;
    }

    public static CharSequence getEncodedString(LintClient client, File file, boolean createString) throws IOException {
        byte[] bytes = client.readBytes(file);
        if (LintUtils.endsWith(file.getName(), ".xml")) {
            return PositionXmlParser.getXmlString((byte[])bytes);
        }
        return LintUtils.getEncodedString(bytes, createString);
    }

    public static boolean isDataBindingExpression(String expression) {
        return expression.startsWith("@{") || expression.startsWith("@={");
    }

    public static boolean isManifestPlaceHolderExpression(String expression) {
        return expression.contains("${");
    }

    public static CharSequence getEncodedString(byte[] data, boolean createString) {
        if (data == null) {
            return "";
        }
        int offset = 0;
        String defaultCharset = "UTF-8";
        String charset = null;
        if (data.length > 4) {
            if (data[0] == -17 && data[1] == -69 && data[2] == -65) {
                charset = "UTF-8";
                defaultCharset = "UTF-8";
                offset += 3;
            } else if (data[0] == -2 && data[1] == -1) {
                charset = UTF_16;
                defaultCharset = UTF_16;
                offset += 2;
            } else if (data[0] == 0 && data[1] == 0 && data[2] == -2 && data[3] == -1) {
                charset = "UTF_32";
                defaultCharset = "UTF_32";
                offset += 4;
            } else if (data[0] == -1 && data[1] == -2 && data[2] == 0 && data[3] == 0) {
                charset = "UTF_32LE";
                defaultCharset = "UTF_32LE";
                offset += 4;
            } else if (data[0] == -1 && data[1] == -2) {
                charset = UTF_16LE;
                defaultCharset = UTF_16LE;
                offset += 2;
            }
        }
        int length = data.length - offset;
        boolean seenOddZero = false;
        boolean seenEvenZero = false;
        for (int lineEnd = offset; lineEnd < data.length; ++lineEnd) {
            if (data[lineEnd] == 0) {
                if ((lineEnd - offset) % 2 == 0) {
                    seenEvenZero = true;
                    continue;
                }
                seenOddZero = true;
                continue;
            }
            if (data[lineEnd] == 10 || data[lineEnd] == 13) break;
        }
        if (charset == null) {
            String string = seenOddZero ? UTF_16LE : (charset = seenEvenZero ? UTF_16 : "UTF-8");
        }
        if (!createString && "UTF-8".equals(charset)) {
            ByteBuffer bytes = ByteBuffer.wrap(data, offset, length);
            try {
                CharBuffer decode = Charsets.UTF_8.newDecoder().decode(bytes);
                decode.compact();
                int size = decode.position();
                assert (size <= decode.limit());
                char[] array = decode.array();
                return CharSequences.createSequence(array, 0, size);
            }
            catch (CharacterCodingException decode) {
                // empty catch block
            }
        }
        String text = null;
        try {
            text = new String(data, offset, length, charset);
        }
        catch (UnsupportedEncodingException e) {
            try {
                if (!charset.equals(defaultCharset)) {
                    text = new String(data, offset, length, defaultCharset);
                }
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
        }
        if (text == null) {
            text = new String(data, offset, length);
        }
        return text;
    }

    public static boolean isStaticInnerClass(ClassNode classNode) {
        List fieldList = classNode.fields;
        for (Object f : fieldList) {
            FieldNode field = (FieldNode)f;
            if (!field.name.startsWith("this$") || (field.access & 0x1000) == 0) continue;
            return false;
        }
        return true;
    }

    public static boolean isAnonymousClass(ClassNode classNode) {
        if (classNode.outerClass == null) {
            return false;
        }
        String name = classNode.name;
        int index = name.lastIndexOf(36);
        if (index == -1 || index == name.length() - 1) {
            return false;
        }
        return Character.isDigit(name.charAt(index + 1));
    }

    public static int getPrevOpcode(AbstractInsnNode node) {
        AbstractInsnNode prev = LintUtils.getPrevInstruction(node);
        if (prev != null) {
            return prev.getOpcode();
        }
        return 0;
    }

    public static AbstractInsnNode getPrevInstruction(AbstractInsnNode node) {
        int type;
        AbstractInsnNode prev = node;
        do {
            if ((prev = prev.getPrevious()) != null) continue;
            return null;
        } while ((type = prev.getType()) == 15 || type == 8 || type == 14);
        return prev;
    }

    public static int getNextOpcode(AbstractInsnNode node) {
        AbstractInsnNode next = LintUtils.getNextInstruction(node);
        if (next != null) {
            return next.getOpcode();
        }
        return 0;
    }

    public static AbstractInsnNode getNextInstruction(AbstractInsnNode node) {
        int type;
        AbstractInsnNode next = node;
        do {
            if ((next = next.getNext()) != null) continue;
            return null;
        } while ((type = next.getType()) == 15 || type == 8 || type == 14);
        return next;
    }

    public static boolean isManifestFolder(File dir) {
        boolean hasManifest = new File(dir, "AndroidManifest.xml").exists();
        if (hasManifest && dir.getName().equals("bin") && (dir = dir.getParentFile()) != null && LintUtils.isManifestFolder(dir)) {
            return false;
        }
        return hasManifest;
    }

    public static String getLocaleAndRegion(String folderName) {
        if (folderName.indexOf(45) == -1) {
            return null;
        }
        String locale = null;
        for (String qualifier : FolderConfiguration.QUALIFIER_SPLITTER.split((CharSequence)folderName)) {
            char second;
            char first;
            int qualifierLength = qualifier.length();
            if (qualifierLength == 2) {
                first = qualifier.charAt(0);
                second = qualifier.charAt(1);
                if (first < 'a' || first > 'z' || second < 'a' || second > 'z') continue;
                locale = qualifier;
                continue;
            }
            if (qualifierLength == 3 && qualifier.charAt(0) == 'r' && locale != null) {
                first = qualifier.charAt(1);
                second = qualifier.charAt(2);
                if (first < 'A' || first > 'Z' || second < 'A' || second > 'Z') break;
                return locale + '-' + qualifier;
            }
            if (!qualifier.startsWith("b+")) continue;
            return qualifier;
        }
        return locale;
    }

    @Deprecated
    public static boolean isImported(Node compilationUnit, String fullyQualifiedName) {
        if (compilationUnit == null) {
            return false;
        }
        int dotIndex = fullyQualifiedName.lastIndexOf(46);
        int dotLength = fullyQualifiedName.length() - dotIndex;
        boolean imported = false;
        for (Node rootNode : compilationUnit.getChildren()) {
            if (!(rootNode instanceof ImportDeclaration)) continue;
            ImportDeclaration importDeclaration = (ImportDeclaration)rootNode;
            String fqn = importDeclaration.asFullyQualifiedName();
            if (fqn.equals(fullyQualifiedName)) {
                return true;
            }
            if (fullyQualifiedName.regionMatches(dotIndex, fqn, fqn.length() - dotLength, dotLength)) {
                return false;
            }
            if (!importDeclaration.astStarImport() || !fqn.regionMatches(0, fqn, 0, dotIndex + 1)) continue;
            imported = true;
        }
        return imported;
    }

    public static List<ResourceValue> getStyleAttributes(Project project, LintClient client, String styleUrl, String namespace, String attribute) {
        if (!client.supportsProjectResources()) {
            return null;
        }
        AbstractResourceRepository resources = client.getResourceRepository(project, true, true);
        if (resources == null) {
            return null;
        }
        ResourceUrl style = ResourceUrl.parse((String)styleUrl);
        if (style == null || style.framework) {
            return null;
        }
        ArrayList result = null;
        ArrayDeque<ResourceValue> queue = new ArrayDeque<ResourceValue>();
        queue.add(new ResourceValue(ResourceUrl.create((ResourceType)style.type, (String)style.name, (boolean)false), null));
        HashSet seen = Sets.newHashSet();
        boolean isFrameworkAttribute = "http://schemas.android.com/apk/res/android".equals(namespace);
        for (int count = 0; count < 30 && !queue.isEmpty(); ++count) {
            ResourceValue front = (ResourceValue)queue.remove();
            String name = front.getName();
            seen.add(name);
            List items = resources.getResourceItem(front.getResourceType(), name);
            if (items == null) continue;
            for (ResourceItem item : items) {
                String parentName;
                int index;
                ResourceUrl p;
                String parent;
                ResourceValue rv = item.getResourceValue(false);
                if (!(rv instanceof StyleResourceValue)) continue;
                StyleResourceValue srv = (StyleResourceValue)rv;
                ItemResourceValue value = srv.getItem(attribute, isFrameworkAttribute);
                if (value != null) {
                    if (result == null) {
                        result = Lists.newArrayList();
                    }
                    if (!result.contains(value)) {
                        result.add(value);
                    }
                }
                if (!((parent = srv.getParentStyle()) == null || parent.startsWith("@android:") || (p = ResourceUrl.parse((String)parent)) == null || p.framework || seen.contains(p.name))) {
                    seen.add(p.name);
                    queue.add(new ResourceValue(ResourceUrl.create((ResourceType)ResourceType.STYLE, (String)p.name, (boolean)false), null));
                }
                if ((index = name.lastIndexOf(46)) <= 0 || seen.contains(parentName = name.substring(0, index))) continue;
                seen.add(parentName);
                queue.add(new ResourceValue(ResourceUrl.create((ResourceType)ResourceType.STYLE, (String)parentName, (boolean)false), null));
            }
        }
        return result;
    }

    public static List<StyleResourceValue> getInheritedStyles(Project project, LintClient client, String styleUrl) {
        if (!client.supportsProjectResources()) {
            return null;
        }
        AbstractResourceRepository resources = client.getResourceRepository(project, true, true);
        if (resources == null) {
            return null;
        }
        ResourceUrl style = ResourceUrl.parse((String)styleUrl);
        if (style == null || style.framework) {
            return null;
        }
        ArrayList result = null;
        ArrayDeque<ResourceValue> queue = new ArrayDeque<ResourceValue>();
        queue.add(new ResourceValue(ResourceUrl.create(null, (ResourceType)style.type, (String)style.name), null));
        HashSet seen = Sets.newHashSet();
        for (int count = 0; count < 30 && !queue.isEmpty(); ++count) {
            ResourceValue front = (ResourceValue)queue.remove();
            String name = front.getName();
            seen.add(name);
            List items = resources.getResourceItem(front.getResourceType(), name);
            if (items == null) continue;
            for (ResourceItem item : items) {
                String parentName;
                int index;
                ResourceUrl p;
                ResourceValue rv = item.getResourceValue(false);
                if (!(rv instanceof StyleResourceValue)) continue;
                StyleResourceValue srv = (StyleResourceValue)rv;
                if (result == null) {
                    result = Lists.newArrayList();
                }
                result.add(srv);
                String parent = srv.getParentStyle();
                if (!(parent == null || parent.startsWith("@android:") || (p = ResourceUrl.parse((String)parent)) == null || p.framework || seen.contains(p.name))) {
                    seen.add(p.name);
                    queue.add(new ResourceValue(ResourceUrl.create(null, (ResourceType)ResourceType.STYLE, (String)p.name), null));
                }
                if ((index = name.lastIndexOf(46)) <= 0 || seen.contains(parentName = name.substring(0, index))) continue;
                seen.add(parentName);
                queue.add(new ResourceValue(ResourceUrl.create(null, (ResourceType)ResourceType.STYLE, (String)parentName), null));
            }
        }
        return result;
    }

    public static boolean isSameResourceFile(File file1, File file2) {
        if (file1 != null && file2 != null && file1.getName().equals(file2.getName())) {
            File parent1 = file1.getParentFile();
            File parent2 = file2.getParentFile();
            if (parent1 != null && parent2 != null && parent1.getName().equals(parent2.getName())) {
                return true;
            }
        }
        return false;
    }

    public static String computeResourcePrefix(AndroidProject project) {
        try {
            if (sTryPrefixLookup && project != null) {
                return project.getResourcePrefix();
            }
        }
        catch (Exception e) {
            sTryPrefixLookup = false;
        }
        return null;
    }

    public static String computeResourceName(String prefix, String name) {
        return LintUtils.computeResourceName(prefix, name, null);
    }

    public static String computeResourceName(String prefix, String name, ResourceFolderType folderType) {
        if (prefix.isEmpty()) {
            return name;
        }
        if (folderType != null && folderType != ResourceFolderType.VALUES) {
            name = name.toLowerCase(Locale.ROOT);
            String underlined = SdkVersionInfo.camelCaseToUnderlines((String)prefix);
            if (!prefix.equals(underlined)) {
                if (!underlined.endsWith("_")) {
                    underlined = underlined + "_";
                }
                prefix = underlined;
            }
        }
        if (!name.isEmpty() && Character.isUpperCase(name.charAt(0))) {
            if (prefix.indexOf(95) != -1) {
                prefix = SdkVersionInfo.underlinesToCamelCase((String)prefix);
            }
            if ((prefix = Character.toUpperCase(prefix.charAt(0)) + prefix.substring(1)).endsWith("_")) {
                prefix = prefix.substring(0, prefix.length() - 1);
            }
        }
        if (name.isEmpty()) {
            return prefix;
        }
        if (prefix.endsWith("_")) {
            return prefix + name;
        }
        return prefix + Character.toUpperCase(name.charAt(0)) + name.substring(1);
    }

    public static AndroidVersion convertVersion(ApiVersion api, IAndroidTarget[] targets) {
        String codename = api.getCodename();
        if (codename != null) {
            AndroidVersion version = SdkVersionInfo.getVersion((String)codename, (IAndroidTarget[])targets);
            if (version != null) {
                return version;
            }
            return new AndroidVersion(api.getApiLevel(), codename);
        }
        return new AndroidVersion(api.getApiLevel(), null);
    }

    public static boolean isModelOlderThan(Project project, int major, int minor, int micro) {
        return LintUtils.isModelOlderThan(project, major, minor, micro, false);
    }

    public static boolean isModelOlderThan(Project project, int major, int minor, int micro, boolean defaultForNonGradleProjects) {
        GradleVersion version = project.getGradleModelVersion();
        if (version == null) {
            return defaultForNonGradleProjects;
        }
        if (version.getMajor() != major) {
            return version.getMajor() < major;
        }
        if (version.getMinor() != minor) {
            return version.getMinor() < minor;
        }
        return version.getMicro() < micro;
    }

    public static LanguageLevel getLanguageLevel(UElement element, LanguageLevel defaultLevel) {
        UFile containingFile = UastUtils.getContainingFile((UElement)element);
        if (containingFile == null) {
            return defaultLevel;
        }
        return LintUtils.getLanguageLevel((PsiElement)containingFile.getPsi(), defaultLevel);
    }

    public static LanguageLevel getLanguageLevel(PsiElement element, LanguageLevel defaultLevel) {
        PsiFile containingFile;
        PsiFile psiFile = containingFile = element instanceof PsiFile ? (PsiFile)element : element.getContainingFile();
        if (containingFile instanceof PsiJavaFile) {
            return ((PsiJavaFile)containingFile).getLanguageLevel();
        }
        return defaultLevel;
    }

    public static String findSubstring(String string, String prefix, String suffix) {
        int start = 0;
        if (prefix != null) {
            start = string.indexOf(prefix);
            if (start == -1) {
                return null;
            }
            start += prefix.length();
        }
        if (suffix != null) {
            int end = string.indexOf(suffix, start);
            if (end == -1) {
                return null;
            }
            return string.substring(start, end);
        }
        return string.substring(start);
    }

    public static List<String> getFormattedParameters(String format, String errorMessage) {
        StringBuilder pattern = new StringBuilder(format.length());
        int parameter = 1;
        int n = format.length();
        for (int i = 0; i < n; ++i) {
            char c = format.charAt(i);
            if (c == '%') {
                assert (i < format.length() - 4) : format;
                assert (format.charAt(i + 1) == 48 + parameter) : format;
                assert (Character.isDigit(format.charAt(i + 1))) : format;
                assert (format.charAt(i + 2) == '$') : format;
                assert (format.charAt(i + 3) == 's') : format;
                ++parameter;
                i += 3;
                pattern.append("(.*)");
                continue;
            }
            pattern.append(c);
        }
        try {
            Pattern compile = Pattern.compile(pattern.toString());
            Matcher matcher = compile.matcher(errorMessage);
            if (matcher.find()) {
                int groupCount = matcher.groupCount();
                ArrayList parameters = Lists.newArrayListWithExpectedSize((int)groupCount);
                for (int i = 1; i <= groupCount; ++i) {
                    parameters.add(matcher.group(i));
                }
                return parameters;
            }
        }
        catch (PatternSyntaxException patternSyntaxException) {
            // empty catch block
        }
        return Collections.emptyList();
    }

    public static LocaleQualifier getLocale(String parent) {
        FolderConfiguration config;
        if (parent.indexOf(45) != -1 && (config = FolderConfiguration.getConfigForFolder((String)parent)) != null) {
            return config.getLocaleQualifier();
        }
        return null;
    }

    public static LocaleQualifier getLocale(XmlContext context) {
        String locale;
        Element root = context.document.getDocumentElement();
        if (root != null && (locale = root.getAttributeNS("http://schemas.android.com/tools", "locale")) != null && !locale.isEmpty()) {
            if (locale.indexOf(45) == -1) {
                return LocaleQualifier.getQualifier((String)locale);
            }
            FolderConfiguration config = FolderConfiguration.getConfigForQualifierString((String)locale);
            if (config != null) {
                return config.getLocaleQualifier();
            }
        }
        return LintUtils.getLocale(context.file.getParentFile().getName());
    }

    public static boolean isEnglishResource(XmlContext context, boolean assumeForBase) {
        LocaleQualifier locale = LintUtils.getLocale(context);
        if (locale == null) {
            return assumeForBase;
        }
        return "en".equals(locale.getLanguage());
    }

    public static Location guessGradleLocation(Project project) {
        File dir = project.getDir();
        File topLevel = new File(dir, "build.gradle");
        Location location = topLevel.exists() ? Location.create(topLevel) : Location.create(dir);
        return location;
    }

    public static Location guessGradleLocation(LintClient client, File projectDir, String string) {
        File gradle = new File(projectDir, "build.gradle");
        if (gradle.isFile()) {
            String contents = client.readFile(gradle).toString();
            int match = contents.indexOf(string);
            if (match != -1) {
                int length = string.length();
                if (contents.indexOf(string, match + length) == -1) {
                    return Location.create(gradle, contents, match, match + length);
                }
                int end = contents.length();
                char first = string.charAt(0);
                for (int offset = 0; offset < end - 1; ++offset) {
                    char c = contents.charAt(offset);
                    if (c == '/') {
                        char next = contents.charAt(offset + 1);
                        if (next == '/') {
                            if ((offset = contents.indexOf(10, offset)) != -1) continue;
                            break;
                        }
                        if (next == '*') {
                            if ((offset = contents.indexOf("*/", offset)) != -1) continue;
                            break;
                        }
                    }
                    if (c != first || !contents.regionMatches(offset, string, 0, length)) continue;
                    return Location.create(gradle, contents, offset, offset + length);
                }
            }
            return Location.create(gradle);
        }
        return Location.create(projectDir);
    }

    public static boolean isNullLiteral(PsiElement element) {
        return element instanceof PsiLiteral && "null".equals(element.getText());
    }

    public static boolean isTrueLiteral(PsiElement element) {
        return element instanceof PsiLiteral && "true".equals(element.getText());
    }

    public static boolean isFalseLiteral(PsiElement element) {
        return element instanceof PsiLiteral && "false".equals(element.getText());
    }

    public static PsiElement skipParentheses(PsiElement element) {
        while (element instanceof PsiParenthesizedExpression) {
            element = element.getParent();
        }
        return element;
    }

    public static UElement skipParentheses(UElement element) {
        while (element instanceof UParenthesizedExpression) {
            element = element.getUastParent();
        }
        return element;
    }

    public static PsiElement nextNonWhitespace(PsiElement element) {
        if (element != null) {
            element = element.getNextSibling();
            while (element instanceof PsiWhiteSpace) {
                element = element.getNextSibling();
            }
        }
        return element;
    }

    public static PsiElement prevNonWhitespace(PsiElement element) {
        if (element != null) {
            element = element.getPrevSibling();
            while (element instanceof PsiWhiteSpace) {
                element = element.getPrevSibling();
            }
        }
        return element;
    }

    public static boolean isString(PsiType type) {
        String shortName;
        if (type instanceof PsiClassType && !Objects.equal((Object)(shortName = ((PsiClassType)type).getClassName()), (Object)"String")) {
            return false;
        }
        return "java.lang.String".equals(type.getCanonicalText());
    }

    public static String getAutoBoxedType(String primitive) {
        if ("int".equals(primitive)) {
            return "java.lang.Integer";
        }
        if ("long".equals(primitive)) {
            return "java.lang.Long";
        }
        if ("char".equals(primitive)) {
            return "java.lang.Character";
        }
        if ("float".equals(primitive)) {
            return "java.lang.Float";
        }
        if ("double".equals(primitive)) {
            return "java.lang.Double";
        }
        if ("boolean".equals(primitive)) {
            return "java.lang.Boolean";
        }
        if ("short".equals(primitive)) {
            return "java.lang.Short";
        }
        if ("byte".equals(primitive)) {
            return "java.lang.Byte";
        }
        return null;
    }

    public static String getPrimitiveType(String autoBoxedType) {
        if ("java.lang.Integer".equals(autoBoxedType)) {
            return "int";
        }
        if ("java.lang.Long".equals(autoBoxedType)) {
            return "long";
        }
        if ("java.lang.Character".equals(autoBoxedType)) {
            return "char";
        }
        if ("java.lang.Float".equals(autoBoxedType)) {
            return "float";
        }
        if ("java.lang.Double".equals(autoBoxedType)) {
            return "double";
        }
        if ("java.lang.Boolean".equals(autoBoxedType)) {
            return "boolean";
        }
        if ("java.lang.Short".equals(autoBoxedType)) {
            return "short";
        }
        if ("java.lang.Byte".equals(autoBoxedType)) {
            return "byte";
        }
        return null;
    }

    public static String resolveManifestName(Element element) {
        String className = element.getAttributeNS("http://schemas.android.com/apk/res/android", "name");
        if ((className = className.replace('$', '.')).startsWith(".")) {
            String pkg = element.getOwnerDocument().getDocumentElement().getAttribute("package");
            return pkg + className;
        }
        if (className.indexOf(46) == -1) {
            String pkg = element.getOwnerDocument().getDocumentElement().getAttribute("package");
            return pkg + '.' + className;
        }
        return className;
    }

    public static List<SourceProvider> getSourceProviders(AndroidProject project, Variant variant) {
        SourceProvider variantProvider;
        ArrayList providers = Lists.newArrayList();
        AndroidArtifact mainArtifact = variant.getMainArtifact();
        providers.add(project.getDefaultConfig().getSourceProvider());
        block0: for (String flavorName : variant.getProductFlavors()) {
            for (ProductFlavorContainer flavor : project.getProductFlavors()) {
                if (!flavorName.equals(flavor.getProductFlavor().getName())) continue;
                providers.add(flavor.getSourceProvider());
                continue block0;
            }
        }
        SourceProvider multiProvider = mainArtifact.getMultiFlavorSourceProvider();
        if (multiProvider != null) {
            providers.add(multiProvider);
        }
        String buildTypeName = variant.getBuildType();
        for (BuildTypeContainer buildType : project.getBuildTypes()) {
            if (!buildTypeName.equals(buildType.getBuildType().getName())) continue;
            providers.add(buildType.getSourceProvider());
            break;
        }
        if ((variantProvider = mainArtifact.getVariantSourceProvider()) != null) {
            providers.add(variantProvider);
        }
        return providers;
    }

    private static boolean isTestArtifact(SourceProviderContainer extra) {
        String artifactName = extra.getArtifactName();
        return "_android_test_".equals(artifactName) || "_unit_test_".equals(artifactName);
    }

    public static List<SourceProvider> getTestSourceProviders(AndroidProject project, Variant variant) {
        ArrayList providers = Lists.newArrayList();
        ProductFlavorContainer defaultConfig = project.getDefaultConfig();
        for (SourceProviderContainer extra : defaultConfig.getExtraSourceProviders()) {
            if (!LintUtils.isTestArtifact(extra)) continue;
            providers.add(extra.getSourceProvider());
        }
        for (String flavorName : variant.getProductFlavors()) {
            for (ProductFlavorContainer flavor : project.getProductFlavors()) {
                if (!flavorName.equals(flavor.getProductFlavor().getName())) continue;
                for (SourceProviderContainer extra : flavor.getExtraSourceProviders()) {
                    if (!LintUtils.isTestArtifact(extra)) continue;
                    providers.add(extra.getSourceProvider());
                }
            }
        }
        String buildTypeName = variant.getBuildType();
        for (BuildTypeContainer buildType : project.getBuildTypes()) {
            if (!buildTypeName.equals(buildType.getBuildType().getName())) continue;
            for (SourceProviderContainer extra : buildType.getExtraSourceProviders()) {
                if (!LintUtils.isTestArtifact(extra)) continue;
                providers.add(extra.getSourceProvider());
            }
        }
        return providers;
    }

    public static boolean isJavaKeyword(String keyword) {
        switch (keyword) {
            case "abstract": 
            case "assert": 
            case "boolean": 
            case "break": 
            case "byte": 
            case "case": 
            case "catch": 
            case "char": 
            case "class": 
            case "const": 
            case "continue": 
            case "default": 
            case "do": 
            case "double": 
            case "else": 
            case "enum": 
            case "extends": 
            case "false": 
            case "final": 
            case "finally": 
            case "float": 
            case "for": 
            case "goto": 
            case "if": 
            case "implements": 
            case "import": 
            case "instanceof": 
            case "int": 
            case "interface": 
            case "long": 
            case "native": 
            case "new": 
            case "null": 
            case "package": 
            case "private": 
            case "protected": 
            case "public": 
            case "return": 
            case "short": 
            case "static": 
            case "strictfp": 
            case "super": 
            case "switch": 
            case "synchronized": 
            case "this": 
            case "throw": 
            case "throws": 
            case "transient": 
            case "true": 
            case "try": 
            case "void": 
            case "volatile": 
            case "while": {
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] readUrlData(LintClient client, String query, int timeout) throws IOException {
        URL url = new URL(query);
        URLConnection connection = client.openConnection(url, timeout);
        if (connection == null) {
            return null;
        }
        try {
            InputStream is = connection.getInputStream();
            if (is == null) {
                byte[] byArray = null;
                return byArray;
            }
            byte[] byArray = ByteStreams.toByteArray((InputStream)is);
            return byArray;
        }
        finally {
            client.closeConnection(connection);
        }
    }

    public static String readUrlDataAsString(LintClient client, String query, int timeout) throws IOException {
        byte[] bytes = LintUtils.readUrlData(client, query, timeout);
        if (bytes != null) {
            return new String(bytes, Charsets.UTF_8);
        }
        return null;
    }

    @SafeVarargs
    public static <T> T coalesce(T ... ts) {
        for (T t : ts) {
            if (t == null) continue;
            return t;
        }
        return null;
    }
}

