/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.client.api;

import com.android.SdkConstants;
import com.android.builder.model.AndroidLibrary;
import com.android.builder.model.Variant;
import com.android.ide.common.repository.ResourceVisibilityLookup;
import com.android.ide.common.res2.AbstractResourceRepository;
import com.android.ide.common.res2.ResourceItem;
import com.android.manifmerger.Actions;
import com.android.prefs.AndroidLocation;
import com.android.repository.api.ProgressIndicator;
import com.android.repository.api.ProgressIndicatorAdapter;
import com.android.sdklib.BuildToolInfo;
import com.android.sdklib.IAndroidTarget;
import com.android.sdklib.repository.AndroidSdkHandler;
import com.android.sdklib.repository.targets.AndroidTargetManager;
import com.android.tools.lint.client.api.BlameFile;
import com.android.tools.lint.client.api.CircularDependencyException;
import com.android.tools.lint.client.api.ClassEntry;
import com.android.tools.lint.client.api.CompositeIssueRegistry;
import com.android.tools.lint.client.api.Configuration;
import com.android.tools.lint.client.api.DefaultConfiguration;
import com.android.tools.lint.client.api.DefaultSdkInfo;
import com.android.tools.lint.client.api.IssueRegistry;
import com.android.tools.lint.client.api.JarFileIssueRegistry;
import com.android.tools.lint.client.api.JavaParser;
import com.android.tools.lint.client.api.LintDriver;
import com.android.tools.lint.client.api.SdkInfo;
import com.android.tools.lint.client.api.UastParser;
import com.android.tools.lint.client.api.XmlParser;
import com.android.tools.lint.detector.api.Context;
import com.android.tools.lint.detector.api.Detector;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.LintFix;
import com.android.tools.lint.detector.api.LintUtils;
import com.android.tools.lint.detector.api.Location;
import com.android.tools.lint.detector.api.Project;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.TextFormat;
import com.android.utils.CharSequences;
import com.android.utils.Pair;
import com.android.utils.XmlUtils;
import com.google.common.annotations.Beta;
import com.google.common.base.Charsets;
import com.google.common.base.Splitter;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.common.io.Files;
import java.io.File;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLClassLoader;
import java.net.URLConnection;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.ReplaceWith;
import kotlin.TypeCastException;
import kotlin._Assertions;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.IntProgression;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

@Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=1, d1={"\u0000\u00d2\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u001e\n\u0002\b\u0003\n\u0002\u0010#\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0003\n\u0002\b\u000e\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\r\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\b'\u0018\u0000 \u00b4\u00012\u00020\u0001:\u0006\u00b3\u0001\u00b4\u0001\u00b5\u0001B\u000f\b\u0014\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B\u0007\b\u0014\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010-\u001a\u00020.2\u0006\u0010/\u001a\u00020.H\u0016J\b\u00100\u001a\u000201H\u0016J\u0010\u00102\u001a\u0002032\u0006\u00104\u001a\u000205H\u0016J\u0018\u00106\u001a\u00020\t2\u0006\u00107\u001a\u00020\b2\u0006\u00108\u001a\u00020\bH\u0014J\u0010\u00109\u001a\u00020:2\u0006\u0010;\u001a\u00020<H\u0016J\u001c\u0010=\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030>2\u0006\u0010?\u001a\u00020\tH\u0016J#\u0010@\u001a\u00020A2\f\u0010B\u001a\b\u0012\u0004\u0012\u00020C0&2\u0006\u0010D\u001a\u00020AH\u0016\u00a2\u0006\u0002\u0010EJ\u0016\u0010F\u001a\u0002032\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\t0\u0011H\u0014J\u000e\u0010G\u001a\b\u0012\u0004\u0012\u00020\b0HH\u0016J\u0012\u0010I\u001a\u0004\u0018\u00010J2\u0006\u0010K\u001a\u00020\"H\u0016J\u001e\u0010L\u001a\u0010\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\"\u0018\u00010#2\u0006\u0010K\u001a\u00020\"H\u0016J\u0012\u0010M\u001a\u0004\u0018\u00010\b2\u0006\u0010N\u001a\u00020\u0003H\u0016J\u0016\u0010O\u001a\b\u0012\u0004\u0012\u00020\b0H2\u0006\u0010?\u001a\u00020\tH\u0016J\u0016\u0010P\u001a\b\u0012\u0004\u0012\u00020\b0H2\u0006\u0010?\u001a\u00020\tH\u0016J\u0012\u0010Q\u001a\u0004\u0018\u00010R2\u0006\u0010?\u001a\u00020\tH\u0016J\u0012\u0010S\u001a\u0004\u0018\u00010\b2\u0006\u0010T\u001a\u000201H\u0017J\u001c\u0010S\u001a\u0004\u0018\u00010\b2\b\u0010U\u001a\u0004\u0018\u00010\u00032\u0006\u0010T\u001a\u000201H\u0016J\u0010\u0010V\u001a\u00020\u00192\u0006\u0010?\u001a\u00020\tH\u0014J\n\u0010W\u001a\u0004\u0018\u00010\u0003H\u0016J\u0012\u0010X\u001a\u0004\u0018\u00010'2\u0006\u0010?\u001a\u00020\tH\u0016J\u001a\u0010Y\u001a\u00020Z2\u0006\u0010?\u001a\u00020\t2\b\u0010[\u001a\u0004\u0018\u00010\\H\u0016J\u0010\u0010]\u001a\u00020\u00032\u0006\u0010^\u001a\u00020\bH\u0016J\u0016\u0010_\u001a\b\u0012\u0004\u0012\u00020\b0H2\u0006\u0010?\u001a\u00020\tH\u0016J\u0016\u0010`\u001a\b\u0012\u0004\u0012\u00020\b0H2\u0006\u0010?\u001a\u00020\tH\u0016J\u001e\u0010a\u001a\b\u0012\u0004\u0012\u00020\b0H2\u0006\u0010?\u001a\u00020\t2\u0006\u0010b\u001a\u000201H\u0016J\u0014\u0010c\u001a\u0004\u0018\u00010d2\b\u0010?\u001a\u0004\u0018\u00010\tH&J\u0016\u0010e\u001a\b\u0012\u0004\u0012\u00020\b0H2\u0006\u0010?\u001a\u00020\tH\u0016J\u0012\u0010f\u001a\u0004\u0018\u00010g2\u0006\u0010?\u001a\u00020\tH\u0016J\u0018\u0010h\u001a\u00020\t2\u0006\u00107\u001a\u00020\b2\u0006\u00108\u001a\u00020\bH\u0016J\u0010\u0010i\u001a\u00020\u00032\u0006\u0010?\u001a\u00020\tH\u0016J\u001a\u0010j\u001a\u0004\u0018\u00010k2\u0006\u0010?\u001a\u00020\t2\u0006\u0010l\u001a\u000201H\u0017J\b\u0010m\u001a\u00020nH\u0016J\u0016\u0010o\u001a\b\u0012\u0004\u0012\u00020\b0H2\u0006\u0010?\u001a\u00020\tH\u0016J\"\u0010p\u001a\u0004\u0018\u00010k2\u0006\u0010?\u001a\u00020\t2\u0006\u0010q\u001a\u0002012\u0006\u0010r\u001a\u000201H\u0016J\b\u0010s\u001a\u00020\u001eH\u0016J\n\u0010t\u001a\u0004\u0018\u00010 H\u0016J\n\u0010u\u001a\u0004\u0018\u00010\bH\u0016J\u0010\u0010v\u001a\u00020w2\u0006\u0010?\u001a\u00020\tH\u0016J\u001a\u0010x\u001a\u0004\u0018\u00010\u00032\u0006\u0010?\u001a\u00020\t2\u0006\u0010U\u001a\u00020\u0003H\u0016J\u0013\u0010y\u001a\b\u0012\u0004\u0012\u00020'0&H\u0016\u00a2\u0006\u0002\u0010zJ\u0016\u0010{\u001a\b\u0012\u0004\u0012\u00020\b0H2\u0006\u0010?\u001a\u00020\tH\u0016J\u0016\u0010|\u001a\b\u0012\u0004\u0012\u00020\b0H2\u0006\u0010?\u001a\u00020\tH\u0016J\u0014\u0010}\u001a\u0004\u0018\u00010~2\b\u0010?\u001a\u0004\u0018\u00010\tH&J\u0016\u0010\u007f\u001a\u0002032\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\t0\u0011H\u0014J\u0011\u0010\u0080\u0001\u001a\u0002012\u0006\u0010?\u001a\u00020\tH\u0016J\u0010\u0010\u0081\u0001\u001a\u0002012\u0007\u0010\u0082\u0001\u001a\u00020\"J\u0011\u0010\u0083\u0001\u001a\u0002012\u0006\u00107\u001a\u00020\bH\u0016J*\u0010\u0084\u0001\u001a\u0004\u0018\u0001012\u0006\u0010?\u001a\u00020\t2\u0006\u0010U\u001a\u00020\u00032\u0007\u0010\u0085\u0001\u001a\u00020\u0003H\u0016\u00a2\u0006\u0003\u0010\u0086\u0001JE\u0010\u0087\u0001\u001a\u0002032\b\u0010\u0088\u0001\u001a\u00030\u0089\u00012\n\u0010\u008a\u0001\u001a\u0005\u0018\u00010\u008b\u00012\t\u0010\u008c\u0001\u001a\u0004\u0018\u00010\u00032\u0013\u0010\u008d\u0001\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00010&\"\u00020\u0001H&\u00a2\u0006\u0003\u0010\u008e\u0001J;\u0010\u0087\u0001\u001a\u0002032\n\u0010\u008a\u0001\u001a\u0005\u0018\u00010\u008b\u00012\t\u0010\u008c\u0001\u001a\u0004\u0018\u00010\u00032\u0013\u0010\u008d\u0001\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00010&\"\u00020\u0001H\u0016\u00a2\u0006\u0003\u0010\u008f\u0001J\u0014\u0010\u0090\u0001\u001a\u0004\u0018\u0001052\u0007\u0010\u0091\u0001\u001a\u00020CH\u0017J\u001d\u0010\u0090\u0001\u001a\u0004\u0018\u0001052\u0007\u0010\u0091\u0001\u001a\u00020C2\u0007\u0010\u0092\u0001\u001a\u00020\rH\u0017J\u001d\u0010\u0093\u0001\u001a\u0002032\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\t0\u0011H\u0000\u00a2\u0006\u0003\b\u0094\u0001J\u0017\u0010\u0095\u0001\u001a\u00020\u00192\u0006\u0010?\u001a\u00020\tH\u0000\u00a2\u0006\u0003\b\u0096\u0001J\u001d\u0010\u0097\u0001\u001a\u0002032\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\t0\u0011H\u0000\u00a2\u0006\u0003\b\u0098\u0001J\u0012\u0010\u0099\u0001\u001a\u00030\u009a\u00012\u0006\u0010^\u001a\u00020\bH\u0017J\u0012\u0010\u009b\u0001\u001a\u00030\u009c\u00012\u0006\u0010^\u001a\u00020\bH&J\u0019\u0010\u009d\u0001\u001a\u0002032\u0006\u00107\u001a\u00020\b2\u0006\u0010?\u001a\u00020\tH\u0016J&\u0010\u009e\u0001\u001a\f\u0012\u0007\b\u0001\u0012\u00030\u00a0\u00010\u009f\u00012\u0011\u0010\u00a1\u0001\u001a\f\u0012\u0007\b\u0001\u0012\u00030\u00a0\u00010\u009f\u0001H\u0016JO\u0010\u00a2\u0001\u001a\u0002032\b\u0010\u00a3\u0001\u001a\u00030\u00a4\u00012\b\u0010\u00a5\u0001\u001a\u00030\u00a6\u00012\b\u0010\u0088\u0001\u001a\u00030\u0089\u00012\u0007\u0010\u00a7\u0001\u001a\u00020J2\u0007\u0010\u00a8\u0001\u001a\u00020\u00032\b\u0010\u008c\u0001\u001a\u00030\u00a9\u00012\n\u0010\u00aa\u0001\u001a\u0005\u0018\u00010\u00ab\u0001H&J\u001b\u0010\u00ac\u0001\u001a\u0002032\u0007\u0010\u00ad\u0001\u001a\u00020g2\u0007\u0010\u00ae\u0001\u001a\u00020\u0001H\u0016J\u0013\u0010\u00af\u0001\u001a\u0002032\b\u0010\u00b0\u0001\u001a\u00030\u00b1\u0001H\u0016J\t\u0010\u00b2\u0001\u001a\u000201H\u0016R \u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0007X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\f\u001a\u00020\r8F\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000fR\u0017\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\t0\u00118F\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013R\u001a\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\b0\u0015X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u001a\u0010\u0018\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\u00190\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\u001a\u001a\u000e\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\u001b0\u0007X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u000bR\u0010\u0010\u001d\u001a\u0004\u0018\u00010\u001eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001f\u001a\u0004\u0018\u00010 X\u0082\u000e\u00a2\u0006\u0002\n\u0000R,\u0010!\u001a\u001a\u0012\u0004\u0012\u00020\"\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\"0#0\u0007X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b$\u0010\u000bR\u0018\u0010%\u001a\n\u0012\u0004\u0012\u00020'\u0018\u00010&X\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010(R\u0012\u0010)\u001a\u00020*X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b+\u0010,\u00a8\u0006\u00b6\u0001"}, d2={"Lcom/android/tools/lint/client/api/LintClient;", "", "clientName", "", "(Ljava/lang/String;)V", "()V", "dirToProject", "", "Ljava/io/File;", "Lcom/android/tools/lint/detector/api/Project;", "getDirToProject", "()Ljava/util/Map;", "highestKnownApiLevel", "", "getHighestKnownApiLevel", "()I", "knownProjects", "", "getKnownProjects", "()Ljava/util/Collection;", "projectDirs", "", "getProjectDirs", "()Ljava/util/Set;", "projectInfo", "Lcom/android/tools/lint/client/api/LintClient$ClassPathInfo;", "reportFileCache", "Lcom/android/tools/lint/client/api/BlameFile;", "getReportFileCache", "resourceVisibilityProvider", "Lcom/android/ide/common/repository/ResourceVisibilityLookup$Provider;", "sdk", "Lcom/android/sdklib/repository/AndroidSdkHandler;", "sourceNodeCache", "Lorg/w3c/dom/Node;", "Lcom/android/utils/Pair;", "getSourceNodeCache", "targets", "", "Lcom/android/sdklib/IAndroidTarget;", "[Lcom/android/sdklib/IAndroidTarget;", "xmlParser", "Lcom/android/tools/lint/client/api/XmlParser;", "getXmlParser", "()Lcom/android/tools/lint/client/api/XmlParser;", "addCustomLintRules", "Lcom/android/tools/lint/client/api/IssueRegistry;", "registry", "checkForSuppressComments", "", "closeConnection", "", "connection", "Ljava/net/URLConnection;", "createProject", "dir", "referenceDir", "createResourceItemHandle", "Lcom/android/tools/lint/detector/api/Location$Handle;", "item", "Lcom/android/ide/common/res2/ResourceItem;", "createSuperClassMap", "", "project", "createUrlClassLoader", "Ljava/lang/ClassLoader;", "urls", "Ljava/net/URL;", "parent", "([Ljava/net/URL;Ljava/lang/ClassLoader;)Ljava/lang/ClassLoader;", "disposeProjects", "findGlobalRuleJars", "", "findManifestSourceLocation", "Lcom/android/tools/lint/detector/api/Location;", "mergedNode", "findManifestSourceNode", "findResource", "relativePath", "findRuleJars", "getAssetFolders", "getBuildTools", "Lcom/android/sdklib/BuildToolInfo;", "getCacheDir", "create", "name", "getClassPath", "getClientRevision", "getCompileTarget", "getConfiguration", "Lcom/android/tools/lint/client/api/Configuration;", "driver", "Lcom/android/tools/lint/client/api/LintDriver;", "getDisplayPath", "file", "getGeneratedSourceFolders", "getJavaClassFolders", "getJavaLibraries", "includeProvided", "getJavaParser", "Lcom/android/tools/lint/client/api/JavaParser;", "getJavaSourceFolders", "getMergedManifest", "Lorg/w3c/dom/Document;", "getProject", "getProjectName", "getProjectResources", "Lcom/android/ide/common/res2/AbstractResourceRepository;", "includeDependencies", "getRepositoryLogger", "Lcom/android/repository/api/ProgressIndicator;", "getResourceFolders", "getResourceRepository", "includeModuleDependencies", "includeLibraries", "getResourceVisibilityProvider", "getSdk", "getSdkHome", "getSdkInfo", "Lcom/android/tools/lint/client/api/SdkInfo;", "getSuperClass", "getTargets", "()[Lcom/android/sdklib/IAndroidTarget;", "getTestLibraries", "getTestSourceFolders", "getUastParser", "Lcom/android/tools/lint/client/api/UastParser;", "initializeProjects", "isGradleProject", "isMergeManifestNode", "node", "isProjectDirectory", "isSubclassOf", "superClassName", "(Lcom/android/tools/lint/detector/api/Project;Ljava/lang/String;Ljava/lang/String;)Ljava/lang/Boolean;", "log", "severity", "Lcom/android/tools/lint/detector/api/Severity;", "exception", "", "format", "args", "(Lcom/android/tools/lint/detector/api/Severity;Ljava/lang/Throwable;Ljava/lang/String;[Ljava/lang/Object;)V", "(Ljava/lang/Throwable;Ljava/lang/String;[Ljava/lang/Object;)V", "openConnection", "url", "timeout", "performDisposeProjects", "performDisposeProjects$lint_api_main", "performGetClassPath", "performGetClassPath$lint_api_main", "performInitializeProjects", "performInitializeProjects$lint_api_main", "readBytes", "", "readFile", "", "registerProject", "replaceDetector", "Ljava/lang/Class;", "Lcom/android/tools/lint/detector/api/Detector;", "detectorClass", "report", "context", "Lcom/android/tools/lint/detector/api/Context;", "issue", "Lcom/android/tools/lint/detector/api/Issue;", "location", "message", "Lcom/android/tools/lint/detector/api/TextFormat;", "fix", "Lcom/android/tools/lint/detector/api/LintFix;", "resolveMergeManifestSources", "mergedManifest", "reportFile", "runReadAction", "runnable", "Ljava/lang/Runnable;", "supportsProjectResources", "ClassPathInfo", "Companion", "RepoLogger", "lint-api_main"})
@Beta
public abstract class LintClient {
    private final Map<Project, ClassPathInfo> projectInfo;
    @NotNull
    private final Map<File, Project> dirToProject;
    @NotNull
    private final Set<File> projectDirs;
    private IAndroidTarget[] targets;
    private AndroidSdkHandler sdk;
    @NotNull
    private final Map<Object, BlameFile> reportFileCache;
    @NotNull
    private final Map<Node, Pair<File, Node>> sourceNodeCache;
    private ResourceVisibilityLookup.Provider resourceVisibilityProvider;
    private static final String PROP_BIN_DIR = "com.android.tools.lint.bindir";
    private static final int SDK_DATABASE_MIN_VERSION = 26;
    private static final String MERGED_MANIFEST = "lint-merged-manifest";
    @JvmField
    @NotNull
    protected static final Pair<File, Node> NOT_FOUND;
    @JvmField
    @NotNull
    public static final String CLIENT_STUDIO = "studio";
    @JvmField
    @NotNull
    public static final String CLIENT_GRADLE = "gradle";
    @JvmField
    @NotNull
    public static final String CLIENT_CLI = "cli";
    @JvmField
    @NotNull
    public static final String CLIENT_UNKNOWN = "unknown";
    @NotNull
    private static String clientName;
    public static final Companion Companion;

    @NotNull
    public Configuration getConfiguration(@NotNull Project project, @Nullable LintDriver driver) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        DefaultConfiguration defaultConfiguration = DefaultConfiguration.create(this, project, null);
        Intrinsics.checkExpressionValueIsNotNull((Object)defaultConfiguration, (String)"DefaultConfiguration.create(this, project, null)");
        return defaultConfiguration;
    }

    public abstract void report(@NotNull Context var1, @NotNull Issue var2, @NotNull Severity var3, @NotNull Location var4, @NotNull String var5, @NotNull TextFormat var6, @Nullable LintFix var7);

    public void log(@Nullable Throwable exception, @Nullable String format, Object ... args) {
        Intrinsics.checkParameterIsNotNull((Object)args, (String)"args");
        this.log(Severity.WARNING, exception, format, Arrays.copyOf(args, args.length));
    }

    public abstract void log(@NotNull Severity var1, @Nullable Throwable var2, @Nullable String var3, Object ... var4);

    @NotNull
    public abstract XmlParser getXmlParser();

    @Nullable
    public abstract JavaParser getJavaParser(@Nullable Project var1);

    @Nullable
    public abstract UastParser getUastParser(@Nullable Project var1);

    @NotNull
    public Class<? extends Detector> replaceDetector(@NotNull Class<? extends Detector> detectorClass) {
        Intrinsics.checkParameterIsNotNull(detectorClass, (String)"detectorClass");
        return detectorClass;
    }

    @NotNull
    public abstract CharSequence readFile(@NotNull File var1);

    @NotNull
    public byte[] readBytes(@NotNull File file) throws IOException {
        Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
        byte[] byArray = Files.toByteArray((File)file);
        Intrinsics.checkExpressionValueIsNotNull((Object)byArray, (String)"Files.toByteArray(file)");
        return byArray;
    }

    @NotNull
    public List<File> getJavaSourceFolders(@NotNull Project project) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        return this.getClassPath(project).getSourceFolders();
    }

    @NotNull
    public List<File> getGeneratedSourceFolders(@NotNull Project project) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        return this.getClassPath(project).getGeneratedFolders();
    }

    @NotNull
    public List<File> getJavaClassFolders(@NotNull Project project) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        return this.getClassPath(project).getClassFolders();
    }

    @NotNull
    public List<File> getJavaLibraries(@NotNull Project project, boolean includeProvided) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        return this.getClassPath(project).getLibraries(includeProvided);
    }

    @NotNull
    public List<File> getTestSourceFolders(@NotNull Project project) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        return this.getClassPath(project).getTestSourceFolders();
    }

    @NotNull
    public List<File> getTestLibraries(@NotNull Project project) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        return this.getClassPath(project).getTestLibraries();
    }

    @NotNull
    public List<File> getResourceFolders(@NotNull Project project) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        File res = new File(project.getDir(), "res");
        if (res.exists()) {
            return CollectionsKt.listOf((Object)res);
        }
        return CollectionsKt.emptyList();
    }

    @NotNull
    public List<File> getAssetFolders(@NotNull Project project) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        File assets = new File(project.getDir(), "assets");
        if (assets.exists()) {
            return CollectionsKt.listOf((Object)assets);
        }
        return CollectionsKt.emptyList();
    }

    @NotNull
    public SdkInfo getSdkInfo(@NotNull Project project) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        return new DefaultSdkInfo();
    }

    @Deprecated(message="Use {@link #getCacheDir(String, boolean)} instead", replaceWith=@ReplaceWith(expression="getCacheDir(null, create)", imports={}))
    @Nullable
    public File getCacheDir(boolean create) {
        return this.getCacheDir(null, create);
    }

    @Nullable
    public File getCacheDir(@Nullable String name, boolean create) {
        String path = System.getenv("ANDROID_SDK_CACHE_DIR");
        if (path != null) {
            if (name != null) {
                path = path + File.separator + name;
            }
            File dir = new File(path);
            if (create && !dir.exists() && !dir.mkdirs()) {
                return null;
            }
            return dir;
        }
        String home = System.getProperty("user.home");
        String relative = ".android" + File.separator + "cache";
        if (name != null) {
            relative = relative + File.separator + name;
        }
        File dir = new File(home, relative);
        if (create && !dir.exists() && !dir.mkdirs()) {
            return null;
        }
        return dir;
    }

    @Nullable
    public File getSdkHome() {
        File binDir = LintClient.Companion.getLintBinDir();
        if (binDir != null) {
            boolean bl = Intrinsics.areEqual((Object)binDir.getName(), (Object)"tools");
            if (_Assertions.ENABLED && !bl) {
                String string = "Assertion failed";
                throw (Throwable)((Object)new AssertionError((Object)string));
            }
            File root = binDir.getParentFile();
            if (root != null && root.isDirectory()) {
                return root;
            }
        }
        String string = System.getenv("ANDROID_HOME");
        if (string == null) {
            return null;
        }
        String home = string;
        return new File(home);
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public File findResource(@NotNull String relativePath) {
        Intrinsics.checkParameterIsNotNull((Object)relativePath, (String)"relativePath");
        File file = this.getSdkHome();
        if (file == null) {
            throw (Throwable)new IllegalArgumentException("Lint must be invoked with $ANDROID_HOME set to point to the SDK, or the System property " + LintClient.Companion.getPROP_BIN_DIR() + " pointing to the ANDROID_SDK tools directory");
        }
        File top = file;
        boolean isAnnotationZip = Intrinsics.areEqual((Object)"annotations.zip", (Object)relativePath);
        boolean isApiDatabase = Intrinsics.areEqual((Object)"api-versions.xml", (Object)relativePath);
        if (isAnnotationZip || isApiDatabase) {
            String build;
            File file2;
            File file222;
            String path;
            if (isAnnotationZip && (path = System.getenv("SDK_ANNOTATIONS")) != null && (file222 = new File(path)).exists()) {
                return file222;
            }
            IAndroidTarget[] targets = this.getTargets();
            IntProgression intProgression = RangesKt.reversed((IntProgression)((IntProgression)ArraysKt.getIndices((Object[])targets)));
            int file222 = intProgression.getFirst();
            int n = intProgression.getLast();
            int n2 = intProgression.getStep();
            int n3 = file222;
            int n4 = n;
            if (n2 > 0 ? n3 <= n4 : n3 >= n4) {
                while (true) {
                    File file3;
                    void i;
                    IAndroidTarget target;
                    if ((target = targets[i]).isPlatform() && target.getVersion().getFeatureLevel() >= 26 && (file3 = new File(target.getFile(7), relativePath)).isFile()) {
                        return file3;
                    }
                    if (i == n) break;
                    i += n2;
                }
            }
            if ((file2 = new File(top, "platform-tools" + File.separator + "api" + File.separator + relativePath)).exists()) {
                return file2;
            }
            if (isApiDatabase && (build = System.getenv("ANDROID_BUILD_TOP")) != null && (file2 = new File(build, StringsKt.replace$default((String)"development/sdk/api-versions.xml", (char)'/', (char)File.separatorChar, (boolean)false, (int)4, null))).exists()) {
                return file2;
            }
            return null;
        }
        File file4 = new File(top, relativePath);
        if (file4.exists()) {
            return file4;
        }
        return null;
    }

    public boolean isGradleProject(@NotNull Project project) {
        File root;
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        if (new File(project.getDir(), "build.gradle").exists()) {
            return true;
        }
        File parent = project.getDir().getParentFile();
        return parent != null && Intrinsics.areEqual((Object)parent.getName(), (Object)"src") && (root = parent.getParentFile()) != null && new File(root, "build.gradle").exists();
    }

    @NotNull
    protected ClassPathInfo getClassPath(@NotNull Project project) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        ClassPathInfo info = this.projectInfo.get(project);
        if (info == null) {
            File[] jars;
            File libs;
            int i;
            CharSequence classpathXml;
            Document document;
            ArrayList<File> sources = new ArrayList<File>(2);
            ArrayList<File> classes = new ArrayList<File>(1);
            ArrayList<File> generated = new ArrayList<File>(1);
            ArrayList<File> libraries = new ArrayList<File>();
            List tests = CollectionsKt.emptyList();
            File projectDir = project.getDir();
            File classpathFile = new File(projectDir, ".classpath");
            if (classpathFile.exists() && (document = CharSequences.parseDocumentSilently((CharSequence)(classpathXml = this.readFile(classpathFile)), (boolean)false)) != null) {
                NodeList tags = document.getElementsByTagName("classpathentry");
                int n = tags.getLength();
                for (i = 0; i < n; ++i) {
                    String path;
                    File folder;
                    Node node = tags.item(i);
                    if (node == null) {
                        throw new TypeCastException("null cannot be cast to non-null type org.w3c.dom.Element");
                    }
                    Element element = (Element)node;
                    String kind = element.getAttribute("kind");
                    List addTo = null;
                    if (Intrinsics.areEqual((Object)kind, (Object)"src")) {
                        addTo = sources;
                    } else if (Intrinsics.areEqual((Object)kind, (Object)"output")) {
                        addTo = classes;
                    } else if (Intrinsics.areEqual((Object)kind, (Object)"lib")) {
                        addTo = libraries;
                    }
                    if (addTo == null || !(folder = new File(projectDir, path = element.getAttribute("path"))).exists()) continue;
                    addTo.add(folder);
                }
            }
            if ((libs = new File(project.getDir(), "libs")).isDirectory() && (jars = libs.listFiles()) != null) {
                for (i = 0; i < jars.length; ++i) {
                    File jar = jars[i];
                    if (!LintUtils.endsWith(jar.getPath(), ".jar") || libraries.contains(jar)) continue;
                    libraries.add(jar);
                }
            }
            if (classes.isEmpty()) {
                File folder = new File(projectDir, SdkConstants.CLASS_FOLDER);
                if (folder.exists()) {
                    classes.add(folder);
                } else {
                    folder = new File(projectDir, "target" + File.separator + "classes");
                    if (folder.exists()) {
                        classes.add(folder);
                        if (sources.isEmpty()) {
                            File src = new File(projectDir, "src" + File.separator + "main" + File.separator + "java");
                            if (src.exists()) {
                                sources.add(src);
                            } else {
                                src = new File(projectDir, "src");
                                if (src.exists()) {
                                    sources.add(src);
                                }
                            }
                            File gen = new File(projectDir, "target" + File.separator + "generated-sources" + File.separator + "r");
                            if (gen.exists()) {
                                generated.add(gen);
                            }
                        }
                    }
                }
            }
            if (sources.isEmpty()) {
                File gen;
                File src = new File(projectDir, "src");
                if (src.exists()) {
                    sources.add(src);
                }
                if ((gen = new File(projectDir, "gen")).exists()) {
                    generated.add(gen);
                }
            }
            info = new ClassPathInfo((List<? extends File>)sources, (List<? extends File>)classes, (List<? extends File>)libraries, (List<? extends File>)libraries, tests, CollectionsKt.emptyList(), (List<? extends File>)generated);
            this.projectInfo.put(project, info);
        }
        return info;
    }

    @NotNull
    protected final Map<File, Project> getDirToProject() {
        return this.dirToProject;
    }

    @NotNull
    public Project getProject(@NotNull File dir, @NotNull File referenceDir) {
        File file;
        Intrinsics.checkParameterIsNotNull((Object)dir, (String)"dir");
        Intrinsics.checkParameterIsNotNull((Object)referenceDir, (String)"referenceDir");
        try {
            file = dir.getCanonicalFile();
        }
        catch (IOException ioe) {
            file = dir;
        }
        File canonicalDir = file;
        Project existingProject = this.dirToProject.get(canonicalDir);
        if (existingProject != null) {
            return existingProject;
        }
        Project project = this.createProject(dir, referenceDir);
        File file2 = canonicalDir;
        Intrinsics.checkExpressionValueIsNotNull((Object)file2, (String)"canonicalDir");
        this.dirToProject.put(file2, project);
        return project;
    }

    @NotNull
    public final Collection<Project> getKnownProjects() {
        return this.dirToProject.values();
    }

    public void registerProject(@NotNull File dir, @NotNull Project project) {
        boolean bl;
        File file;
        Intrinsics.checkParameterIsNotNull((Object)dir, (String)"dir");
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        try {
            file = dir.getCanonicalFile();
        }
        catch (IOException ioe) {
            file = dir;
        }
        File canonicalDir = file;
        boolean bl2 = bl = !this.dirToProject.containsKey(dir);
        if (_Assertions.ENABLED && !bl) {
            File file2 = dir;
            throw (Throwable)((Object)new AssertionError(file2));
        }
        File file3 = canonicalDir;
        Intrinsics.checkExpressionValueIsNotNull((Object)file3, (String)"canonicalDir");
        this.dirToProject.put(file3, project);
    }

    @NotNull
    protected final Set<File> getProjectDirs() {
        return this.projectDirs;
    }

    @NotNull
    protected Project createProject(@NotNull File dir, @NotNull File referenceDir) {
        Intrinsics.checkParameterIsNotNull((Object)dir, (String)"dir");
        Intrinsics.checkParameterIsNotNull((Object)referenceDir, (String)"referenceDir");
        if (this.projectDirs.contains(dir)) {
            throw (Throwable)new CircularDependencyException("Circular library dependencies; check your project.properties files carefully");
        }
        this.projectDirs.add(dir);
        Project project = Project.create(this, dir, referenceDir);
        Intrinsics.checkExpressionValueIsNotNull((Object)project, (String)"Project.create(this, dir, referenceDir)");
        return project;
    }

    protected void initializeProjects(@NotNull Collection<? extends Project> knownProjects) {
        Intrinsics.checkParameterIsNotNull(knownProjects, (String)"knownProjects");
    }

    protected void disposeProjects(@NotNull Collection<? extends Project> knownProjects) {
        Intrinsics.checkParameterIsNotNull(knownProjects, (String)"knownProjects");
    }

    @NotNull
    public final ClassPathInfo performGetClassPath$lint_api_main(@NotNull Project project) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        return this.getClassPath(project);
    }

    public final void performInitializeProjects$lint_api_main(@NotNull Collection<? extends Project> knownProjects) {
        Intrinsics.checkParameterIsNotNull(knownProjects, (String)"knownProjects");
        this.initializeProjects(knownProjects);
    }

    public final void performDisposeProjects$lint_api_main(@NotNull Collection<? extends Project> knownProjects) {
        Intrinsics.checkParameterIsNotNull(knownProjects, (String)"knownProjects");
        this.disposeProjects(knownProjects);
    }

    @NotNull
    public String getProjectName(@NotNull Project project) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        String string = project.getDir().getName();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"project.dir.name");
        return string;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public IAndroidTarget[] getTargets() {
        if (this.targets == null) {
            AndroidSdkHandler sdkHandler = this.getSdk();
            if (sdkHandler != null) {
                void $receiver$iv;
                Collection targets;
                ProgressIndicator logger = this.getRepositoryLogger();
                Collection collection = targets = sdkHandler.getAndroidTargetManager(logger).getTargets(logger);
                LintClient lintClient = this;
                void v0 = $receiver$iv;
                if (v0 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type java.util.Collection<T>");
                }
                void thisCollection$iv = v0;
                IAndroidTarget[] iAndroidTargetArray = thisCollection$iv.toArray(new IAndroidTarget[thisCollection$iv.size()]);
                if (iAndroidTargetArray == null) {
                    throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<T>");
                }
                IAndroidTarget[] iAndroidTargetArray2 = iAndroidTargetArray;
                lintClient.targets = iAndroidTargetArray2;
            } else {
                LintClient lintClient = this;
                IAndroidTarget[] iAndroidTargetArray = new IAndroidTarget[]{};
                lintClient.targets = iAndroidTargetArray;
            }
        }
        if (this.targets == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<com.android.sdklib.IAndroidTarget>");
        }
        return this.targets;
    }

    @Nullable
    public AndroidSdkHandler getSdk() {
        if (this.sdk == null) {
            this.sdk = AndroidSdkHandler.getInstance((File)this.getSdkHome());
        }
        return this.sdk;
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public IAndroidTarget getCompileTarget(@NotNull Project project) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        String compileSdkVersion = project.getBuildTargetHash();
        if (compileSdkVersion != null) {
            AndroidTargetManager manager;
            IAndroidTarget target;
            ProgressIndicator logger = this.getRepositoryLogger();
            AndroidSdkHandler handler = this.getSdk();
            if (handler != null && (target = (manager = handler.getAndroidTargetManager(logger)).getTargetFromHashString(compileSdkVersion, logger)) != null) {
                return target;
            }
        }
        int buildSdk = project.getBuildSdk();
        IAndroidTarget[] targets = this.getTargets();
        IntProgression intProgression = RangesKt.reversed((IntProgression)((IntProgression)ArraysKt.getIndices((Object[])targets)));
        int manager = intProgression.getFirst();
        int n = intProgression.getLast();
        int n2 = intProgression.getStep();
        int n3 = manager;
        int n4 = n;
        if (n2 > 0 ? n3 <= n4 : n3 >= n4) {
            while (true) {
                void i;
                IAndroidTarget target;
                if ((target = targets[i]).isPlatform() && target.getVersion().getApiLevel() == buildSdk) {
                    return target;
                }
                if (i == n) break;
                i += n2;
            }
        }
        return null;
    }

    public final int getHighestKnownApiLevel() {
        int max = 26;
        IAndroidTarget[] iAndroidTargetArray = this.getTargets();
        for (int i = 0; i < iAndroidTargetArray.length; ++i) {
            int api;
            IAndroidTarget target = iAndroidTargetArray[i];
            if (!target.isPlatform() || (api = target.getVersion().getApiLevel()) <= max || target.getVersion().isPreview()) continue;
            max = api;
        }
        return max;
    }

    @Nullable
    public BuildToolInfo getBuildTools(@NotNull Project project) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        AndroidSdkHandler sdk = this.getSdk();
        if (sdk != null) {
            IAndroidTarget compileTarget = this.getCompileTarget(project);
            if (compileTarget != null) {
                return compileTarget.getBuildToolInfo();
            }
            return sdk.getLatestBuildTool(this.getRepositoryLogger(), false);
        }
        return null;
    }

    @Nullable
    public String getSuperClass(@NotNull Project project, @NotNull String name) {
        boolean bl;
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
        boolean bl2 = bl = StringsKt.indexOf$default((CharSequence)name, (char)'.', (int)0, (boolean)false, (int)6, null) == -1;
        if (_Assertions.ENABLED && !bl) {
            String string = "Use VM signatures, e.g. java/lang/Integer";
            throw (Throwable)((Object)new AssertionError((Object)string));
        }
        if (Intrinsics.areEqual((Object)"java/lang/Object", (Object)name)) {
            return null;
        }
        String superClass = project.getSuperClassMap().get(name);
        if (superClass != null) {
            return superClass;
        }
        for (Project library : project.getAllLibraries()) {
            String librarySuperClass = library.getSuperClassMap().get(name);
            if (librarySuperClass == null) continue;
            return librarySuperClass;
        }
        return null;
    }

    @NotNull
    public Map<String, String> createSuperClassMap(@NotNull Project project) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        List<File> libraries = project.getJavaLibraries(true);
        List<File> classFolders = project.getJavaClassFolders();
        List<ClassEntry> classEntries = ClassEntry.fromClassPath(this, classFolders, true);
        if (libraries.isEmpty()) {
            Map<String, String> map = ClassEntry.createSuperClassMap(this, classEntries);
            Intrinsics.checkExpressionValueIsNotNull(map, (String)"ClassEntry.createSuperClassMap(this, classEntries)");
            return map;
        }
        List<ClassEntry> libraryEntries = ClassEntry.fromClassPath(this, libraries, true);
        Map<String, String> map = ClassEntry.createSuperClassMap(this, libraryEntries, classEntries);
        Intrinsics.checkExpressionValueIsNotNull(map, (String)"ClassEntry.createSuperCl\u2026aryEntries, classEntries)");
        return map;
    }

    @Nullable
    public Boolean isSubclassOf(@NotNull Project project, @NotNull String name, @NotNull String superClassName) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
        Intrinsics.checkParameterIsNotNull((Object)superClassName, (String)"superClassName");
        return null;
    }

    @NotNull
    public List<File> findGlobalRuleJars() {
        String lintClassPath;
        Object lint;
        List files = null;
        try {
            File[] list;
            String androidHome = AndroidLocation.getFolder();
            lint = new File(androidHome + File.separator + "lint");
            if (((File)lint).exists() && (list = ((File)lint).listFiles()) != null) {
                for (int i = 0; i < list.length; ++i) {
                    File jarFile = list[i];
                    if (!LintUtils.endsWith(jarFile.getName(), ".jar")) continue;
                    if (files == null) {
                        files = new ArrayList();
                    }
                    File file = jarFile;
                    Intrinsics.checkExpressionValueIsNotNull((Object)file, (String)"jarFile");
                    files.add(file);
                }
            }
        }
        catch (AndroidLocation.AndroidLocationException androidHome) {
            // empty catch block
        }
        if ((lintClassPath = System.getenv("ANDROID_LINT_JARS")) != null && !((lint = (CharSequence)lintClassPath).length() == 0)) {
            CharSequence charSequence = lintClassPath;
            String[] stringArray = new String[1];
            String string = File.pathSeparator;
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"File.pathSeparator");
            stringArray[0] = string;
            List paths = StringsKt.split$default((CharSequence)charSequence, (String[])stringArray, (boolean)false, (int)0, (int)6, null);
            for (String path : paths) {
                File jarFile = new File(path);
                if (!jarFile.exists()) continue;
                if (files == null) {
                    files = new ArrayList();
                } else if (files.contains(jarFile)) continue;
                files.add(jarFile);
            }
        }
        return files != null ? files : CollectionsKt.emptyList();
    }

    @NotNull
    public List<File> findRuleJars(@NotNull Project project) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        if (project.isGradleProject()) {
            File lintJar;
            if (project.isLibrary()) {
                File lintJar2;
                AndroidLibrary model = project.getGradleLibraryModel();
                if (model != null && (lintJar2 = model.getLintJar()).exists()) {
                    return CollectionsKt.listOf((Object)lintJar2);
                }
            } else if (project.getSubset() != null) {
                List rules = null;
                Variant variant = project.getCurrentVariant();
                if (variant != null) {
                    Collection libraries = variant.getMainArtifact().getDependencies().getLibraries();
                    for (AndroidLibrary library : libraries) {
                        File lintJar3 = library.getLintJar();
                        if (!lintJar3.exists()) continue;
                        if (rules == null) {
                            rules = Lists.newArrayListWithExpectedSize((int)4);
                        }
                        List list = rules;
                        if (list == null) {
                            Intrinsics.throwNpe();
                        }
                        File file = lintJar3;
                        Intrinsics.checkExpressionValueIsNotNull((Object)file, (String)"lintJar");
                        list.add(file);
                    }
                    if (rules != null) {
                        return rules;
                    }
                }
            } else if (StringsKt.endsWith$default((String)project.getDir().getPath(), (String)".aar", (boolean)false, (int)2, null) && (lintJar = new File(project.getDir(), "lint.jar")).exists()) {
                return CollectionsKt.listOf((Object)lintJar);
            }
        }
        return CollectionsKt.emptyList();
    }

    @Nullable
    public URLConnection openConnection(@NotNull URL url) throws IOException {
        Intrinsics.checkParameterIsNotNull((Object)url, (String)"url");
        return this.openConnection(url, 0);
    }

    @Nullable
    public URLConnection openConnection(@NotNull URL url, int timeout) throws IOException {
        Intrinsics.checkParameterIsNotNull((Object)url, (String)"url");
        URLConnection connection = url.openConnection();
        if (timeout > 0) {
            connection.setConnectTimeout(timeout);
            connection.setReadTimeout(timeout);
        }
        return connection;
    }

    public void closeConnection(@NotNull URLConnection connection) {
        Intrinsics.checkParameterIsNotNull((Object)connection, (String)"connection");
        if (connection instanceof HttpURLConnection) {
            ((HttpURLConnection)connection).disconnect();
        }
    }

    public boolean isProjectDirectory(@NotNull File dir) {
        Intrinsics.checkParameterIsNotNull((Object)dir, (String)"dir");
        return LintUtils.isManifestFolder(dir) || Project.isAospFrameworksRelatedProject(dir) || new File(dir, "build.gradle").exists();
    }

    public boolean checkForSuppressComments() {
        return true;
    }

    @NotNull
    public IssueRegistry addCustomLintRules(@NotNull IssueRegistry registry) {
        Intrinsics.checkParameterIsNotNull((Object)registry, (String)"registry");
        List<File> jarFiles = this.findGlobalRuleJars();
        if (!jarFiles.isEmpty()) {
            ArrayList registries = Lists.newArrayListWithExpectedSize((int)jarFiles.size());
            registries.add(registry);
            for (File jarFile : jarFiles) {
                try {
                    registries.add(JarFileIssueRegistry.get(this, jarFile));
                }
                catch (Throwable e) {
                    this.log(e, "Could not load custom rule jar file %1$s", jarFile);
                }
            }
            if (registries.size() > 1) {
                return new CompositeIssueRegistry(registries);
            }
        }
        return registry;
    }

    @NotNull
    public ClassLoader createUrlClassLoader(@NotNull URL[] urls, @NotNull ClassLoader parent) {
        Intrinsics.checkParameterIsNotNull((Object)urls, (String)"urls");
        Intrinsics.checkParameterIsNotNull((Object)parent, (String)"parent");
        return new URLClassLoader(urls, parent);
    }

    @Nullable
    public Document getMergedManifest(@NotNull Project project) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        List<File> manifestFiles = project.getManifestFiles();
        if (manifestFiles.size() == 1) {
            File primary = manifestFiles.get(0);
            try {
                String xml = Files.toString((File)primary, (Charset)Charsets.UTF_8);
                return XmlUtils.parseDocumentSilently((String)xml, (boolean)true);
            }
            catch (IOException e) {
                this.log(Severity.ERROR, e, "Could not read manifest " + primary, new Object[0]);
            }
        }
        return null;
    }

    public void resolveMergeManifestSources(@NotNull Document mergedManifest, @NotNull Object reportFile) {
        Intrinsics.checkParameterIsNotNull((Object)mergedManifest, (String)"mergedManifest");
        Intrinsics.checkParameterIsNotNull((Object)reportFile, (String)"reportFile");
        mergedManifest.setUserData(MERGED_MANIFEST, reportFile, null);
    }

    public final boolean isMergeManifestNode(@NotNull Node node) {
        Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
        Document document = node.getOwnerDocument();
        return (document != null ? document.getUserData(MERGED_MANIFEST) : null) != null;
    }

    @NotNull
    protected final Map<Object, BlameFile> getReportFileCache() {
        return this.reportFileCache;
    }

    @NotNull
    protected final Map<Node, Pair<File, Node>> getSourceNodeCache() {
        return this.sourceNodeCache;
    }

    @Nullable
    public Pair<File, Node> findManifestSourceNode(@NotNull Node mergedNode) {
        Pair<File, Node> pair;
        Intrinsics.checkParameterIsNotNull((Object)mergedNode, (String)"mergedNode");
        Document document = mergedNode.getOwnerDocument();
        if (document == null) {
            return null;
        }
        Document doc = document;
        Object object = doc.getUserData(MERGED_MANIFEST);
        if (object == null) {
            return null;
        }
        Object report = object;
        Pair<File, Node> cached = this.sourceNodeCache.get(mergedNode);
        if (cached != null) {
            if (cached == NOT_FOUND) {
                return null;
            }
            return cached;
        }
        BlameFile blameFile = this.reportFileCache.get(report);
        if (blameFile == null) {
            try {
                if (report instanceof File) {
                    Object file = report;
                    if (StringsKt.endsWith$default((String)((File)file).getPath(), (String)".xml", (boolean)false, (int)2, null)) {
                        return Pair.of((Object)file, (Object)mergedNode);
                    }
                    blameFile = BlameFile.parse((File)file);
                } else if (report instanceof String) {
                    List lines = Splitter.on((char)'\n').splitToList((CharSequence)report);
                    blameFile = BlameFile.parse(lines);
                } else if (report instanceof Actions) {
                    blameFile = BlameFile.parse((Actions)report);
                } else {
                    boolean lines = false;
                    if (_Assertions.ENABLED && !lines) {
                        Object object2 = report;
                        throw (Throwable)((Object)new AssertionError(object2));
                    }
                    blameFile = BlameFile.NONE;
                }
            }
            catch (IOException ignore) {
                blameFile = BlameFile.NONE;
            }
            if (blameFile == null) {
                Intrinsics.throwNpe();
            }
            this.reportFileCache.put(report, blameFile);
        }
        Pair<File, Node> source = null;
        if (blameFile != BlameFile.NONE) {
            source = blameFile.findSourceNode(this, mergedNode);
        }
        if ((pair = source) == null) {
            pair = NOT_FOUND;
        }
        Pair<File, Node> cacheValue = pair;
        Map<Node, Pair<File, Node>> map = this.sourceNodeCache;
        Pair<File, Node> pair2 = cacheValue;
        map.put(mergedNode, pair2);
        return source;
    }

    @Nullable
    public Location findManifestSourceLocation(@NotNull Node mergedNode) {
        Intrinsics.checkParameterIsNotNull((Object)mergedNode, (String)"mergedNode");
        Pair<File, Node> source = this.findManifestSourceNode(mergedNode);
        if (source != null) {
            return this.getXmlParser().getLocation((File)source.getFirst(), (Node)source.getSecond());
        }
        return null;
    }

    @NotNull
    public String getDisplayPath(@NotNull File file) {
        Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
        String string = TextFormat.TEXT.convertTo(file.getPath(), TextFormat.RAW);
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"TextFormat.TEXT.convertT\u2026ile.path, TextFormat.RAW)");
        return string;
    }

    public boolean supportsProjectResources() {
        return false;
    }

    @Deprecated(message="Use {@link #getResourceRepository} instead", replaceWith=@ReplaceWith(expression="getResourceRepository(project, includeDependencies, false)", imports={}))
    @Nullable
    public AbstractResourceRepository getProjectResources(@NotNull Project project, boolean includeDependencies) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        return this.getResourceRepository(project, includeDependencies, false);
    }

    @Nullable
    public AbstractResourceRepository getResourceRepository(@NotNull Project project, boolean includeModuleDependencies, boolean includeLibraries) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        return null;
    }

    @NotNull
    public Location.Handle createResourceItemHandle(@NotNull ResourceItem item) {
        Intrinsics.checkParameterIsNotNull((Object)item, (String)"item");
        return new Location.ResourceItemHandle(item);
    }

    @NotNull
    public ResourceVisibilityLookup.Provider getResourceVisibilityProvider() {
        if (this.resourceVisibilityProvider == null) {
            this.resourceVisibilityProvider = new ResourceVisibilityLookup.Provider();
        }
        ResourceVisibilityLookup.Provider provider = this.resourceVisibilityProvider;
        if (provider == null) {
            Intrinsics.throwNpe();
        }
        return provider;
    }

    @Nullable
    public String getClientRevision() {
        return null;
    }

    public void runReadAction(@NotNull Runnable runnable) {
        Intrinsics.checkParameterIsNotNull((Object)runnable, (String)"runnable");
        runnable.run();
    }

    @NotNull
    public ProgressIndicator getRepositoryLogger() {
        return (ProgressIndicator)new RepoLogger();
    }

    protected LintClient(@NotNull String clientName) {
        Map map;
        Intrinsics.checkParameterIsNotNull((Object)clientName, (String)"clientName");
        LintClient lintClient = this;
        lintClient.projectInfo = map = (Map)new LinkedHashMap();
        this.dirToProject = new HashMap();
        HashSet hashSet = Sets.newHashSet();
        Intrinsics.checkExpressionValueIsNotNull((Object)hashSet, (String)"Sets.newHashSet<File>()");
        this.projectDirs = hashSet;
        HashMap hashMap = Maps.newHashMap();
        Intrinsics.checkExpressionValueIsNotNull((Object)hashMap, (String)"Maps.newHashMap<Any, BlameFile>()");
        this.reportFileCache = hashMap;
        IdentityHashMap identityHashMap = Maps.newIdentityHashMap();
        Intrinsics.checkExpressionValueIsNotNull((Object)identityHashMap, (String)"Maps.newIdentityHashMap<Node, Pair<File, Node>>()");
        this.sourceNodeCache = identityHashMap;
        LintClient.Companion.setClientName(clientName);
    }

    protected LintClient() {
        Map map;
        LintClient lintClient = this;
        lintClient.projectInfo = map = (Map)new LinkedHashMap();
        this.dirToProject = new HashMap();
        HashSet hashSet = Sets.newHashSet();
        Intrinsics.checkExpressionValueIsNotNull((Object)hashSet, (String)"Sets.newHashSet<File>()");
        this.projectDirs = hashSet;
        HashMap hashMap = Maps.newHashMap();
        Intrinsics.checkExpressionValueIsNotNull((Object)hashMap, (String)"Maps.newHashMap<Any, BlameFile>()");
        this.reportFileCache = hashMap;
        IdentityHashMap identityHashMap = Maps.newIdentityHashMap();
        Intrinsics.checkExpressionValueIsNotNull((Object)identityHashMap, (String)"Maps.newIdentityHashMap<Node, Pair<File, Node>>()");
        this.sourceNodeCache = identityHashMap;
        LintClient.Companion.setClientName(CLIENT_UNKNOWN);
    }

    static {
        Companion = new Companion(null);
        PROP_BIN_DIR = PROP_BIN_DIR;
        Pair pair = Pair.of(null, null);
        Intrinsics.checkExpressionValueIsNotNull((Object)pair, (String)"Pair.of<File, Node>(null, null)");
        NOT_FOUND = pair;
        CLIENT_STUDIO = CLIENT_STUDIO;
        CLIENT_GRADLE = CLIENT_GRADLE;
        CLIENT_CLI = CLIENT_CLI;
        clientName = CLIENT_UNKNOWN = CLIENT_UNKNOWN;
    }

    private static final String getPROP_BIN_DIR() {
        return LintClient.Companion.getPROP_BIN_DIR();
    }

    @NotNull
    public static final String getClientName() {
        return Companion.getClientName();
    }

    private static final void setClientName(String string) {
        LintClient.Companion.setClientName(string);
    }

    public static final boolean isStudio() {
        return Companion.isStudio();
    }

    public static final boolean isGradle() {
        return Companion.isGradle();
    }

    @Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=1, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u000f\n\u0002\u0010\u000b\n\u0000\u0018\u00002\u00020\u0001Bg\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\u000bJ\u0014\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\u0006\u0010\u0013\u001a\u00020\u0014R\u0017\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0017\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\rR\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\rR\u0017\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\rR\u0017\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\r\u00a8\u0006\u0015"}, d2={"Lcom/android/tools/lint/client/api/LintClient$ClassPathInfo;", "", "sourceFolders", "", "Ljava/io/File;", "classFolders", "libraries", "nonProvidedLibraries", "testSourceFolders", "testLibraries", "generatedFolders", "(Ljava/util/List;Ljava/util/List;Ljava/util/List;Ljava/util/List;Ljava/util/List;Ljava/util/List;Ljava/util/List;)V", "getClassFolders", "()Ljava/util/List;", "getGeneratedFolders", "getSourceFolders", "getTestLibraries", "getTestSourceFolders", "getLibraries", "includeProvided", "", "lint-api_main"})
    public static final class ClassPathInfo {
        @NotNull
        private final List<File> sourceFolders;
        @NotNull
        private final List<File> classFolders;
        private final List<File> libraries;
        private final List<File> nonProvidedLibraries;
        @NotNull
        private final List<File> testSourceFolders;
        @NotNull
        private final List<File> testLibraries;
        @NotNull
        private final List<File> generatedFolders;

        @NotNull
        public final List<File> getLibraries(boolean includeProvided) {
            return includeProvided ? this.libraries : this.nonProvidedLibraries;
        }

        @NotNull
        public final List<File> getSourceFolders() {
            return this.sourceFolders;
        }

        @NotNull
        public final List<File> getClassFolders() {
            return this.classFolders;
        }

        @NotNull
        public final List<File> getTestSourceFolders() {
            return this.testSourceFolders;
        }

        @NotNull
        public final List<File> getTestLibraries() {
            return this.testLibraries;
        }

        @NotNull
        public final List<File> getGeneratedFolders() {
            return this.generatedFolders;
        }

        public ClassPathInfo(@NotNull List<? extends File> sourceFolders, @NotNull List<? extends File> classFolders, @NotNull List<? extends File> libraries, @NotNull List<? extends File> nonProvidedLibraries, @NotNull List<? extends File> testSourceFolders, @NotNull List<? extends File> testLibraries, @NotNull List<? extends File> generatedFolders) {
            Intrinsics.checkParameterIsNotNull(sourceFolders, (String)"sourceFolders");
            Intrinsics.checkParameterIsNotNull(classFolders, (String)"classFolders");
            Intrinsics.checkParameterIsNotNull(libraries, (String)"libraries");
            Intrinsics.checkParameterIsNotNull(nonProvidedLibraries, (String)"nonProvidedLibraries");
            Intrinsics.checkParameterIsNotNull(testSourceFolders, (String)"testSourceFolders");
            Intrinsics.checkParameterIsNotNull(testLibraries, (String)"testLibraries");
            Intrinsics.checkParameterIsNotNull(generatedFolders, (String)"generatedFolders");
            this.sourceFolders = sourceFolders;
            this.classFolders = classFolders;
            this.libraries = libraries;
            this.nonProvidedLibraries = nonProvidedLibraries;
            this.testSourceFolders = testSourceFolders;
            this.testLibraries = testLibraries;
            this.generatedFolders = generatedFolders;
        }
    }

    @Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0003\n\u0002\b\u0003\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u001a\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\bH\u0016J\u0010\u0010\t\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u001a\u0010\n\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\bH\u0016\u00a8\u0006\u000b"}, d2={"Lcom/android/tools/lint/client/api/LintClient$RepoLogger;", "Lcom/android/repository/api/ProgressIndicatorAdapter;", "()V", "logError", "", "s", "", "e", "", "logInfo", "logWarning", "lint-api_main"})
    private static final class RepoLogger
    extends ProgressIndicatorAdapter {
        public void logError(@NotNull String s, @Nullable Throwable e) {
            Intrinsics.checkParameterIsNotNull((Object)s, (String)"s");
        }

        public void logInfo(@NotNull String s) {
            Intrinsics.checkParameterIsNotNull((Object)s, (String)"s");
        }

        public void logWarning(@NotNull String s, @Nullable Throwable e) {
            Intrinsics.checkParameterIsNotNull((Object)s, (String)"s");
        }
    }

    @Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\b\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0010\u0010\u0003\u001a\u00020\u00048\u0006X\u0087D\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0005\u001a\u00020\u00048\u0006X\u0087D\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u00020\u00048\u0006X\u0087D\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0007\u001a\u00020\u00048\u0006X\u0087D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u001c\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\f0\n8\u0004X\u0085\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\r\u001a\u00020\u00048\u0002X\u0083D\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u000e\u0010\u0002\u001a\u0004\b\u000f\u0010\u0010R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082T\u00a2\u0006\u0002\n\u0000R,\u0010\u0014\u001a\u00020\u00042\u0006\u0010\u0013\u001a\u00020\u00048\u0006@BX\u0087\u000e\u00a2\u0006\u0014\n\u0000\u0012\u0004\b\u0015\u0010\u0002\u001a\u0004\b\u0016\u0010\u0010\"\u0004\b\u0017\u0010\u0018R\u001a\u0010\u0019\u001a\u00020\u001a8FX\u0087\u0004\u00a2\u0006\f\u0012\u0004\b\u001b\u0010\u0002\u001a\u0004\b\u0019\u0010\u001cR\u001a\u0010\u001d\u001a\u00020\u001a8FX\u0087\u0004\u00a2\u0006\f\u0012\u0004\b\u001e\u0010\u0002\u001a\u0004\b\u001d\u0010\u001cR\u0016\u0010\u001f\u001a\u0004\u0018\u00010\u000b8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b \u0010!\u00a8\u0006\""}, d2={"Lcom/android/tools/lint/client/api/LintClient$Companion;", "", "()V", "CLIENT_CLI", "", "CLIENT_GRADLE", "CLIENT_STUDIO", "CLIENT_UNKNOWN", "MERGED_MANIFEST", "NOT_FOUND", "Lcom/android/utils/Pair;", "Ljava/io/File;", "Lorg/w3c/dom/Node;", "PROP_BIN_DIR", "PROP_BIN_DIR$annotations", "getPROP_BIN_DIR", "()Ljava/lang/String;", "SDK_DATABASE_MIN_VERSION", "", "<set-?>", "clientName", "clientName$annotations", "getClientName", "setClientName", "(Ljava/lang/String;)V", "isGradle", "", "isGradle$annotations", "()Z", "isStudio", "isStudio$annotations", "lintBinDir", "getLintBinDir", "()Ljava/io/File;", "lint-api_main"})
    public static final class Companion {
        @JvmStatic
        private static /* synthetic */ void PROP_BIN_DIR$annotations() {
        }

        private final String getPROP_BIN_DIR() {
            return PROP_BIN_DIR;
        }

        private final File getLintBinDir() {
            File file;
            CharSequence charSequence;
            String path = System.getProperty(Companion.getPROP_BIN_DIR());
            if (path == null || (charSequence = (CharSequence)path).length() == 0) {
                path = System.getenv(Companion.getPROP_BIN_DIR());
            }
            if (path != null && !((charSequence = (CharSequence)path).length() == 0) && (file = new File(path)).exists()) {
                return file;
            }
            return null;
        }

        @JvmStatic
        public static /* synthetic */ void clientName$annotations() {
        }

        @NotNull
        public final String getClientName() {
            return clientName;
        }

        private final void setClientName(String string) {
            clientName = string;
        }

        @JvmStatic
        public static /* synthetic */ void isStudio$annotations() {
        }

        public final boolean isStudio() {
            return Intrinsics.areEqual((Object)CLIENT_STUDIO, (Object)Companion.getClientName());
        }

        @JvmStatic
        public static /* synthetic */ void isGradle$annotations() {
        }

        public final boolean isGradle() {
            return Intrinsics.areEqual((Object)CLIENT_GRADLE, (Object)Companion.getClientName());
        }

        private Companion() {
        }

        @NotNull
        public static final /* synthetic */ String access$getClientName$p(Companion $this) {
            return $this.getClientName();
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

