/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.helpers;

import com.android.tools.lint.client.api.JavaEvaluator;
import com.android.tools.lint.client.api.UastParser;
import com.android.tools.lint.detector.api.JavaContext;
import com.android.tools.lint.detector.api.Location;
import com.android.tools.lint.detector.api.Project;
import com.android.tools.lint.helpers.DefaultJavaEvaluator;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.StandardFileSystems;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiCompiledElement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiNameIdentifierOwner;
import com.intellij.psi.impl.light.LightElement;
import java.io.File;
import java.lang.reflect.Field;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.uast.UCallExpression;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UExpression;
import org.jetbrains.uast.UFile;
import org.jetbrains.uast.UIdentifier;
import org.jetbrains.uast.UastContext;
import org.jetbrains.uast.UastUtils;
import org.jetbrains.uast.psi.UElementWithLocation;

@Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=1, d1={"\u0000\u0086\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\r\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0000\b\u0016\u0018\u00002\u00020\u0001B\u0017\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u001a\u0010\u000b\u001a\u00020\f2\b\u0010\u0002\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0014J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0011H\u0016J\u0014\u0010\u0012\u001a\u0004\u0018\u00010\u00102\b\u0010\u000f\u001a\u0004\u0018\u00010\u0011H\u0002J(\u0010\u0013\u001a\u00020\u000e2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u0019H\u0016J\u001a\u0010\u001b\u001a\u0004\u0018\u00010\u001c2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\b\u0010\u001d\u001a\u00020\bH\u0016J\u0012\u0010\u001e\u001a\u0004\u0018\u00010\u001f2\u0006\u0010 \u001a\u00020\u001cH\u0016J\u0010\u0010!\u001a\u00020\"2\u0006\u0010 \u001a\u00020\u001cH\u0016J\u0018\u0010#\u001a\u00020\u000e2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u0018\u0010#\u001a\u00020\u000e2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u000f\u001a\u00020\u0011H\u0016J\u0018\u0010$\u001a\u00020\u000e2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u0018\u0010$\u001a\u00020\u000e2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u000f\u001a\u00020\u0011H\u0016J0\u0010%\u001a\u00020\u000e2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010&\u001a\u00020\u00102\u0006\u0010'\u001a\u00020(2\u0006\u0010)\u001a\u00020\u00102\u0006\u0010*\u001a\u00020(H\u0016J(\u0010%\u001a\u00020\u000e2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010&\u001a\u00020\u00102\u0006\u0010'\u001a\u00020(2\u0006\u0010*\u001a\u00020(H\u0016J(\u0010%\u001a\u00020\u000e2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010&\u001a\u00020\u00112\u0006\u0010'\u001a\u00020(2\u0006\u0010*\u001a\u00020(H\u0016J0\u0010%\u001a\u00020\u000e2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010&\u001a\u00020\u00112\u0006\u0010'\u001a\u00020(2\u0006\u0010)\u001a\u00020\u00112\u0006\u0010*\u001a\u00020(H\u0016J\u0012\u0010+\u001a\u0004\u0018\u00010,2\u0006\u0010\u000f\u001a\u00020\u0011H\u0002J\n\u0010-\u001a\u0004\u0018\u00010\nH\u0016J\u0012\u0010.\u001a\u0004\u0018\u00010/2\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\u0016\u00100\u001a\u00020\u00192\f\u00101\u001a\b\u0012\u0004\u0012\u00020\u001502H\u0016R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\t\u001a\u0004\u0018\u00010\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00063"}, d2={"Lcom/android/tools/lint/helpers/DefaultUastParser;", "Lcom/android/tools/lint/client/api/UastParser;", "project", "Lcom/android/tools/lint/detector/api/Project;", "p", "Lcom/intellij/openapi/project/Project;", "(Lcom/android/tools/lint/detector/api/Project;Lcom/intellij/openapi/project/Project;)V", "javaEvaluator", "Lcom/android/tools/lint/client/api/JavaEvaluator;", "uastContext", "Lorg/jetbrains/uast/UastContext;", "createEvaluator", "Lcom/android/tools/lint/helpers/DefaultJavaEvaluator;", "createLocation", "Lcom/android/tools/lint/detector/api/Location;", "element", "Lcom/intellij/psi/PsiElement;", "Lorg/jetbrains/uast/UElement;", "findPsi", "getCallLocation", "context", "Lcom/android/tools/lint/detector/api/JavaContext;", "call", "Lorg/jetbrains/uast/UCallExpression;", "includeReceiver", "", "includeArguments", "getContainingFile", "Lcom/intellij/psi/PsiFile;", "getEvaluator", "getFile", "Ljava/io/File;", "file", "getFileContents", "", "getLocation", "getNameLocation", "getRangeLocation", "from", "fromDelta", "", "to", "toDelta", "getTextRange", "Lcom/intellij/openapi/util/TextRange;", "getUastContext", "parse", "Lorg/jetbrains/uast/UFile;", "prepare", "contexts", "", "lint-api_main"})
public class DefaultUastParser
extends UastParser {
    private final UastContext uastContext;
    private final JavaEvaluator javaEvaluator;

    @NotNull
    protected DefaultJavaEvaluator createEvaluator(@Nullable Project project, @NotNull com.intellij.openapi.project.Project p) {
        Intrinsics.checkParameterIsNotNull((Object)p, (String)"p");
        return new DefaultJavaEvaluator(p, project);
    }

    @Override
    public boolean prepare(@NotNull List<? extends JavaContext> contexts) {
        Intrinsics.checkParameterIsNotNull(contexts, (String)"contexts");
        return true;
    }

    @Override
    @NotNull
    public JavaEvaluator getEvaluator() {
        return this.javaEvaluator;
    }

    @Override
    @Nullable
    public UFile parse(@NotNull JavaContext context) {
        UElement uElement;
        UElement uElement2;
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        UastContext uastContext = this.uastContext;
        if (uastContext == null || (uastContext = uastContext.getProject()) == null) {
            return null;
        }
        UastContext ideaProject = uastContext;
        if (ideaProject.isDisposed()) {
            return null;
        }
        VirtualFile virtualFile = StandardFileSystems.local().findFileByPath(context.file.getAbsolutePath());
        if (virtualFile == null) {
            return null;
        }
        VirtualFile virtualFile2 = virtualFile;
        PsiFile psiFile = PsiManager.getInstance((com.intellij.openapi.project.Project)ideaProject).findFile(virtualFile2);
        if (psiFile == null) {
            return null;
        }
        PsiFile psiFile2 = psiFile;
        UastContext uastContext2 = this.uastContext;
        if (uastContext2 != null) {
            PsiFile psiFile3 = psiFile2;
            Intrinsics.checkExpressionValueIsNotNull((Object)psiFile3, (String)"psiFile");
            uElement2 = uastContext2.convertElementWithParent((PsiElement)psiFile3, UFile.class);
        } else {
            uElement2 = uElement = null;
        }
        if (!(uElement2 instanceof UFile)) {
            uElement = null;
        }
        UFile uFile = (UFile)uElement;
        if (uFile == null) {
            return null;
        }
        UFile uElement3 = uFile;
        return uElement3;
    }

    @Override
    @Nullable
    public UastContext getUastContext() {
        return this.uastContext;
    }

    @Override
    @NotNull
    public Location getLocation(@NotNull JavaContext context, @NotNull PsiElement element) {
        CharSequence contents;
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
        TextRange range = element.getTextRange();
        if (element instanceof PsiCompiledElement && (range == null || Intrinsics.areEqual((Object)TextRange.EMPTY_RANGE, (Object)range))) {
            VirtualFile virtualFile;
            PsiFile containingFile = element.getContainingFile();
            if (containingFile != null && (virtualFile = containingFile.getVirtualFile()) != null) {
                File file = VfsUtilCore.virtualToIoFile((VirtualFile)virtualFile);
                Intrinsics.checkExpressionValueIsNotNull((Object)file, (String)"VfsUtilCore.virtualToIoFile(virtualFile)");
                return Location.Companion.create(file);
            }
            return Location.Companion.create(context.file);
        }
        PsiFile containingFile = this.getContainingFile(context, element);
        File file = context.file;
        CharSequence charSequence = context.getContents();
        if (charSequence == null) {
            charSequence = contents = (CharSequence)"";
        }
        if (containingFile != null && Intrinsics.areEqual((Object)containingFile, (Object)context.getPsiFile()) ^ true) {
            File ioFile;
            if (context.getDriver().getScope().size() == 1) {
                return Location.NONE;
            }
            File file2 = this.getFile(containingFile);
            if (file2 == null) {
                return Location.NONE;
            }
            file = ioFile = file2;
            contents = this.getFileContents(containingFile);
        }
        if (range == null) {
            PsiElement parent;
            if (element instanceof LightElement && (parent = element.getParent()) != null) {
                return this.getLocation(context, parent);
            }
            return Location.Companion.create(file);
        }
        return Location.Companion.create(file, contents, range.getStartOffset(), range.getEndOffset()).setSource(element);
    }

    private final PsiFile getContainingFile(JavaContext context, PsiElement element) {
        Class<?> cls;
        String name;
        PsiFile containingFile = element.getContainingFile();
        if (Intrinsics.areEqual((Object)containingFile, (Object)context.getPsiFile()) ^ true && StringsKt.startsWith$default((String)(name = (cls = containingFile.getClass()).getName()), (String)"org.jetbrains.kotlin.asJava.classes.KtLightClassForSourceDeclaration", (boolean)false, (int)2, null)) {
            try {
                PsiFile psiFile;
                Field declaredField = cls.getSuperclass().getDeclaredField("ktFile");
                declaredField.setAccessible(true);
                Object object = declaredField.get(containingFile);
                if (!(object instanceof PsiFile)) {
                    object = null;
                }
                if ((psiFile = (PsiFile)object) == null) {
                    psiFile = containingFile;
                }
                return psiFile;
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return containingFile;
    }

    @Override
    @NotNull
    public Location getLocation(@NotNull JavaContext context, @NotNull UElement element) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
        if (element instanceof UElementWithLocation) {
            UFile uFile = UastUtils.getContainingFile((UElement)element);
            if (uFile == null) {
                return Location.NONE;
            }
            UFile file = uFile;
            File file2 = UastUtils.getIoFile((UFile)file);
            if (file2 == null) {
                return Location.NONE;
            }
            File ioFile = file2;
            UElement segment = element;
            String text = file.getPsi().getText();
            Location location = Location.Companion.create(ioFile, text, ((UElementWithLocation)segment).getStartOffset(), ((UElementWithLocation)segment).getEndOffset());
            location.setSource(element);
            return location;
        }
        PsiElement psiElement = element.getPsi();
        if (psiElement != null) {
            return this.getLocation(context, psiElement);
        }
        UElement parent = element.getUastParent();
        if (parent != null) {
            return this.getLocation(context, parent);
        }
        return Location.NONE;
    }

    @Override
    @NotNull
    public Location getCallLocation(@NotNull JavaContext context, @NotNull UCallExpression call, boolean includeReceiver, boolean includeArguments) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)call, (String)"call");
        UExpression receiver = call.getReceiver();
        if (!includeReceiver || receiver == null) {
            if (includeArguments) {
                return this.getLocation(context, (UElement)call);
            }
            UIdentifier methodIdentifier = call.getMethodIdentifier();
            if (methodIdentifier != null) {
                return this.getLocation(context, (UElement)methodIdentifier);
            }
        } else {
            UIdentifier methodIdentifier;
            if (!includeArguments && (methodIdentifier = call.getMethodIdentifier()) != null) {
                return this.getRangeLocation(context, (UElement)receiver, 0, (UElement)methodIdentifier, 0);
            }
            return this.getRangeLocation(context, (UElement)receiver, 0, (UElement)call, 0);
        }
        return this.getLocation(context, (UElement)call);
    }

    @Override
    @Nullable
    public File getFile(@NotNull PsiFile file) {
        Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
        VirtualFile virtualFile = file.getVirtualFile();
        return virtualFile != null ? VfsUtilCore.virtualToIoFile((VirtualFile)virtualFile) : null;
    }

    @Override
    @NotNull
    public CharSequence getFileContents(@NotNull PsiFile file) {
        Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
        String string = file.getText();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"file.text");
        return string;
    }

    @Override
    @NotNull
    public Location createLocation(@NotNull PsiElement element) {
        PsiFile containingFile;
        Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
        TextRange range = element.getTextRange();
        PsiFile psiFile = containingFile = element.getContainingFile();
        Intrinsics.checkExpressionValueIsNotNull((Object)psiFile, (String)"containingFile");
        File file = this.getFile(psiFile);
        if (file == null) {
            return Location.NONE;
        }
        File file2 = file;
        PsiFile psiFile2 = containingFile;
        Intrinsics.checkExpressionValueIsNotNull((Object)psiFile2, (String)"containingFile");
        CharSequence contents = this.getFileContents(psiFile2);
        return Location.Companion.create(file2, contents, range.getStartOffset(), range.getEndOffset()).setSource(element);
    }

    @Override
    @NotNull
    public Location createLocation(@NotNull UElement element) {
        Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
        if (element instanceof UElementWithLocation) {
            UFile uFile = UastUtils.getContainingFile((UElement)element);
            if (uFile == null) {
                return Location.NONE;
            }
            UFile file = uFile;
            File file2 = UastUtils.getIoFile((UFile)file);
            if (file2 == null) {
                return Location.NONE;
            }
            File ioFile = file2;
            UElement segment = element;
            String text = file.getPsi().getText();
            Location location = Location.Companion.create(ioFile, text, ((UElementWithLocation)segment).getStartOffset(), ((UElementWithLocation)segment).getEndOffset());
            location.setSource(element);
            return location;
        }
        PsiElement psiElement = element.getPsi();
        if (psiElement != null) {
            return this.createLocation(psiElement);
        }
        UElement parent = element.getUastParent();
        if (parent != null) {
            return this.createLocation(parent);
        }
        return Location.NONE;
    }

    @Override
    @NotNull
    public Location getRangeLocation(@NotNull JavaContext context, @NotNull PsiElement from, int fromDelta, @NotNull PsiElement to, int toDelta) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)from, (String)"from");
        Intrinsics.checkParameterIsNotNull((Object)to, (String)"to");
        CharSequence contents = context.getContents();
        TextRange fromRange = from.getTextRange();
        int start = Math.max(0, fromRange.getStartOffset() + fromDelta);
        CharSequence charSequence = contents;
        int end = Math.min(charSequence != null ? charSequence.length() : Integer.MAX_VALUE, to.getTextRange().getEndOffset() + toDelta);
        if (end <= start) {
            return Location.Companion.create(context.file, contents, start, fromRange.getEndOffset()).setSource(from);
        }
        return Location.Companion.create(context.file, contents, start, end).setSource(from);
    }

    private final TextRange getTextRange(UElement element) {
        if (element instanceof UElementWithLocation) {
            UElement segment = element;
            return new TextRange(((UElementWithLocation)segment).getStartOffset(), ((UElementWithLocation)segment).getEndOffset());
        }
        PsiElement psiElement = element.getPsi();
        if (psiElement != null) {
            return psiElement.getTextRange();
        }
        return null;
    }

    @Override
    @NotNull
    public Location getRangeLocation(@NotNull JavaContext context, @NotNull UElement from, int fromDelta, @NotNull UElement to, int toDelta) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)from, (String)"from");
        Intrinsics.checkParameterIsNotNull((Object)to, (String)"to");
        CharSequence contents = context.getContents();
        TextRange fromRange = this.getTextRange(from);
        TextRange toRange = this.getTextRange(to);
        File file = context.file;
        PsiElement psi = this.findPsi(from);
        if (psi != null) {
            PsiFile containingFile = psi.getContainingFile();
            contents = context.getContents();
            if (Intrinsics.areEqual((Object)containingFile, (Object)context.getPsiFile()) ^ true) {
                File ioFile;
                if (context.getDriver().getScope().size() == 1) {
                    return Location.NONE;
                }
                PsiFile psiFile = containingFile;
                Intrinsics.checkExpressionValueIsNotNull((Object)psiFile, (String)"containingFile");
                File file2 = this.getFile(psiFile);
                if (file2 == null) {
                    return Location.NONE;
                }
                file = ioFile = file2;
                PsiFile psiFile2 = containingFile;
                Intrinsics.checkExpressionValueIsNotNull((Object)psiFile2, (String)"containingFile");
                contents = this.getFileContents(psiFile2);
            }
        }
        if (fromRange != null && toRange != null) {
            int start = Math.max(0, fromRange.getStartOffset() + fromDelta);
            int end = Math.min(contents == null ? Integer.MAX_VALUE : contents.length(), toRange.getEndOffset() + toDelta);
            if (end <= start) {
                return Location.Companion.create(file, contents, start, fromRange.getEndOffset()).setSource(from);
            }
            return Location.Companion.create(file, contents, start, end).setSource(from);
        }
        return Location.Companion.create(file).setSource(from);
    }

    private final PsiElement findPsi(UElement element) {
        for (UElement currentElement = element; currentElement != null; currentElement = currentElement.getUastParent()) {
            PsiElement psi = currentElement.getPsi();
            if (psi == null) continue;
            return psi;
        }
        return null;
    }

    @Override
    @NotNull
    public Location getRangeLocation(@NotNull JavaContext context, @NotNull PsiElement from, int fromDelta, int toDelta) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)from, (String)"from");
        return this.getRangeLocation(context, from, fromDelta, from, -(from.getTextRange().getLength() - toDelta));
    }

    @Override
    @NotNull
    public Location getRangeLocation(@NotNull JavaContext context, @NotNull UElement from, int fromDelta, int toDelta) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)from, (String)"from");
        TextRange fromRange = this.getTextRange(from);
        if (fromRange != null) {
            return this.getRangeLocation(context, from, fromDelta, from, -(fromRange.getLength() - toDelta));
        }
        return Location.Companion.create(context.file).setSource(from);
    }

    @Override
    @NotNull
    public Location getNameLocation(@NotNull JavaContext context, @NotNull PsiElement element) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
        PsiElement namedElement = element;
        PsiElement nameNode = JavaContext.Companion.findNameElement(namedElement);
        if (nameNode != null) {
            namedElement = nameNode;
        }
        return this.getLocation(context, namedElement);
    }

    @Override
    @NotNull
    public Location getNameLocation(@NotNull JavaContext context, @NotNull UElement element) {
        PsiElement nameIdentifier;
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
        UElement namedElement = element;
        UElement nameNode = JavaContext.Companion.findNameElement(namedElement);
        if (nameNode != null) {
            namedElement = nameNode;
        } else if (namedElement instanceof PsiNameIdentifierOwner && (nameIdentifier = ((PsiNameIdentifierOwner)namedElement).getNameIdentifier()) != null) {
            return this.getLocation(context, nameIdentifier);
        }
        return this.getLocation(context, namedElement);
    }

    public DefaultUastParser(@Nullable Project project, @NotNull com.intellij.openapi.project.Project p) {
        Intrinsics.checkParameterIsNotNull((Object)p, (String)"p");
        this.javaEvaluator = this.createEvaluator(project, p);
        this.uastContext = !p.isDisposed() ? (UastContext)ServiceManager.getService((com.intellij.openapi.project.Project)p, UastContext.class) : (UastContext)null;
    }
}

