/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.client.api;

import com.android.ide.common.blame.SourceFilePosition;
import com.android.manifmerger.Actions;
import com.android.manifmerger.XmlNode;
import com.android.tools.lint.client.api.LintClient;
import com.android.tools.lint.client.api.XmlParser;
import com.android.utils.Pair;
import com.google.common.base.Charsets;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.io.Files;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class BlameFile {
    public static final BlameFile NONE = new BlameFile(Collections.emptyMap(), null);
    private final Map<String, BlameNode> nodes;
    private final Actions actions;

    BlameFile(Map<String, BlameNode> nodes, Actions actions) {
        this.nodes = nodes;
        this.actions = actions;
    }

    private BlameNode findBlameNode(Element element) {
        String key = BlameFile.getNodeKey(element);
        BlameNode blameNode = this.nodes.get(key);
        if (blameNode == null && this.actions != null) {
            XmlNode.NodeKey nodeKey = XmlNode.NodeKey.fromXml((Element)element);
            ImmutableList records = this.actions.getNodeRecords(nodeKey);
            for (Actions.NodeRecord record : records) {
                SourceFilePosition actionLocation;
                File sourceFile;
                Actions.ActionType actionType = record.getActionType();
                if (actionType != Actions.ActionType.ADDED && actionType != Actions.ActionType.MERGED) continue;
                if (blameNode == null) {
                    blameNode = new BlameNode(key);
                    this.nodes.put(key, blameNode);
                }
                if ((sourceFile = (actionLocation = record.getActionLocation()).getFile().getSourceFile()) == null) continue;
                blameNode.setElementLocation(" from " + sourceFile.getPath());
            }
            for (XmlNode.NodeName nodeName : this.actions.getRecordedAttributeNames(nodeKey)) {
                for (Actions.AttributeRecord record : this.actions.getAttributeRecords(nodeKey, nodeName)) {
                    SourceFilePosition actionLocation;
                    File sourceFile;
                    Actions.ActionType actionType = record.getActionType();
                    if (actionType != Actions.ActionType.ADDED && actionType != Actions.ActionType.MERGED) continue;
                    if (blameNode == null) {
                        blameNode = new BlameNode(key);
                        this.nodes.put(key, blameNode);
                    }
                    if ((sourceFile = (actionLocation = record.getActionLocation()).getFile().getSourceFile()) == null) continue;
                    blameNode.setAttributeLocations(nodeName.getLocalName(), " from " + sourceFile.getPath());
                }
            }
        }
        return blameNode;
    }

    public Pair<File, Node> findSourceNode(LintClient client, Node node) {
        if (node instanceof Attr) {
            return this.findSourceAttribute(client, (Attr)node);
        }
        if (node instanceof Element) {
            return this.findSourceElement(client, (Element)node);
        }
        return null;
    }

    public Pair<File, Node> findSourceElement(LintClient client, Element element) {
        Pair<File, Node> source = this.findElementOrAttribute(client, element, null);
        if (source != null && source.getSecond() instanceof Element) {
            return source;
        }
        return null;
    }

    public Pair<File, Node> findSourceAttribute(LintClient client, Attr attr) {
        Element element = attr.getOwnerElement();
        Pair<File, Node> source = this.findElementOrAttribute(client, element, attr);
        if (source != null && source.getSecond() instanceof Attr) {
            return source;
        }
        if (source != null && source.getSecond() instanceof Element) {
            Element sourceElement = (Element)source.getSecond();
            if (attr.getPrefix() != null) {
                String localName;
                String namespace = attr.getNamespaceURI();
                Attr sourceAttribute = sourceElement.getAttributeNodeNS(namespace, localName = attr.getLocalName());
                if (sourceAttribute != null) {
                    return Pair.of((Object)source.getFirst(), (Object)sourceAttribute);
                }
                return null;
            }
            Attr sourceAttribute = sourceElement.getAttributeNode(attr.getName());
            if (sourceAttribute != null) {
                return Pair.of((Object)source.getFirst(), (Object)sourceAttribute);
            }
            return null;
        }
        return null;
    }

    private Pair<File, Node> findElementOrAttribute(LintClient client, Element element, Attr attribute) {
        Document document;
        char c;
        int range;
        BlameNode blameNode = this.findBlameNode(element);
        if (blameNode == null) {
            return null;
        }
        String location = null;
        if (attribute != null && (location = blameNode.getAttributeLocation(attribute.getName())) == null) {
            location = blameNode.getAttributeLocation(attribute.getLocalName());
        }
        if (location == null) {
            location = blameNode.getElementLocation();
        }
        if (location == null) {
            return null;
        }
        int index = location.indexOf(" from ");
        if (index == -1) {
            return null;
        }
        if (location.startsWith("[", index += " from ".length())) {
            index = location.indexOf("] ");
            if (index == -1) {
                return null;
            }
            index += 2;
        }
        for (range = location.length(); range > 0 && ((c = location.charAt(range - 1)) == ':' || c == '-' || Character.isDigit(c)); --range) {
        }
        String path = location.substring(index, range);
        File manifest = new File(path);
        if (!manifest.isFile()) {
            return null;
        }
        XmlParser parser = client.getXmlParser();
        try {
            document = parser.parseXml(manifest);
            if (document == null) {
                return null;
            }
        }
        catch (Throwable ignore) {
            return null;
        }
        final String targetKey = blameNode.getKey();
        final AtomicReference reference = new AtomicReference();
        XmlVisitor.accept(document, new XmlVisitor(){

            @Override
            public boolean visitTag(Element element, String tag) {
                String key = BlameFile.getNodeKey(element);
                if (targetKey.equals(key)) {
                    reference.set(element);
                    return true;
                }
                return false;
            }
        });
        return Pair.of((Object)manifest, reference.get());
    }

    private static String getNodeKey(Element element) {
        return XmlNode.NodeKey.fromXml((Element)element).toString();
    }

    public static BlameFile parse(File file) throws IOException {
        List lines = Files.readLines((File)file, (Charset)Charsets.UTF_8);
        return BlameFile.parse(lines);
    }

    public static BlameFile parse(Actions mergerActions) {
        HashMap nodes = Maps.newHashMapWithExpectedSize((int)80);
        return new BlameFile(nodes, mergerActions);
    }

    public static BlameFile parse(List<String> lines) {
        HashMap nodes = Maps.newHashMapWithExpectedSize((int)80);
        BlameNode last = null;
        String attributeName = null;
        for (String line : lines) {
            int indent;
            if (line.isEmpty() || line.startsWith("INJECTED ", indent = BlameFile.getIndent(line))) continue;
            if (line.startsWith("ADDED ", indent) || line.startsWith("MERGED ", indent)) {
                if (last == null) continue;
                if (indent > 0) {
                    assert (attributeName != null);
                    last.setAttributeLocations(attributeName, line.trim());
                    continue;
                }
                if (last.getElementLocation() != null) continue;
                last.setElementLocation(line.trim());
                continue;
            }
            if (line.startsWith("--")) continue;
            if (indent > 0) {
                attributeName = line.trim();
                continue;
            }
            String key = line.trim();
            BlameNode node = new BlameNode(key);
            nodes.put(key, node);
            attributeName = null;
            last = node;
        }
        return new BlameFile(nodes, null);
    }

    private static int getIndent(String line) {
        for (int i = 0; i < line.length(); ++i) {
            char c = line.charAt(i);
            if (c == '\t') continue;
            return i;
        }
        return line.length();
    }

    static class BlameNode {
        private String from;
        private List<Pair<String, String>> attributeLocations;
        private final String key;

        public BlameNode(String key) {
            this.key = key;
        }

        public String getKey() {
            return this.key;
        }

        public String getElementLocation() {
            return this.from;
        }

        public String getAttributeLocation(String name) {
            if (this.attributeLocations != null) {
                for (Pair<String, String> pair : this.attributeLocations) {
                    if (!name.equals(pair.getFirst())) continue;
                    return (String)pair.getSecond();
                }
            }
            return null;
        }

        public void setElementLocation(String location) {
            this.from = location;
        }

        public void setAttributeLocations(String name, String location) {
            if (this.attributeLocations != null) {
                if (name.equals(this.attributeLocations.get(this.attributeLocations.size() - 1).getFirst())) {
                    this.attributeLocations.remove(this.attributeLocations.size() - 1);
                }
            } else {
                this.attributeLocations = Lists.newArrayList();
            }
            this.attributeLocations.add((Pair<String, String>)Pair.of((Object)name, (Object)location));
        }
    }

    public static abstract class XmlVisitor {
        public boolean visitTag(Element element, String tag) {
            return false;
        }

        public boolean visitAttribute(Attr attribute) {
            return false;
        }

        public static void accept(Node node, XmlVisitor visitor) {
            visitor.visit(node);
        }

        private boolean visit(Node node) {
            if (node.getNodeType() == 1) {
                Element tag = (Element)node;
                if (this.visitTag(tag, tag.getLocalName())) {
                    return true;
                }
                NamedNodeMap attributes = tag.getAttributes();
                int n = attributes.getLength();
                for (int i = 0; i < n; ++i) {
                    Node attr = attributes.item(i);
                    if (!this.visitAttribute((Attr)attr)) continue;
                    return true;
                }
            }
            for (Node child = node.getFirstChild(); child != null; child = child.getNextSibling()) {
                if (!this.visit(child)) continue;
                return true;
            }
            return false;
        }
    }
}

