/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.client.api;

import com.android.builder.model.AndroidLibrary;
import com.android.builder.model.Dependencies;
import com.android.builder.model.JavaLibrary;
import com.android.builder.model.Library;
import com.android.builder.model.MavenCoordinates;
import com.android.tools.lint.detector.api.ClassContext;
import com.google.common.collect.Maps;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAnnotationOwner;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiEllipsisType;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeVisitor;
import com.intellij.psi.PsiWildcardType;
import java.io.File;
import java.util.Collection;
import java.util.Map;
import org.jetbrains.uast.UAnnotated;
import org.jetbrains.uast.UAnnotation;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UMethod;

public abstract class JavaEvaluator {
    private Map<String, MavenCoordinates> jarToGroup;

    public abstract boolean extendsClass(PsiClass var1, String var2, boolean var3);

    public abstract boolean implementsInterface(PsiClass var1, String var2, boolean var3);

    public boolean isMemberInSubClassOf(PsiMember method, String className, boolean strict) {
        PsiClass containingClass = method.getContainingClass();
        return containingClass != null && this.extendsClass(containingClass, className, strict);
    }

    public boolean isMemberInClass(PsiMember method, String className) {
        if (method == null) {
            return false;
        }
        PsiClass containingClass = method.getContainingClass();
        return containingClass != null && className.equals(containingClass.getQualifiedName());
    }

    public int getParameterCount(PsiMethod method) {
        return method.getParameterList().getParametersCount();
    }

    public boolean inheritsFrom(PsiClass cls, String className, boolean strict) {
        return this.extendsClass(cls, className, strict) || this.implementsInterface(cls, className, strict);
    }

    public boolean methodMatches(PsiMethod method, String className, boolean allowInherit, String ... argumentTypes) {
        if (className != null && allowInherit && !this.isMemberInSubClassOf((PsiMember)method, className, false)) {
            return false;
        }
        return this.parametersMatch(method, argumentTypes);
    }

    public boolean parametersMatch(PsiMethod method, String ... argumentTypes) {
        PsiParameterList parameterList = method.getParameterList();
        if (parameterList.getParametersCount() != argumentTypes.length) {
            return false;
        }
        PsiParameter[] parameters = parameterList.getParameters();
        for (int i = 0; i < parameters.length; ++i) {
            PsiType type = parameters[i].getType();
            if (type.getCanonicalText().equals(argumentTypes[i])) continue;
            return false;
        }
        return true;
    }

    public boolean parameterHasType(PsiMethod method, int parameterIndex, String typeName) {
        if (method == null) {
            return false;
        }
        PsiParameterList parameterList = method.getParameterList();
        return parameterList.getParametersCount() > parameterIndex && this.typeMatches(parameterList.getParameters()[parameterIndex].getType(), typeName);
    }

    public boolean typeMatches(PsiType type, String typeName) {
        return type != null && type.getCanonicalText().equals(typeName);
    }

    public PsiElement resolve(PsiElement element) {
        PsiMethod resolved;
        if (element instanceof PsiReference) {
            return ((PsiReference)element).resolve();
        }
        if (element instanceof PsiMethodCallExpression && (resolved = ((PsiMethodCallExpression)element).resolveMethod()) != null) {
            return resolved;
        }
        return null;
    }

    public boolean isPublic(PsiModifierListOwner owner) {
        if (owner != null) {
            PsiModifierList modifierList = owner.getModifierList();
            return modifierList != null && modifierList.hasModifierProperty("public");
        }
        return false;
    }

    public boolean isStatic(PsiModifierListOwner owner) {
        if (owner != null) {
            PsiModifierList modifierList = owner.getModifierList();
            return modifierList != null && modifierList.hasModifierProperty("static");
        }
        return false;
    }

    public boolean isPrivate(PsiModifierListOwner owner) {
        if (owner != null) {
            PsiModifierList modifierList = owner.getModifierList();
            return modifierList != null && modifierList.hasModifierProperty("private");
        }
        return false;
    }

    public boolean isAbstract(PsiModifierListOwner owner) {
        if (owner != null) {
            PsiModifierList modifierList = owner.getModifierList();
            return modifierList != null && modifierList.hasModifierProperty("abstract");
        }
        return false;
    }

    public boolean isFinal(PsiModifierListOwner owner) {
        if (owner != null) {
            PsiModifierList modifierList = owner.getModifierList();
            return modifierList != null && modifierList.hasModifierProperty("final");
        }
        return false;
    }

    public PsiMethod getSuperMethod(PsiMethod method) {
        if (method == null) {
            return null;
        }
        PsiMethod[] superMethods = method.findSuperMethods();
        if (superMethods.length > 0) {
            return superMethods[0];
        }
        return null;
    }

    public String getInternalName(PsiClass psiClass) {
        String qualifiedName = psiClass.getQualifiedName();
        if (qualifiedName == null && (qualifiedName = psiClass.getName()) == null) {
            assert (psiClass instanceof PsiAnonymousClass);
            return this.getInternalName(psiClass.getContainingClass());
        }
        return ClassContext.getInternalName(qualifiedName);
    }

    public String getInternalName(PsiClassType psiClassType) {
        return ClassContext.getInternalName(psiClassType.getCanonicalText());
    }

    public String getInternalDescription(PsiMethod method, boolean includeName, boolean includeReturn) {
        assert (!includeName);
        assert (!includeReturn);
        StringBuilder signature = new StringBuilder();
        if (includeName) {
            if (method.isConstructor()) {
                PsiClass outerClass;
                PsiClass declaringClass = method.getContainingClass();
                if (declaringClass != null && (outerClass = declaringClass.getContainingClass()) != null && !declaringClass.hasModifierProperty("static") && !this.appendJvmTypeName(signature, outerClass)) {
                    return null;
                }
                signature.append("<init>");
            } else {
                signature.append(method.getName());
            }
        }
        signature.append('(');
        for (PsiParameter psiParameter : method.getParameterList().getParameters()) {
            if (this.appendJvmSignature(signature, psiParameter.getType())) continue;
            return null;
        }
        signature.append(')');
        if (includeReturn) {
            if (!method.isConstructor()) {
                if (!this.appendJvmSignature(signature, method.getReturnType())) {
                    return null;
                }
            } else {
                signature.append('V');
            }
        }
        return signature.toString();
    }

    private boolean appendJvmTypeName(StringBuilder signature, PsiClass outerClass) {
        String className = this.getInternalName(outerClass);
        if (className == null) {
            return false;
        }
        signature.append('L').append(className.replace('.', '/')).append(';');
        return true;
    }

    private boolean appendJvmSignature(StringBuilder buffer, PsiType type) {
        if (type == null) {
            return false;
        }
        PsiType psiType = JavaEvaluator.erasure(type);
        if (psiType instanceof PsiArrayType) {
            buffer.append('[');
            this.appendJvmSignature(buffer, ((PsiArrayType)psiType).getComponentType());
        } else if (psiType instanceof PsiClassType) {
            PsiClass resolved = ((PsiClassType)psiType).resolve();
            if (resolved == null) {
                return false;
            }
            if (!this.appendJvmTypeName(buffer, resolved)) {
                return false;
            }
        } else if (psiType instanceof PsiPrimitiveType) {
            buffer.append(JavaEvaluator.getPrimitiveSignature(psiType.getCanonicalText()));
        } else {
            return false;
        }
        return true;
    }

    public boolean areSignaturesEqual(PsiMethod method1, PsiMethod method2) {
        PsiParameterList parameterList1 = method1.getParameterList();
        PsiParameterList parameterList2 = method2.getParameterList();
        if (parameterList1.getParametersCount() != parameterList2.getParametersCount()) {
            return false;
        }
        PsiParameter[] parameters1 = parameterList1.getParameters();
        PsiParameter[] parameters2 = parameterList2.getParameters();
        int n = parameters1.length;
        for (int i = 0; i < n; ++i) {
            PsiType type2;
            PsiParameter parameter1 = parameters1[i];
            PsiParameter parameter2 = parameters2[i];
            PsiType type1 = parameter1.getType();
            if (type1.equals(type2 = parameter2.getType()) || (type1 = JavaEvaluator.erasure(parameter1.getType())).equals(type2 = JavaEvaluator.erasure(parameter2.getType()))) continue;
            return false;
        }
        return true;
    }

    public static PsiType erasure(PsiType type) {
        if (type == null) {
            return null;
        }
        return (PsiType)type.accept((PsiTypeVisitor)new PsiTypeVisitor<PsiType>(){

            public PsiType visitType(PsiType type) {
                return type;
            }

            public PsiType visitClassType(PsiClassType classType) {
                return classType.rawType();
            }

            public PsiType visitWildcardType(PsiWildcardType wildcardType) {
                return wildcardType;
            }

            public PsiType visitPrimitiveType(PsiPrimitiveType primitiveType) {
                return primitiveType;
            }

            public PsiType visitEllipsisType(PsiEllipsisType ellipsisType) {
                PsiType componentType = ellipsisType.getComponentType();
                PsiType newComponentType = (PsiType)componentType.accept((PsiTypeVisitor)this);
                if (newComponentType == componentType) {
                    return ellipsisType;
                }
                return newComponentType != null ? newComponentType.createArrayType() : null;
            }

            public PsiType visitArrayType(PsiArrayType arrayType) {
                PsiType componentType = arrayType.getComponentType();
                PsiType newComponentType = (PsiType)componentType.accept((PsiTypeVisitor)this);
                if (newComponentType == componentType) {
                    return arrayType;
                }
                return newComponentType != null ? newComponentType.createArrayType() : null;
            }
        });
    }

    public static String getPrimitiveSignature(String typeName) {
        switch (typeName) {
            case "boolean": {
                return "Z";
            }
            case "byte": {
                return "B";
            }
            case "char": {
                return "C";
            }
            case "short": {
                return "S";
            }
            case "int": {
                return "I";
            }
            case "long": {
                return "J";
            }
            case "float": {
                return "F";
            }
            case "double": {
                return "D";
            }
            case "void": {
                return "V";
            }
        }
        return null;
    }

    public abstract PsiClass findClass(String var1);

    public abstract PsiClassType getClassType(PsiClass var1);

    public abstract PsiAnnotation[] getAllAnnotations(PsiModifierListOwner var1, boolean var2);

    public abstract PsiAnnotation findAnnotationInHierarchy(PsiModifierListOwner var1, String ... var2);

    public abstract PsiAnnotation findAnnotation(PsiModifierListOwner var1, String ... var2);

    public abstract String findJarPath(PsiElement var1);

    public abstract String findJarPath(UElement var1);

    public boolean isInherited(PsiAnnotation annotation, PsiModifierListOwner owner) {
        PsiAnnotationOwner annotationOwner = annotation.getOwner();
        return annotationOwner == null || !annotationOwner.equals(owner.getModifierList());
    }

    public boolean isInherited(UAnnotation annotation, PsiModifierListOwner owner) {
        PsiElement psi = annotation.getPsi();
        if (psi instanceof PsiAnnotation) {
            PsiAnnotationOwner annotationOwner = ((PsiAnnotation)psi).getOwner();
            return annotationOwner == null || !annotationOwner.equals(owner.getModifierList());
        }
        return true;
    }

    public boolean isInherited(UAnnotation annotation, UAnnotated owner) {
        return owner.getAnnotations().contains(annotation);
    }

    public abstract PsiPackage getPackage(PsiElement var1);

    public abstract PsiPackage getPackage(UElement var1);

    public PsiPackage getPackage(UMethod node) {
        return this.getPackage((PsiElement)node);
    }

    public MavenCoordinates getLibrary(PsiElement element) {
        return this.getLibrary(this.findJarPath(element));
    }

    public MavenCoordinates getLibrary(UElement element) {
        return this.getLibrary(this.findJarPath(element));
    }

    public MavenCoordinates getLibrary(UMethod element) {
        return this.getLibrary((PsiElement)element);
    }

    public abstract Dependencies getDependencies();

    private MavenCoordinates getLibrary(String jarFile) {
        if (jarFile != null) {
            MavenCoordinates coordinates;
            if (this.jarToGroup == null) {
                this.jarToGroup = Maps.newHashMap();
            }
            if ((coordinates = this.jarToGroup.get(jarFile)) == null) {
                int index;
                Library library = this.findOwnerLibrary(jarFile.replace('/', File.separatorChar));
                if (library != null) {
                    coordinates = library.getResolvedCoordinates();
                }
                if (coordinates == null && (index = jarFile.indexOf("exploded-aar")) != -1) {
                    block0: for (int i = index += 13; i < jarFile.length(); ++i) {
                        char c = jarFile.charAt(i);
                        if (c != '/' && c != File.separatorChar) continue;
                        String groupId = jarFile.substring(index, i);
                        for (int j = ++i; j < jarFile.length(); ++j) {
                            c = jarFile.charAt(j);
                            if (c != '/' && c != File.separatorChar) continue;
                            String artifactId = jarFile.substring(i, j);
                            coordinates = new MyMavenCoordinates(groupId, artifactId);
                            break block0;
                        }
                        break;
                    }
                }
                if (coordinates == null) {
                    coordinates = MyMavenCoordinates.NONE;
                }
                this.jarToGroup.put(jarFile, coordinates);
            }
            return coordinates == MyMavenCoordinates.NONE ? null : coordinates;
        }
        return null;
    }

    public Library findOwnerLibrary(String jarFile) {
        Dependencies dependencies = this.getDependencies();
        if (dependencies != null) {
            Library match = JavaEvaluator.findOwnerLibrary(dependencies.getLibraries(), jarFile);
            if (match != null) {
                return match;
            }
            match = JavaEvaluator.findOwnerJavaLibrary(dependencies.getJavaLibraries(), jarFile);
            if (match != null) {
                return match;
            }
        }
        return null;
    }

    private static Library findOwnerJavaLibrary(Collection<? extends JavaLibrary> dependencies, String jarFile) {
        for (JavaLibrary javaLibrary : dependencies) {
            if (jarFile.equals(javaLibrary.getJarFile().getPath())) {
                return javaLibrary;
            }
            Library match = JavaEvaluator.findOwnerJavaLibrary(javaLibrary.getDependencies(), jarFile);
            if (match == null) continue;
            return match;
        }
        return null;
    }

    private static Library findOwnerLibrary(Collection<? extends AndroidLibrary> dependencies, String jarFile) {
        for (AndroidLibrary androidLibrary : dependencies) {
            if (jarFile.equals(androidLibrary.getJarFile().getPath())) {
                return androidLibrary;
            }
            for (File jar : androidLibrary.getLocalJars()) {
                if (!jarFile.equals(jar.getPath())) continue;
                return androidLibrary;
            }
            Library match = JavaEvaluator.findOwnerLibrary(androidLibrary.getLibraryDependencies(), jarFile);
            if (match != null) {
                return match;
            }
            match = JavaEvaluator.findOwnerJavaLibrary(androidLibrary.getJavaDependencies(), jarFile);
            if (match == null) continue;
            return match;
        }
        return null;
    }

    private static class MyMavenCoordinates
    implements MavenCoordinates {
        private static final MyMavenCoordinates NONE = new MyMavenCoordinates("", "");
        private final String groupId;
        private final String artifactId;

        public MyMavenCoordinates(String groupId, String artifactId) {
            this.groupId = groupId;
            this.artifactId = artifactId;
        }

        public String getGroupId() {
            return this.groupId;
        }

        public String getArtifactId() {
            return this.artifactId;
        }

        public String getVersion() {
            return "";
        }

        public String getPackaging() {
            return "";
        }

        public String getClassifier() {
            return "";
        }

        public String getVersionlessId() {
            return this.groupId + ':' + this.artifactId;
        }
    }
}

