/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.client.api;

import com.android.resources.ResourceType;
import com.google.common.base.Joiner;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import java.util.Collections;
import java.util.List;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UExpression;
import org.jetbrains.uast.UQualifiedReferenceExpression;
import org.jetbrains.uast.UResolvable;
import org.jetbrains.uast.USimpleNameReferenceExpression;
import org.jetbrains.uast.UVariable;
import org.jetbrains.uast.UastUtils;
import org.jetbrains.uast.java.JavaAbstractUExpression;
import org.jetbrains.uast.java.JavaUDeclarationsExpression;

public class ResourceReference {
    public final UExpression node;
    private final String rPackage;
    private final ResourceType type;
    private final String name;

    public String getPackage() {
        return this.rPackage;
    }

    public ResourceType getType() {
        return this.type;
    }

    public String getName() {
        return this.name;
    }

    boolean isFramework() {
        return this.rPackage.equals("android");
    }

    public ResourceReference(UExpression node, String rPackage, ResourceType type, String name) {
        this.node = node;
        this.rPackage = rPackage;
        this.type = type;
        this.name = name;
    }

    private static ResourceReference toAndroidReference(UQualifiedReferenceExpression expression) {
        int i;
        String containingClassFqName;
        List path2 = UastUtils.asQualifiedPath((UExpression)expression);
        String packageNameFromResolved = null;
        PsiClass containingClass = UastUtils.getContainingClass((PsiElement)expression.resolve());
        if (containingClass != null && (containingClassFqName = containingClass.getQualifiedName()) != null && (i = containingClassFqName.lastIndexOf(".R.")) >= 0) {
            packageNameFromResolved = containingClassFqName.substring(0, i);
        }
        if (path2 == null) {
            return null;
        }
        int size = path2.size();
        if (size < 3) {
            return null;
        }
        String r = (String)path2.get(size - 3);
        if (!r.equals("R")) {
            return null;
        }
        String packageName = packageNameFromResolved != null ? packageNameFromResolved : Joiner.on((char)'.').join(path2.subList(0, size - 3));
        String type = (String)path2.get(size - 2);
        String name = (String)path2.get(size - 1);
        ResourceType resourceType = null;
        for (ResourceType value : ResourceType.values()) {
            if (!value.getName().equals(type)) continue;
            resourceType = value;
            break;
        }
        if (resourceType == null) {
            return null;
        }
        return new ResourceReference((UExpression)expression, packageName, resourceType, name);
    }

    public static ResourceReference get(UElement element) {
        UExpression node;
        ResourceReference ref;
        UExpression maybeQualified;
        PsiVariable declaration;
        ResourceReference ref2;
        if (element instanceof UQualifiedReferenceExpression && element instanceof JavaAbstractUExpression && (ref2 = ResourceReference.toAndroidReference((UQualifiedReferenceExpression)element)) != null) {
            return ref2;
        }
        if (element instanceof UVariable) {
            declaration = ((UVariable)element).getPsi();
        } else if (element instanceof UResolvable) {
            declaration = ((UResolvable)element).resolve();
        } else {
            return null;
        }
        if (declaration == null && element instanceof USimpleNameReferenceExpression && element instanceof JavaAbstractUExpression && (maybeQualified = UastUtils.getQualifiedParentOrThis((UExpression)((UExpression)element))) instanceof UQualifiedReferenceExpression && (ref = ResourceReference.toAndroidReference((UQualifiedReferenceExpression)maybeQualified)) != null) {
            return ref;
        }
        if (!(declaration instanceof PsiVariable)) {
            return null;
        }
        PsiVariable variable = declaration;
        if (!(variable instanceof PsiField) || variable.getType() != PsiType.INT || !variable.hasModifierProperty("static")) {
            return null;
        }
        PsiClass resTypeClass = ((PsiField)variable).getContainingClass();
        if (resTypeClass == null || !resTypeClass.hasModifierProperty("static")) {
            return null;
        }
        PsiClass rClass = resTypeClass.getContainingClass();
        if (rClass == null || rClass.getContainingClass() != null || !"R".equals(rClass.getName())) {
            return null;
        }
        String packageName = ((PsiJavaFile)rClass.getContainingFile()).getPackageName();
        if (packageName.isEmpty()) {
            return null;
        }
        ResourceType resourceType = ResourceType.getEnum((String)resTypeClass.getName());
        if (resourceType == null) {
            return null;
        }
        String resourceName = variable.getName();
        if (element instanceof UExpression) {
            node = (UExpression)element;
        } else if (element instanceof UVariable) {
            node = new JavaUDeclarationsExpression(null, Collections.singletonList((UVariable)element));
        } else {
            throw new IllegalArgumentException("element must be an expression or a UVariable");
        }
        return new ResourceReference(node, packageName, resourceType, resourceName);
    }
}

