/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.detector.api;

import com.android.tools.lint.detector.api.Location;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import org.intellij.lang.annotations.Language;
import org.jetbrains.annotations.Nls;

public class LintFix {
    @Nls
    public final String displayName;

    protected LintFix(String displayName) {
        this.displayName = displayName;
    }

    public static Builder create() {
        return new Builder();
    }

    @Nls
    public String getDisplayName() {
        return this.displayName;
    }

    public static <T> T getData(LintFix fix, Class<T> key) {
        if (fix instanceof DataMap) {
            return ((DataMap)fix).get(key);
        }
        return null;
    }

    public static class ReplaceString
    extends LintFix {
        public final String oldString;
        public final String oldPattern;
        public final String replacement;
        public final Location range;
        public final boolean shortenNames;
        public final boolean reformat;

        private ReplaceString(String displayName, String oldString, String oldPattern, String replacement, boolean shortenNames, boolean reformat, Location range) {
            super(displayName);
            this.oldString = oldString;
            this.oldPattern = oldPattern;
            this.replacement = replacement;
            this.shortenNames = shortenNames;
            this.reformat = reformat;
            this.range = range;
        }

        @Override
        public String getDisplayName() {
            if (this.displayName != null) {
                return this.displayName;
            }
            return "Replace with " + this.replacement;
        }

        public String expandBackReferences(Matcher matcher) {
            return ReplaceString.expandBackReferences(this.replacement, matcher);
        }

        public static String expandBackReferences(String replacement, Matcher matcher) {
            if (!replacement.contains("\\k<")) {
                return replacement;
            }
            StringBuilder sb = new StringBuilder();
            int begin = 0;
            while (true) {
                int end;
                if ((end = replacement.indexOf("\\k<", begin)) == -1) break;
                int next = replacement.indexOf(62, end + 3);
                if (next != -1 && Character.isDigit(replacement.charAt(end + 3))) {
                    sb.append(replacement.substring(begin, end));
                    String groupString = replacement.substring(end + 3, next);
                    int group = Integer.parseInt(groupString);
                    if (group <= matcher.groupCount()) {
                        sb.append(matcher.group(group));
                    }
                    begin = next + 1;
                    continue;
                }
                sb.append(replacement.substring(begin, end += 3));
                begin = end;
            }
            sb.append(replacement.substring(begin));
            return sb.toString();
        }
    }

    public static class SetAttribute
    extends LintFix {
        public final String namespace;
        public final String attribute;
        public final String value;
        public final int dot;
        public final int mark;

        private SetAttribute(String displayName, String namespace, String attribute, String value, int dot, int mark) {
            super(displayName);
            this.namespace = namespace;
            this.attribute = attribute;
            this.value = value;
            this.dot = dot;
            this.mark = mark;
        }

        @Override
        public String getDisplayName() {
            if (this.displayName != null) {
                return this.displayName;
            }
            if (this.value != null) {
                if (this.value.isEmpty() || this.dot > 0) {
                    return "Set " + this.attribute;
                }
                return "Set " + this.attribute + "=\"" + this.value + "\"";
            }
            return "Delete " + this.attribute;
        }
    }

    public static class LintFixGroup
    extends LintFix {
        public final List<LintFix> fixes;
        public final GroupType type;

        public LintFixGroup(String displayName, GroupType type, List<LintFix> fixes) {
            super(displayName);
            this.type = type;
            this.fixes = fixes;
        }

        @Override
        @Nls
        public String getDisplayName() {
            if (this.displayName == null && this.type == GroupType.COMPOSITE) {
                for (LintFix fix : this.fixes) {
                    String name = fix.getDisplayName();
                    if (name == null) continue;
                    return name;
                }
            }
            return this.displayName;
        }
    }

    public static enum GroupType {
        COMPOSITE,
        ALTERNATIVES;

    }

    public static class DataMap
    extends LintFix
    implements Iterable {
        private final Map<Object, Object> map;

        private DataMap(String displayName, Map<Object, Object> map) {
            super(displayName);
            this.map = map;
        }

        public <T> T get(Class<T> key) {
            Object t = this.map.get(key);
            if (t != null) {
                return (T)t;
            }
            for (Map.Entry<Object, Object> entry : this.map.entrySet()) {
                Object k = entry.getKey();
                if (!(k instanceof Class) || !key.isAssignableFrom((Class)k)) continue;
                return (T)entry.getValue();
            }
            return null;
        }

        public Object get(String key) {
            return this.map.get(key);
        }

        public Iterator iterator() {
            return this.map.values().iterator();
        }

        public Set<Object> keys() {
            return this.map.keySet();
        }

        public String toString() {
            return this.map.toString();
        }
    }

    public static class FixMapBuilder {
        @Nls
        protected final String displayName;
        private final Map<Object, Object> map = Maps.newHashMapWithExpectedSize((int)4);

        private FixMapBuilder(String displayName) {
            this.displayName = displayName;
        }

        public <T> FixMapBuilder put(T value) {
            if (value == null) {
                return this;
            }
            Class<Object> key = value.getClass();
            if (value instanceof List) {
                key = List.class;
            } else if (value instanceof Map) {
                key = Map.class;
            } else if (value instanceof Set) {
                key = Set.class;
            }
            assert (!this.map.containsKey(key));
            this.map.put(key, value);
            return this;
        }

        public FixMapBuilder put(String key, Object value) {
            if (value == null) {
                return this;
            }
            assert (!this.map.containsKey(key));
            this.map.put(key, value);
            return this;
        }

        public LintFix build() {
            return new DataMap(this.displayName, this.map);
        }
    }

    public static class SetAttributeBuilder {
        @Nls
        protected String displayName;
        private String attribute;
        private String namespace;
        private String value = "";
        private int mark = Integer.MIN_VALUE;
        private int dot = Integer.MIN_VALUE;

        private SetAttributeBuilder(String displayName) {
            this.displayName = displayName;
        }

        public SetAttributeBuilder name(String displayName) {
            this.displayName = displayName;
            return this;
        }

        public SetAttributeBuilder android() {
            assert (this.namespace == null);
            this.namespace = "http://schemas.android.com/apk/res/android";
            return this;
        }

        public SetAttributeBuilder namespace(String namespace) {
            assert (this.namespace == null);
            this.namespace = namespace;
            return this;
        }

        public SetAttributeBuilder value(String value) {
            this.value = value;
            if (value != null && value.isEmpty()) {
                this.caret(0);
            }
            return this;
        }

        public SetAttributeBuilder attribute(String attribute) {
            assert (attribute.indexOf(58) == -1) : attribute;
            assert (this.attribute == null);
            this.attribute = attribute;
            return this;
        }

        public SetAttributeBuilder remove(String attribute) {
            assert (this.attribute == null);
            assert (attribute.indexOf(58) == -1) : attribute;
            this.attribute = attribute;
            this.value = null;
            return this;
        }

        public SetAttributeBuilder selectAll() {
            assert (this.value != null);
            this.mark = 0;
            this.dot = this.value.length();
            return this;
        }

        public SetAttributeBuilder todo(String namespace, String attribute, String prefix, String suffix) {
            this.namespace(namespace);
            this.attribute(attribute);
            StringBuilder sb = new StringBuilder();
            if (prefix != null) {
                sb.append(prefix);
            }
            int start = sb.length();
            sb.append("TODO");
            int end = sb.length();
            if (suffix != null) {
                sb.append(suffix);
            }
            this.value(sb.toString());
            this.select(start, end);
            return this;
        }

        public SetAttributeBuilder todo(String namespace, String attribute) {
            return this.todo(namespace, attribute, null, null);
        }

        public SetAttributeBuilder select(int start, int end) {
            assert (this.value != null);
            this.mark = Math.min(start, end);
            this.dot = Math.max(start, end);
            return this;
        }

        public SetAttributeBuilder caret(int valueStartDelta) {
            this.mark = this.dot = valueStartDelta;
            return this;
        }

        public SetAttributeBuilder caretBegin() {
            return this.caret(0);
        }

        public SetAttributeBuilder caretEnd() {
            assert (this.value != null);
            return this.caret(this.value.length());
        }

        public LintFix build() {
            return new SetAttribute(this.displayName, this.namespace, this.attribute, this.value, this.dot, this.mark);
        }
    }

    public static class ReplaceStringBuilder {
        @Nls
        protected String displayName;
        private String newText;
        private String oldText;
        private boolean shortenNames;
        private boolean reformat;
        @Language(value="RegExp")
        private String oldPattern;
        private Location range;

        private ReplaceStringBuilder(String displayName) {
            this.displayName = displayName;
        }

        public ReplaceStringBuilder name(String displayName) {
            this.displayName = displayName;
            return this;
        }

        public ReplaceStringBuilder pattern(@Language(value="RegExp") String oldPattern) {
            assert (this.oldText == null);
            assert (this.oldPattern == null);
            if (oldPattern.indexOf(40) == -1) {
                oldPattern = "(" + oldPattern + ")";
            }
            this.oldPattern = oldPattern;
            return this;
        }

        public ReplaceStringBuilder text(String oldText) {
            assert (this.oldText == null);
            assert (this.oldPattern == null);
            this.oldText = oldText;
            return this;
        }

        public ReplaceStringBuilder range(Location range) {
            this.range = range;
            return this;
        }

        public ReplaceStringBuilder all() {
            return this;
        }

        public ReplaceStringBuilder with(String newText) {
            assert (this.newText == null);
            this.newText = newText;
            return this;
        }

        public ReplaceStringBuilder shortenNames() {
            this.shortenNames = true;
            return this;
        }

        public ReplaceStringBuilder reformat(boolean reformat) {
            this.reformat = reformat;
            return this;
        }

        public LintFix build() {
            return new ReplaceString(this.displayName, this.oldText, this.oldPattern, this.newText != null ? this.newText : "", this.shortenNames, this.reformat, this.range);
        }
    }

    public static class GroupBuilder {
        @Nls
        private String displayName;
        private GroupType type = GroupType.ALTERNATIVES;
        private final List<LintFix> list = Lists.newArrayListWithExpectedSize((int)4);

        private GroupBuilder(String displayName) {
            this.displayName = displayName;
        }

        public GroupBuilder name(String displayName) {
            this.displayName = displayName;
            return this;
        }

        public GroupBuilder join(LintFix ... fixes) {
            this.list.addAll(Arrays.asList(fixes));
            return this;
        }

        public GroupBuilder add(LintFix fix) {
            this.list.add(fix);
            return this;
        }

        public GroupBuilder type(GroupType type) {
            this.type = type;
            return this;
        }

        public LintFix build() {
            assert (!this.list.isEmpty());
            return new LintFixGroup(this.displayName, this.type, this.list);
        }
    }

    public static class Builder {
        @Nls
        protected String displayName;

        private Builder() {
        }

        public Builder name(String displayName) {
            this.displayName = displayName;
            return this;
        }

        public GroupBuilder group() {
            return new GroupBuilder(this.displayName).type(GroupType.ALTERNATIVES);
        }

        public GroupBuilder composite() {
            return new GroupBuilder(this.displayName).type(GroupType.COMPOSITE);
        }

        public LintFix composite(LintFix ... fixes) {
            return new GroupBuilder(this.displayName).type(GroupType.COMPOSITE).join(fixes).build();
        }

        public LintFix group(LintFix ... fixes) {
            return new GroupBuilder(this.displayName).join(fixes).build();
        }

        public ReplaceStringBuilder replace() {
            return new ReplaceStringBuilder(this.displayName);
        }

        public SetAttributeBuilder set() {
            return new SetAttributeBuilder(this.displayName);
        }

        public SetAttributeBuilder unset() {
            return new SetAttributeBuilder(this.displayName).value(null);
        }

        public SetAttributeBuilder set(String namespace, String attribute, String value) {
            return new SetAttributeBuilder(this.displayName).namespace(namespace).attribute(attribute).value(value);
        }

        public SetAttributeBuilder unset(String namespace, String attribute) {
            return new SetAttributeBuilder(this.displayName).namespace(namespace).attribute(attribute).value(null);
        }

        public FixMapBuilder map() {
            return new FixMapBuilder(this.displayName);
        }

        public FixMapBuilder map(Object ... args) {
            FixMapBuilder builder = this.map();
            for (Object arg : args) {
                builder.put(arg);
            }
            return builder;
        }

        public LintFix data(Object ... args) {
            return this.map(args).build();
        }
    }
}

