/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.helpers;

import com.android.builder.model.AndroidArtifact;
import com.android.builder.model.Dependencies;
import com.android.builder.model.Variant;
import com.android.tools.lint.client.api.JavaEvaluator;
import com.android.tools.lint.detector.api.LintUtils;
import com.android.tools.lint.detector.api.Project;
import com.google.common.collect.Sets;
import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileSystem;
import com.intellij.psi.JavaDirectoryService;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiCompiledFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiType;
import com.intellij.psi.impl.file.PsiPackageImpl;
import com.intellij.psi.impl.source.tree.java.PsiCompositeModifierList;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.MethodSignatureUtil;
import com.intellij.psi.util.TypeConversionUtil;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.uast.UCallExpression;
import org.jetbrains.uast.UDeclaration;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UExpression;
import org.jetbrains.uast.UFile;
import org.jetbrains.uast.UastUtils;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000\u0090\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0016\u0018\u00002\u00020\u0001B\u0019\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\u0006J\u0018\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000eH\u0016J$\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u00130\u00112\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u000eH\u0016J\u0014\u0010\u0017\u001a\u0004\u0018\u00010\u00182\b\u0010\u0019\u001a\u0004\u0018\u00010\u0018H\u0016J\"\u0010\u001a\u001a\u00020\f2\b\u0010\u001b\u001a\u0004\u0018\u00010\u001c2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\fH\u0016J-\u0010 \u001a\u0004\u0018\u00010!2\b\u0010\"\u001a\u0004\u0018\u00010#2\u0012\u0010$\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u001e0%\"\u00020\u001eH\u0016\u00a2\u0006\u0002\u0010&J+\u0010'\u001a\u0004\u0018\u00010!2\u0006\u0010\"\u001a\u00020#2\u0012\u0010$\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u001e0%\"\u00020\u001eH\u0016\u00a2\u0006\u0002\u0010&J\u0012\u0010(\u001a\u0004\u0018\u00010\u001c2\u0006\u0010)\u001a\u00020\u001eH\u0016J\u0012\u0010*\u001a\u0004\u0018\u00010\u001e2\u0006\u0010+\u001a\u00020,H\u0016J\u0014\u0010*\u001a\u0004\u0018\u00010\u001e2\b\u0010-\u001a\u0004\u0018\u00010.H\u0002J\u0012\u0010*\u001a\u0004\u0018\u00010\u001e2\u0006\u0010+\u001a\u00020/H\u0016J#\u00100\u001a\b\u0012\u0004\u0012\u00020!0%2\u0006\u00101\u001a\u00020#2\u0006\u00102\u001a\u00020\fH\u0016\u00a2\u0006\u0002\u00103J\u0014\u00104\u001a\u0004\u0018\u0001052\b\u00106\u001a\u0004\u0018\u00010\u001cH\u0016J\u0012\u00107\u001a\u0004\u0018\u00010\u001e2\u0006\u00106\u001a\u00020\u001cH\u0017J\u0012\u00107\u001a\u0004\u0018\u00010\u001e2\u0006\u00108\u001a\u000205H\u0017J\u0012\u00109\u001a\u0004\u0018\u00010:2\u0006\u0010;\u001a\u00020,H\u0016J\u0012\u00109\u001a\u0004\u0018\u00010:2\u0006\u0010;\u001a\u00020/H\u0016J\u0012\u0010<\u001a\u0004\u0018\u00010\u001e2\u0006\u00106\u001a\u00020\u001cH\u0016J\u0012\u0010<\u001a\u0004\u0018\u00010\u001e2\u0006\u00108\u001a\u000205H\u0016J \u0010=\u001a\u00020\f2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010>\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\fH\u0016J \u0010?\u001a\u00020\f2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\fH\u0016R\u0016\u0010\u0007\u001a\u0004\u0018\u00010\b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0002\u001a\u0004\u0018\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006@"}, d2={"Lcom/android/tools/lint/helpers/DefaultJavaEvaluator;", "Lcom/android/tools/lint/client/api/JavaEvaluator;", "myProject", "Lcom/intellij/openapi/project/Project;", "myLintProject", "Lcom/android/tools/lint/detector/api/Project;", "(Lcom/intellij/openapi/project/Project;Lcom/android/tools/lint/detector/api/Project;)V", "dependencies", "Lcom/android/builder/model/Dependencies;", "getDependencies", "()Lcom/android/builder/model/Dependencies;", "areSignaturesEqual", "", "method1", "Lcom/intellij/psi/PsiMethod;", "method2", "computeArgumentMapping", "", "Lorg/jetbrains/uast/UExpression;", "Lcom/intellij/psi/PsiParameter;", "call", "Lorg/jetbrains/uast/UCallExpression;", "method", "erasure", "Lcom/intellij/psi/PsiType;", "type", "extendsClass", "cls", "Lcom/intellij/psi/PsiClass;", "className", "", "strict", "findAnnotation", "Lcom/intellij/psi/PsiAnnotation;", "listOwner", "Lcom/intellij/psi/PsiModifierListOwner;", "annotationNames", "", "(Lcom/intellij/psi/PsiModifierListOwner;[Ljava/lang/String;)Lcom/intellij/psi/PsiAnnotation;", "findAnnotationInHierarchy", "findClass", "qualifiedName", "findJarPath", "element", "Lcom/intellij/psi/PsiElement;", "containingFile", "Lcom/intellij/psi/PsiFile;", "Lorg/jetbrains/uast/UElement;", "getAllAnnotations", "owner", "inHierarchy", "(Lcom/intellij/psi/PsiModifierListOwner;Z)[Lcom/intellij/psi/PsiAnnotation;", "getClassType", "Lcom/intellij/psi/PsiClassType;", "psiClass", "getInternalName", "psiClassType", "getPackage", "Lcom/intellij/psi/PsiPackage;", "node", "getQualifiedName", "implementsInterface", "interfaceName", "inheritsFrom", "lint-api"})
public class DefaultJavaEvaluator
extends JavaEvaluator {
    private final com.intellij.openapi.project.Project myProject;
    private final Project myLintProject;

    @Override
    @Nullable
    public Dependencies getDependencies() {
        Variant variant;
        if (this.myLintProject != null && this.myLintProject.isAndroidProject() && (variant = this.myLintProject.getCurrentVariant()) != null) {
            AndroidArtifact androidArtifact = variant.getMainArtifact();
            Intrinsics.checkExpressionValueIsNotNull((Object)androidArtifact, (String)"variant.mainArtifact");
            return androidArtifact.getDependencies();
        }
        return null;
    }

    @Override
    public boolean extendsClass(@Nullable PsiClass cls, @NotNull String className, boolean strict) {
        Intrinsics.checkParameterIsNotNull((Object)className, (String)"className");
        return InheritanceUtil.isInheritor((PsiClass)cls, (boolean)strict, (String)className);
    }

    @Override
    public boolean implementsInterface(@NotNull PsiClass cls, @NotNull String interfaceName, boolean strict) {
        Intrinsics.checkParameterIsNotNull((Object)cls, (String)"cls");
        Intrinsics.checkParameterIsNotNull((Object)interfaceName, (String)"interfaceName");
        return InheritanceUtil.isInheritor((PsiClass)cls, (boolean)strict, (String)interfaceName);
    }

    @Override
    public boolean inheritsFrom(@NotNull PsiClass cls, @NotNull String className, boolean strict) {
        Intrinsics.checkParameterIsNotNull((Object)cls, (String)"cls");
        Intrinsics.checkParameterIsNotNull((Object)className, (String)"className");
        return InheritanceUtil.isInheritor((PsiClass)cls, (boolean)strict, (String)className);
    }

    @Override
    @Nullable
    public PsiClass findClass(@NotNull String qualifiedName) {
        Intrinsics.checkParameterIsNotNull((Object)qualifiedName, (String)"qualifiedName");
        com.intellij.openapi.project.Project project = this.myProject;
        if (project == null) {
            return null;
        }
        return JavaPsiFacade.getInstance((com.intellij.openapi.project.Project)project).findClass(qualifiedName, GlobalSearchScope.allScope((com.intellij.openapi.project.Project)this.myProject));
    }

    @Override
    @Nullable
    public PsiClassType getClassType(@Nullable PsiClass psiClass) {
        return this.myProject != null && psiClass != null ? JavaPsiFacade.getElementFactory((com.intellij.openapi.project.Project)this.myProject).createType(psiClass) : null;
    }

    @Override
    @NotNull
    public PsiAnnotation[] getAllAnnotations(@NotNull PsiModifierListOwner owner, boolean inHierarchy) {
        Intrinsics.checkParameterIsNotNull((Object)owner, (String)"owner");
        if (owner instanceof UDeclaration) {
            return this.getAllAnnotations(((UDeclaration)owner).getPsi(), inHierarchy);
        }
        PsiAnnotation[] psiAnnotationArray = AnnotationUtil.getAllAnnotations((PsiModifierListOwner)owner, (boolean)inHierarchy, null, (boolean)false);
        Intrinsics.checkExpressionValueIsNotNull((Object)psiAnnotationArray, (String)"AnnotationUtil.getAllAnn\u2026inHierarchy, null, false)");
        return psiAnnotationArray;
    }

    @Override
    @Nullable
    public PsiAnnotation findAnnotationInHierarchy(@NotNull PsiModifierListOwner listOwner, String ... annotationNames) {
        Intrinsics.checkParameterIsNotNull((Object)listOwner, (String)"listOwner");
        Intrinsics.checkParameterIsNotNull((Object)annotationNames, (String)"annotationNames");
        if (listOwner instanceof UDeclaration) {
            return this.findAnnotationInHierarchy(((UDeclaration)listOwner).getPsi(), Arrays.copyOf(annotationNames, annotationNames.length));
        }
        return AnnotationUtil.findAnnotationInHierarchy((PsiModifierListOwner)listOwner, (Set)Sets.newHashSet((Object[])Arrays.copyOf(annotationNames, annotationNames.length)));
    }

    @Override
    @Nullable
    public PsiAnnotation findAnnotation(@Nullable PsiModifierListOwner listOwner, String ... annotationNames) {
        Intrinsics.checkParameterIsNotNull((Object)annotationNames, (String)"annotationNames");
        if (listOwner instanceof UDeclaration) {
            return this.findAnnotation(((UDeclaration)listOwner).getPsi(), Arrays.copyOf(annotationNames, annotationNames.length));
        }
        return AnnotationUtil.findAnnotation((PsiModifierListOwner)listOwner, (boolean)false, (String[])Arrays.copyOf(annotationNames, annotationNames.length));
    }

    @Override
    public boolean areSignaturesEqual(@NotNull PsiMethod method1, @NotNull PsiMethod method2) {
        Intrinsics.checkParameterIsNotNull((Object)method1, (String)"method1");
        Intrinsics.checkParameterIsNotNull((Object)method2, (String)"method2");
        return MethodSignatureUtil.areSignaturesEqual((PsiMethod)method1, (PsiMethod)method2);
    }

    @Override
    @Nullable
    public String findJarPath(@NotNull PsiElement element) {
        Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
        PsiFile containingFile = element.getContainingFile();
        return this.findJarPath(containingFile);
    }

    @Override
    @Nullable
    public String findJarPath(@NotNull UElement element) {
        Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
        UFile uFile = UastUtils.getContainingUFile((UElement)element);
        return uFile != null ? this.findJarPath(uFile.getPsi()) : null;
    }

    private final String findJarPath(PsiFile containingFile) {
        VirtualFile file;
        if (containingFile instanceof PsiCompiledFile && (file = ((PsiCompiledFile)containingFile).getVirtualFile()) != null) {
            VirtualFileSystem virtualFileSystem = file.getFileSystem();
            Intrinsics.checkExpressionValueIsNotNull((Object)virtualFileSystem, (String)"file.fileSystem");
            if (Intrinsics.areEqual((Object)virtualFileSystem.getProtocol(), (Object)"jar")) {
                String path2;
                String string = path2 = file.getPath();
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"path");
                int separatorIndex = StringsKt.indexOf$default((CharSequence)string, (String)"!/", (int)0, (boolean)false, (int)6, null);
                if (separatorIndex >= 0) {
                    String string2 = path2;
                    int n = 0;
                    String string3 = string2.substring(n, separatorIndex);
                    Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
                    return string3;
                }
            }
        }
        return null;
    }

    @Override
    @Nullable
    public PsiPackage getPackage(@NotNull PsiElement node) {
        PsiFile containingFile;
        PsiFile psiFile;
        Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
        PsiElement psiElement = node;
        if (!(psiElement instanceof PsiFile)) {
            psiElement = null;
        }
        if ((psiFile = (PsiFile)psiElement) == null) {
            psiFile = containingFile = node.getContainingFile();
        }
        if (containingFile != null) {
            if (containingFile instanceof PsiJavaFile) {
                String packageName = ((PsiJavaFile)containingFile).getPackageName();
                return (PsiPackage)new PsiPackageImpl(this, packageName, node, node.getManager(), packageName){
                    final /* synthetic */ DefaultJavaEvaluator this$0;
                    final /* synthetic */ String $packageName;
                    final /* synthetic */ PsiElement $node;

                    @Nullable
                    public PsiModifierList getAnnotationList() {
                        PsiClass cls = this.this$0.findClass(this.$packageName + '.' + "package-info");
                        if (cls != null) {
                            PsiModifierList modifierList = cls.getModifierList();
                            return modifierList != null ? (PsiModifierList)new PsiCompositeModifierList(this.getManager(), CollectionsKt.listOf((Object)modifierList)) : modifierList;
                        }
                        return null;
                    }
                    {
                        this.this$0 = $outer;
                        this.$packageName = $captured_local_variable$1;
                        this.$node = $captured_local_variable$2;
                        super($super_call_param$3, $super_call_param$4);
                    }
                };
            }
            PsiDirectory dir = containingFile.getParent();
            if (dir != null) {
                return JavaDirectoryService.getInstance().getPackage(dir);
            }
        }
        return null;
    }

    @Override
    @Nullable
    public PsiPackage getPackage(@NotNull UElement node) {
        Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
        UFile uFile = UastUtils.getContainingUFile((UElement)node);
        return uFile != null ? this.getPackage((PsiElement)uFile.getPsi()) : null;
    }

    @Override
    @Nullable
    public String getQualifiedName(@NotNull PsiClassType psiClassType) {
        Intrinsics.checkParameterIsNotNull((Object)psiClassType, (String)"psiClassType");
        PsiType erased = this.erasure((PsiType)psiClassType);
        return erased instanceof PsiClassType ? super.getQualifiedName((PsiClassType)erased) : super.getQualifiedName(psiClassType);
    }

    @Override
    @Nullable
    public String getQualifiedName(@NotNull PsiClass psiClass) {
        Intrinsics.checkParameterIsNotNull((Object)psiClass, (String)"psiClass");
        return psiClass.getQualifiedName();
    }

    @Override
    @Nullable
    public String getInternalName(@NotNull PsiClassType psiClassType) {
        Intrinsics.checkParameterIsNotNull((Object)psiClassType, (String)"psiClassType");
        PsiType erased = this.erasure((PsiType)psiClassType);
        return erased instanceof PsiClassType ? super.getInternalName((PsiClassType)erased) : super.getInternalName(psiClassType);
    }

    @Override
    @Nullable
    public String getInternalName(@NotNull PsiClass psiClass) {
        Intrinsics.checkParameterIsNotNull((Object)psiClass, (String)"psiClass");
        return LintUtils.getInternalName(psiClass);
    }

    @Override
    @Nullable
    public PsiType erasure(@Nullable PsiType type) {
        return TypeConversionUtil.erasure((PsiType)type);
    }

    @Override
    @NotNull
    public Map<UExpression, PsiParameter> computeArgumentMapping(@NotNull UCallExpression call, @NotNull PsiMethod method) {
        PsiParameter psiParameter;
        Map map;
        PsiParameter parameter;
        UExpression argument;
        Object[] objectArray;
        PsiParameterList parameterList;
        Intrinsics.checkParameterIsNotNull((Object)call, (String)"call");
        Intrinsics.checkParameterIsNotNull((Object)method, (String)"method");
        PsiParameterList psiParameterList = parameterList = method.getParameterList();
        Intrinsics.checkExpressionValueIsNotNull((Object)psiParameterList, (String)"parameterList");
        if (psiParameterList.getParametersCount() == 0) {
            return MapsKt.emptyMap();
        }
        List arguments = call.getValueArguments();
        PsiParameter[] parameters = parameterList.getParameters();
        int j = 0;
        Intrinsics.checkExpressionValueIsNotNull((Object)parameters, (String)"parameters");
        Object[] objectArray2 = objectArray = (Object[])parameters;
        if (!(objectArray2.length == 0)) {
            PsiParameter psiParameter2 = parameters[0];
            Intrinsics.checkExpressionValueIsNotNull((Object)psiParameter2, (String)"parameters[0]");
            if (Intrinsics.areEqual((Object)"$receiver", (Object)psiParameter2.getName())) {
                ++j;
            }
        }
        int i = 0;
        int n = Math.min(((Object[])parameters).length, arguments.size());
        HashMap map2 = new HashMap(2 * n);
        while (j < n) {
            argument = (UExpression)arguments.get(i);
            parameter = parameters[j];
            map = map2;
            Intrinsics.checkExpressionValueIsNotNull((Object)parameter, (String)"parameter");
            map.put(argument, psiParameter);
            ++i;
            ++j;
        }
        if (i < arguments.size() && j > 0) {
            --j;
            while (i < arguments.size()) {
                argument = (UExpression)arguments.get(i);
                parameter = parameters[j];
                map = map2;
                Intrinsics.checkExpressionValueIsNotNull((Object)parameter, (String)"parameter");
                map.put(argument, psiParameter);
                ++i;
            }
        }
        return map2;
    }

    public DefaultJavaEvaluator(@Nullable com.intellij.openapi.project.Project myProject, @Nullable Project myLintProject) {
        this.myProject = myProject;
        this.myLintProject = myLintProject;
    }
}

