/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.detector.api;

import com.android.tools.lint.detector.api.JavaContext;
import com.android.tools.lint.detector.api.UastLintUtils;
import com.google.common.collect.Lists;
import com.intellij.psi.JavaRecursiveElementVisitor;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiArrayInitializerExpression;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiBinaryExpression;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiConditionalExpression;
import com.intellij.psi.PsiDeclarationStatement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiIfStatement;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiLiteral;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiParenthesizedExpression;
import com.intellij.psi.PsiPolyadicExpression;
import com.intellij.psi.PsiPrefixExpression;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeCastExpression;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import org.jetbrains.uast.UBinaryExpression;
import org.jetbrains.uast.UBinaryExpressionWithType;
import org.jetbrains.uast.UBlockExpression;
import org.jetbrains.uast.UCallExpression;
import org.jetbrains.uast.UDeclarationsExpression;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UExpression;
import org.jetbrains.uast.UIfExpression;
import org.jetbrains.uast.ULiteralExpression;
import org.jetbrains.uast.UParenthesizedExpression;
import org.jetbrains.uast.UPolyadicExpression;
import org.jetbrains.uast.UPrefixExpression;
import org.jetbrains.uast.UQualifiedReferenceExpression;
import org.jetbrains.uast.UReferenceExpression;
import org.jetbrains.uast.UResolvable;
import org.jetbrains.uast.USimpleNameReferenceExpression;
import org.jetbrains.uast.UVariable;
import org.jetbrains.uast.UastBinaryExpressionWithTypeKind;
import org.jetbrains.uast.UastBinaryOperator;
import org.jetbrains.uast.UastContext;
import org.jetbrains.uast.UastPrefixOperator;
import org.jetbrains.uast.UastUtils;
import org.jetbrains.uast.util.UastExpressionUtils;
import org.jetbrains.uast.visitor.AbstractUastVisitor;
import org.jetbrains.uast.visitor.UastVisitor;

public class ConstantEvaluator {
    private boolean allowUnknown;
    private boolean allowFieldInitializers;

    public ConstantEvaluator allowUnknowns() {
        this.allowUnknown = true;
        return this;
    }

    public ConstantEvaluator allowFieldInitializers() {
        this.allowFieldInitializers = true;
        return this;
    }

    public Object evaluate(UElement node) {
        Object evaluated;
        if (node == null) {
            return null;
        }
        if (node instanceof ULiteralExpression) {
            return ((ULiteralExpression)node).getValue();
        }
        if (node instanceof UPrefixExpression) {
            UastPrefixOperator operator = ((UPrefixExpression)node).getOperator();
            Object operand = this.evaluate((UElement)((UPrefixExpression)node).getOperand());
            if (operand == null) {
                return null;
            }
            if (operator == UastPrefixOperator.LOGICAL_NOT) {
                if (operand instanceof Boolean) {
                    return (Boolean)operand == false;
                }
            } else {
                if (operator == UastPrefixOperator.UNARY_PLUS) {
                    return operand;
                }
                if (operator == UastPrefixOperator.BITWISE_NOT) {
                    if (operand instanceof Integer) {
                        return ~((Integer)operand).intValue();
                    }
                    if (operand instanceof Long) {
                        return (Long)operand ^ 0xFFFFFFFFFFFFFFFFL;
                    }
                    if (operand instanceof Short) {
                        return (int)(~((Short)operand).shortValue());
                    }
                    if (operand instanceof Character) {
                        return (int)(~((Character)operand).charValue());
                    }
                    if (operand instanceof Byte) {
                        return (int)(~((Byte)operand).byteValue());
                    }
                } else if (operator == UastPrefixOperator.UNARY_MINUS) {
                    if (operand instanceof Integer) {
                        return -((Integer)operand).intValue();
                    }
                    if (operand instanceof Long) {
                        return -((Long)operand).longValue();
                    }
                    if (operand instanceof Double) {
                        return -((Double)operand).doubleValue();
                    }
                    if (operand instanceof Float) {
                        return Float.valueOf(-((Float)operand).floatValue());
                    }
                    if (operand instanceof Short) {
                        return (int)(-((Short)operand).shortValue());
                    }
                    if (operand instanceof Character) {
                        return (int)(-((Character)operand).charValue());
                    }
                    if (operand instanceof Byte) {
                        return (int)(-((Byte)operand).byteValue());
                    }
                }
            }
        } else if (node instanceof UIfExpression && ((UIfExpression)node).getExpressionType() != null) {
            UIfExpression expression = (UIfExpression)node;
            Object known = this.evaluate((UElement)expression.getCondition());
            if (known == Boolean.TRUE && expression.getThenExpression() != null) {
                return this.evaluate((UElement)expression.getThenExpression());
            }
            if (known == Boolean.FALSE && expression.getElseExpression() != null) {
                return this.evaluate((UElement)expression.getElseExpression());
            }
        } else {
            if (node instanceof UParenthesizedExpression) {
                UParenthesizedExpression parenthesizedExpression = (UParenthesizedExpression)node;
                UExpression expression = parenthesizedExpression.getExpression();
                return this.evaluate((UElement)expression);
            }
            if (node instanceof UPolyadicExpression) {
                UPolyadicExpression polyadicExpression = (UPolyadicExpression)node;
                UastBinaryOperator operator = polyadicExpression.getOperator();
                List operands = polyadicExpression.getOperands();
                assert (!operands.isEmpty());
                Object result = this.evaluate((UElement)operands.get(0));
                int n = operands.size();
                for (int i = 1; i < n; ++i) {
                    Object rhs = this.evaluate((UElement)operands.get(i));
                    result = this.evaluateBinary(operator, result, rhs);
                }
                if (result != null) {
                    return result;
                }
            } else {
                PsiType componentType;
                PsiType arrayType;
                UCallExpression call;
                if (node instanceof UBinaryExpressionWithType && ((UBinaryExpressionWithType)node).getOperationKind() == UastBinaryExpressionWithTypeKind.TYPE_CAST) {
                    UBinaryExpressionWithType cast = (UBinaryExpressionWithType)node;
                    Object operandValue = this.evaluate((UElement)cast.getOperand());
                    if (operandValue instanceof Number) {
                        Number number = (Number)operandValue;
                        PsiType type = cast.getType();
                        if (PsiType.FLOAT.equals((Object)type)) {
                            return Float.valueOf(number.floatValue());
                        }
                        if (PsiType.DOUBLE.equals((Object)type)) {
                            return number.doubleValue();
                        }
                        if (PsiType.INT.equals((Object)type)) {
                            return number.intValue();
                        }
                        if (PsiType.LONG.equals((Object)type)) {
                            return number.longValue();
                        }
                        if (PsiType.SHORT.equals((Object)type)) {
                            return number.shortValue();
                        }
                        if (PsiType.BYTE.equals((Object)type)) {
                            return number.byteValue();
                        }
                    }
                    return operandValue;
                }
                if (node instanceof UReferenceExpression) {
                    PsiElement resolved = ((UReferenceExpression)node).resolve();
                    if (resolved instanceof PsiVariable) {
                        if (resolved instanceof PsiField) {
                            PsiField field = (PsiField)resolved;
                            Object value = field.computeConstantValue();
                            if (value != null) {
                                return value;
                            }
                            if (field.getInitializer() != null && (this.allowFieldInitializers || field.hasModifierProperty("static") && field.hasModifierProperty("final")) && (value = this.evaluate((PsiElement)field.getInitializer())) != null) {
                                if (ConstantEvaluator.surroundedByVariableCheck(node, (PsiVariable)field)) {
                                    return null;
                                }
                                return value;
                            }
                            return null;
                        }
                        PsiVariable variable = (PsiVariable)resolved;
                        UastContext uastContext = UastUtils.getUastContext((UElement)node);
                        Object value = UastLintUtils.findLastValue(variable, node, uastContext, this);
                        if (value != null) {
                            if (ConstantEvaluator.surroundedByVariableCheck(node, variable)) {
                                return null;
                            }
                            return value;
                        }
                        if (variable.getInitializer() != null) {
                            Object initializedValue = this.evaluate((PsiElement)variable.getInitializer());
                            if (ConstantEvaluator.surroundedByVariableCheck(node, variable)) {
                                return null;
                            }
                            return initializedValue;
                        }
                        return null;
                    }
                } else if (UastExpressionUtils.isNewArrayWithDimensions((UElement)node)) {
                    Object lengthObj;
                    PsiType componentType2;
                    call = (UCallExpression)node;
                    PsiType arrayType2 = call.getExpressionType();
                    if (arrayType2 instanceof PsiArrayType && !((componentType2 = ((PsiArrayType)arrayType2).getComponentType()) instanceof PsiArrayType) && call.getValueArgumentCount() == 1 && (lengthObj = this.evaluate((UElement)call.getValueArguments().get(0))) instanceof Number) {
                        int length = ((Number)lengthObj).intValue();
                        if (length > 30) {
                            length = 30;
                        }
                        if (componentType2 == PsiType.BOOLEAN) {
                            return new boolean[length];
                        }
                        if (ConstantEvaluator.isObjectType(componentType2)) {
                            return new Object[length];
                        }
                        if (componentType2 == PsiType.CHAR) {
                            return new char[length];
                        }
                        if (componentType2 == PsiType.BYTE) {
                            return new byte[length];
                        }
                        if (componentType2 == PsiType.DOUBLE) {
                            return new double[length];
                        }
                        if (componentType2 == PsiType.FLOAT) {
                            return new float[length];
                        }
                        if (componentType2 == PsiType.INT) {
                            return new int[length];
                        }
                        if (componentType2 == PsiType.SHORT) {
                            return new short[length];
                        }
                        if (componentType2 == PsiType.LONG) {
                            return new long[length];
                        }
                        if (ConstantEvaluator.isStringType(componentType2)) {
                            return new String[length];
                        }
                    }
                } else if (UastExpressionUtils.isNewArrayWithInitializer((UElement)node) && (arrayType = (call = (UCallExpression)node).getExpressionType()) instanceof PsiArrayType && !((componentType = ((PsiArrayType)arrayType).getComponentType()) instanceof PsiArrayType)) {
                    Object o;
                    Object[] arr;
                    int length = call.getValueArgumentCount();
                    ArrayList<Object> evaluatedArgs = new ArrayList<Object>(length);
                    for (UExpression arg : call.getValueArguments()) {
                        Object evaluatedArg = this.evaluate((UElement)arg);
                        if (!this.allowUnknown && evaluatedArg == null) {
                            return null;
                        }
                        evaluatedArgs.add(evaluatedArg);
                    }
                    if (componentType == PsiType.BOOLEAN) {
                        arr = new boolean[length];
                        for (int i = 0; i < length; ++i) {
                            o = evaluatedArgs.get(i);
                            if (!(o instanceof Boolean)) continue;
                            arr[i] = (Boolean)o;
                        }
                        return arr;
                    }
                    if (ConstantEvaluator.isObjectType(componentType)) {
                        arr = new Object[length];
                        for (int i = 0; i < length; ++i) {
                            arr[i] = evaluatedArgs.get(i);
                        }
                        return arr;
                    }
                    if (componentType.equals(PsiType.CHAR)) {
                        arr = new char[length];
                        for (int i = 0; i < length; ++i) {
                            o = evaluatedArgs.get(i);
                            if (!(o instanceof Character)) continue;
                            arr[i] = ((Character)o).charValue();
                        }
                        return arr;
                    }
                    if (componentType.equals(PsiType.BYTE)) {
                        arr = new byte[length];
                        for (int i = 0; i < length; ++i) {
                            o = evaluatedArgs.get(i);
                            if (!(o instanceof Byte)) continue;
                            arr[i] = (Byte)o;
                        }
                        return arr;
                    }
                    if (componentType.equals(PsiType.DOUBLE)) {
                        arr = new double[length];
                        for (int i = 0; i < length; ++i) {
                            o = evaluatedArgs.get(i);
                            if (!(o instanceof Double)) continue;
                            arr[i] = ((Double)o).doubleValue();
                        }
                        return arr;
                    }
                    if (componentType.equals(PsiType.FLOAT)) {
                        arr = new float[length];
                        for (int i = 0; i < length; ++i) {
                            o = evaluatedArgs.get(i);
                            if (!(o instanceof Float)) continue;
                            arr[i] = ((Float)o).floatValue();
                        }
                        return arr;
                    }
                    if (componentType.equals(PsiType.INT)) {
                        arr = new int[length];
                        for (int i = 0; i < length; ++i) {
                            o = evaluatedArgs.get(i);
                            if (!(o instanceof Integer)) continue;
                            arr[i] = (Integer)o;
                        }
                        return arr;
                    }
                    if (componentType.equals(PsiType.SHORT)) {
                        arr = new short[length];
                        for (int i = 0; i < length; ++i) {
                            o = evaluatedArgs.get(i);
                            if (!(o instanceof Short)) continue;
                            arr[i] = (Short)o;
                        }
                        return arr;
                    }
                    if (componentType.equals(PsiType.LONG)) {
                        arr = new long[length];
                        for (int i = 0; i < length; ++i) {
                            o = evaluatedArgs.get(i);
                            if (!(o instanceof Long)) continue;
                            arr[i] = ((Long)o).longValue();
                        }
                        return arr;
                    }
                    if (ConstantEvaluator.isStringType(componentType)) {
                        arr = new String[length];
                        for (int i = 0; i < length; ++i) {
                            o = evaluatedArgs.get(i);
                            if (!(o instanceof String)) continue;
                            arr[i] = (String)o;
                        }
                        return arr;
                    }
                }
            }
        }
        if (node instanceof UExpression && (evaluated = ((UExpression)node).evaluate()) != null) {
            return evaluated;
        }
        return null;
    }

    private Object evaluateBinary(UastBinaryOperator operator, Object operandLeft, Object operandRight) {
        if (operandLeft == null || operandRight == null) {
            if (this.allowUnknown) {
                if (operandLeft == null) {
                    return operandRight;
                }
                return operandLeft;
            }
            return null;
        }
        if (operandLeft instanceof String && operandRight instanceof String) {
            if (operator == UastBinaryOperator.PLUS) {
                return operandLeft.toString() + operandRight.toString();
            }
            return null;
        }
        if (operandLeft instanceof Boolean && operandRight instanceof Boolean) {
            boolean left = (Boolean)operandLeft;
            boolean right = (Boolean)operandRight;
            if (operator == UastBinaryOperator.LOGICAL_OR) {
                return left || right;
            }
            if (operator == UastBinaryOperator.LOGICAL_AND) {
                return left && right;
            }
            if (operator == UastBinaryOperator.BITWISE_OR) {
                return left | right;
            }
            if (operator == UastBinaryOperator.BITWISE_XOR) {
                return left ^ right;
            }
            if (operator == UastBinaryOperator.BITWISE_AND) {
                return left & right;
            }
            if (operator == UastBinaryOperator.IDENTITY_EQUALS || operator == UastBinaryOperator.EQUALS) {
                return left == right;
            }
            if (operator == UastBinaryOperator.IDENTITY_NOT_EQUALS || operator == UastBinaryOperator.NOT_EQUALS) {
                return left != right;
            }
        } else if (operandLeft instanceof Number && operandRight instanceof Number) {
            boolean isWide;
            boolean isInteger;
            Number left = (Number)operandLeft;
            Number right = (Number)operandRight;
            boolean bl = isInteger = !(left instanceof Float) && !(left instanceof Double) && !(right instanceof Float) && !(right instanceof Double);
            boolean bl2 = isInteger ? left instanceof Long || right instanceof Long : (isWide = left instanceof Double || right instanceof Double);
            if (operator == UastBinaryOperator.BITWISE_OR) {
                if (isWide) {
                    return left.longValue() | right.longValue();
                }
                return left.intValue() | right.intValue();
            }
            if (operator == UastBinaryOperator.BITWISE_XOR) {
                if (isWide) {
                    return left.longValue() ^ right.longValue();
                }
                return left.intValue() ^ right.intValue();
            }
            if (operator == UastBinaryOperator.BITWISE_AND) {
                if (isWide) {
                    return left.longValue() & right.longValue();
                }
                return left.intValue() & right.intValue();
            }
            if (operator == UastBinaryOperator.EQUALS || operator == UastBinaryOperator.IDENTITY_EQUALS) {
                if (isInteger) {
                    return left.longValue() == right.longValue();
                }
                return left.doubleValue() == right.doubleValue();
            }
            if (operator == UastBinaryOperator.NOT_EQUALS || operator == UastBinaryOperator.IDENTITY_NOT_EQUALS) {
                if (isInteger) {
                    return left.longValue() != right.longValue();
                }
                return left.doubleValue() != right.doubleValue();
            }
            if (operator == UastBinaryOperator.GREATER) {
                if (isInteger) {
                    return left.longValue() > right.longValue();
                }
                return left.doubleValue() > right.doubleValue();
            }
            if (operator == UastBinaryOperator.GREATER_OR_EQUALS) {
                if (isInteger) {
                    return left.longValue() >= right.longValue();
                }
                return left.doubleValue() >= right.doubleValue();
            }
            if (operator == UastBinaryOperator.LESS) {
                if (isInteger) {
                    return left.longValue() < right.longValue();
                }
                return left.doubleValue() < right.doubleValue();
            }
            if (operator == UastBinaryOperator.LESS_OR_EQUALS) {
                if (isInteger) {
                    return left.longValue() <= right.longValue();
                }
                return left.doubleValue() <= right.doubleValue();
            }
            if (operator == UastBinaryOperator.SHIFT_LEFT) {
                if (isWide) {
                    return left.longValue() << right.intValue();
                }
                return left.intValue() << right.intValue();
            }
            if (operator == UastBinaryOperator.SHIFT_RIGHT) {
                if (isWide) {
                    return left.longValue() >> right.intValue();
                }
                return left.intValue() >> right.intValue();
            }
            if (operator == UastBinaryOperator.UNSIGNED_SHIFT_RIGHT) {
                if (isWide) {
                    return left.longValue() >>> right.intValue();
                }
                return left.intValue() >>> right.intValue();
            }
            if (operator == UastBinaryOperator.PLUS) {
                if (isInteger) {
                    if (isWide) {
                        return left.longValue() + right.longValue();
                    }
                    return left.intValue() + right.intValue();
                }
                if (isWide) {
                    return left.doubleValue() + right.doubleValue();
                }
                return Float.valueOf(left.floatValue() + right.floatValue());
            }
            if (operator == UastBinaryOperator.MINUS) {
                if (isInteger) {
                    if (isWide) {
                        return left.longValue() - right.longValue();
                    }
                    return left.intValue() - right.intValue();
                }
                if (isWide) {
                    return left.doubleValue() - right.doubleValue();
                }
                return Float.valueOf(left.floatValue() - right.floatValue());
            }
            if (operator == UastBinaryOperator.MULTIPLY) {
                if (isInteger) {
                    if (isWide) {
                        return left.longValue() * right.longValue();
                    }
                    return left.intValue() * right.intValue();
                }
                if (isWide) {
                    return left.doubleValue() * right.doubleValue();
                }
                return Float.valueOf(left.floatValue() * right.floatValue());
            }
            if (operator == UastBinaryOperator.DIV) {
                if (isInteger) {
                    if (isWide) {
                        return left.longValue() / right.longValue();
                    }
                    return left.intValue() / right.intValue();
                }
                if (isWide) {
                    return left.doubleValue() / right.doubleValue();
                }
                return Float.valueOf(left.floatValue() / right.floatValue());
            }
            if (operator == UastBinaryOperator.MOD) {
                if (isInteger) {
                    if (isWide) {
                        return left.longValue() % right.longValue();
                    }
                    return left.intValue() % right.intValue();
                }
                if (isWide) {
                    return left.doubleValue() % right.doubleValue();
                }
                return Float.valueOf(left.floatValue() % right.floatValue());
            }
            return null;
        }
        return null;
    }

    private static boolean surroundedByVariableCheck(UElement node, PsiVariable variable) {
        if (node == null) {
            return false;
        }
        UIfExpression curr = (UIfExpression)UastUtils.getParentOfType((UElement)node, UIfExpression.class);
        while (curr != null) {
            UExpression condition;
            if (ConstantEvaluator.references(curr.getCondition(), variable) && !UastUtils.isChildOf((UElement)node, (UElement)(condition = curr.getCondition()), (boolean)true)) {
                return true;
            }
            curr = (UIfExpression)UastUtils.getParentOfType((UElement)curr, UIfExpression.class);
        }
        return false;
    }

    private static boolean isStringType(PsiType type) {
        if (!(type instanceof PsiClassType)) {
            return false;
        }
        PsiClass resolvedClass = ((PsiClassType)type).resolve();
        return resolvedClass != null && "java.lang.String".equals(resolvedClass.getQualifiedName());
    }

    private static boolean isObjectType(PsiType type) {
        if (!(type instanceof PsiClassType)) {
            return false;
        }
        PsiClass resolvedClass = ((PsiClassType)type).resolve();
        return resolvedClass != null && "java.lang.Object".equals(resolvedClass.getQualifiedName());
    }

    /*
     * WARNING - void declaration
     */
    public Object evaluate(PsiElement node) {
        if (node == null) {
            return null;
        }
        if (node instanceof PsiLiteral) {
            return ((PsiLiteral)node).getValue();
        }
        if (node instanceof PsiPrefixExpression) {
            IElementType operator = ((PsiPrefixExpression)node).getOperationTokenType();
            Object operand = this.evaluate((PsiElement)((PsiPrefixExpression)node).getOperand());
            if (operand == null) {
                return null;
            }
            if (operator == JavaTokenType.EXCL) {
                if (operand instanceof Boolean) {
                    return (Boolean)operand == false;
                }
            } else {
                if (operator == JavaTokenType.PLUS) {
                    return operand;
                }
                if (operator == JavaTokenType.TILDE) {
                    if (operand instanceof Integer) {
                        return ~((Integer)operand).intValue();
                    }
                    if (operand instanceof Long) {
                        return (Long)operand ^ 0xFFFFFFFFFFFFFFFFL;
                    }
                    if (operand instanceof Short) {
                        return (int)(~((Short)operand).shortValue());
                    }
                    if (operand instanceof Character) {
                        return (int)(~((Character)operand).charValue());
                    }
                    if (operand instanceof Byte) {
                        return (int)(~((Byte)operand).byteValue());
                    }
                } else if (operator == JavaTokenType.MINUS) {
                    if (operand instanceof Integer) {
                        return -((Integer)operand).intValue();
                    }
                    if (operand instanceof Long) {
                        return -((Long)operand).longValue();
                    }
                    if (operand instanceof Double) {
                        return -((Double)operand).doubleValue();
                    }
                    if (operand instanceof Float) {
                        return Float.valueOf(-((Float)operand).floatValue());
                    }
                    if (operand instanceof Short) {
                        return (int)(-((Short)operand).shortValue());
                    }
                    if (operand instanceof Character) {
                        return (int)(-((Character)operand).charValue());
                    }
                    if (operand instanceof Byte) {
                        return (int)(-((Byte)operand).byteValue());
                    }
                }
            }
        } else if (node instanceof PsiConditionalExpression) {
            PsiConditionalExpression expression = (PsiConditionalExpression)node;
            Object known = this.evaluate((PsiElement)expression.getCondition());
            if (known == Boolean.TRUE && expression.getThenExpression() != null) {
                return this.evaluate((PsiElement)expression.getThenExpression());
            }
            if (known == Boolean.FALSE && expression.getElseExpression() != null) {
                return this.evaluate((PsiElement)expression.getElseExpression());
            }
        } else if (node instanceof PsiParenthesizedExpression) {
            PsiParenthesizedExpression parenthesizedExpression = (PsiParenthesizedExpression)node;
            PsiExpression expression = parenthesizedExpression.getExpression();
            if (expression != null) {
                return this.evaluate((PsiElement)expression);
            }
        } else if (node instanceof PsiBinaryExpression) {
            PsiBinaryExpression expression = (PsiBinaryExpression)node;
            IElementType operator = expression.getOperationTokenType();
            Object operandLeft = this.evaluate((PsiElement)expression.getLOperand());
            Object operandRight = this.evaluate((PsiElement)expression.getROperand());
            if (operandLeft == null || operandRight == null) {
                if (this.allowUnknown) {
                    if (operandLeft == null) {
                        return operandRight;
                    }
                    return operandLeft;
                }
                return null;
            }
            if (operandLeft instanceof String && operandRight instanceof String) {
                if (operator == JavaTokenType.PLUS) {
                    return operandLeft.toString() + operandRight.toString();
                }
                return null;
            }
            if (operandLeft instanceof Boolean && operandRight instanceof Boolean) {
                boolean left = (Boolean)operandLeft;
                boolean right = (Boolean)operandRight;
                if (operator == JavaTokenType.OROR) {
                    return left || right;
                }
                if (operator == JavaTokenType.ANDAND) {
                    return left && right;
                }
                if (operator == JavaTokenType.OR) {
                    return left | right;
                }
                if (operator == JavaTokenType.XOR) {
                    return left ^ right;
                }
                if (operator == JavaTokenType.AND) {
                    return left & right;
                }
                if (operator == JavaTokenType.EQEQ) {
                    return left == right;
                }
                if (operator == JavaTokenType.NE) {
                    return left != right;
                }
            } else if (operandLeft instanceof Number && operandRight instanceof Number) {
                boolean isWide;
                boolean isInteger;
                Number left = (Number)operandLeft;
                Number right = (Number)operandRight;
                boolean bl = isInteger = !(left instanceof Float) && !(left instanceof Double) && !(right instanceof Float) && !(right instanceof Double);
                boolean bl2 = isInteger ? left instanceof Long || right instanceof Long : (isWide = left instanceof Double || right instanceof Double);
                if (operator == JavaTokenType.OR) {
                    if (isWide) {
                        return left.longValue() | right.longValue();
                    }
                    return left.intValue() | right.intValue();
                }
                if (operator == JavaTokenType.XOR) {
                    if (isWide) {
                        return left.longValue() ^ right.longValue();
                    }
                    return left.intValue() ^ right.intValue();
                }
                if (operator == JavaTokenType.AND) {
                    if (isWide) {
                        return left.longValue() & right.longValue();
                    }
                    return left.intValue() & right.intValue();
                }
                if (operator == JavaTokenType.EQEQ) {
                    if (isInteger) {
                        return left.longValue() == right.longValue();
                    }
                    return left.doubleValue() == right.doubleValue();
                }
                if (operator == JavaTokenType.NE) {
                    if (isInteger) {
                        return left.longValue() != right.longValue();
                    }
                    return left.doubleValue() != right.doubleValue();
                }
                if (operator == JavaTokenType.GT) {
                    if (isInteger) {
                        return left.longValue() > right.longValue();
                    }
                    return left.doubleValue() > right.doubleValue();
                }
                if (operator == JavaTokenType.GE) {
                    if (isInteger) {
                        return left.longValue() >= right.longValue();
                    }
                    return left.doubleValue() >= right.doubleValue();
                }
                if (operator == JavaTokenType.LT) {
                    if (isInteger) {
                        return left.longValue() < right.longValue();
                    }
                    return left.doubleValue() < right.doubleValue();
                }
                if (operator == JavaTokenType.LE) {
                    if (isInteger) {
                        return left.longValue() <= right.longValue();
                    }
                    return left.doubleValue() <= right.doubleValue();
                }
                if (operator == JavaTokenType.LTLT) {
                    if (isWide) {
                        return left.longValue() << right.intValue();
                    }
                    return left.intValue() << right.intValue();
                }
                if (operator == JavaTokenType.GTGT) {
                    if (isWide) {
                        return left.longValue() >> right.intValue();
                    }
                    return left.intValue() >> right.intValue();
                }
                if (operator == JavaTokenType.GTGTGT) {
                    if (isWide) {
                        return left.longValue() >>> right.intValue();
                    }
                    return left.intValue() >>> right.intValue();
                }
                if (operator == JavaTokenType.PLUS) {
                    if (isInteger) {
                        if (isWide) {
                            return left.longValue() + right.longValue();
                        }
                        return left.intValue() + right.intValue();
                    }
                    if (isWide) {
                        return left.doubleValue() + right.doubleValue();
                    }
                    return Float.valueOf(left.floatValue() + right.floatValue());
                }
                if (operator == JavaTokenType.MINUS) {
                    if (isInteger) {
                        if (isWide) {
                            return left.longValue() - right.longValue();
                        }
                        return left.intValue() - right.intValue();
                    }
                    if (isWide) {
                        return left.doubleValue() - right.doubleValue();
                    }
                    return Float.valueOf(left.floatValue() - right.floatValue());
                }
                if (operator == JavaTokenType.ASTERISK) {
                    if (isInteger) {
                        if (isWide) {
                            return left.longValue() * right.longValue();
                        }
                        return left.intValue() * right.intValue();
                    }
                    if (isWide) {
                        return left.doubleValue() * right.doubleValue();
                    }
                    return Float.valueOf(left.floatValue() * right.floatValue());
                }
                if (operator == JavaTokenType.DIV) {
                    if (isInteger) {
                        if (isWide) {
                            return left.longValue() / right.longValue();
                        }
                        return left.intValue() / right.intValue();
                    }
                    if (isWide) {
                        return left.doubleValue() / right.doubleValue();
                    }
                    return Float.valueOf(left.floatValue() / right.floatValue());
                }
                if (operator == JavaTokenType.PERC) {
                    if (isInteger) {
                        if (isWide) {
                            return left.longValue() % right.longValue();
                        }
                        return left.intValue() % right.intValue();
                    }
                    if (isWide) {
                        return left.doubleValue() % right.doubleValue();
                    }
                    return Float.valueOf(left.floatValue() % right.floatValue());
                }
                return null;
            }
        } else if (node instanceof PsiPolyadicExpression) {
            int i;
            Object value;
            void var13_127;
            PsiPolyadicExpression expression = (PsiPolyadicExpression)node;
            IElementType operator = expression.getOperationTokenType();
            PsiExpression[] operands = expression.getOperands();
            ArrayList<Object> values = new ArrayList<Object>(operands.length);
            boolean hasString = false;
            boolean hasBoolean = false;
            boolean hasNumber = false;
            boolean isFloat = false;
            boolean isWide = false;
            PsiExpression[] psiExpressionArray = operands;
            int n = psiExpressionArray.length;
            boolean bl = false;
            while (var13_127 < n) {
                PsiExpression operand = psiExpressionArray[var13_127];
                value = this.evaluate((PsiElement)operand);
                if (value != null) {
                    values.add(value);
                    if (value instanceof String) {
                        hasString = true;
                    } else if (value instanceof Boolean) {
                        hasBoolean = true;
                    } else if (value instanceof Number) {
                        if (value instanceof Float) {
                            isFloat = true;
                        } else if (value instanceof Double) {
                            isFloat = true;
                            isWide = true;
                        } else if (value instanceof Long) {
                            isWide = true;
                        }
                        hasNumber = true;
                    }
                }
                ++var13_127;
            }
            if (values.isEmpty()) {
                return null;
            }
            if (hasString) {
                if (operator == JavaTokenType.PLUS) {
                    StringBuilder sb = new StringBuilder();
                    for (Object e : values) {
                        sb.append(e.toString());
                    }
                    return sb.toString();
                }
                return null;
            }
            if (!this.allowUnknown && operands.length != values.size()) {
                return null;
            }
            if (hasBoolean) {
                if (operator == JavaTokenType.OROR) {
                    boolean result = false;
                    for (Object e : values) {
                        if (!(e instanceof Boolean)) continue;
                        result = result || (Boolean)e != false;
                    }
                    return result;
                }
                if (operator == JavaTokenType.ANDAND) {
                    boolean result = true;
                    for (Object e : values) {
                        if (!(e instanceof Boolean)) continue;
                        result = result && (Boolean)e != false;
                    }
                    return result;
                }
                if (operator == JavaTokenType.OR) {
                    boolean result = false;
                    for (Object e : values) {
                        if (!(e instanceof Boolean)) continue;
                        result |= ((Boolean)e).booleanValue();
                    }
                    return result;
                }
                if (operator == JavaTokenType.XOR) {
                    boolean result = false;
                    for (Object e : values) {
                        if (!(e instanceof Boolean)) continue;
                        result ^= ((Boolean)e).booleanValue();
                    }
                    return result;
                }
                if (operator == JavaTokenType.AND) {
                    boolean result = true;
                    for (Object e : values) {
                        if (!(e instanceof Boolean)) continue;
                        result &= ((Boolean)e).booleanValue();
                    }
                    return result;
                }
                if (operator == JavaTokenType.EQEQ) {
                    boolean result = false;
                    for (i = 0; i < values.size(); ++i) {
                        Object e = values.get(i);
                        if (!(e instanceof Boolean)) continue;
                        boolean b = (Boolean)e;
                        result = i == 0 ? b : result == b;
                    }
                    return result;
                }
                if (operator == JavaTokenType.NE) {
                    boolean result = false;
                    for (i = 0; i < values.size(); ++i) {
                        Object e = values.get(i);
                        if (!(e instanceof Boolean)) continue;
                        boolean b = (Boolean)e;
                        result = i == 0 ? b : result != b;
                    }
                    return result;
                }
                return null;
            }
            if (hasNumber) {
                int prev;
                Object value2;
                if (operator == JavaTokenType.OR) {
                    if (isWide) {
                        void var13_137;
                        long result = 0L;
                        boolean bl3 = false;
                        while (var13_137 < values.size()) {
                            Object value10 = values.get((int)var13_137);
                            if (value10 instanceof Number) {
                                long l = ((Number)value10).longValue();
                                result = var13_137 == false ? l : (result |= l);
                            }
                            ++var13_137;
                        }
                        return result;
                    }
                    int result = 0;
                    for (i = 0; i < values.size(); ++i) {
                        Object e = values.get(i);
                        if (!(e instanceof Number)) continue;
                        int l = ((Number)e).intValue();
                        if (i == 0) {
                            result = l;
                            continue;
                        }
                        result |= l;
                    }
                    return result;
                }
                if (operator == JavaTokenType.XOR) {
                    if (isWide) {
                        void var13_140;
                        long result = 0L;
                        boolean bl4 = false;
                        while (var13_140 < values.size()) {
                            value2 = values.get((int)var13_140);
                            if (value2 instanceof Number) {
                                long l = ((Number)value2).longValue();
                                result = var13_140 == false ? l : (result ^= l);
                            }
                            ++var13_140;
                        }
                        return result;
                    }
                    int result = 0;
                    for (i = 0; i < values.size(); ++i) {
                        Object e = values.get(i);
                        if (!(e instanceof Number)) continue;
                        int l = ((Number)e).intValue();
                        if (i == 0) {
                            result = l;
                            continue;
                        }
                        result ^= l;
                    }
                    return result;
                }
                if (operator == JavaTokenType.AND) {
                    if (isWide) {
                        void var13_143;
                        long result = 0L;
                        boolean bl5 = false;
                        while (var13_143 < values.size()) {
                            value2 = values.get((int)var13_143);
                            if (value2 instanceof Number) {
                                long l = ((Number)value2).longValue();
                                result = var13_143 == false ? l : (result &= l);
                            }
                            ++var13_143;
                        }
                        return result;
                    }
                    int result = 0;
                    for (i = 0; i < values.size(); ++i) {
                        Object e = values.get(i);
                        if (!(e instanceof Number)) continue;
                        int l = ((Number)e).intValue();
                        if (i == 0) {
                            result = l;
                            continue;
                        }
                        result &= l;
                    }
                    return result;
                }
                if (operator == JavaTokenType.EQEQ) {
                    void var13_146;
                    if (isWide) {
                        boolean result = false;
                        long prev2 = 0L;
                        for (int i3 = 0; i3 < values.size(); ++i3) {
                            value = values.get(i3);
                            if (!(value instanceof Number)) continue;
                            long l = ((Number)value).longValue();
                            if (i3 == 0) {
                                prev2 = l;
                                continue;
                            }
                            result = prev2 == l;
                            prev2 = l;
                        }
                        return result;
                    }
                    boolean result = false;
                    prev = 0;
                    boolean bl6 = false;
                    while (var13_146 < values.size()) {
                        value2 = values.get((int)var13_146);
                        if (value2 instanceof Number) {
                            int l = ((Number)value2).intValue();
                            if (var13_146 == false) {
                                prev = l;
                            } else {
                                result = prev == l;
                                prev = l;
                            }
                        }
                        ++var13_146;
                    }
                    return result;
                }
                if (operator == JavaTokenType.NE) {
                    void var13_148;
                    if (isWide) {
                        boolean result = false;
                        long prev3 = 0L;
                        for (int i4 = 0; i4 < values.size(); ++i4) {
                            value = values.get(i4);
                            if (!(value instanceof Number)) continue;
                            long l = ((Number)value).longValue();
                            if (i4 == 0) {
                                prev3 = l;
                                continue;
                            }
                            result = prev3 != l;
                            prev3 = l;
                        }
                        return result;
                    }
                    boolean result = false;
                    prev = 0;
                    boolean bl7 = false;
                    while (var13_148 < values.size()) {
                        value2 = values.get((int)var13_148);
                        if (value2 instanceof Number) {
                            int l = ((Number)value2).intValue();
                            if (var13_148 == false) {
                                prev = l;
                            } else {
                                result = prev != l;
                                prev = l;
                            }
                        }
                        ++var13_148;
                    }
                    return result;
                }
                if (operator == JavaTokenType.GT) {
                    void var13_150;
                    if (isWide) {
                        boolean result = false;
                        long prev4 = 0L;
                        for (int i5 = 0; i5 < values.size(); ++i5) {
                            value = values.get(i5);
                            if (!(value instanceof Number)) continue;
                            long l = ((Number)value).longValue();
                            if (i5 == 0) {
                                prev4 = l;
                                continue;
                            }
                            result = prev4 > l;
                            prev4 = l;
                        }
                        return result;
                    }
                    boolean result = false;
                    prev = 0;
                    boolean bl8 = false;
                    while (var13_150 < values.size()) {
                        value2 = values.get((int)var13_150);
                        if (value2 instanceof Number) {
                            int l = ((Number)value2).intValue();
                            if (var13_150 == false) {
                                prev = l;
                            } else {
                                result = prev > l;
                                prev = l;
                            }
                        }
                        ++var13_150;
                    }
                    return result;
                }
                if (operator == JavaTokenType.GE) {
                    void var13_152;
                    if (isWide) {
                        boolean result = false;
                        long prev5 = 0L;
                        for (int i6 = 0; i6 < values.size(); ++i6) {
                            value = values.get(i6);
                            if (!(value instanceof Number)) continue;
                            long l = ((Number)value).longValue();
                            if (i6 == 0) {
                                prev5 = l;
                                continue;
                            }
                            result = prev5 >= l;
                            prev5 = l;
                        }
                        return result;
                    }
                    boolean result = false;
                    prev = 0;
                    boolean bl9 = false;
                    while (var13_152 < values.size()) {
                        value2 = values.get((int)var13_152);
                        if (value2 instanceof Number) {
                            int l = ((Number)value2).intValue();
                            if (var13_152 == false) {
                                prev = l;
                            } else {
                                result = prev >= l;
                                prev = l;
                            }
                        }
                        ++var13_152;
                    }
                    return result;
                }
                if (operator == JavaTokenType.LT) {
                    void var13_154;
                    if (isWide) {
                        boolean result = false;
                        long prev6 = 0L;
                        for (int i7 = 0; i7 < values.size(); ++i7) {
                            value = values.get(i7);
                            if (!(value instanceof Number)) continue;
                            long l = ((Number)value).longValue();
                            if (i7 == 0) {
                                prev6 = l;
                                continue;
                            }
                            result = prev6 < l;
                            prev6 = l;
                        }
                        return result;
                    }
                    boolean result = false;
                    prev = 0;
                    boolean bl10 = false;
                    while (var13_154 < values.size()) {
                        value2 = values.get((int)var13_154);
                        if (value2 instanceof Number) {
                            int l = ((Number)value2).intValue();
                            if (var13_154 == false) {
                                prev = l;
                            } else {
                                result = prev < l;
                                prev = l;
                            }
                        }
                        ++var13_154;
                    }
                    return result;
                }
                if (operator == JavaTokenType.LE) {
                    void var13_156;
                    if (isWide) {
                        boolean result = false;
                        long prev7 = 0L;
                        for (int i8 = 0; i8 < values.size(); ++i8) {
                            value = values.get(i8);
                            if (!(value instanceof Number)) continue;
                            long l = ((Number)value).longValue();
                            if (i8 == 0) {
                                prev7 = l;
                                continue;
                            }
                            result = prev7 <= l;
                            prev7 = l;
                        }
                        return result;
                    }
                    boolean result = false;
                    prev = 0;
                    boolean bl11 = false;
                    while (var13_156 < values.size()) {
                        value2 = values.get((int)var13_156);
                        if (value2 instanceof Number) {
                            int l = ((Number)value2).intValue();
                            if (var13_156 == false) {
                                prev = l;
                            } else {
                                result = prev <= l;
                                prev = l;
                            }
                        }
                        ++var13_156;
                    }
                    return result;
                }
                if (operator == JavaTokenType.LTLT) {
                    if (isWide) {
                        void var13_158;
                        long result = 0L;
                        boolean bl12 = false;
                        while (var13_158 < values.size()) {
                            value2 = values.get((int)var13_158);
                            if (value2 instanceof Number) {
                                long l = ((Number)value2).longValue();
                                result = var13_158 == false ? l : (result <<= (int)l);
                            }
                            ++var13_158;
                        }
                        return result;
                    }
                    int result = 0;
                    for (i = 0; i < values.size(); ++i) {
                        Object e = values.get(i);
                        if (!(e instanceof Number)) continue;
                        int l = ((Number)e).intValue();
                        if (i == 0) {
                            result = l;
                            continue;
                        }
                        result <<= l;
                    }
                    return result;
                }
                if (operator == JavaTokenType.GTGT) {
                    if (isWide) {
                        void var13_161;
                        long result = 0L;
                        boolean bl13 = false;
                        while (var13_161 < values.size()) {
                            value2 = values.get((int)var13_161);
                            if (value2 instanceof Number) {
                                long l = ((Number)value2).longValue();
                                result = var13_161 == false ? l : (result >>= (int)l);
                            }
                            ++var13_161;
                        }
                        return result;
                    }
                    int result = 0;
                    for (i = 0; i < values.size(); ++i) {
                        Object e = values.get(i);
                        if (!(e instanceof Number)) continue;
                        int l = ((Number)e).intValue();
                        if (i == 0) {
                            result = l;
                            continue;
                        }
                        result >>= l;
                    }
                    return result;
                }
                if (operator == JavaTokenType.GTGTGT) {
                    if (isWide) {
                        void var13_164;
                        long result = 0L;
                        boolean bl14 = false;
                        while (var13_164 < values.size()) {
                            value2 = values.get((int)var13_164);
                            if (value2 instanceof Number) {
                                long l = ((Number)value2).longValue();
                                result = var13_164 == false ? l : (result >>>= (int)l);
                            }
                            ++var13_164;
                        }
                        return result;
                    }
                    int result = 0;
                    for (i = 0; i < values.size(); ++i) {
                        Object e = values.get(i);
                        if (!(e instanceof Number)) continue;
                        int l = ((Number)e).intValue();
                        if (i == 0) {
                            result = l;
                            continue;
                        }
                        result >>>= l;
                    }
                    return result;
                }
                if (operator == JavaTokenType.PLUS) {
                    if (isFloat) {
                        if (isWide) {
                            void var13_167;
                            double result = 0.0;
                            boolean bl15 = false;
                            while (var13_167 < values.size()) {
                                value2 = values.get((int)var13_167);
                                if (value2 instanceof Number) {
                                    double l = ((Number)value2).doubleValue();
                                    result = var13_167 == false ? l : (result += l);
                                }
                                ++var13_167;
                            }
                            return result;
                        }
                        float result = 0.0f;
                        for (i = 0; i < values.size(); ++i) {
                            Object e = values.get(i);
                            if (!(e instanceof Number)) continue;
                            float l = ((Number)e).floatValue();
                            if (i == 0) {
                                result = l;
                                continue;
                            }
                            result += l;
                        }
                        return Float.valueOf(result);
                    }
                    if (isWide) {
                        void var13_170;
                        long result = 0L;
                        boolean bl16 = false;
                        while (var13_170 < values.size()) {
                            value2 = values.get((int)var13_170);
                            if (value2 instanceof Number) {
                                long l = ((Number)value2).longValue();
                                result = var13_170 == false ? l : (result += l);
                            }
                            ++var13_170;
                        }
                        return result;
                    }
                    int result = 0;
                    for (i = 0; i < values.size(); ++i) {
                        Object e = values.get(i);
                        if (!(e instanceof Number)) continue;
                        int l = ((Number)e).intValue();
                        if (i == 0) {
                            result = l;
                            continue;
                        }
                        result += l;
                    }
                    return result;
                }
                if (operator == JavaTokenType.MINUS) {
                    if (isFloat) {
                        if (isWide) {
                            void var13_173;
                            double result = 0.0;
                            boolean bl17 = false;
                            while (var13_173 < values.size()) {
                                value2 = values.get((int)var13_173);
                                if (value2 instanceof Number) {
                                    double l = ((Number)value2).doubleValue();
                                    result = var13_173 == false ? l : (result -= l);
                                }
                                ++var13_173;
                            }
                            return result;
                        }
                        float result = 0.0f;
                        for (i = 0; i < values.size(); ++i) {
                            Object e = values.get(i);
                            if (!(e instanceof Number)) continue;
                            float l = ((Number)e).floatValue();
                            if (i == 0) {
                                result = l;
                                continue;
                            }
                            result -= l;
                        }
                        return Float.valueOf(result);
                    }
                    if (isWide) {
                        void var13_176;
                        long result = 0L;
                        boolean bl18 = false;
                        while (var13_176 < values.size()) {
                            value2 = values.get((int)var13_176);
                            if (value2 instanceof Number) {
                                long l = ((Number)value2).longValue();
                                result = var13_176 == false ? l : (result -= l);
                            }
                            ++var13_176;
                        }
                        return result;
                    }
                    int result = 0;
                    for (i = 0; i < values.size(); ++i) {
                        Object e = values.get(i);
                        if (!(e instanceof Number)) continue;
                        int l = ((Number)e).intValue();
                        if (i == 0) {
                            result = l;
                            continue;
                        }
                        result -= l;
                    }
                    return result;
                }
                if (operator == JavaTokenType.ASTERISK) {
                    if (isFloat) {
                        if (isWide) {
                            void var13_179;
                            double result = 0.0;
                            boolean bl19 = false;
                            while (var13_179 < values.size()) {
                                value2 = values.get((int)var13_179);
                                if (value2 instanceof Number) {
                                    double l = ((Number)value2).doubleValue();
                                    result = var13_179 == false ? l : (result *= l);
                                }
                                ++var13_179;
                            }
                            return result;
                        }
                        float result = 0.0f;
                        for (i = 0; i < values.size(); ++i) {
                            Object e = values.get(i);
                            if (!(e instanceof Number)) continue;
                            float l = ((Number)e).floatValue();
                            if (i == 0) {
                                result = l;
                                continue;
                            }
                            result *= l;
                        }
                        return Float.valueOf(result);
                    }
                    if (isWide) {
                        void var13_182;
                        long result = 0L;
                        boolean bl20 = false;
                        while (var13_182 < values.size()) {
                            value2 = values.get((int)var13_182);
                            if (value2 instanceof Number) {
                                long l = ((Number)value2).longValue();
                                result = var13_182 == false ? l : (result *= l);
                            }
                            ++var13_182;
                        }
                        return result;
                    }
                    int result = 0;
                    for (i = 0; i < values.size(); ++i) {
                        Object e = values.get(i);
                        if (!(e instanceof Number)) continue;
                        int l = ((Number)e).intValue();
                        if (i == 0) {
                            result = l;
                            continue;
                        }
                        result *= l;
                    }
                    return result;
                }
                if (operator == JavaTokenType.DIV) {
                    if (isFloat) {
                        if (isWide) {
                            void var13_185;
                            double result = 0.0;
                            boolean bl21 = false;
                            while (var13_185 < values.size()) {
                                value2 = values.get((int)var13_185);
                                if (value2 instanceof Number) {
                                    double l = ((Number)value2).doubleValue();
                                    result = var13_185 == false ? l : (result /= l);
                                }
                                ++var13_185;
                            }
                            return result;
                        }
                        float result = 0.0f;
                        for (i = 0; i < values.size(); ++i) {
                            Object e = values.get(i);
                            if (!(e instanceof Number)) continue;
                            float l = ((Number)e).floatValue();
                            if (i == 0) {
                                result = l;
                                continue;
                            }
                            result /= l;
                        }
                        return Float.valueOf(result);
                    }
                    if (isWide) {
                        void var13_188;
                        long result = 0L;
                        boolean bl22 = false;
                        while (var13_188 < values.size()) {
                            value2 = values.get((int)var13_188);
                            if (value2 instanceof Number) {
                                long l = ((Number)value2).longValue();
                                result = var13_188 == false ? l : (result /= l);
                            }
                            ++var13_188;
                        }
                        return result;
                    }
                    int result = 0;
                    for (i = 0; i < values.size(); ++i) {
                        Object e = values.get(i);
                        if (!(e instanceof Number)) continue;
                        int l = ((Number)e).intValue();
                        if (i == 0) {
                            result = l;
                            continue;
                        }
                        result /= l;
                    }
                    return result;
                }
                if (operator == JavaTokenType.PERC) {
                    if (isFloat) {
                        if (isWide) {
                            void var13_191;
                            double result = 0.0;
                            boolean bl23 = false;
                            while (var13_191 < values.size()) {
                                value2 = values.get((int)var13_191);
                                if (value2 instanceof Number) {
                                    double l = ((Number)value2).doubleValue();
                                    result = var13_191 == false ? l : (result %= l);
                                }
                                ++var13_191;
                            }
                            return result;
                        }
                        float result = 0.0f;
                        for (i = 0; i < values.size(); ++i) {
                            Object e = values.get(i);
                            if (!(e instanceof Number)) continue;
                            float l = ((Number)e).floatValue();
                            if (i == 0) {
                                result = l;
                                continue;
                            }
                            result %= l;
                        }
                        return Float.valueOf(result);
                    }
                    if (isWide) {
                        void var13_194;
                        long result = 0L;
                        boolean bl24 = false;
                        while (var13_194 < values.size()) {
                            value2 = values.get((int)var13_194);
                            if (value2 instanceof Number) {
                                long l = ((Number)value2).longValue();
                                result = var13_194 == false ? l : (result %= l);
                            }
                            ++var13_194;
                        }
                        return result;
                    }
                    int result = 0;
                    for (i = 0; i < values.size(); ++i) {
                        Object e = values.get(i);
                        if (!(e instanceof Number)) continue;
                        int l = ((Number)e).intValue();
                        if (i == 0) {
                            result = l;
                            continue;
                        }
                        result %= l;
                    }
                    return result;
                }
                return null;
            }
        } else {
            if (node instanceof PsiTypeCastExpression) {
                PsiTypeCastExpression cast = (PsiTypeCastExpression)node;
                Object operandValue = this.evaluate((PsiElement)cast.getOperand());
                if (operandValue instanceof Number) {
                    Number number = (Number)operandValue;
                    PsiTypeElement typeElement = cast.getCastType();
                    if (typeElement != null) {
                        PsiType type = typeElement.getType();
                        if (PsiType.FLOAT.equals((Object)type)) {
                            return Float.valueOf(number.floatValue());
                        }
                        if (PsiType.DOUBLE.equals((Object)type)) {
                            return number.doubleValue();
                        }
                        if (PsiType.INT.equals((Object)type)) {
                            return number.intValue();
                        }
                        if (PsiType.LONG.equals((Object)type)) {
                            return number.longValue();
                        }
                        if (PsiType.SHORT.equals((Object)type)) {
                            return number.shortValue();
                        }
                        if (PsiType.BYTE.equals((Object)type)) {
                            return number.byteValue();
                        }
                    }
                }
                return operandValue;
            }
            if (node instanceof PsiReference) {
                PsiLocalVariable variable;
                PsiExpression last;
                PsiElement resolved = ((PsiReference)node).resolve();
                if (resolved instanceof PsiField) {
                    PsiField field = (PsiField)resolved;
                    Object value = field.computeConstantValue();
                    if (value != null) {
                        return value;
                    }
                    if (field.getInitializer() != null && (this.allowFieldInitializers || field.hasModifierProperty("static") && field.hasModifierProperty("final")) && (value = this.evaluate((PsiElement)field.getInitializer())) != null) {
                        PsiIfStatement curr = (PsiIfStatement)PsiTreeUtil.getParentOfType((PsiElement)node, PsiIfStatement.class);
                        while (curr != null) {
                            PsiExpression condition;
                            if (curr.getCondition() != null && ConstantEvaluator.references(curr.getCondition(), (PsiVariable)field) && !PsiTreeUtil.isAncestor((PsiElement)(condition = curr.getCondition()), (PsiElement)node, (boolean)true)) {
                                return value;
                            }
                            curr = (PsiIfStatement)PsiTreeUtil.getParentOfType((PsiElement)curr, PsiIfStatement.class, (boolean)true);
                        }
                        return value;
                    }
                    return null;
                }
                if (resolved instanceof PsiLocalVariable && (last = ConstantEvaluator.findLastAssignment(node, (PsiVariable)(variable = (PsiLocalVariable)resolved))) != null) {
                    return this.evaluate((PsiElement)last);
                }
            } else if (node instanceof PsiNewExpression) {
                PsiNewExpression creation = (PsiNewExpression)node;
                PsiArrayInitializerExpression initializer = creation.getArrayInitializer();
                PsiType type = creation.getType();
                if (type instanceof PsiArrayType) {
                    Object fixedSize;
                    if (initializer != null) {
                        int i;
                        Object[] array;
                        PsiExpression[] initializers = initializer.getInitializers();
                        Class<?> commonType = null;
                        ArrayList values = Lists.newArrayListWithExpectedSize((int)initializers.length);
                        int count = 0;
                        for (PsiExpression expression : initializers) {
                            Object object = this.evaluate((PsiElement)expression);
                            if (object != null) {
                                values.add(object);
                                if (commonType == null) {
                                    commonType = object.getClass();
                                } else {
                                    while (!commonType.isAssignableFrom(object.getClass())) {
                                        commonType = commonType.getSuperclass();
                                    }
                                }
                            } else if (!this.allowUnknown) {
                                return null;
                            }
                            if (++count == 20) break;
                        }
                        if ((type = type.getDeepComponentType()) == PsiType.INT) {
                            if (!values.isEmpty()) {
                                array = new int[values.size()];
                                for (i = 0; i < values.size(); ++i) {
                                    Object o = values.get(i);
                                    if (!(o instanceof Integer)) continue;
                                    array[i] = (Integer)o;
                                }
                                return array;
                            }
                            return new int[0];
                        }
                        if (type == PsiType.BOOLEAN) {
                            if (!values.isEmpty()) {
                                array = new boolean[values.size()];
                                for (i = 0; i < values.size(); ++i) {
                                    Object o = values.get(i);
                                    if (!(o instanceof Boolean)) continue;
                                    array[i] = ((Boolean)o).booleanValue() ? 1 : 0;
                                }
                                return array;
                            }
                            return new boolean[0];
                        }
                        if (type == PsiType.DOUBLE) {
                            if (!values.isEmpty()) {
                                array = new double[values.size()];
                                for (i = 0; i < values.size(); ++i) {
                                    Object o = values.get(i);
                                    if (!(o instanceof Double)) continue;
                                    array[i] = (int)((Double)o).doubleValue();
                                }
                                return array;
                            }
                            return new double[0];
                        }
                        if (type == PsiType.LONG) {
                            if (!values.isEmpty()) {
                                array = new long[values.size()];
                                for (i = 0; i < values.size(); ++i) {
                                    Object o = values.get(i);
                                    if (!(o instanceof Long)) continue;
                                    array[i] = (int)((Long)o).longValue();
                                }
                                return array;
                            }
                            return new long[0];
                        }
                        if (type == PsiType.FLOAT) {
                            if (!values.isEmpty()) {
                                array = new float[values.size()];
                                for (i = 0; i < values.size(); ++i) {
                                    Object o = values.get(i);
                                    if (!(o instanceof Float)) continue;
                                    array[i] = (int)((Float)o).floatValue();
                                }
                                return array;
                            }
                            return new float[0];
                        }
                        if (type == PsiType.CHAR) {
                            if (!values.isEmpty()) {
                                array = new char[values.size()];
                                for (i = 0; i < values.size(); ++i) {
                                    Object o = values.get(i);
                                    if (!(o instanceof Character)) continue;
                                    array[i] = ((Character)o).charValue();
                                }
                                return array;
                            }
                            return new char[0];
                        }
                        if (type == PsiType.BYTE) {
                            if (!values.isEmpty()) {
                                array = new byte[values.size()];
                                for (i = 0; i < values.size(); ++i) {
                                    Object o = values.get(i);
                                    if (!(o instanceof Byte)) continue;
                                    array[i] = ((Byte)o).byteValue();
                                }
                                return array;
                            }
                            return new byte[0];
                        }
                        if (type == PsiType.SHORT) {
                            if (!values.isEmpty()) {
                                array = new short[values.size()];
                                for (i = 0; i < values.size(); ++i) {
                                    Object o = values.get(i);
                                    if (!(o instanceof Short)) continue;
                                    array[i] = ((Short)o).shortValue();
                                }
                                return array;
                            }
                            return new short[0];
                        }
                        if (!values.isEmpty()) {
                            Object o = Array.newInstance(commonType, values.size());
                            return values.toArray((Object[])o);
                        }
                        return null;
                    }
                    PsiExpression[] arrayDimensions = creation.getArrayDimensions();
                    int size = 0;
                    if (arrayDimensions.length == 1 && (fixedSize = this.evaluate((PsiElement)arrayDimensions[0])) instanceof Number && (size = ((Number)fixedSize).intValue()) > 30) {
                        size = 30;
                    }
                    if ((type = type.getDeepComponentType()) instanceof PsiPrimitiveType) {
                        if (PsiType.BYTE.equals((Object)type)) {
                            return new byte[size];
                        }
                        if (PsiType.BOOLEAN.equals((Object)type)) {
                            return new boolean[size];
                        }
                        if (PsiType.INT.equals((Object)type)) {
                            return new int[size];
                        }
                        if (PsiType.LONG.equals((Object)type)) {
                            return new long[size];
                        }
                        if (PsiType.CHAR.equals((Object)type)) {
                            return new char[size];
                        }
                        if (PsiType.FLOAT.equals((Object)type)) {
                            return new float[size];
                        }
                        if (PsiType.DOUBLE.equals((Object)type)) {
                            return new double[size];
                        }
                        if (PsiType.SHORT.equals((Object)type)) {
                            return new short[size];
                        }
                    } else if (type instanceof PsiClassType) {
                        String className = type.getCanonicalText();
                        if ("java.lang.String".equals(className)) {
                            return new String[size];
                        }
                        if ("java.lang.Object".equals(className)) {
                            return new Object[size];
                        }
                    }
                }
            }
        }
        return null;
    }

    private static boolean references(PsiExpression element, final PsiVariable variable) {
        final AtomicBoolean found = new AtomicBoolean();
        element.accept((PsiElementVisitor)new JavaRecursiveElementVisitor(){

            public void visitReferenceElement(PsiJavaCodeReferenceElement reference) {
                PsiElement refersTo = reference.resolve();
                if (variable.equals(refersTo)) {
                    found.set(true);
                }
                super.visitReferenceElement(reference);
            }
        });
        return found.get();
    }

    private static boolean references(UExpression element, final PsiVariable variable) {
        final AtomicBoolean found = new AtomicBoolean();
        element.accept((UastVisitor)new AbstractUastVisitor(){

            public boolean visitSimpleNameReferenceExpression(USimpleNameReferenceExpression node) {
                PsiElement refersTo = node.resolve();
                if (variable.equals(refersTo)) {
                    found.set(true);
                }
                return super.visitSimpleNameReferenceExpression(node);
            }

            public boolean visitQualifiedReferenceExpression(UQualifiedReferenceExpression node) {
                return super.visitQualifiedReferenceExpression(node);
            }
        });
        return found.get();
    }

    public static boolean isArrayLiteral(PsiElement node) {
        PsiTypeCastExpression castExpression;
        PsiExpression operand;
        if (node instanceof PsiReference) {
            PsiLocalVariable variable;
            PsiExpression last;
            PsiElement resolved = ((PsiReference)node).resolve();
            if (resolved instanceof PsiField) {
                PsiField field = (PsiField)resolved;
                if (field.getInitializer() != null) {
                    return ConstantEvaluator.isArrayLiteral((PsiElement)field.getInitializer());
                }
            } else if (resolved instanceof PsiLocalVariable && (last = ConstantEvaluator.findLastAssignment(node, (PsiVariable)(variable = (PsiLocalVariable)resolved))) != null) {
                return ConstantEvaluator.isArrayLiteral((PsiElement)last);
            }
        } else if (node instanceof PsiNewExpression) {
            PsiNewExpression creation = (PsiNewExpression)node;
            if (creation.getArrayInitializer() != null) {
                return true;
            }
            PsiType type = creation.getType();
            if (type instanceof PsiArrayType) {
                return true;
            }
        } else if (node instanceof PsiParenthesizedExpression) {
            PsiParenthesizedExpression parenthesizedExpression = (PsiParenthesizedExpression)node;
            PsiExpression expression = parenthesizedExpression.getExpression();
            if (expression != null) {
                return ConstantEvaluator.isArrayLiteral((PsiElement)expression);
            }
        } else if (node instanceof PsiTypeCastExpression && (operand = (castExpression = (PsiTypeCastExpression)node).getOperand()) != null) {
            return ConstantEvaluator.isArrayLiteral((PsiElement)operand);
        }
        return false;
    }

    public static boolean isArrayLiteral(UElement node) {
        if (node instanceof UReferenceExpression) {
            PsiVariable variable;
            UExpression lastAssignment;
            PsiElement resolved = ((UReferenceExpression)node).resolve();
            if (resolved instanceof PsiVariable && (lastAssignment = UastLintUtils.findLastAssignment(variable = (PsiVariable)resolved, node)) != null) {
                return ConstantEvaluator.isArrayLiteral((UElement)lastAssignment);
            }
        } else {
            if (UastExpressionUtils.isNewArrayWithDimensions((UElement)node)) {
                return true;
            }
            if (UastExpressionUtils.isNewArrayWithInitializer((UElement)node)) {
                return true;
            }
            if (node instanceof UParenthesizedExpression) {
                UParenthesizedExpression parenthesizedExpression = (UParenthesizedExpression)node;
                UExpression expression = parenthesizedExpression.getExpression();
                return ConstantEvaluator.isArrayLiteral((UElement)expression);
            }
            if (UastExpressionUtils.isTypeCast((UElement)node)) {
                UBinaryExpressionWithType castExpression = (UBinaryExpressionWithType)node;
                assert (castExpression != null);
                UExpression operand = castExpression.getOperand();
                return ConstantEvaluator.isArrayLiteral((UElement)operand);
            }
        }
        return false;
    }

    public static Object evaluate(JavaContext context, PsiElement node) {
        Object evaluate = new ConstantEvaluator().evaluate(node);
        return evaluate;
    }

    public static Object evaluate(JavaContext context, UElement element) {
        if (element instanceof ULiteralExpression) {
            return ((ULiteralExpression)element).getValue();
        }
        return new ConstantEvaluator().evaluate(element);
    }

    public static String evaluateString(JavaContext context, PsiElement node, boolean allowUnknown) {
        Object value;
        ConstantEvaluator evaluator = new ConstantEvaluator();
        if (allowUnknown) {
            evaluator.allowUnknowns();
        }
        return (value = evaluator.evaluate(node)) instanceof String ? (String)value : null;
    }

    public static PsiExpression findLastAssignment(PsiElement usage, PsiVariable variable) {
        PsiStatement statement = (PsiStatement)PsiTreeUtil.getParentOfType((PsiElement)usage, PsiStatement.class, (boolean)false);
        if (statement != null) {
            PsiStatement prev = (PsiStatement)PsiTreeUtil.getPrevSiblingOfType((PsiElement)statement, PsiStatement.class);
            String targetName = variable.getName();
            if (targetName == null) {
                return null;
            }
            while (prev != null) {
                PsiReferenceExpression reference;
                PsiAssignmentExpression assign;
                PsiExpression lhs;
                PsiExpression expression;
                if (prev instanceof PsiDeclarationStatement) {
                    for (PsiElement element : ((PsiDeclarationStatement)prev).getDeclaredElements()) {
                        if (!variable.equals(element)) continue;
                        return variable.getInitializer();
                    }
                } else if (prev instanceof PsiExpressionStatement && (expression = ((PsiExpressionStatement)prev).getExpression()) instanceof PsiAssignmentExpression && (lhs = (assign = (PsiAssignmentExpression)expression).getLExpression()) instanceof PsiReferenceExpression && targetName.equals((reference = (PsiReferenceExpression)lhs).getReferenceName()) && reference.getQualifier() == null) {
                    return assign.getRExpression();
                }
                prev = (PsiStatement)PsiTreeUtil.getPrevSiblingOfType((PsiElement)prev, PsiStatement.class);
            }
        }
        return null;
    }

    public static String evaluateString(JavaContext context, UElement element, boolean allowUnknown) {
        Object value;
        ConstantEvaluator evaluator = new ConstantEvaluator();
        if (allowUnknown) {
            evaluator.allowUnknowns();
        }
        return (value = evaluator.evaluate(element)) instanceof String ? (String)value : null;
    }

    public static class LastAssignmentFinder
    extends AbstractUastVisitor {
        private final PsiVariable mVariable;
        private final UElement mEndAt;
        private final ConstantEvaluator mConstantEvaluator;
        private boolean mDone = false;
        private int mCurrentLevel = 0;
        private int mVariableLevel = -1;
        private Object mCurrentValue;
        private UElement mLastAssignment;

        public LastAssignmentFinder(PsiVariable variable, UElement endAt, UastContext context, ConstantEvaluator constantEvaluator, int variableLevel) {
            this.mVariable = variable;
            this.mEndAt = endAt;
            UExpression initializer = context.getInitializerBody(variable);
            this.mLastAssignment = initializer;
            this.mConstantEvaluator = constantEvaluator;
            if (initializer != null && constantEvaluator != null) {
                this.mCurrentValue = constantEvaluator.evaluate((UElement)initializer);
            }
            this.mVariableLevel = variableLevel;
        }

        public Object getCurrentValue() {
            return this.mCurrentValue;
        }

        public UElement getLastAssignment() {
            return this.mLastAssignment;
        }

        public boolean visitElement(UElement node) {
            if (LastAssignmentFinder.elementHasLevel(node)) {
                ++this.mCurrentLevel;
            }
            if (node.equals(this.mEndAt)) {
                this.mDone = true;
            }
            return this.mDone || super.visitElement(node);
        }

        public boolean visitVariable(UVariable node) {
            if (this.mVariableLevel < 0 && node.getPsi().isEquivalentTo((PsiElement)this.mVariable)) {
                this.mVariableLevel = this.mCurrentLevel;
            }
            return super.visitVariable(node);
        }

        public void afterVisitBinaryExpression(UBinaryExpression node) {
            if (!this.mDone && node.getOperator() instanceof UastBinaryOperator.AssignOperator && this.mVariableLevel >= 0) {
                UExpression leftOperand = node.getLeftOperand();
                UastBinaryOperator operator = node.getOperator();
                if (!(operator instanceof UastBinaryOperator.AssignOperator) || !(leftOperand instanceof UResolvable)) {
                    return;
                }
                PsiElement resolved = ((UResolvable)leftOperand).resolve();
                if (!this.mVariable.equals(resolved)) {
                    return;
                }
                if (this.mCurrentLevel > this.mVariableLevel + 1) {
                    this.mLastAssignment = null;
                    this.mCurrentValue = null;
                    return;
                }
                UExpression rightOperand = node.getRightOperand();
                ConstantEvaluator constantEvaluator = this.mConstantEvaluator;
                this.mCurrentValue = constantEvaluator != null ? constantEvaluator.evaluate((UElement)rightOperand) : null;
                this.mLastAssignment = rightOperand;
            }
            super.afterVisitBinaryExpression(node);
        }

        public void afterVisitElement(UElement node) {
            if (LastAssignmentFinder.elementHasLevel(node)) {
                --this.mCurrentLevel;
            }
            super.afterVisitElement(node);
        }

        private static boolean elementHasLevel(UElement node) {
            return !(node instanceof UBlockExpression) && !(node instanceof UDeclarationsExpression);
        }
    }
}

