/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.detector.api;

import com.android.tools.lint.detector.api.TextFormat$WhenMappings;
import com.android.utils.SdkUtils;
import com.android.utils.XmlUtils;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.TypeCastException;
import kotlin._Assertions;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u000e\b\u0086\u0001\u0018\u0000 \u00112\b\u0012\u0004\u0012\u00020\u00000\u0001:\u0001\u0011B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u0000J\u0010\u0010\u0007\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\u0004H\u0002J\u0010\u0010\t\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\u0004H\u0002J\u000e\u0010\u000b\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\u0004J\u000e\u0010\f\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\u0004j\u0002\b\rj\u0002\b\u000ej\u0002\b\u000fj\u0002\b\u0010\u00a8\u0006\u0012"}, d2={"Lcom/android/tools/lint/detector/api/TextFormat;", "", "(Ljava/lang/String;I)V", "convertTo", "", "message", "to", "fromHtml", "html", "fromRaw", "text", "toHtml", "toText", "RAW", "TEXT", "HTML", "HTML_WITH_UNICODE", "Companion", "lint-api"})
public final class TextFormat
extends Enum<TextFormat> {
    public static final /* enum */ TextFormat RAW;
    public static final /* enum */ TextFormat TEXT;
    public static final /* enum */ TextFormat HTML;
    public static final /* enum */ TextFormat HTML_WITH_UNICODE;
    private static final /* synthetic */ TextFormat[] $VALUES;
    private static final String HTTP_PREFIX = "http://";
    private static final String HTTPS_PREFIX = "https://";
    public static final Companion Companion;

    static {
        TextFormat[] textFormatArray = new TextFormat[4];
        TextFormat[] textFormatArray2 = textFormatArray;
        textFormatArray[0] = RAW = new TextFormat();
        textFormatArray[1] = TEXT = new TextFormat();
        textFormatArray[2] = HTML = new TextFormat();
        textFormatArray[3] = HTML_WITH_UNICODE = new TextFormat();
        $VALUES = textFormatArray;
        Companion = new Companion(null);
    }

    @NotNull
    public final String toHtml(@NotNull String text) {
        Intrinsics.checkParameterIsNotNull((Object)text, (String)"text");
        return this.convertTo(text, HTML);
    }

    @NotNull
    public final String toText(@NotNull String text) {
        Intrinsics.checkParameterIsNotNull((Object)text, (String)"text");
        return this.convertTo(text, TEXT);
    }

    @NotNull
    public final String convertTo(@NotNull String message, @NotNull TextFormat to) {
        Intrinsics.checkParameterIsNotNull((Object)message, (String)"message");
        Intrinsics.checkParameterIsNotNull((Object)((Object)to), (String)"to");
        if (this == to) {
            return message;
        }
        switch (TextFormat$WhenMappings.$EnumSwitchMapping$4[this.ordinal()]) {
            case 1: {
                String string;
                switch (TextFormat$WhenMappings.$EnumSwitchMapping$0[to.ordinal()]) {
                    case 1: {
                        string = message;
                        break;
                    }
                    case 2: 
                    case 3: 
                    case 4: {
                        string = to.fromRaw(message);
                        break;
                    }
                    default: {
                        throw new NoWhenBranchMatchedException();
                    }
                }
                return string;
            }
            case 2: {
                String string;
                switch (TextFormat$WhenMappings.$EnumSwitchMapping$1[to.ordinal()]) {
                    case 1: {
                        string = TextFormat.Companion.textToRaw(message);
                        break;
                    }
                    case 2: {
                        string = message;
                        break;
                    }
                    case 3: 
                    case 4: {
                        String string2 = XmlUtils.toXmlTextValue((String)message);
                        string = string2;
                        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"XmlUtils.toXmlTextValue(message)");
                        break;
                    }
                    default: {
                        throw new NoWhenBranchMatchedException();
                    }
                }
                return string;
            }
            case 3: {
                String string;
                switch (TextFormat$WhenMappings.$EnumSwitchMapping$2[to.ordinal()]) {
                    case 1: {
                        string = message;
                        break;
                    }
                    case 2: {
                        string = TextFormat.Companion.removeNumericEntities(message);
                        break;
                    }
                    case 3: 
                    case 4: {
                        string = to.fromHtml(message);
                        break;
                    }
                    default: {
                        throw new NoWhenBranchMatchedException();
                    }
                }
                return string;
            }
            case 4: {
                String string;
                switch (TextFormat$WhenMappings.$EnumSwitchMapping$3[to.ordinal()]) {
                    case 1: 
                    case 2: {
                        string = message;
                        break;
                    }
                    case 3: 
                    case 4: {
                        string = to.fromHtml(message);
                        break;
                    }
                    default: {
                        throw new NoWhenBranchMatchedException();
                    }
                }
                return string;
            }
        }
        throw new NoWhenBranchMatchedException();
    }

    /*
     * WARNING - void declaration
     */
    private final String fromHtml(String html) {
        boolean bl;
        boolean bl2 = bl = this == RAW || this == TEXT;
        if (_Assertions.ENABLED && !bl) {
            TextFormat textFormat = this;
            throw (Throwable)((Object)new AssertionError((Object)textFormat));
        }
        StringBuilder sb = new StringBuilder(html.length());
        boolean inPre = false;
        int i = 0;
        int n = html.length();
        while (i < n) {
            CharSequence charSequence;
            int end;
            char c = html.charAt(i);
            if (c == '<') {
                String tag;
                void $receiver$iv;
                int begin;
                if (StringsKt.startsWith$default((String)html, (String)"<!--", (int)i, (boolean)false, (int)4, null)) {
                    end = StringsKt.indexOf$default((CharSequence)html, (String)"-->", (int)i, (boolean)false, (int)4, null);
                    if (end == -1) break;
                    i = end + 2;
                    ++i;
                    continue;
                }
                boolean isEndTag = false;
                if (StringsKt.startsWith$default((String)html, (String)"</", (int)i, (boolean)false, (int)4, null)) {
                    begin = i + 2;
                    isEndTag = true;
                } else {
                    begin = i + 1;
                }
                i = StringsKt.indexOf$default((CharSequence)html, (char)'>', (int)i, (boolean)false, (int)4, null);
                if (i == -1) break;
                int end2 = i;
                if (html.charAt(i - 1) == '/') {
                    --end2;
                    isEndTag = true;
                }
                charSequence = html;
                String string = charSequence;
                if (string == null) {
                    throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
                }
                String string2 = string.substring(begin, end2);
                Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
                charSequence = string2;
                CharSequence $receiver$iv$iv = (CharSequence)$receiver$iv;
                int startIndex$iv$iv = 0;
                int endIndex$iv$iv = $receiver$iv$iv.length() - 1;
                boolean startFound$iv$iv = false;
                while (startIndex$iv$iv <= endIndex$iv$iv) {
                    boolean match$iv$iv;
                    int index$iv$iv = !startFound$iv$iv ? startIndex$iv$iv : endIndex$iv$iv;
                    char it = $receiver$iv$iv.charAt(index$iv$iv);
                    boolean bl3 = match$iv$iv = it <= ' ';
                    if (!startFound$iv$iv) {
                        if (!match$iv$iv) {
                            startFound$iv$iv = true;
                            continue;
                        }
                        ++startIndex$iv$iv;
                        continue;
                    }
                    if (!match$iv$iv) break;
                    --endIndex$iv$iv;
                }
                if (StringsKt.equals((String)(tag = ((Object)$receiver$iv$iv.subSequence(startIndex$iv$iv, endIndex$iv$iv + 1)).toString()), (String)"br", (boolean)true)) {
                    sb.append('\n');
                } else if (StringsKt.equals((String)tag, (String)"p", (boolean)true) || StringsKt.equals((String)tag, (String)"div", (boolean)true) || StringsKt.equals((String)tag, (String)"pre", (boolean)true) || StringsKt.equals((String)tag, (String)"blockquote", (boolean)true) || StringsKt.equals((String)tag, (String)"dl", (boolean)true) || StringsKt.equals((String)tag, (String)"dd", (boolean)true) || StringsKt.equals((String)tag, (String)"dt", (boolean)true) || StringsKt.equals((String)tag, (String)"ol", (boolean)true) || StringsKt.equals((String)tag, (String)"ul", (boolean)true) || StringsKt.equals((String)tag, (String)"li", (boolean)true) || tag.length() == 2 && StringsKt.startsWith$default((String)tag, (String)"h", (boolean)false, (int)2, null) && Character.isDigit(tag.charAt(1))) {
                    charSequence = sb;
                    if (charSequence.length() > 0 && sb.charAt(sb.length() - 1) != '\n') {
                        sb.append('\n');
                    }
                    if (Intrinsics.areEqual((Object)tag, (Object)"li") && !isEndTag) {
                        sb.append("* ");
                    }
                    if (StringsKt.equals((String)tag, (String)"pre", (boolean)true)) {
                        inPre = !isEndTag;
                    }
                }
            } else if (c == '&') {
                end = StringsKt.indexOf$default((CharSequence)html, (char)';', (int)i, (boolean)false, (int)4, null);
                if (end > i) {
                    String entity;
                    String s;
                    String end2 = html;
                    int tag = end + 1;
                    String string = end2;
                    if (string == null) {
                        throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
                    }
                    Intrinsics.checkExpressionValueIsNotNull((Object)string.substring(i, tag), (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
                    String string3 = s = XmlUtils.fromXmlAttributeValue((String)entity);
                    Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"s");
                    if (StringsKt.startsWith$default((String)string3, (String)"&", (boolean)false, (int)2, null)) {
                        if (StringsKt.equals((String)entity, (String)"&nbsp;", (boolean)true)) {
                            s = " ";
                        } else if (StringsKt.startsWith$default((String)entity, (String)"&#", (boolean)false, (int)2, null)) {
                            try {
                                charSequence = entity;
                                int n2 = 2;
                                String string4 = charSequence;
                                if (string4 == null) {
                                    throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
                                }
                                String string5 = string4.substring(n2);
                                Intrinsics.checkExpressionValueIsNotNull((Object)string5, (String)"(this as java.lang.String).substring(startIndex)");
                                int value = Integer.parseInt(string5);
                                s = Character.toString((char)value);
                            }
                            catch (NumberFormatException numberFormatException) {
                                // empty catch block
                            }
                        }
                    }
                    sb.append(s);
                    i = end;
                } else {
                    sb.append(c);
                }
            } else if (Character.isWhitespace(c)) {
                if (inPre) {
                    sb.append(c);
                } else {
                    CharSequence charSequence2 = sb;
                    if (charSequence2.length() == 0 || !Character.isWhitespace(sb.charAt(sb.length() - 1))) {
                        sb.append(' ');
                    }
                }
            } else {
                sb.append(c);
            }
            ++i;
        }
        String string = sb.toString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"sb.toString()");
        String s = string;
        String string6 = SdkUtils.wrap((String)s, (int)60, null);
        Intrinsics.checkExpressionValueIsNotNull((Object)string6, (String)"SdkUtils.wrap(s, 60, null)");
        s = string6;
        return s;
    }

    private final String fromRaw(String text) {
        boolean bl;
        boolean bl2 = bl = this == HTML || this == HTML_WITH_UNICODE || this == TEXT;
        if (_Assertions.ENABLED && !bl) {
            TextFormat textFormat = this;
            throw (Throwable)((Object)new AssertionError((Object)textFormat));
        }
        StringBuilder sb = new StringBuilder(3 * text.length() / 2);
        boolean html = this == HTML || this == HTML_WITH_UNICODE;
        boolean escapeUnicode = this == HTML;
        char prev = (char)0;
        int flushIndex = 0;
        int n = text.length();
        boolean escaped = false;
        int i = 0;
        while (i < n) {
            char c = text.charAt(i);
            if (c == '\\' && !escaped) {
                escaped = true;
                if (i > flushIndex) {
                    TextFormat.Companion.appendEscapedText(sb, text, html, flushIndex, i, escapeUnicode);
                }
                flushIndex = i + 1;
                ++i;
                continue;
            }
            if (!(escaped || c != '*' && c != '`' || i >= n - 1)) {
                if (!Character.isLetterOrDigit(prev) && !Character.isWhitespace(text.charAt(i + 1))) {
                    int end = StringsKt.indexOf$default((CharSequence)text, (char)c, (int)(i + 1), (boolean)false, (int)4, null);
                    boolean bold = false;
                    if (end == i + 1 && c == '*') {
                        int end2 = StringsKt.indexOf$default((CharSequence)text, (char)'*', (int)(end + 1), (boolean)false, (int)4, null);
                        if (end2 == end + 1) {
                            if ((end2 = StringsKt.indexOf$default((CharSequence)text, (String)"***", (int)(end2 + 1), (boolean)false, (int)4, null)) != -1) {
                                if (i > flushIndex) {
                                    TextFormat.Companion.appendEscapedText(sb, text, html, flushIndex, i, escapeUnicode);
                                }
                                if (html) {
                                    sb.append("<b><i>");
                                    TextFormat.Companion.appendEscapedText(sb, text, true, i + 3, end2, escapeUnicode);
                                    sb.append("</i></b>");
                                } else {
                                    TextFormat.Companion.appendEscapedText(sb, text, false, i + 3, end2, escapeUnicode);
                                }
                                flushIndex = end2 + 3;
                                i = flushIndex - 1;
                            }
                            ++i;
                            continue;
                        }
                        if (end2 != -1 && end2 > end + 1 && end2 < n - 1 && text.charAt(end2 + 1) == '*') {
                            end = end2;
                            bold = true;
                        }
                    }
                    if (!(end == -1 || end != n - 1 && Character.isLetter(text.charAt(end + 1)))) {
                        if (i > flushIndex) {
                            TextFormat.Companion.appendEscapedText(sb, text, html, flushIndex, i, escapeUnicode);
                        }
                        if (bold) {
                            ++i;
                        }
                        if (html) {
                            String tag = bold ? "b" : (c == '*' ? "i" : "code");
                            sb.append('<').append(tag).append('>');
                            TextFormat.Companion.appendEscapedText(sb, text, true, i + 1, end, escapeUnicode);
                            sb.append('<').append('/').append(tag).append('>');
                        } else {
                            TextFormat.Companion.appendEscapedText(sb, text, false, i + 1, end, escapeUnicode);
                        }
                        flushIndex = end + 1;
                        if (bold) {
                            ++flushIndex;
                        }
                        i = flushIndex - 1;
                    }
                }
            } else if (html && c == 'h' && i < n - 1 && text.charAt(i + 1) == 't' && (StringsKt.startsWith$default((String)text, (String)HTTP_PREFIX, (int)i, (boolean)false, (int)4, null) || StringsKt.startsWith$default((String)text, (String)HTTPS_PREFIX, (int)i, (boolean)false, (int)4, null)) && !Character.isLetterOrDigit(prev)) {
                char d;
                int end;
                int length = StringsKt.startsWith$default((String)text, (String)HTTP_PREFIX, (int)i, (boolean)false, (int)4, null) ? HTTP_PREFIX.length() : HTTPS_PREFIX.length();
                for (end = i + length; end < n && !TextFormat.Companion.terminatesUrl(d = text.charAt(end)); ++end) {
                }
                char last = text.charAt(end - 1);
                if (last == '.' || last == ')' || last == '!') {
                    --end;
                }
                if (end > i + length) {
                    String url;
                    String string;
                    if (i > flushIndex) {
                        TextFormat.Companion.appendEscapedText(sb, text, true, flushIndex, i, escapeUnicode);
                    }
                    String string2 = string = text;
                    if (string2 == null) {
                        throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
                    }
                    Intrinsics.checkExpressionValueIsNotNull((Object)string2.substring(i, end), (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
                    sb.append("<a href=\"");
                    sb.append(url);
                    sb.append('\"').append('>');
                    sb.append(url);
                    sb.append("</a>");
                    flushIndex = end;
                    i = flushIndex - 1;
                }
            } else if (c == '\n' && escaped) {
                ++flushIndex;
            }
            prev = c;
            escaped = false;
            ++i;
        }
        if (flushIndex < n) {
            TextFormat.Companion.appendEscapedText(sb, text, html, flushIndex, n, escapeUnicode);
        }
        String string = sb.toString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"sb.toString()");
        return string;
    }

    public static TextFormat[] values() {
        return (TextFormat[])$VALUES.clone();
    }

    public static TextFormat valueOf(String string) {
        return Enum.valueOf(TextFormat.class, string);
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\f\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J<\u0010\u0006\u001a\u00020\u00072\n\u0010\b\u001a\u00060\tj\u0002`\n2\u0006\u0010\u000b\u001a\u00020\u00042\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u0011\u001a\u00020\rH\u0002J\u0010\u0010\u0012\u001a\u00020\u00042\u0006\u0010\f\u001a\u00020\u0004H\u0002J\u0010\u0010\u0013\u001a\u00020\r2\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J\u0010\u0010\u0016\u001a\u00020\u00042\u0006\u0010\u0017\u001a\u00020\u0004H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lcom/android/tools/lint/detector/api/TextFormat$Companion;", "", "()V", "HTTPS_PREFIX", "", "HTTP_PREFIX", "appendEscapedText", "", "sb", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "text", "html", "", "start", "", "end", "escapeUnicode", "removeNumericEntities", "terminatesUrl", "c", "", "textToRaw", "message", "lint-api"})
    public static final class Companion {
        /*
         * WARNING - void declaration
         */
        private final String textToRaw(String message) {
            boolean mustEscape = false;
            int n = message.length();
            int n2 = 0;
            int n3 = n;
            while (n2 < n3) {
                void i;
                char c = message.charAt((int)i);
                if (c == '\\' || c == '*' || c == '`') {
                    mustEscape = true;
                    break;
                }
                ++i;
            }
            if (!mustEscape) {
                return message;
            }
            StringBuilder sb = new StringBuilder(message.length() * 2);
            n3 = 0;
            int n4 = n;
            while (n3 < n4) {
                void i;
                char c = message.charAt((int)i);
                if (c == '\\' || c == '*' || c == '`') {
                    sb.append('\\');
                }
                sb.append(c);
                ++i;
            }
            String string = sb.toString();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"sb.toString()");
            return string;
        }

        private final boolean terminatesUrl(char c) {
            char c2 = c;
            char c3 = c2;
            return 'a' <= c3 && 'z' >= c3 ? false : ('A' <= (c3 = c2) && 'Z' >= c3 ? false : ('0' <= (c3 = c2) && '9' >= c3 ? false : c2 != '-' && c2 != '_' && c2 != '.' && c2 != '*' && c2 != '+' && c2 != '%' && c2 != '/' && c2 != '#'));
        }

        private final String removeNumericEntities(String html) {
            if (!StringsKt.contains$default((CharSequence)html, (CharSequence)"&#", (boolean)false, (int)2, null)) {
                return html;
            }
            StringBuilder sb = new StringBuilder(html.length());
            int i = 0;
            int n = html.length();
            while (i < n) {
                int end;
                char c = html.charAt(i);
                if (c == '&' && i < n - 1 && html.charAt(i + 1) == '#' && (end = StringsKt.indexOf$default((CharSequence)html, (char)';', (int)(i + 2), (boolean)false, (int)4, null)) != -1) {
                    String string = html;
                    int n2 = i + 2;
                    String string2 = string;
                    if (string2 == null) {
                        throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
                    }
                    Intrinsics.checkExpressionValueIsNotNull((Object)string2.substring(n2, end), (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
                    try {
                        String decimal;
                        c = (char)Integer.parseInt(decimal);
                        sb.append(c);
                        i = end;
                        ++i;
                        continue;
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                }
                sb.append(c);
                ++i;
            }
            String string = sb.toString();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"sb.toString()");
            return string;
        }

        /*
         * WARNING - void declaration
         */
        private final void appendEscapedText(StringBuilder sb, String text, boolean html, int start, int end, boolean escapeUnicode) {
            if (html) {
                int n = start;
                int n2 = end;
                while (n < n2) {
                    void i;
                    char c = text.charAt((int)i);
                    if (c == '<') {
                        sb.append("&lt;");
                    } else if (c == '&') {
                        sb.append("&amp;");
                    } else if (c == '\n') {
                        sb.append("<br/>\n");
                    } else if (c > '\u00ff' && escapeUnicode) {
                        if (c != '\u200b') {
                            sb.append("&#");
                            sb.append(Integer.toString(c));
                            sb.append(';');
                        }
                    } else if (c == '\u00a0') {
                        sb.append("&nbsp;");
                    } else {
                        sb.append(c);
                    }
                    ++i;
                }
            } else {
                int n = end;
                for (int i = start; i < n; ++i) {
                    char c = text.charAt(i);
                    if (c == '\u200b') continue;
                    sb.append(c);
                }
            }
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

