/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.helpers;

import com.android.builder.model.AndroidArtifact;
import com.android.builder.model.Dependencies;
import com.android.builder.model.Variant;
import com.android.tools.lint.client.api.JavaEvaluator;
import com.android.tools.lint.client.api.LintClient;
import com.android.tools.lint.detector.api.Lint;
import com.android.tools.lint.detector.api.Project;
import com.android.tools.lint.helpers.DefaultJavaEvaluator;
import com.google.common.collect.Sets;
import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileSystem;
import com.intellij.psi.JavaDirectoryService;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiCompiledFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiType;
import com.intellij.psi.impl.file.PsiPackageImpl;
import com.intellij.psi.impl.source.tree.java.PsiCompositeModifierList;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.MethodSignatureUtil;
import com.intellij.psi.util.TypeConversionUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.uast.UAnnotated;
import org.jetbrains.uast.UAnnotation;
import org.jetbrains.uast.UCallExpression;
import org.jetbrains.uast.UDeclaration;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UExpression;
import org.jetbrains.uast.UFile;
import org.jetbrains.uast.UastUtils;
import org.jetbrains.uast.java.JavaUAnnotation;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\u009e\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000b\b\u0016\u0018\u00002\u00020\u0001B\u0019\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\u0006J\u0018\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0012H\u0016J$\u0010\u0014\u001a\u000e\u0012\u0004\u0012\u00020\u0016\u0012\u0004\u0012\u00020\u00170\u00152\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u0012H\u0016J\u0014\u0010\u001b\u001a\u0004\u0018\u00010\u001c2\b\u0010\u001d\u001a\u0004\u0018\u00010\u001cH\u0016J\"\u0010\u001e\u001a\u00020\u00102\b\u0010\u001f\u001a\u0004\u0018\u00010 2\u0006\u0010!\u001a\u00020\r2\u0006\u0010\"\u001a\u00020\u0010H\u0016J-\u0010#\u001a\u0004\u0018\u00010$2\b\u0010%\u001a\u0004\u0018\u00010&2\u0012\u0010'\u001a\n\u0012\u0006\b\u0001\u0012\u00020\r0(\"\u00020\rH\u0016\u00a2\u0006\u0002\u0010)J+\u0010*\u001a\u0004\u0018\u00010$2\u0006\u0010%\u001a\u00020&2\u0012\u0010'\u001a\n\u0012\u0006\b\u0001\u0012\u00020\r0(\"\u00020\rH\u0016\u00a2\u0006\u0002\u0010)J\u0012\u0010+\u001a\u0004\u0018\u00010 2\u0006\u0010,\u001a\u00020\rH\u0016J\u0012\u0010-\u001a\u0004\u0018\u00010\r2\u0006\u0010.\u001a\u00020/H\u0016J\u0014\u0010-\u001a\u0004\u0018\u00010\r2\b\u00100\u001a\u0004\u0018\u000101H\u0002J\u0012\u0010-\u001a\u0004\u0018\u00010\r2\u0006\u0010.\u001a\u000202H\u0016J#\u00103\u001a\b\u0012\u0004\u0012\u00020$0(2\u0006\u00104\u001a\u00020&2\u0006\u00105\u001a\u00020\u0010H\u0016\u00a2\u0006\u0002\u00106J\u001e\u00103\u001a\b\u0012\u0004\u0012\u000208072\u0006\u00104\u001a\u0002092\u0006\u00105\u001a\u00020\u0010H\u0016J\u0014\u0010:\u001a\u0004\u0018\u00010;2\b\u0010<\u001a\u0004\u0018\u00010 H\u0016J\u0012\u0010=\u001a\u0004\u0018\u00010\r2\u0006\u0010<\u001a\u00020 H\u0016J\u0012\u0010=\u001a\u0004\u0018\u00010\r2\u0006\u0010>\u001a\u00020;H\u0016J\u0012\u0010?\u001a\u0004\u0018\u00010\u000e2\u0006\u0010@\u001a\u00020/H\u0016J\u0012\u0010?\u001a\u0004\u0018\u00010\u000e2\u0006\u0010@\u001a\u000202H\u0016J\u0012\u0010A\u001a\u0004\u0018\u00010\u00052\u0006\u0010.\u001a\u00020/H\u0016J\u0012\u0010B\u001a\u0004\u0018\u00010\r2\u0006\u0010<\u001a\u00020 H\u0016J\u0012\u0010B\u001a\u0004\u0018\u00010\r2\u0006\u0010>\u001a\u00020;H\u0016J \u0010C\u001a\u00020\u00102\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010D\u001a\u00020\r2\u0006\u0010\"\u001a\u00020\u0010H\u0016J\"\u0010E\u001a\u00020\u00102\b\u0010\u001f\u001a\u0004\u0018\u00010 2\u0006\u0010!\u001a\u00020\r2\u0006\u0010\"\u001a\u00020\u0010H\u0016R\u0016\u0010\u0007\u001a\u0004\u0018\u00010\b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0002\u001a\u0004\u0018\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u000e0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006F"}, d2={"Lcom/android/tools/lint/helpers/DefaultJavaEvaluator;", "Lcom/android/tools/lint/client/api/JavaEvaluator;", "myProject", "Lcom/intellij/openapi/project/Project;", "myLintProject", "Lcom/android/tools/lint/detector/api/Project;", "(Lcom/intellij/openapi/project/Project;Lcom/android/tools/lint/detector/api/Project;)V", "dependencies", "Lcom/android/builder/model/Dependencies;", "getDependencies", "()Lcom/android/builder/model/Dependencies;", "packageInfoCache", "", "", "Lcom/intellij/psi/PsiPackage;", "areSignaturesEqual", "", "method1", "Lcom/intellij/psi/PsiMethod;", "method2", "computeArgumentMapping", "", "Lorg/jetbrains/uast/UExpression;", "Lcom/intellij/psi/PsiParameter;", "call", "Lorg/jetbrains/uast/UCallExpression;", "method", "erasure", "Lcom/intellij/psi/PsiType;", "type", "extendsClass", "cls", "Lcom/intellij/psi/PsiClass;", "className", "strict", "findAnnotation", "Lcom/intellij/psi/PsiAnnotation;", "listOwner", "Lcom/intellij/psi/PsiModifierListOwner;", "annotationNames", "", "(Lcom/intellij/psi/PsiModifierListOwner;[Ljava/lang/String;)Lcom/intellij/psi/PsiAnnotation;", "findAnnotationInHierarchy", "findClass", "qualifiedName", "findJarPath", "element", "Lcom/intellij/psi/PsiElement;", "containingFile", "Lcom/intellij/psi/PsiFile;", "Lorg/jetbrains/uast/UElement;", "getAllAnnotations", "owner", "inHierarchy", "(Lcom/intellij/psi/PsiModifierListOwner;Z)[Lcom/intellij/psi/PsiAnnotation;", "", "Lorg/jetbrains/uast/UAnnotation;", "Lorg/jetbrains/uast/UAnnotated;", "getClassType", "Lcom/intellij/psi/PsiClassType;", "psiClass", "getInternalName", "psiClassType", "getPackage", "node", "getProject", "getQualifiedName", "implementsInterface", "interfaceName", "inheritsFrom", "lint-api"})
public class DefaultJavaEvaluator
extends JavaEvaluator {
    private final Map<String, PsiPackage> packageInfoCache;
    private final com.intellij.openapi.project.Project myProject;
    private final Project myLintProject;

    @Override
    @Nullable
    public Dependencies getDependencies() {
        Variant variant;
        if (this.myLintProject != null && this.myLintProject.isAndroidProject() && (variant = this.myLintProject.getCurrentVariant()) != null) {
            AndroidArtifact androidArtifact = variant.getMainArtifact();
            Intrinsics.checkExpressionValueIsNotNull((Object)androidArtifact, (String)"variant.mainArtifact");
            return androidArtifact.getDependencies();
        }
        return null;
    }

    @Override
    public boolean extendsClass(@Nullable PsiClass cls, @NotNull String className, boolean strict) {
        Intrinsics.checkParameterIsNotNull((Object)className, (String)"className");
        return InheritanceUtil.isInheritor((PsiClass)cls, (boolean)strict, (String)className);
    }

    @Override
    public boolean implementsInterface(@NotNull PsiClass cls, @NotNull String interfaceName, boolean strict) {
        Intrinsics.checkParameterIsNotNull((Object)cls, (String)"cls");
        Intrinsics.checkParameterIsNotNull((Object)interfaceName, (String)"interfaceName");
        return InheritanceUtil.isInheritor((PsiClass)cls, (boolean)strict, (String)interfaceName);
    }

    @Override
    public boolean inheritsFrom(@Nullable PsiClass cls, @NotNull String className, boolean strict) {
        Intrinsics.checkParameterIsNotNull((Object)className, (String)"className");
        if (cls == null) {
            return false;
        }
        return InheritanceUtil.isInheritor((PsiClass)cls, (boolean)strict, (String)className);
    }

    @Override
    @Nullable
    public PsiClass findClass(@NotNull String qualifiedName) {
        Intrinsics.checkParameterIsNotNull((Object)qualifiedName, (String)"qualifiedName");
        com.intellij.openapi.project.Project project = this.myProject;
        if (project == null) {
            return null;
        }
        return JavaPsiFacade.getInstance((com.intellij.openapi.project.Project)project).findClass(qualifiedName, GlobalSearchScope.allScope((com.intellij.openapi.project.Project)this.myProject));
    }

    @Override
    @Nullable
    public PsiClassType getClassType(@Nullable PsiClass psiClass) {
        return this.myProject != null && psiClass != null ? JavaPsiFacade.getElementFactory((com.intellij.openapi.project.Project)this.myProject).createType(psiClass) : null;
    }

    @Override
    @NotNull
    public List<UAnnotation> getAllAnnotations(@NotNull UAnnotated owner, boolean inHierarchy) {
        Intrinsics.checkParameterIsNotNull((Object)owner, (String)"owner");
        if (owner instanceof UDeclaration) {
            List annotations = owner.getAnnotations();
            PsiAnnotation[] psiAnnotations = this.getAllAnnotations(((UDeclaration)owner).getPsi(), inHierarchy);
            if (!annotations.isEmpty()) {
                PsiAnnotation[] psiAnnotationArray = psiAnnotations;
                boolean bl = false;
                if (psiAnnotationArray.length == 0) {
                    return annotations;
                }
                bl = false;
                List result = new ArrayList();
                for (PsiAnnotation psi : psiAnnotations) {
                    String signature = psi.getQualifiedName();
                    boolean handled = false;
                    for (UAnnotation ua : annotations) {
                        if (!Intrinsics.areEqual((Object)ua.getQualifiedName(), (Object)signature)) continue;
                        result.add(ua);
                        handled = true;
                        break;
                    }
                    if (handled) continue;
                    result.add(JavaUAnnotation.Companion.wrap(psi));
                }
                return result;
            }
            return JavaUAnnotation.Companion.wrap(psiAnnotations);
        }
        return owner.getAnnotations();
    }

    @Override
    @NotNull
    public PsiAnnotation[] getAllAnnotations(@NotNull PsiModifierListOwner owner, boolean inHierarchy) {
        Intrinsics.checkParameterIsNotNull((Object)owner, (String)"owner");
        if (owner instanceof UDeclaration) {
            return this.getAllAnnotations(((UDeclaration)owner).getPsi(), inHierarchy);
        }
        PsiAnnotation[] psiAnnotationArray = AnnotationUtil.getAllAnnotations((PsiModifierListOwner)owner, (boolean)inHierarchy, null, (boolean)false);
        Intrinsics.checkExpressionValueIsNotNull((Object)psiAnnotationArray, (String)"AnnotationUtil.getAllAnn\u2026inHierarchy, null, false)");
        return psiAnnotationArray;
    }

    @Override
    @Nullable
    public PsiAnnotation findAnnotationInHierarchy(@NotNull PsiModifierListOwner listOwner, String ... annotationNames) {
        Intrinsics.checkParameterIsNotNull((Object)listOwner, (String)"listOwner");
        Intrinsics.checkParameterIsNotNull((Object)annotationNames, (String)"annotationNames");
        if (listOwner instanceof UDeclaration) {
            return this.findAnnotationInHierarchy(((UDeclaration)listOwner).getPsi(), Arrays.copyOf(annotationNames, annotationNames.length));
        }
        return AnnotationUtil.findAnnotationInHierarchy((PsiModifierListOwner)listOwner, (Set)Sets.newHashSet((Object[])Arrays.copyOf(annotationNames, annotationNames.length)));
    }

    @Override
    @Nullable
    public PsiAnnotation findAnnotation(@Nullable PsiModifierListOwner listOwner, String ... annotationNames) {
        Intrinsics.checkParameterIsNotNull((Object)annotationNames, (String)"annotationNames");
        if (listOwner instanceof UDeclaration) {
            return this.findAnnotation(((UDeclaration)listOwner).getPsi(), Arrays.copyOf(annotationNames, annotationNames.length));
        }
        return AnnotationUtil.findAnnotation((PsiModifierListOwner)listOwner, (boolean)false, (String[])Arrays.copyOf(annotationNames, annotationNames.length));
    }

    @Override
    public boolean areSignaturesEqual(@NotNull PsiMethod method1, @NotNull PsiMethod method2) {
        Intrinsics.checkParameterIsNotNull((Object)method1, (String)"method1");
        Intrinsics.checkParameterIsNotNull((Object)method2, (String)"method2");
        return MethodSignatureUtil.areSignaturesEqual((PsiMethod)method1, (PsiMethod)method2);
    }

    @Override
    @Nullable
    public Project getProject(@NotNull PsiElement element) {
        Object v3;
        Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
        Object object = this.myLintProject;
        if (object == null || (object = ((Project)object).getClient()) == null || (object = ((LintClient)object).getKnownProjects()) == null) {
            return null;
        }
        Collection<Project> projects = object;
        if (projects.isEmpty()) {
            return null;
        }
        PsiFile psiFile = element.getContainingFile();
        if (psiFile == null || (psiFile = psiFile.getVirtualFile()) == null) {
            return null;
        }
        PsiFile virtualFile = psiFile;
        File file = VfsUtilCore.virtualToIoFile((VirtualFile)virtualFile);
        Intrinsics.checkExpressionValueIsNotNull((Object)file, (String)"VfsUtilCore.virtualToIoFile(virtualFile)");
        File file2 = file;
        String path2 = file2.getPath();
        Sequence $this$maxBy$iv = SequencesKt.filter((Sequence)CollectionsKt.asSequence((Iterable)projects), (Function1)((Function1)new Function1<Project, Boolean>(path2){
            final /* synthetic */ String $path;

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final boolean invoke(@NotNull Project it) {
                Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                File file = it.getDir();
                Intrinsics.checkExpressionValueIsNotNull((Object)file, (String)"it.dir");
                if (Intrinsics.areEqual((Object)this.$path, (Object)file.getPath())) return true;
                String string = this.$path;
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"path");
                StringBuilder stringBuilder = new StringBuilder();
                File file2 = it.getDir();
                Intrinsics.checkExpressionValueIsNotNull((Object)file2, (String)"it.dir");
                if (!StringsKt.startsWith$default((String)string, (String)stringBuilder.append(file2.getPath()).append(File.separator).toString(), (boolean)false, (int)2, null)) return false;
                return true;
            }
            {
                this.$path = string;
                super(1);
            }
        }));
        boolean $i$f$maxBy = false;
        Iterator iterator$iv = $this$maxBy$iv.iterator();
        if (!iterator$iv.hasNext()) {
            v3 = null;
        } else {
            Object maxElem$iv = iterator$iv.next();
            if (!iterator$iv.hasNext()) {
                v3 = maxElem$iv;
            } else {
                Project it = (Project)maxElem$iv;
                boolean bl = false;
                File file3 = it.getDir();
                Intrinsics.checkExpressionValueIsNotNull((Object)file3, (String)"it.dir");
                int maxValue$iv = file3.getPath().length();
                do {
                    Object e$iv = iterator$iv.next();
                    Project it2 = (Project)e$iv;
                    $i$a$-maxBy-DefaultJavaEvaluator$getProject$2 = false;
                    File file4 = it2.getDir();
                    Intrinsics.checkExpressionValueIsNotNull((Object)file4, (String)"it.dir");
                    int v$iv = file4.getPath().length();
                    if (maxValue$iv >= v$iv) continue;
                    maxElem$iv = e$iv;
                    maxValue$iv = v$iv;
                } while (iterator$iv.hasNext());
                v3 = maxElem$iv;
            }
        }
        return v3;
    }

    @Override
    @Nullable
    public String findJarPath(@NotNull PsiElement element) {
        Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
        PsiFile containingFile = element.getContainingFile();
        return this.findJarPath(containingFile);
    }

    @Override
    @Nullable
    public String findJarPath(@NotNull UElement element) {
        Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
        UFile uFile = UastUtils.getContainingUFile((UElement)element);
        return uFile != null ? this.findJarPath((PsiFile)uFile.getSourcePsi()) : null;
    }

    private final String findJarPath(PsiFile containingFile) {
        VirtualFile file;
        if (containingFile instanceof PsiCompiledFile && (file = ((PsiCompiledFile)containingFile).getVirtualFile()) != null) {
            VirtualFileSystem virtualFileSystem = file.getFileSystem();
            Intrinsics.checkExpressionValueIsNotNull((Object)virtualFileSystem, (String)"file.fileSystem");
            if (Intrinsics.areEqual((Object)virtualFileSystem.getProtocol(), (Object)"jar")) {
                String string = file.getPath();
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"file.path");
                String path2 = string;
                int separatorIndex = StringsKt.indexOf$default((CharSequence)path2, (String)"!/", (int)0, (boolean)false, (int)6, null);
                if (separatorIndex >= 0) {
                    String string2 = path2;
                    int n = 0;
                    boolean bl = false;
                    String string3 = string2;
                    if (string3 == null) {
                        throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
                    }
                    String string4 = string3.substring(n, separatorIndex);
                    Intrinsics.checkExpressionValueIsNotNull((Object)string4, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
                    return string4;
                }
            }
        }
        return null;
    }

    @Override
    @Nullable
    public PsiPackage getPackage(@NotNull PsiElement node) {
        PsiFile containingFile;
        PsiFile psiFile;
        Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
        PsiElement psiElement = node;
        if (!(psiElement instanceof PsiFile)) {
            psiElement = null;
        }
        if ((psiFile = (PsiFile)psiElement) == null) {
            psiFile = containingFile = node.getContainingFile();
        }
        if (containingFile != null) {
            if (containingFile instanceof PsiJavaFile) {
                return this.packageInfoCache.computeIfAbsent(((PsiJavaFile)containingFile).getPackageName(), new Function<String, PsiPackage>(this, node){
                    final /* synthetic */ DefaultJavaEvaluator this$0;
                    final /* synthetic */ PsiElement $node;

                    @NotNull
                    public final getPackage.1 apply(@NotNull String name) {
                        PsiClass cls;
                        Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
                        PsiClass psiClass = cls = this.this$0.findClass(name + '.' + "package-info");
                        PsiModifierList modifierList = psiClass != null ? psiClass.getModifierList() : null;
                        return new PsiPackageImpl(this, modifierList, name, this.$node.getManager(), name){
                            final /* synthetic */ getPackage.1 this$0;
                            final /* synthetic */ PsiModifierList $modifierList;
                            final /* synthetic */ String $name;

                            @Nullable
                            public PsiModifierList getAnnotationList() {
                                return this.$modifierList != null ? (PsiModifierList)new PsiCompositeModifierList(this.getManager(), CollectionsKt.listOf((Object)this.$modifierList)) : null;
                            }
                            {
                                this.this$0 = $outer;
                                this.$modifierList = $captured_local_variable$1;
                                this.$name = $captured_local_variable$2;
                                super($super_call_param$3, $super_call_param$4);
                            }
                        };
                    }
                    {
                        this.this$0 = defaultJavaEvaluator;
                        this.$node = psiElement;
                    }
                });
            }
            PsiDirectory dir = containingFile.getParent();
            if (dir != null) {
                return JavaDirectoryService.getInstance().getPackage(dir);
            }
        }
        return null;
    }

    @Override
    @Nullable
    public PsiPackage getPackage(@NotNull UElement node) {
        Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
        UFile uFile = UastUtils.getContainingUFile((UElement)node);
        return uFile != null ? this.getPackage((PsiElement)uFile.getPsi()) : null;
    }

    @Override
    @Nullable
    public String getQualifiedName(@NotNull PsiClassType psiClassType) {
        Intrinsics.checkParameterIsNotNull((Object)psiClassType, (String)"psiClassType");
        PsiType erased = this.erasure((PsiType)psiClassType);
        return erased instanceof PsiClassType ? super.getQualifiedName((PsiClassType)erased) : super.getQualifiedName(psiClassType);
    }

    @Override
    @Nullable
    public String getQualifiedName(@NotNull PsiClass psiClass) {
        Intrinsics.checkParameterIsNotNull((Object)psiClass, (String)"psiClass");
        return psiClass.getQualifiedName();
    }

    @Override
    @Nullable
    public String getInternalName(@NotNull PsiClassType psiClassType) {
        Intrinsics.checkParameterIsNotNull((Object)psiClassType, (String)"psiClassType");
        PsiType erased = this.erasure((PsiType)psiClassType);
        return erased instanceof PsiClassType ? super.getInternalName((PsiClassType)erased) : super.getInternalName(psiClassType);
    }

    @Override
    @Nullable
    public String getInternalName(@NotNull PsiClass psiClass) {
        Intrinsics.checkParameterIsNotNull((Object)psiClass, (String)"psiClass");
        return Lint.getInternalName(psiClass);
    }

    @Override
    @Nullable
    public PsiType erasure(@Nullable PsiType type) {
        return TypeConversionUtil.erasure((PsiType)type);
    }

    @Override
    @NotNull
    public Map<UExpression, PsiParameter> computeArgumentMapping(@NotNull UCallExpression call, @NotNull PsiMethod method) {
        Object parameter;
        UExpression argument;
        Intrinsics.checkParameterIsNotNull((Object)call, (String)"call");
        Intrinsics.checkParameterIsNotNull((Object)method, (String)"method");
        PsiParameterList psiParameterList = method.getParameterList();
        Intrinsics.checkExpressionValueIsNotNull((Object)psiParameterList, (String)"method.parameterList");
        PsiParameterList parameterList = psiParameterList;
        if (parameterList.getParametersCount() == 0) {
            return MapsKt.emptyMap();
        }
        Map<UExpression, PsiParameter> kotlinMap = Lint.computeKotlinArgumentMapping(call, method);
        if (kotlinMap != null) {
            return kotlinMap;
        }
        List arguments = call.getValueArguments();
        Object[] objectArray = parameterList.getParameters();
        Intrinsics.checkExpressionValueIsNotNull((Object)objectArray, (String)"parameterList.parameters");
        Object[] parameters = objectArray;
        int j = 0;
        Object object = (PsiParameter)ArraysKt.firstOrNull((Object[])parameters);
        if (object != null && (object = object.getName()) != null) {
            if (StringsKt.startsWith$default((String)object, (String)"$this", (boolean)false, (int)2, null)) {
                if (Lint.isKotlin(call.getSourcePsi())) {
                    ++j;
                }
            }
        }
        int i = 0;
        int n = Math.min(parameters.length, arguments.size());
        HashMap map = new HashMap(2 * n);
        while (j < n) {
            argument = (UExpression)arguments.get(i);
            parameter = parameters[j];
            Map map2 = map;
            Object object2 = parameter;
            Intrinsics.checkExpressionValueIsNotNull((Object)object2, (String)"parameter");
            map2.put(argument, object2);
            ++i;
            ++j;
        }
        if (i < arguments.size() && j > 0) {
            --j;
            while (i < arguments.size()) {
                argument = (UExpression)arguments.get(i);
                parameter = parameters[j];
                Map map3 = map;
                Object object3 = parameter;
                Intrinsics.checkExpressionValueIsNotNull((Object)object3, (String)"parameter");
                map3.put(argument, object3);
                ++i;
            }
        }
        return map;
    }

    public DefaultJavaEvaluator(@Nullable com.intellij.openapi.project.Project myProject, @Nullable Project myLintProject) {
        Map map;
        this.myProject = myProject;
        this.myLintProject = myLintProject;
        DefaultJavaEvaluator defaultJavaEvaluator = this;
        boolean bl = false;
        defaultJavaEvaluator.packageInfoCache = map = (Map)new LinkedHashMap();
    }
}

