/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.client.api;

import com.android.tools.lint.client.api.LintClient;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Maps;
import com.google.common.io.ByteStreams;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;

class ClassEntry
implements Comparable<ClassEntry> {
    public final File file;
    public final File jarFile;
    public final File binDir;
    public final byte[] bytes;

    @VisibleForTesting
    ClassEntry(File file, File jarFile, File binDir, byte[] bytes) {
        this.file = file;
        this.jarFile = jarFile;
        this.binDir = binDir;
        this.bytes = bytes;
    }

    public String path() {
        if (this.jarFile != null) {
            return this.jarFile.getPath() + ':' + this.file.getPath();
        }
        return this.file.getPath();
    }

    @Override
    public int compareTo(ClassEntry other) {
        int m2;
        String p1 = this.file.getPath();
        String p2 = other.file.getPath();
        int m1 = p1.length();
        if (m1 == (m2 = p2.length()) && p1.equals(p2)) {
            return 0;
        }
        int m = Math.min(m1, m2);
        for (int i = 0; i < m; ++i) {
            char c2;
            char c1 = p1.charAt(i);
            if (c1 == (c2 = p2.charAt(i))) continue;
            if (c1 == '.') {
                return -1;
            }
            if (c2 == '.') {
                return 1;
            }
            return c1 - c2;
        }
        return m == m1 ? -1 : 1;
    }

    public String toString() {
        return this.file.getPath();
    }

    public static List<ClassEntry> fromClassPath(LintClient client, List<File> classPath, boolean sort) {
        if (!classPath.isEmpty()) {
            ArrayList<ClassEntry> libraryEntries = new ArrayList<ClassEntry>(64);
            ClassEntry.addEntries(client, libraryEntries, classPath);
            if (sort) {
                Collections.sort(libraryEntries);
            }
            return libraryEntries;
        }
        return Collections.emptyList();
    }

    public static List<ClassEntry> fromClassFiles(LintClient client, List<File> classFiles, List<File> classFolders, boolean sort) {
        ArrayList<ClassEntry> entries = new ArrayList<ClassEntry>(classFiles.size());
        if (!classFolders.isEmpty()) {
            for (File file : classFiles) {
                String path2 = file.getPath();
                if (!file.isFile() || !path2.endsWith(".class")) continue;
                try {
                    byte[] bytes = client.readBytes(file);
                    for (File dir : classFolders) {
                        if (!path2.startsWith(dir.getPath())) continue;
                        entries.add(new ClassEntry(file, null, dir, bytes));
                    }
                }
                catch (IOException e) {
                    client.log(e, null, new Object[0]);
                }
            }
            if (sort && !entries.isEmpty()) {
                Collections.sort(entries);
            }
        }
        return entries;
    }

    private static void addEntries(LintClient client, List<ClassEntry> entries, List<File> classPath) {
        for (File classPathEntry : classPath) {
            String name = classPathEntry.getName();
            if (name.endsWith(".jar")) {
                File jarFile = classPathEntry;
                if (!jarFile.exists()) continue;
                try {
                    ZipFile jar = new ZipFile(jarFile);
                    Object object = null;
                    try {
                        Enumeration<? extends ZipEntry> enumeration = jar.entries();
                        while (enumeration.hasMoreElements()) {
                            ZipEntry entry = enumeration.nextElement();
                            if (!entry.getName().endsWith(".class")) continue;
                            try {
                                InputStream is = jar.getInputStream(entry);
                                Throwable throwable = null;
                                try {
                                    byte[] bytes = ByteStreams.toByteArray((InputStream)is);
                                    if (bytes == null) continue;
                                    File file = new File(entry.getName());
                                    entries.add(new ClassEntry(file, jarFile, jarFile, bytes));
                                }
                                catch (Throwable throwable2) {
                                    throwable = throwable2;
                                    throw throwable2;
                                }
                                finally {
                                    if (is == null) continue;
                                    if (throwable != null) {
                                        try {
                                            is.close();
                                        }
                                        catch (Throwable throwable3) {
                                            throwable.addSuppressed(throwable3);
                                        }
                                        continue;
                                    }
                                    is.close();
                                }
                            }
                            catch (Throwable e) {
                                client.log(e, null, new Object[0]);
                            }
                        }
                    }
                    catch (Throwable enumeration) {
                        object = enumeration;
                        throw enumeration;
                    }
                    finally {
                        if (jar == null) continue;
                        if (object != null) {
                            try {
                                jar.close();
                            }
                            catch (Throwable enumeration) {
                                ((Throwable)object).addSuppressed(enumeration);
                            }
                            continue;
                        }
                        jar.close();
                    }
                }
                catch (IOException e) {
                    client.log(e, "Could not read jar file contents from %1$s", jarFile);
                }
                continue;
            }
            if (classPathEntry.isDirectory()) {
                File binDir = classPathEntry;
                ArrayList<File> classFiles = new ArrayList<File>();
                ClassEntry.addClassFiles(binDir, classFiles);
                for (File file : classFiles) {
                    try {
                        byte[] bytes = client.readBytes(file);
                        entries.add(new ClassEntry(file, null, binDir, bytes));
                    }
                    catch (IOException e) {
                        client.log(e, null, new Object[0]);
                    }
                }
                continue;
            }
            if (name.endsWith(".srcjar")) continue;
            client.log(null, "Ignoring class path entry %1$s", classPathEntry);
        }
    }

    private static void addClassFiles(File dir, List<File> classFiles) {
        File[] files = dir.listFiles();
        if (files != null && files.length > 0) {
            for (File file : files) {
                if (file.isFile() && file.getName().endsWith(".class")) {
                    classFiles.add(file);
                    continue;
                }
                if (!file.isDirectory()) continue;
                ClassEntry.addClassFiles(file, classFiles);
            }
        }
    }

    public static Map<String, String> createSuperClassMap(LintClient client, List<ClassEntry> libraryEntries, List<ClassEntry> classEntries) {
        int size = libraryEntries.size() + classEntries.size();
        HashMap map = Maps.newHashMapWithExpectedSize((int)size);
        SuperclassVisitor visitor = new SuperclassVisitor(map);
        ClassEntry.addSuperClasses(client, visitor, libraryEntries);
        ClassEntry.addSuperClasses(client, visitor, classEntries);
        return map;
    }

    public static Map<String, String> createSuperClassMap(LintClient client, List<ClassEntry> entries) {
        HashMap map = Maps.newHashMapWithExpectedSize((int)entries.size());
        SuperclassVisitor visitor = new SuperclassVisitor(map);
        ClassEntry.addSuperClasses(client, visitor, entries);
        return map;
    }

    private static void addSuperClasses(LintClient client, SuperclassVisitor visitor, List<ClassEntry> entries) {
        for (ClassEntry entry : entries) {
            try {
                ClassReader reader = new ClassReader(entry.bytes);
                int flags = 7;
                reader.accept((ClassVisitor)visitor, flags);
            }
            catch (Throwable t) {
                client.log(null, "Error processing %1$s: broken class file? (%2$s)", entry.path(), t.getMessage());
            }
        }
    }

    private static class SuperclassVisitor
    extends ClassVisitor {
        private final Map<String, String> mMap;

        SuperclassVisitor(Map<String, String> map) {
            super(327680);
            this.mMap = map;
        }

        public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
            if (superName != null && !"java/lang/Object".equals(superName)) {
                this.mMap.put(name, superName);
            }
        }
    }
}

