/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.client.api;

import com.android.ide.common.blame.SourceFilePosition;
import com.android.manifmerger.Actions;
import com.android.manifmerger.DocumentModel;
import com.android.manifmerger.ManifestModel;
import com.android.manifmerger.XmlNode;
import com.android.tools.lint.client.api.LintClient;
import com.android.utils.Pair;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\u0018\u0000 \u001a2\u00020\u0001:\u0003\u0019\u001a\u001bB%\b\u0000\u0012\u0012\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0002\u0010\bJ\u0012\u0010\t\u001a\u0004\u0018\u00010\u00052\u0006\u0010\n\u001a\u00020\u000bH\u0002J0\u0010\f\u001a\u0010\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u000f\u0018\u00010\r2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\n\u001a\u00020\u000b2\b\u0010\u0012\u001a\u0004\u0018\u00010\u0013H\u0002J&\u0010\u0014\u001a\u0012\u0012\u0004\u0012\u00020\u000e\u0012\u0006\b\u0001\u0012\u00020\u000f\u0018\u00010\r2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0015\u001a\u00020\u0013J$\u0010\u0016\u001a\u0010\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u000f\u0018\u00010\r2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\n\u001a\u00020\u000bJ&\u0010\u0017\u001a\u0012\u0012\u0004\u0012\u00020\u000e\u0012\u0006\b\u0001\u0012\u00020\u000f\u0018\u00010\r2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0018\u001a\u00020\u000fR\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lcom/android/tools/lint/client/api/BlameFile;", "", "nodes", "", "", "Lcom/android/tools/lint/client/api/BlameFile$BlameNode;", "actions", "Lcom/android/manifmerger/Actions;", "(Ljava/util/Map;Lcom/android/manifmerger/Actions;)V", "findBlameNode", "element", "Lorg/w3c/dom/Element;", "findElementOrAttribute", "Lcom/android/utils/Pair;", "Ljava/io/File;", "Lorg/w3c/dom/Node;", "client", "Lcom/android/tools/lint/client/api/LintClient;", "attribute", "Lorg/w3c/dom/Attr;", "findSourceAttribute", "attr", "findSourceElement", "findSourceNode", "node", "BlameNode", "Companion", "XmlVisitor", "lint-api"})
public final class BlameFile {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Map<String, BlameNode> nodes;
    @Nullable
    private final Actions actions;
    @NotNull
    private static final BlameFile NONE;
    @NotNull
    private static final ManifestModel model;

    public BlameFile(@NotNull Map<String, BlameNode> nodes, @Nullable Actions actions) {
        Intrinsics.checkNotNullParameter(nodes, (String)"nodes");
        this.nodes = nodes;
        this.actions = actions;
    }

    private final BlameNode findBlameNode(Element element) {
        String key = BlameFile.Companion.getNodeKey(element);
        BlameNode blameNode = this.nodes.get(key);
        if (blameNode == null && this.actions != null) {
            XmlNode.NodeKey nodeKey = XmlNode.NodeKey.fromXml((Element)element, (DocumentModel)((DocumentModel)model));
            ImmutableList records = this.actions.getNodeRecords(nodeKey);
            for (Actions.NodeRecord record : records) {
                SourceFilePosition actionLocation;
                File sourceFile;
                Actions.ActionType actionType = record.getActionType();
                if (actionType != Actions.ActionType.ADDED && actionType != Actions.ActionType.MERGED) continue;
                if (blameNode == null) {
                    blameNode = new BlameNode(key);
                    Map<String, BlameNode> map = this.nodes;
                    boolean bl = false;
                    map.put(key, blameNode);
                }
                if ((sourceFile = (actionLocation = record.getActionLocation()).getFile().getSourceFile()) == null) continue;
                blameNode.setElementLocation(Intrinsics.stringPlus((String)" from ", (Object)sourceFile.getPath()));
            }
            for (XmlNode.NodeName nodeName : this.actions.getRecordedAttributeNames(nodeKey)) {
                for (Actions.AttributeRecord record : this.actions.getAttributeRecords(nodeKey, nodeName)) {
                    SourceFilePosition actionLocation;
                    File sourceFile;
                    Actions.ActionType actionType = record.getActionType();
                    if (actionType != Actions.ActionType.ADDED && actionType != Actions.ActionType.MERGED) continue;
                    if (blameNode == null) {
                        blameNode = new BlameNode(key);
                        Map<String, BlameNode> map = this.nodes;
                        boolean bl = false;
                        map.put(key, blameNode);
                    }
                    if ((sourceFile = (actionLocation = record.getActionLocation()).getFile().getSourceFile()) == null) continue;
                    String string = nodeName.getLocalName();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"nodeName.localName");
                    blameNode.setAttributeLocations(string, Intrinsics.stringPlus((String)" from ", (Object)sourceFile.getPath()));
                }
            }
        }
        return blameNode;
    }

    @Nullable
    public final Pair<File, ? extends Node> findSourceNode(@NotNull LintClient client, @NotNull Node node) {
        Intrinsics.checkNotNullParameter((Object)client, (String)"client");
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        Node node2 = node;
        return node2 instanceof Attr ? this.findSourceAttribute(client, (Attr)node) : (node2 instanceof Element ? this.findSourceElement(client, (Element)node) : null);
    }

    @Nullable
    public final Pair<File, Node> findSourceElement(@NotNull LintClient client, @NotNull Element element) {
        Intrinsics.checkNotNullParameter((Object)client, (String)"client");
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Pair<File, Node> source = this.findElementOrAttribute(client, element, null);
        return source != null && source.getSecond() instanceof Element ? source : null;
    }

    @Nullable
    public final Pair<File, ? extends Node> findSourceAttribute(@NotNull LintClient client, @NotNull Attr attr) {
        Intrinsics.checkNotNullParameter((Object)client, (String)"client");
        Intrinsics.checkNotNullParameter((Object)attr, (String)"attr");
        Element element = attr.getOwnerElement();
        Intrinsics.checkNotNullExpressionValue((Object)element, (String)"element");
        Pair<File, Node> source = this.findElementOrAttribute(client, element, attr);
        if (source != null && source.getSecond() instanceof Attr) {
            return source;
        }
        if (source != null && source.getSecond() instanceof Element) {
            Attr sourceAttribute;
            String localName;
            String namespace;
            Attr sourceAttribute2;
            Object object = source.getSecond();
            if (object == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.w3c.dom.Element");
            }
            Element sourceElement = (Element)object;
            Object object2 = attr.getPrefix() != null ? ((sourceAttribute2 = sourceElement.getAttributeNodeNS(namespace = attr.getNamespaceURI(), localName = attr.getLocalName())) != null ? Pair.of((Object)source.getFirst(), (Object)sourceAttribute2) : null) : ((sourceAttribute = sourceElement.getAttributeNode(attr.getName())) != null ? Pair.of((Object)source.getFirst(), (Object)sourceAttribute) : null);
            return object2;
        }
        return null;
    }

    private final Pair<File, Node> findElementOrAttribute(LintClient client, Element element, Attr attribute) {
        char c;
        BlameNode blameNode = this.findBlameNode(element);
        if (blameNode == null) {
            return null;
        }
        BlameNode blameNode2 = blameNode;
        String location = null;
        if (attribute != null) {
            String string = attribute.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"attribute.name");
            location = blameNode2.getAttributeLocation(string);
            if (location == null) {
                string = attribute.getLocalName();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"attribute.localName");
                location = blameNode2.getAttributeLocation(string);
            }
        }
        if (location == null) {
            location = blameNode2.getElementLocation();
        }
        if (location == null) {
            return null;
        }
        int index = StringsKt.indexOf$default((CharSequence)location, (String)" from ", (int)0, (boolean)false, (int)6, null);
        if (index == -1) {
            return null;
        }
        if (StringsKt.startsWith$default((String)location, (String)"[", (int)(index += " from ".length()), (boolean)false, (int)4, null)) {
            index = StringsKt.indexOf$default((CharSequence)location, (String)"] ", (int)0, (boolean)false, (int)6, null);
            if (index == -1) {
                return null;
            }
            index += 2;
        }
        int range = location.length();
        while (range > 0 && ((c = location.charAt(range - 1)) == ':' || c == '-' || Character.isDigit(c))) {
            int n = range;
            range = n + -1;
        }
        String string = location;
        boolean bl = false;
        String string2 = string.substring(index, range);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
        String path2 = string2;
        File manifest = new File(path2);
        if (!manifest.isFile()) {
            return null;
        }
        Document document = null;
        try {
            document = LintClient.getXmlDocument$default(client, manifest, null, 2, null);
            if (document == null) {
                return null;
            }
        }
        catch (Throwable ignore) {
            return null;
        }
        String targetKey = blameNode2.getKey();
        AtomicReference<Element> reference = new AtomicReference<Element>();
        XmlVisitor.Companion.accept(document, new XmlVisitor(targetKey, reference){
            final /* synthetic */ String $targetKey;
            final /* synthetic */ AtomicReference<Element> $reference;
            {
                this.$targetKey = $targetKey;
                this.$reference = $reference;
            }

            public boolean visitTag(@NotNull Element element, @NotNull String tag) {
                Intrinsics.checkNotNullParameter((Object)element, (String)"element");
                Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
                String key = com.android.tools.lint.client.api.BlameFile$Companion.access$getNodeKey(BlameFile.Companion, element);
                if (Intrinsics.areEqual((Object)this.$targetKey, (Object)key)) {
                    this.$reference.set(element);
                    return true;
                }
                return false;
            }
        });
        return Pair.of((Object)manifest, (Object)reference.get());
    }

    static {
        boolean bl = false;
        NONE = new BlameFile(new LinkedHashMap(), null);
        model = new ManifestModel();
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b&\u0018\u0000 \u000f2\u00020\u0001:\u0001\u000fB\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u0010\u0010\u0007\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\tH\u0016J\u0018\u0010\n\u001a\u00020\u00042\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016\u00a8\u0006\u0010"}, d2={"Lcom/android/tools/lint/client/api/BlameFile$XmlVisitor;", "", "()V", "visit", "", "node", "Lorg/w3c/dom/Node;", "visitAttribute", "attribute", "Lorg/w3c/dom/Attr;", "visitTag", "element", "Lorg/w3c/dom/Element;", "tag", "", "Companion", "lint-api"})
    public static abstract class XmlVisitor {
        @NotNull
        public static final Companion Companion = new Companion(null);

        public boolean visitTag(@NotNull Element element, @NotNull String tag) {
            Intrinsics.checkNotNullParameter((Object)element, (String)"element");
            Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
            return false;
        }

        public boolean visitAttribute(@NotNull Attr attribute) {
            Intrinsics.checkNotNullParameter((Object)attribute, (String)"attribute");
            return false;
        }

        private final boolean visit(Node node) {
            if (node.getNodeType() == 1) {
                Element tag = (Element)node;
                String string = tag.getLocalName();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"tag.localName");
                if (this.visitTag(tag, string)) {
                    return true;
                }
                NamedNodeMap attributes = tag.getAttributes();
                int i = 0;
                int n = attributes.getLength();
                while (i < n) {
                    Node attr = attributes.item(i);
                    if (attr == null) {
                        throw new NullPointerException("null cannot be cast to non-null type org.w3c.dom.Attr");
                    }
                    if (this.visitAttribute((Attr)attr)) {
                        return true;
                    }
                    int n2 = i;
                    i = n2 + 1;
                }
            }
            for (Node child = node.getFirstChild(); child != null; child = child.getNextSibling()) {
                if (!this.visit(child)) continue;
                return true;
            }
            return false;
        }

        @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b\u00a8\u0006\t"}, d2={"Lcom/android/tools/lint/client/api/BlameFile$XmlVisitor$Companion;", "", "()V", "accept", "", "node", "Lorg/w3c/dom/Node;", "visitor", "Lcom/android/tools/lint/client/api/BlameFile$XmlVisitor;", "lint-api"})
        public static final class Companion {
            private Companion() {
            }

            public final void accept(@NotNull Node node, @NotNull XmlVisitor visitor) {
                Intrinsics.checkNotNullParameter((Object)node, (String)"node");
                Intrinsics.checkNotNullParameter((Object)visitor, (String)"visitor");
                visitor.visit(node);
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\r\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u000e\u001a\u00020\u0003J\u0016\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u000e\u001a\u00020\u00032\u0006\u0010\u0011\u001a\u00020\u0003R\"\u0010\u0005\u001a\u0016\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\u0007\u0018\u00010\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001c\u0010\b\u001a\u0004\u0018\u00010\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\u0004R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\n\u00a8\u0006\u0012"}, d2={"Lcom/android/tools/lint/client/api/BlameFile$BlameNode;", "", "key", "", "(Ljava/lang/String;)V", "attributeLocations", "", "Lcom/android/utils/Pair;", "elementLocation", "getElementLocation", "()Ljava/lang/String;", "setElementLocation", "getKey", "getAttributeLocation", "name", "setAttributeLocations", "", "location", "lint-api"})
    public static final class BlameNode {
        @NotNull
        private final String key;
        @Nullable
        private String elementLocation;
        @Nullable
        private List<Pair<String, String>> attributeLocations;

        public BlameNode(@NotNull String key) {
            Intrinsics.checkNotNullParameter((Object)key, (String)"key");
            this.key = key;
        }

        @NotNull
        public final String getKey() {
            return this.key;
        }

        @Nullable
        public final String getElementLocation() {
            return this.elementLocation;
        }

        public final void setElementLocation(@Nullable String string) {
            this.elementLocation = string;
        }

        @Nullable
        public final String getAttributeLocation(@NotNull String name) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            if (this.attributeLocations != null) {
                List<Pair<String, String>> list2 = this.attributeLocations;
                Intrinsics.checkNotNull(list2);
                for (Pair<String, String> pair : list2) {
                    if (!Intrinsics.areEqual((Object)name, (Object)pair.getFirst())) continue;
                    return (String)pair.getSecond();
                }
            }
            return null;
        }

        public final void setAttributeLocations(@NotNull String name, @NotNull String location) {
            Object object;
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Intrinsics.checkNotNullParameter((Object)location, (String)"location");
            if (this.attributeLocations != null) {
                object = this.attributeLocations;
                Intrinsics.checkNotNull(object);
                Pair pair = object;
                object = this.attributeLocations;
                Intrinsics.checkNotNull(object);
                if (Intrinsics.areEqual((Object)name, (Object)((Pair)pair.get(object.size() - 1)).getFirst())) {
                    object = this.attributeLocations;
                    Intrinsics.checkNotNull((Object)object);
                    Object object2 = object;
                    object = this.attributeLocations;
                    Intrinsics.checkNotNull((Object)object);
                    object2.remove(object.size() - 1);
                }
            } else {
                this.attributeLocations = Lists.newArrayList();
            }
            object = this.attributeLocations;
            Intrinsics.checkNotNull(object);
            Pair pair = object;
            object = Pair.of((Object)name, (Object)location);
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"of(name, location)");
            pair.add(object);
        }
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0010\u0010\r\u001a\u00020\f2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u000e\u0010\u0010\u001a\u00020\u00042\u0006\u0010\u0011\u001a\u00020\u0012J\u000e\u0010\u0010\u001a\u00020\u00042\u0006\u0010\u0013\u001a\u00020\u0014J\u0014\u0010\u0010\u001a\u00020\u00042\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\f0\u0016R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lcom/android/tools/lint/client/api/BlameFile$Companion;", "", "()V", "NONE", "Lcom/android/tools/lint/client/api/BlameFile;", "getNONE", "()Lcom/android/tools/lint/client/api/BlameFile;", "model", "Lcom/android/manifmerger/ManifestModel;", "getIndent", "", "line", "", "getNodeKey", "element", "Lorg/w3c/dom/Element;", "parse", "mergerActions", "Lcom/android/manifmerger/Actions;", "file", "Ljava/io/File;", "lines", "", "lint-api"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final BlameFile getNONE() {
            return NONE;
        }

        private final String getNodeKey(Element element) {
            String string = XmlNode.NodeKey.fromXml((Element)element, (DocumentModel)((DocumentModel)model)).toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"fromXml(element, model).toString()");
            return string;
        }

        @NotNull
        public final BlameFile parse(@NotNull File file) throws IOException {
            Intrinsics.checkNotNullParameter((Object)file, (String)"file");
            List lines = FilesKt.readLines$default((File)file, null, (int)1, null);
            return this.parse(lines);
        }

        @NotNull
        public final BlameFile parse(@NotNull Actions mergerActions) {
            Intrinsics.checkNotNullParameter((Object)mergerActions, (String)"mergerActions");
            HashMap nodes = Maps.newHashMapWithExpectedSize((int)80);
            Intrinsics.checkNotNullExpressionValue((Object)nodes, (String)"nodes");
            return new BlameFile(nodes, mergerActions);
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final BlameFile parse(@NotNull List<String> lines) {
            Intrinsics.checkNotNullParameter(lines, (String)"lines");
            HashMap nodes = Maps.newHashMapWithExpectedSize((int)80);
            BlameNode last = null;
            String attributeName = null;
            for (String line : lines) {
                boolean match$iv$iv;
                char it;
                int index$iv$iv;
                boolean startFound$iv$iv;
                int endIndex$iv$iv;
                int startIndex$iv$iv;
                boolean $i$f$trim;
                CharSequence $this$trim$iv$iv;
                boolean bl;
                int indent;
                CharSequence charSequence = line;
                boolean bl2 = false;
                if (charSequence.length() == 0 || StringsKt.startsWith$default((String)line, (String)"INJECTED ", (int)(indent = this.getIndent(line)), (boolean)false, (int)4, null)) continue;
                if (StringsKt.startsWith$default((String)line, (String)"ADDED ", (int)indent, (boolean)false, (int)4, null) || StringsKt.startsWith$default((String)line, (String)"MERGED ", (int)indent, (boolean)false, (int)4, null)) {
                    BlameNode blameNode;
                    String string;
                    if (last == null) continue;
                    if (indent > 0) {
                        void $this$trim$iv;
                        bl2 = attributeName != null;
                        boolean bl3 = false;
                        boolean bl4 = false;
                        if (_Assertions.ENABLED && !bl2) {
                            bl = false;
                            String string2 = "Assertion failed";
                            throw (Throwable)((Object)new AssertionError((Object)string2));
                        }
                        Intrinsics.checkNotNull(attributeName);
                        String string3 = line;
                        string = attributeName;
                        blameNode = last;
                        boolean $i$f$trim2 = false;
                        $this$trim$iv$iv = (CharSequence)$this$trim$iv;
                        $i$f$trim = false;
                        startIndex$iv$iv = 0;
                        endIndex$iv$iv = $this$trim$iv$iv.length() - 1;
                        startFound$iv$iv = false;
                        while (startIndex$iv$iv <= endIndex$iv$iv) {
                            index$iv$iv = !startFound$iv$iv ? startIndex$iv$iv : endIndex$iv$iv;
                            it = $this$trim$iv$iv.charAt(index$iv$iv);
                            boolean bl5 = false;
                            boolean bl6 = match$iv$iv = Intrinsics.compare((int)it, (int)32) <= 0;
                            if (!startFound$iv$iv) {
                                if (!match$iv$iv) {
                                    startFound$iv$iv = true;
                                    continue;
                                }
                                ++startIndex$iv$iv;
                                continue;
                            }
                            if (!match$iv$iv) break;
                            --endIndex$iv$iv;
                        }
                        String string4 = ((Object)$this$trim$iv$iv.subSequence(startIndex$iv$iv, endIndex$iv$iv + 1)).toString();
                        blameNode.setAttributeLocations(string, string4);
                        continue;
                    }
                    if (last.getElementLocation() != null) continue;
                    String $this$trim$iv = line;
                    blameNode = last;
                    boolean $i$f$trim3 = false;
                    $this$trim$iv$iv = $this$trim$iv;
                    $i$f$trim = false;
                    startIndex$iv$iv = 0;
                    endIndex$iv$iv = $this$trim$iv$iv.length() - 1;
                    startFound$iv$iv = false;
                    while (startIndex$iv$iv <= endIndex$iv$iv) {
                        index$iv$iv = !startFound$iv$iv ? startIndex$iv$iv : endIndex$iv$iv;
                        it = $this$trim$iv$iv.charAt(index$iv$iv);
                        boolean bl7 = false;
                        boolean bl8 = match$iv$iv = Intrinsics.compare((int)it, (int)32) <= 0;
                        if (!startFound$iv$iv) {
                            if (!match$iv$iv) {
                                startFound$iv$iv = true;
                                continue;
                            }
                            ++startIndex$iv$iv;
                            continue;
                        }
                        if (!match$iv$iv) break;
                        --endIndex$iv$iv;
                    }
                    string = ((Object)$this$trim$iv$iv.subSequence(startIndex$iv$iv, endIndex$iv$iv + 1)).toString();
                    blameNode.setElementLocation(string);
                    continue;
                }
                if (StringsKt.startsWith$default((String)line, (String)"--", (boolean)false, (int)2, null)) continue;
                if (indent > 0) {
                    String $this$trim$iv = line;
                    boolean $i$f$trim4 = false;
                    $this$trim$iv$iv = $this$trim$iv;
                    $i$f$trim = false;
                    startIndex$iv$iv = 0;
                    endIndex$iv$iv = $this$trim$iv$iv.length() - 1;
                    startFound$iv$iv = false;
                    while (startIndex$iv$iv <= endIndex$iv$iv) {
                        index$iv$iv = !startFound$iv$iv ? startIndex$iv$iv : endIndex$iv$iv;
                        it = $this$trim$iv$iv.charAt(index$iv$iv);
                        boolean bl9 = false;
                        boolean bl10 = match$iv$iv = Intrinsics.compare((int)it, (int)32) <= 0;
                        if (!startFound$iv$iv) {
                            if (!match$iv$iv) {
                                startFound$iv$iv = true;
                                continue;
                            }
                            ++startIndex$iv$iv;
                            continue;
                        }
                        if (!match$iv$iv) break;
                        --endIndex$iv$iv;
                    }
                    attributeName = ((Object)$this$trim$iv$iv.subSequence(startIndex$iv$iv, endIndex$iv$iv + 1)).toString();
                    continue;
                }
                String $this$trim$iv = line;
                boolean $i$f$trim5 = false;
                CharSequence $this$trim$iv$iv2 = $this$trim$iv;
                boolean $i$f$trim6 = false;
                int startIndex$iv$iv2 = 0;
                int endIndex$iv$iv2 = $this$trim$iv$iv2.length() - 1;
                boolean startFound$iv$iv2 = false;
                while (startIndex$iv$iv2 <= endIndex$iv$iv2) {
                    boolean match$iv$iv2;
                    int index$iv$iv2 = !startFound$iv$iv2 ? startIndex$iv$iv2 : endIndex$iv$iv2;
                    char it2 = $this$trim$iv$iv2.charAt(index$iv$iv2);
                    boolean bl11 = false;
                    boolean bl12 = match$iv$iv2 = Intrinsics.compare((int)it2, (int)32) <= 0;
                    if (!startFound$iv$iv2) {
                        if (!match$iv$iv2) {
                            startFound$iv$iv2 = true;
                            continue;
                        }
                        ++startIndex$iv$iv2;
                        continue;
                    }
                    if (!match$iv$iv2) break;
                    --endIndex$iv$iv2;
                }
                String key = ((Object)$this$trim$iv$iv2.subSequence(startIndex$iv$iv2, endIndex$iv$iv2 + 1)).toString();
                BlameNode node = new BlameNode(key);
                Intrinsics.checkNotNullExpressionValue((Object)nodes, (String)"nodes");
                Map map = nodes;
                bl = false;
                map.put(key, node);
                attributeName = null;
                last = node;
            }
            Intrinsics.checkNotNullExpressionValue((Object)nodes, (String)"nodes");
            return new BlameFile(nodes, null);
        }

        private final int getIndent(String line) {
            int n = 0;
            int n2 = line.length() + -1;
            if (n <= n2) {
                do {
                    int i;
                    char c;
                    if ((c = line.charAt(i = n++)) == '\t') continue;
                    return i;
                } while (n <= n2);
            }
            return line.length();
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

