/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.detector.api;

import com.android.tools.lint.detector.api.ConstantEvaluator;
import com.android.tools.lint.detector.api.JavaContext;
import com.android.tools.lint.detector.api.UastLintUtils;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import org.jetbrains.uast.UCallExpression;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UExpression;
import org.jetbrains.uast.UMethod;
import org.jetbrains.uast.UReferenceExpression;
import org.jetbrains.uast.UVariable;
import org.jetbrains.uast.kotlin.KotlinUQualifiedReferenceExpression;
import org.jetbrains.uast.util.UastExpressionUtils;

public class TypeEvaluator {
    private final JavaContext context;

    public TypeEvaluator(JavaContext context2) {
        this.context = context2;
    }

    public PsiType evaluate(PsiElement node) {
        if (node == null) {
            return null;
        }
        PsiElement resolved = null;
        if (node instanceof PsiReference) {
            resolved = ((PsiReference)node).resolve();
        }
        if (resolved instanceof PsiMethod) {
            PsiMethod method = (PsiMethod)resolved;
            if (method.isConstructor()) {
                PsiClass containingClass = method.getContainingClass();
                if (containingClass != null && this.context != null) {
                    return this.context.getEvaluator().getClassType(containingClass);
                }
            } else {
                return method.getReturnType();
            }
        }
        if (resolved instanceof PsiField) {
            PsiType type;
            PsiField field = (PsiField)resolved;
            if (field.getInitializer() != null && (type = this.evaluate((PsiElement)field.getInitializer())) != null) {
                return type;
            }
            return field.getType();
        }
        if (resolved instanceof PsiLocalVariable) {
            PsiLocalVariable variable = (PsiLocalVariable)resolved;
            PsiExpression last = ConstantEvaluator.findLastAssignment(node, (PsiVariable)variable);
            if (last != null) {
                return this.evaluate((PsiElement)last);
            }
            return variable.getType();
        }
        if (node instanceof PsiExpression) {
            PsiExpression expression = (PsiExpression)node;
            return expression.getType();
        }
        return null;
    }

    public static PsiType evaluate(UElement node) {
        if (node == null) {
            return null;
        }
        UElement resolved = node;
        if (resolved instanceof UReferenceExpression && !(resolved instanceof KotlinUQualifiedReferenceExpression)) {
            resolved = UastLintUtils.tryResolveUDeclaration(resolved);
        }
        if (resolved instanceof UMethod) {
            return ((UMethod)resolved).getPsi().getReturnType();
        }
        if (resolved instanceof UVariable) {
            UVariable variable = (UVariable)resolved;
            UExpression lastAssignment = UastLintUtils.findLastAssignment((PsiVariable)variable, node);
            if (lastAssignment != null) {
                return TypeEvaluator.evaluate((UElement)lastAssignment);
            }
            return variable.getType();
        }
        if (resolved instanceof UCallExpression) {
            if (UastExpressionUtils.isMethodCall((UElement)resolved)) {
                PsiMethod resolvedMethod = ((UCallExpression)resolved).resolve();
                return resolvedMethod != null ? resolvedMethod.getReturnType() : null;
            }
            return ((UCallExpression)resolved).getExpressionType();
        }
        if (resolved instanceof UExpression) {
            return ((UExpression)resolved).getExpressionType();
        }
        return null;
    }

    public static PsiType evaluate(JavaContext context2, PsiElement node) {
        return new TypeEvaluator(context2).evaluate(node);
    }
}

