/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.client.api;

import com.android.SdkConstants;
import com.android.tools.lint.client.api.CompositeIssueRegistry;
import com.android.tools.lint.client.api.IssueRegistry;
import com.android.tools.lint.client.api.JarFileIssueRegistry;
import com.android.tools.lint.client.api.LintClient;
import com.android.tools.lint.client.api.LintDriver;
import com.android.tools.lint.client.api.LintJarVerifier;
import com.android.tools.lint.client.api.Vendor;
import com.android.tools.lint.detector.api.ApiKt;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.Project;
import com.android.tools.lint.detector.api.Severity;
import com.android.utils.SdkUtils;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.ref.SoftReference;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.io.TextStreamsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\t\n\u0002\b\u0005\u0018\u0000 \u001d2\u00020\u0001:\u0001\u001dB'\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0001\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\b\u0010\u001c\u001a\u00020\u000fH\u0014R\u0014\u0010\n\u001a\u00020\u000bX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0014\u0010\u000e\u001a\u00020\u000f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u0010R\u001a\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u0012X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u000e\u0010\u0018\u001a\u00020\u0019X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\u00020\bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001b\u00a8\u0006\u001e"}, d2={"Lcom/android/tools/lint/client/api/JarFileIssueRegistry;", "Lcom/android/tools/lint/client/api/IssueRegistry;", "client", "Lcom/android/tools/lint/client/api/LintClient;", "jarFile", "Ljava/io/File;", "registry", "vendor", "Lcom/android/tools/lint/client/api/Vendor;", "(Lcom/android/tools/lint/client/api/LintClient;Ljava/io/File;Lcom/android/tools/lint/client/api/IssueRegistry;Lcom/android/tools/lint/client/api/Vendor;)V", "api", "", "getApi", "()I", "isUpToDate", "", "()Z", "issues", "", "Lcom/android/tools/lint/detector/api/Issue;", "getIssues", "()Ljava/util/List;", "getJarFile", "()Ljava/io/File;", "timestamp", "", "getVendor", "()Lcom/android/tools/lint/client/api/Vendor;", "cacheable", "Factory", "lint-api"})
public final class JarFileIssueRegistry
extends IssueRegistry {
    @NotNull
    public static final Factory Factory = new Factory(null);
    @NotNull
    private final File jarFile;
    @NotNull
    private final Vendor vendor;
    @NotNull
    private final List<Issue> issues;
    private long timestamp;
    private final int api;
    private static final Pattern ARTIFACT_PATTERN = Pattern.compile(".*[/\\\\].gradle[/\\\\]caches[/\\\\]transforms-[0-9]+[/\\\\][0-9a-f]+[/\\\\]transformed[/\\\\](.+)[/\\\\]jars[/\\\\]lint\\.jar$");
    @NotNull
    private static final String SERVICE_KEY = "META-INF/services/com.android.tools.lint.client.api.IssueRegistry";
    @NotNull
    private static final String MF_LINT_REGISTRY = "Lint-Registry-v2";
    @NotNull
    private static final String MF_LINT_REGISTRY_OLD = "Lint-Registry";
    @Nullable
    private static Map<File, SoftReference<JarFileIssueRegistry>> cache;

    private JarFileIssueRegistry(LintClient client, File jarFile, IssueRegistry registry, Vendor vendor) {
        this.jarFile = jarFile;
        this.vendor = vendor;
        this.issues = CollectionsKt.toList((Iterable)registry.getIssues());
        this.timestamp = this.jarFile.lastModified();
        ClassLoader loader = registry.getClass().getClassLoader();
        if (loader instanceof URLClassLoader) {
            JarFileIssueRegistry.Factory.loadAndCloseURLClassLoader(client, this.jarFile, (URLClassLoader)loader);
        }
        this.api = 11;
    }

    @NotNull
    public final File getJarFile() {
        return this.jarFile;
    }

    @Override
    @NotNull
    public Vendor getVendor() {
        return this.vendor;
    }

    @Override
    protected boolean cacheable() {
        return LintClient.Companion.isStudio();
    }

    @Override
    @NotNull
    public List<Issue> getIssues() {
        return this.issues;
    }

    @Override
    public boolean isUpToDate() {
        return this.timestamp == this.jarFile.lastModified();
    }

    @Override
    public int getApi() {
        return this.api;
    }

    public /* synthetic */ JarFileIssueRegistry(LintClient client, File jarFile, IssueRegistry registry, Vendor vendor, DefaultConstructorMarker $constructor_marker) {
        this(client, jarFile, registry, vendor);
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000\u0086\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010$\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\u000f\u001a\u00020\u0010J*\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\f0\u00122\u0006\u0010\u0013\u001a\u00020\u00142\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\f0\u0016H\u0002J6\u0010\u0017\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0018\u001a\u00020\u00072\u0006\u0010\u0019\u001a\u00020\f2\b\u0010\u001a\u001a\u0004\u0018\u00010\u001b2\b\u0010\u001c\u001a\u0004\u0018\u00010\u001dH\u0002J:\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u000e0\u001e2\u0006\u0010\u0013\u001a\u00020\u00142\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\f0\u00162\n\b\u0002\u0010\u001a\u001a\u0004\u0018\u00010\u001b2\n\b\u0002\u0010\u001c\u001a\u0004\u0018\u00010\u001dJ\u0018\u0010\u001f\u001a\u00020\u00072\u0006\u0010 \u001a\u00020\u00072\u0006\u0010!\u001a\u00020\"H\u0002J \u0010#\u001a\u00020$2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010%\u001a\u00020&2\u0006\u0010\u0019\u001a\u00020\fH\u0002J\u001f\u0010'\u001a\u00020&2\u0012\u0010(\u001a\n\u0012\u0006\b\u0001\u0012\u00020&0)\"\u00020&\u00a2\u0006\u0002\u0010*J \u0010+\u001a\u00020\u00102\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010,\u001a\u00020\f2\u0006\u0010-\u001a\u00020.H\u0002J6\u0010/\u001a\u0004\u0018\u00010&2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0019\u001a\u00020\f2\u0006\u0010 \u001a\u00020\u00072\b\u0010\u001a\u001a\u0004\u0018\u00010\u001b2\b\u0010\u001c\u001a\u0004\u0018\u00010\u001dH\u0002J\b\u00100\u001a\u000201H\u0002J\u0012\u00102\u001a\u0002012\b\u0010\u001c\u001a\u0004\u0018\u00010\u001dH\u0002J\u0018\u00103\u001a\u00020\"2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0019\u001a\u00020\fH\u0002R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\"\u0010\n\u001a\u0016\u0012\u0004\u0012\u00020\f\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000e0\r\u0018\u00010\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u00064"}, d2={"Lcom/android/tools/lint/client/api/JarFileIssueRegistry$Factory;", "", "()V", "ARTIFACT_PATTERN", "Ljava/util/regex/Pattern;", "kotlin.jvm.PlatformType", "MF_LINT_REGISTRY", "", "MF_LINT_REGISTRY_OLD", "SERVICE_KEY", "cache", "", "Ljava/io/File;", "Ljava/lang/ref/SoftReference;", "Lcom/android/tools/lint/client/api/JarFileIssueRegistry;", "clearCache", "", "findRegistries", "", "client", "Lcom/android/tools/lint/client/api/LintClient;", "jarFiles", "", "get", "registryClassName", "jarFile", "currentProject", "Lcom/android/tools/lint/detector/api/Project;", "driver", "Lcom/android/tools/lint/client/api/LintDriver;", "", "getPackagingConflictMessage", "className", "verifier", "Lcom/android/tools/lint/client/api/LintJarVerifier;", "getVendor", "Lcom/android/tools/lint/client/api/Vendor;", "registry", "Lcom/android/tools/lint/client/api/IssueRegistry;", "join", "registries", "", "([Lcom/android/tools/lint/client/api/IssueRegistry;)Lcom/android/tools/lint/client/api/IssueRegistry;", "loadAndCloseURLClassLoader", "file", "loader", "Ljava/net/URLClassLoader;", "loadIssueRegistry", "logJarProblems", "", "reportErrors", "verify", "lint-api"})
    public static final class Factory {
        private Factory() {
        }

        @NotNull
        public final List<JarFileIssueRegistry> get(@NotNull LintClient client, @NotNull Collection<? extends File> jarFiles, @Nullable Project currentProject, @Nullable LintDriver driver) {
            Map<String, File> map;
            Intrinsics.checkNotNullParameter((Object)client, (String)"client");
            Intrinsics.checkNotNullParameter(jarFiles, (String)"jarFiles");
            try {
                map = this.findRegistries(client, jarFiles);
            }
            catch (IOException e) {
                if (this.logJarProblems()) {
                    client.log(e, Intrinsics.stringPlus((String)"Could not load custom lint check jar files: ", (Object)e.getMessage()), new Object[0]);
                }
                return CollectionsKt.emptyList();
            }
            Map<String, File> registryMap = map;
            if (registryMap.isEmpty()) {
                return CollectionsKt.emptyList();
            }
            int capacity = jarFiles.size() + 1;
            ArrayList<JarFileIssueRegistry> registries = new ArrayList<JarFileIssueRegistry>(capacity);
            Object object = registryMap;
            boolean bl = false;
            Iterator<Map.Entry<String, File>> iterator = object.entrySet().iterator();
            while (iterator.hasNext()) {
                Object object2 = object = iterator.next();
                boolean bl2 = false;
                String registryClass = (String)object2.getKey();
                Object object3 = object;
                boolean bl3 = false;
                File jarFile = (File)object3.getValue();
                try {
                    JarFileIssueRegistry jarFileIssueRegistry = this.get(client, registryClass, jarFile, currentProject, driver);
                    if (jarFileIssueRegistry == null) continue;
                    JarFileIssueRegistry registry = jarFileIssueRegistry;
                    registries.add(registry);
                }
                catch (Throwable e) {
                    if (!this.logJarProblems()) continue;
                    Object[] objectArray = new Object[]{jarFile};
                    client.log(e, "Could not load custom lint check jar file %1$s", objectArray);
                }
            }
            return registries;
        }

        public static /* synthetic */ List get$default(Factory factory, LintClient lintClient, Collection collection, Project project, LintDriver lintDriver, int n, Object object) {
            if ((n & 4) != 0) {
                project = null;
            }
            if ((n & 8) != 0) {
                lintDriver = null;
            }
            return factory.get(lintClient, collection, project, lintDriver);
        }

        private final JarFileIssueRegistry get(LintClient client, String registryClassName, File jarFile, Project currentProject, LintDriver driver) {
            JarFileIssueRegistry jarFileIssueRegistry;
            if (cache == null) {
                cache = new HashMap();
            } else {
                JarFileIssueRegistry registry;
                Map map = cache;
                Intrinsics.checkNotNull((Object)map);
                SoftReference reference = (SoftReference)map.get(jarFile);
                if (reference != null && (registry = (JarFileIssueRegistry)reference.get()) != null && registry.isUpToDate()) {
                    return registry;
                }
            }
            IssueRegistry.Companion.reset();
            IssueRegistry userRegistry = this.loadIssueRegistry(client, jarFile, registryClassName, currentProject, driver);
            if (userRegistry != null) {
                Vendor vendor = this.getVendor(client, userRegistry, jarFile);
                JarFileIssueRegistry jarIssueRegistry = new JarFileIssueRegistry(client, jarFile, userRegistry, vendor, null);
                for (Issue issue : userRegistry.getIssues()) {
                    issue.setRegistry(jarIssueRegistry);
                    if (issue.getDefaultSeverity() != Severity.IGNORE) continue;
                    client.log(Severity.ERROR, null, "Issue " + issue.getId() + " has defaultSeverity=IGNORE; that's not valid. Use enabledByDefault=false instead.", new Object[0]);
                }
                Map map = cache;
                Intrinsics.checkNotNull((Object)map);
                SoftReference<JarFileIssueRegistry> softReference = new SoftReference<JarFileIssueRegistry>(jarIssueRegistry);
                boolean bl = false;
                map.put(jarFile, softReference);
                jarFileIssueRegistry = jarIssueRegistry;
            } else {
                jarFileIssueRegistry = null;
            }
            return jarFileIssueRegistry;
        }

        public final void clearCache() {
            Map map = cache;
            if (map != null) {
                map.clear();
            }
        }

        @NotNull
        public final IssueRegistry join(IssueRegistry ... registries) {
            Intrinsics.checkNotNullParameter((Object)registries, (String)"registries");
            return registries.length == 1 ? registries[0] : (IssueRegistry)new CompositeIssueRegistry(ArraysKt.toList((Object[])registries));
        }

        private final LintJarVerifier verify(LintClient client, File jarFile) {
            LintJarVerifier verifier = new LintJarVerifier(jarFile);
            Throwable throwable = verifier.getVerificationThrowable();
            if (throwable != null) {
                Throwable throwable2 = throwable;
                boolean bl = false;
                boolean bl2 = false;
                Throwable it = throwable2;
                boolean bl3 = false;
                if (Factory.logJarProblems()) {
                    client.log(it, Intrinsics.stringPlus((String)"Error verifying bytecode in ", (Object)jarFile), new Object[0]);
                }
            }
            return verifier;
        }

        private final boolean reportErrors(LintDriver driver) {
            LintDriver lintDriver = driver;
            return (lintDriver == null ? null : lintDriver.getMode()) != LintDriver.DriverMode.ANALYSIS_ONLY;
        }

        /*
         * WARNING - void declaration
         */
        private final IssueRegistry loadIssueRegistry(LintClient client, File jarFile, String className, Project currentProject, LintDriver driver) {
            IssueRegistry issueRegistry;
            URL url = SdkUtils.fileToUrl((File)jarFile);
            try {
                IssueRegistry registry;
                block31: {
                    List<Issue> list2;
                    Object object = new URL[1];
                    Intrinsics.checkNotNullExpressionValue((Object)url, (String)"url");
                    object[0] = url;
                    URL[] uRLArray = object;
                    object = JarFileIssueRegistry.class.getClassLoader();
                    Intrinsics.checkNotNullExpressionValue((Object)object, (String)"JarFileIssueRegistry::class.java.classLoader");
                    ClassLoader loader = client.createUrlClassLoader(uRLArray, (ClassLoader)object);
                    Class<?> registryClass = Class.forName(className, true, loader);
                    Object obj = registryClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                    if (obj == null) {
                        throw new NullPointerException("null cannot be cast to non-null type com.android.tools.lint.client.api.IssueRegistry");
                    }
                    registry = (IssueRegistry)obj;
                    try {
                        list2 = registry.getIssues();
                    }
                    catch (Throwable e) {
                        if (this.reportErrors(driver)) {
                            StringBuilder stacktrace = new StringBuilder();
                            LintDriver.Companion.appendStackTraceSummary$default(LintDriver.Companion, e, stacktrace, 0, 0, 12, null);
                            String message2 = "Lint found one or more custom checks that could not be loaded. The most likely reason for this is that it is using an older, incompatible or unsupported API in lint. Make sure these lint checks are updated to the new APIs. The issue registry class is " + className + ". The class loading issue is " + e.getMessage() + ": " + stacktrace;
                            LintClient.Companion.report$default(LintClient.Companion, client, IssueRegistry.OBSOLETE_LINT_CHECK, message2, jarFile, null, null, null, null, null, currentProject, null, driver, null, 5616, null);
                        }
                        return null;
                    }
                    List<Issue> issues = list2;
                    try {
                        if (registry.getMaxApi() < 11) {
                            return null;
                        }
                        Method apiField = registryClass.getDeclaredMethod("getApi", new Class[0]);
                        Object stacktrace = apiField.invoke((Object)registry, new Object[0]);
                        if (stacktrace == null) {
                            throw new NullPointerException("null cannot be cast to non-null type kotlin.Int");
                        }
                        int api = (Integer)stacktrace;
                        if (api < 11) {
                            LintJarVerifier verifier = this.verify(client, jarFile);
                            if (!verifier.isCompatible()) {
                                if (this.reportErrors(driver)) {
                                    String string = "\nLibrary lint checks out of date.\n\nLint found an issue registry (`" + className + "`)\nwhich was compiled against an older version of lint\nthan this one.\n\nThis often works just fine, but some basic verification\nshows that the lint check jar references (for example)\nthe following API which is no longer valid in this\nversion of lint:\n" + verifier.describeFirstIncompatibleReference() + "\n(Referenced from " + verifier.getReferenceClassFile() + ")\n\nRecompile the checks against the latest version, or if\nthis is a check bundled with a third-party library, see\nif there is a more recent version available.\n\nVersion of Lint API this lint check is using is " + api + ".\nThe Lint API version currently running is 11 (" + ApiKt.describeApi(11) + ").\n";
                                    boolean bl = false;
                                    String string2 = string;
                                    if (string2 == null) {
                                        throw new NullPointerException("null cannot be cast to non-null type kotlin.CharSequence");
                                    }
                                    String message3 = ((Object)StringsKt.trim((CharSequence)string2)).toString();
                                    LintClient.Companion.report$default(LintClient.Companion, client, IssueRegistry.OBSOLETE_LINT_CHECK, message3, jarFile, null, null, null, null, null, currentProject, null, driver, null, 5616, null);
                                }
                                return null;
                            }
                            if (verifier.hasPackageConflict()) {
                                if (this.reportErrors(driver)) {
                                    String message4 = this.getPackagingConflictMessage(className, verifier);
                                    LintClient.Companion.report$default(LintClient.Companion, client, IssueRegistry.OBSOLETE_LINT_CHECK, message4, jarFile, null, null, null, null, null, currentProject, null, driver, null, 5616, null);
                                }
                                return null;
                            }
                            break block31;
                        }
                        try {
                            int minApi = registry.getMinApi();
                            if (minApi > 11) {
                                if (this.reportErrors(driver)) {
                                    String message5 = "Lint found an issue registry (`" + className + "`) which requires a newer API level. That means that the custom lint checks are intended for a newer lint version; please upgrade.";
                                    LintClient.Companion.report$default(LintClient.Companion, client, IssueRegistry.OBSOLETE_LINT_CHECK, message5, jarFile, null, null, null, null, null, currentProject, null, driver, null, 5616, null);
                                }
                                return null;
                            }
                            if (api >= 11) {
                                LintJarVerifier verifier = this.verify(client, jarFile);
                                if (!verifier.isCompatible()) {
                                    if (this.reportErrors(driver)) {
                                        String string = "\nRequires newer lint.\n\nLint found an issue registry (`" + className + "`)\nwhich was compiled against a newer version of lint\nthan this one.\n\nThis often works just fine, but some basic verification\nshows that the lint check jar references (for example)\nthe following API which is not valid in the version of\nlint which is running:\n" + verifier.describeFirstIncompatibleReference() + "\n(Referenced from " + verifier.getReferenceClassFile() + ")\n\nTo use this lint check, upgrade to a more recent version\nof lint.\n\nVersion of Lint API this lint check is using is " + api + ".\nThe Lint API version currently running is 11 (" + ApiKt.describeApi(11) + ").\n";
                                        boolean bl = false;
                                        String string3 = string;
                                        if (string3 == null) {
                                            throw new NullPointerException("null cannot be cast to non-null type kotlin.CharSequence");
                                        }
                                        String message6 = ((Object)StringsKt.trim((CharSequence)string3)).toString();
                                        LintClient.Companion.report$default(LintClient.Companion, client, IssueRegistry.OBSOLETE_LINT_CHECK, message6, jarFile, null, null, null, null, null, currentProject, null, driver, null, 5616, null);
                                    }
                                    return null;
                                }
                                if (verifier.hasPackageConflict()) {
                                    if (this.reportErrors(driver)) {
                                        String message7 = this.getPackagingConflictMessage(className, verifier);
                                        LintClient.Companion.report$default(LintClient.Companion, client, IssueRegistry.OBSOLETE_LINT_CHECK, message7, jarFile, null, null, null, null, null, currentProject, null, driver, null, 5616, null);
                                    }
                                    return null;
                                }
                            }
                        }
                        catch (Throwable e) {
                            if (this.logJarProblems()) {
                                client.log(e, null, new Object[0]);
                            }
                        }
                    }
                    catch (Throwable e) {
                        void $this$mapTo$iv$iv;
                        if (StringsKt.startsWith$default((String)className, (String)"androidx.", (boolean)false, (int)2, null) || StringsKt.startsWith$default((String)className, (String)"android.", (boolean)false, (int)2, null)) {
                            return registry;
                        }
                        if (!this.reportErrors(driver)) break block31;
                        String message8 = "Lint found an issue registry (`" + className + "`)\nwhich did not specify the Lint API version it was compiled with.\n\n**This means that the lint checks are likely not compatible.**\n\nIf you are the author of this lint check, make your lint\n`IssueRegistry` class contain\n\u00a0\u00a0override val api: Int = com.android.tools.lint.detector.api.CURRENT_API\nor from Java,\n\u00a0\u00a0@Override public int getApi() { return com.android.tools.lint.detector.api.ApiKt.CURRENT_API; }";
                        Iterable $this$map$iv = issues;
                        boolean $i$f$map = false;
                        Iterable iterable = $this$map$iv;
                        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                        boolean $i$f$mapTo = false;
                        for (Object item$iv$iv : $this$mapTo$iv$iv) {
                            void it;
                            Issue issue = (Issue)item$iv$iv;
                            Collection collection = destination$iv$iv;
                            boolean bl = false;
                            String string = it.getId();
                            collection.add(string);
                        }
                        List issueIds = CollectionsKt.sorted((Iterable)((List)destination$iv$iv));
                        if (CollectionsKt.any((Iterable)issueIds)) {
                            message8 = Intrinsics.stringPlus((String)message8, (Object)StringsKt.replace$default((String)("\n\nIf you are just using lint checks from a third party library\nyou have no control over, you can disable these lint checks (if\nthey misbehave) like this:\n\n    android {\n        lintOptions {\n            disable " + CollectionsKt.joinToString$default((Iterable)issueIds, (CharSequence)",\n                    ", null, null, (int)0, null, (Function1)loadIssueRegistry.1.INSTANCE, (int)30, null) + "\n        }\n    }\n"), (String)"    ", (String)"\u00a0\u00a0\u00a0\u00a0", (boolean)false, (int)4, null));
                        }
                        LintClient.Companion.report$default(LintClient.Companion, client, IssueRegistry.OBSOLETE_LINT_CHECK, message8, jarFile, null, null, null, null, null, currentProject, null, driver, null, 5616, null);
                    }
                }
                issueRegistry = registry;
            }
            catch (Throwable e) {
                if (this.logJarProblems()) {
                    Object[] objectArray = new Object[]{jarFile};
                    client.log(e, "Could not load custom lint check jar file %1$s", objectArray);
                }
                issueRegistry = null;
            }
            return issueRegistry;
        }

        private final String getPackagingConflictMessage(String className, LintJarVerifier verifier) {
            String string = "\nLint found an issue registry (`" + className + "`)\nwhich contains code in some of lint's reserved packages.\n\nThis is usually because the lint jar has accidentally\npacked in libraries that are part of lint's API surface,\nsuch as the Kotlin standard library (`kotlin.*`), or\nsome of the Android tooling libraries (`com.android.*`)\nincluding lint's own API jars, or some of the third party\nlibraries that lint depends on, such as UAST.\nIf you need these and cannot rely on the ones provided\nin lint's runtime environment, consider `jarjar`ing your\nown versions.\n\nA second reason is one where you've accidentally placed\nyour own detector code into one of these package\nnamespaces, since they are pretty broad (`com.android.*`).\nFor Android specifically, you can place them under\n`com.android.internal.*` which is explicitly allowed.\n\nThe first bundled package that is part of lint's API\nsurface namespace is:\n" + verifier.describeFirstPackagedDependency() + '\n';
            boolean bl = false;
            String string2 = string;
            if (string2 == null) {
                throw new NullPointerException("null cannot be cast to non-null type kotlin.CharSequence");
            }
            return ((Object)StringsKt.trim((CharSequence)string2)).toString();
        }

        private final Vendor getVendor(LintClient client, IssueRegistry registry, File jarFile) {
            Vendor vendor;
            Vendor vendor2 = registry.getVendor();
            if (vendor2 == null) {
                Vendor inferredVendor;
                Vendor vendor3;
                Object object;
                String string;
                Factory factory = this;
                boolean bl = false;
                boolean bl2 = false;
                Factory $this$getVendor_u24lambda_u2d2 = factory;
                boolean bl3 = false;
                String registryClass = registry.getClass().getName();
                Matcher matcher = ARTIFACT_PATTERN.matcher(jarFile.getPath());
                if (matcher.matches()) {
                    string = matcher.group(1);
                } else {
                    Intrinsics.checkNotNullExpressionValue((Object)registryClass, (String)"registryClass");
                    String string2 = StringsKt.removeSuffix((String)StringsKt.removeSuffix((String)StringsKt.removeSuffix((String)StringsKt.removeSuffix((String)registryClass, (CharSequence)"IssueRegistry"), (CharSequence)"Registry"), (CharSequence)".My"), (CharSequence)".");
                    object = Locale.US;
                    Intrinsics.checkNotNullExpressionValue((Object)object, (String)"US");
                    boolean bl4 = false;
                    String string3 = string2;
                    boolean bl5 = false;
                    String string4 = string3;
                    if (string4 == null) {
                        throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
                    }
                    String string5 = string4.toLowerCase((Locale)object);
                    string = string5;
                    Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"(this as java.lang.String).toLowerCase(locale)");
                }
                String identifier = string;
                Intrinsics.checkNotNullExpressionValue((Object)registryClass, (String)"registryClass");
                if (StringsKt.startsWith$default((String)registryClass, (String)"androidx.", (boolean)false, (int)2, null) || StringsKt.startsWith$default((String)registryClass, (String)"android.", (boolean)false, (int)2, null)) {
                    object = "Android Open Source Project (" + identifier + ')';
                    vendor3 = new Vendor((String)object, identifier, "https://issuetracker.google.com/issues/new?component=192731", null, 8, null);
                } else {
                    vendor3 = inferredVendor = StringsKt.startsWith$default((String)registryClass, (String)"com.google.", (boolean)false, (int)2, null) ? new Vendor("Google (" + identifier + ')', identifier, null, null, 12, null) : (Vendor)null;
                }
                if (inferredVendor != null) {
                    vendor = inferredVendor;
                } else {
                    if ($this$getVendor_u24lambda_u2d2.logJarProblems()) {
                        client.log(Severity.WARNING, null, registryClass + " in " + jarFile + " does not specify a vendor; see IssueRegistry#vendor", new Object[0]);
                    }
                    vendor = new Vendor(null, identifier, null, null, 13, null);
                }
            } else {
                vendor = vendor2;
            }
            return vendor;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final Map<String, File> findRegistries(LintClient client, Collection<? extends File> jarFiles) {
            HashMap registryClassToJarFile = new HashMap();
            for (File file : jarFiles) {
                Closeable closeable = new JarFile(file);
                boolean bl = false;
                boolean bl2 = false;
                Throwable throwable = null;
                try {
                    boolean bl3;
                    String string;
                    Object[] objectArray;
                    JarFile file2 = (JarFile)closeable;
                    boolean bl4 = false;
                    Manifest manifest = file2.getManifest();
                    Attributes attrs = manifest.getMainAttributes();
                    Object attribute = attrs.get(new Attributes.Name(JarFileIssueRegistry.MF_LINT_REGISTRY));
                    boolean isLegacy = false;
                    if (attribute == null && (attribute = attrs.get(new Attributes.Name(JarFileIssueRegistry.MF_LINT_REGISTRY_OLD))) != null) {
                        isLegacy = true;
                    }
                    if (attribute instanceof String) {
                        Object className = attribute;
                        if (!isLegacy || registryClassToJarFile.get(className) == null) {
                            objectArray = registryClassToJarFile;
                            string = (String)className;
                            bl3 = false;
                            objectArray.put(string, file);
                        }
                    } else {
                        JarEntry services = file2.getJarEntry(JarFileIssueRegistry.SERVICE_KEY);
                        if (services != null) {
                            objectArray = file2.getInputStream(services);
                            boolean bl5 = false;
                            bl3 = false;
                            Throwable throwable2 = null;
                            try {
                                InputStream it = (InputStream)objectArray;
                                boolean bl6 = false;
                                InputStreamReader reader = new InputStreamReader(it, Charsets.UTF_8);
                                Reader $this$useLines$iv = reader;
                                boolean $i$f$useLines = false;
                                Closeable closeable2 = $this$useLines$iv;
                                int n = 8192;
                                boolean bl7 = false;
                                closeable2 = closeable2 instanceof BufferedReader ? (BufferedReader)closeable2 : new BufferedReader((Reader)closeable2, n);
                                n = 0;
                                bl7 = false;
                                Throwable throwable3 = null;
                                try {
                                    BufferedReader it$iv = (BufferedReader)closeable2;
                                    boolean bl8 = false;
                                    Sequence lines = TextStreamsKt.lineSequence((BufferedReader)it$iv);
                                    boolean bl9 = false;
                                    for (String line : lines) {
                                        String string2;
                                        int n2;
                                        Object object;
                                        int comment = StringsKt.indexOf$default((CharSequence)line, (String)"#", (int)0, (boolean)false, (int)6, null);
                                        if (comment >= 0) {
                                            object = line;
                                            n2 = 0;
                                            boolean bl10 = false;
                                            String string3 = object;
                                            if (string3 == null) {
                                                throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
                                            }
                                            String string4 = string3.substring(n2, comment);
                                            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
                                            object = string4;
                                            n2 = 0;
                                            CharSequence charSequence = object;
                                            if (charSequence == null) {
                                                throw new NullPointerException("null cannot be cast to non-null type kotlin.CharSequence");
                                            }
                                            string2 = ((Object)StringsKt.trim((CharSequence)charSequence)).toString();
                                        } else {
                                            object = line;
                                            n2 = 0;
                                            String string5 = object;
                                            if (string5 == null) {
                                                throw new NullPointerException("null cannot be cast to non-null type kotlin.CharSequence");
                                            }
                                            string2 = ((Object)StringsKt.trim((CharSequence)string5)).toString();
                                        }
                                        String className = string2;
                                        object = className;
                                        n2 = 0;
                                        if (!(object.length() > 0) || registryClassToJarFile.get(className) != null) continue;
                                        object = registryClassToJarFile;
                                        n2 = 0;
                                        object.put(className, file);
                                    }
                                    Unit unit = Unit.INSTANCE;
                                }
                                catch (Throwable throwable4) {
                                    throwable3 = throwable4;
                                    throw throwable4;
                                }
                                finally {
                                    CloseableKt.closeFinally((Closeable)closeable2, (Throwable)throwable3);
                                }
                                Unit unit = Unit.INSTANCE;
                            }
                            catch (Throwable throwable5) {
                                throwable2 = throwable5;
                                throw throwable5;
                            }
                            finally {
                                CloseableKt.closeFinally((Closeable)objectArray, (Throwable)throwable2);
                            }
                        }
                        if (Factory.logJarProblems() && Intrinsics.areEqual((Object)file.getName(), (Object)"lint.jar")) {
                            objectArray = new Object[2];
                            string = file.getPath();
                            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"jarFile.path");
                            objectArray[0] = string;
                            objectArray[1] = JarFileIssueRegistry.MF_LINT_REGISTRY;
                            client.log(Severity.ERROR, null, "Custom lint rule jar %1$s does not contain a valid registry manifest key (%2$s).\nEither the custom jar is invalid, or it uses an outdated API not supported this lint client", objectArray);
                        }
                    }
                    Unit unit = Unit.INSTANCE;
                }
                catch (Throwable throwable6) {
                    throwable = throwable6;
                    throw throwable6;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                }
            }
            return registryClassToJarFile;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final void loadAndCloseURLClassLoader(LintClient client, File file, URLClassLoader loader) {
            if (SdkConstants.CURRENT_PLATFORM != 2) {
                return;
            }
            try {
                Closeable closeable = new JarFile(file);
                boolean bl = false;
                boolean bl2 = false;
                Throwable throwable = null;
                try {
                    JarFile jar = (JarFile)closeable;
                    boolean bl3 = false;
                    Enumeration<JarEntry> enumeration = jar.entries();
                    while (enumeration.hasMoreElements()) {
                        JarEntry entry = enumeration.nextElement();
                        String path2 = entry.getName();
                        Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"path");
                        if (!StringsKt.endsWith$default((String)path2, (String)".class", (boolean)false, (int)2, null) || StringsKt.indexOf$default((CharSequence)path2, (char)'$', (int)0, (boolean)false, (int)6, null) != -1) continue;
                        String string = path2;
                        int n = 0;
                        int n2 = path2.length() - ".class".length();
                        boolean bl4 = false;
                        String string2 = string.substring(n, n2);
                        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
                        String name = StringsKt.replace$default((String)string2, (char)'/', (char)'.', (boolean)false, (int)4, null);
                        try {
                            Class<?> cls = Class.forName(name, true, loader);
                            if (cls.isAnnotation() || cls.isEnum() || cls.isInterface()) continue;
                            try {
                                Constructor<?> defaultConstructor = cls.getConstructor(new Class[0]);
                                defaultConstructor.setAccessible(true);
                                defaultConstructor.newInstance(new Object[0]);
                            }
                            catch (NoSuchMethodException noSuchMethodException) {
                            }
                        }
                        catch (Throwable e) {
                            if (!Factory.logJarProblems()) continue;
                            client.log(Severity.ERROR, e, "Failed to prefetch " + name + " from " + file, new Object[0]);
                        }
                    }
                    Unit unit = Unit.INSTANCE;
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                }
            }
            catch (Throwable throwable) {
            }
            finally {
                try {
                    loader.close();
                }
                catch (Throwable throwable) {}
            }
        }

        private final boolean logJarProblems() {
            return !Intrinsics.areEqual((Object)System.getProperty("android.lint.log-jar-problems"), (Object)"false");
        }

        public /* synthetic */ Factory(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

