/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.detector.api;

import com.android.tools.lint.client.api.Configuration;
import com.android.tools.lint.client.api.ConfigurationHierarchy;
import com.android.tools.lint.client.api.IssueRegistry;
import com.android.tools.lint.client.api.LintClient;
import com.android.tools.lint.client.api.LintDriver;
import com.android.tools.lint.client.api.LintTomlValue;
import com.android.tools.lint.client.api.SdkInfo;
import com.android.tools.lint.client.api.Vendor;
import com.android.tools.lint.client.api.XmlParser;
import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.ClassContext;
import com.android.tools.lint.detector.api.Constraint;
import com.android.tools.lint.detector.api.Context;
import com.android.tools.lint.detector.api.Detector;
import com.android.tools.lint.detector.api.GradleContext;
import com.android.tools.lint.detector.api.Incident;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.JavaContext;
import com.android.tools.lint.detector.api.Lint;
import com.android.tools.lint.detector.api.LintFix;
import com.android.tools.lint.detector.api.LintMap;
import com.android.tools.lint.detector.api.Location;
import com.android.tools.lint.detector.api.LocationType;
import com.android.tools.lint.detector.api.PartialResult;
import com.android.tools.lint.detector.api.Project;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.XmlContext;
import com.android.utils.CharSequences;
import com.google.common.annotations.VisibleForTesting;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.uast.UCallExpression;
import org.jetbrains.uast.UElement;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u00be\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\r\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\n\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0003\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0016\u0018\u0000 X2\u00020\u0001:\u0001XB3\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\n\b\u0002\u0010\t\u001a\u0004\u0018\u00010\n\u00a2\u0006\u0002\u0010\u000bJ\u0006\u0010\u0014\u001a\u00020\u0015J\u000e\u00101\u001a\u00020\u00112\u0006\u0010\u0007\u001a\u00020\bJ\u0018\u00102\u001a\u0002032\u0006\u00104\u001a\u0002052\u0006\u00106\u001a\u000207H\u0002J\n\u00108\u001a\u0004\u0018\u00010\nH\u0016J\u001a\u00109\u001a\u0002032\b\u00104\u001a\u0004\u0018\u00010\u00012\b\b\u0002\u00106\u001a\u000207J\u000e\u0010:\u001a\u00020;2\u0006\u0010<\u001a\u00020=J\u000e\u0010>\u001a\u00020\u00152\u0006\u0010<\u001a\u00020=J\u0006\u0010?\u001a\u00020\u0015J\u0016\u0010@\u001a\u00020\u00152\u0006\u0010A\u001a\u00020 2\u0006\u0010<\u001a\u00020=J3\u0010B\u001a\u00020C2\b\u0010D\u001a\u0004\u0018\u00010E2\b\u0010F\u001a\u0004\u0018\u00010.2\u0012\u0010G\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00010H\"\u00020\u0001\u00a2\u0006\u0002\u0010IJ\u000e\u0010J\u001a\u00020C2\u0006\u0010K\u001a\u00020LJ\u0016\u0010J\u001a\u00020C2\u0006\u0010K\u001a\u00020L2\u0006\u0010M\u001a\u00020NJ\u0016\u0010J\u001a\u00020C2\u0006\u0010K\u001a\u00020L2\u0006\u0010O\u001a\u00020PJ,\u0010J\u001a\u00020C2\u0006\u0010<\u001a\u00020=2\u0006\u0010Q\u001a\u0002032\u0006\u0010R\u001a\u00020.2\n\b\u0002\u0010S\u001a\u0004\u0018\u00010TH\u0017J\u001e\u0010U\u001a\u00020C2\u0006\u0010V\u001a\u00020W2\u000e\u0010$\u001a\n\u0012\u0004\u0012\u00020&\u0018\u00010%R\u0011\u0010\f\u001a\u00020\r8F\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0010\u001a\u00020\u0011\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0012\u0010\u0014\u001a\u0004\u0018\u00010\u0015X\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u0016R\u0010\u0010\t\u001a\u0004\u0018\u00010\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u0010\u0010\u0007\u001a\u00020\b8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0019\u001a\u00020\u00158BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u001bR\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u001c\u001a\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b\u001d\u0010\u001eR\u0011\u0010\u001f\u001a\u00020 8F\u00a2\u0006\u0006\u001a\u0004\b!\u0010\"R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b#\u0010\u001eR\u0017\u0010$\u001a\b\u0012\u0004\u0012\u00020&0%8F\u00a2\u0006\u0006\u001a\u0004\b'\u0010(R\u0011\u0010)\u001a\u00020*8F\u00a2\u0006\u0006\u001a\u0004\b+\u0010,R\u0016\u0010-\u001a\u0004\u0018\u00010.8TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b/\u00100\u00a8\u0006Y"}, d2={"Lcom/android/tools/lint/detector/api/Context;", "", "driver", "Lcom/android/tools/lint/client/api/LintDriver;", "project", "Lcom/android/tools/lint/detector/api/Project;", "main", "file", "Ljava/io/File;", "contents", "", "(Lcom/android/tools/lint/client/api/LintDriver;Lcom/android/tools/lint/detector/api/Project;Lcom/android/tools/lint/detector/api/Project;Ljava/io/File;Ljava/lang/CharSequence;)V", "client", "Lcom/android/tools/lint/client/api/LintClient;", "getClient", "()Lcom/android/tools/lint/client/api/LintClient;", "configuration", "Lcom/android/tools/lint/client/api/Configuration;", "getConfiguration", "()Lcom/android/tools/lint/client/api/Configuration;", "containsCommentSuppress", "", "Ljava/lang/Boolean;", "getDriver", "()Lcom/android/tools/lint/client/api/LintDriver;", "forbidMainAccess", "getForbidMainAccess", "()Z", "mainProject", "getMainProject", "()Lcom/android/tools/lint/detector/api/Project;", "phase", "", "getPhase", "()I", "getProject", "scope", "Ljava/util/EnumSet;", "Lcom/android/tools/lint/detector/api/Scope;", "getScope", "()Ljava/util/EnumSet;", "sdkInfo", "Lcom/android/tools/lint/client/api/SdkInfo;", "getSdkInfo", "()Lcom/android/tools/lint/client/api/SdkInfo;", "suppressCommentPrefix", "", "getSuppressCommentPrefix", "()Ljava/lang/String;", "findConfiguration", "findNodeInProject", "Lcom/android/tools/lint/detector/api/Location;", "node", "Lorg/w3c/dom/Node;", "type", "Lcom/android/tools/lint/detector/api/LocationType;", "getContents", "getLocation", "getPartialResults", "Lcom/android/tools/lint/detector/api/PartialResult;", "issue", "Lcom/android/tools/lint/detector/api/Issue;", "isEnabled", "isGlobalAnalysis", "isSuppressedWithComment", "startOffset", "log", "", "exception", "", "format", "args", "", "(Ljava/lang/Throwable;Ljava/lang/String;[Ljava/lang/Object;)V", "report", "incident", "Lcom/android/tools/lint/detector/api/Incident;", "constraint", "Lcom/android/tools/lint/detector/api/Constraint;", "map", "Lcom/android/tools/lint/detector/api/LintMap;", "location", "message", "quickfixData", "Lcom/android/tools/lint/detector/api/LintFix;", "requestRepeat", "detector", "Lcom/android/tools/lint/detector/api/Detector;", "Companion", "lint-api"})
@SourceDebugExtension(value={"SMAP\nContext.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Context.kt\ncom/android/tools/lint/detector/api/Context\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,776:1\n1#2:777\n766#3:778\n857#3,2:779\n*S KotlinDebug\n*F\n+ 1 Context.kt\ncom/android/tools/lint/detector/api/Context\n*L\n310#1:778\n310#1:779,2\n*E\n"})
public class Context {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final LintDriver driver;
    @NotNull
    private final Project project;
    @Nullable
    private final Project main;
    @JvmField
    @NotNull
    public final File file;
    @Nullable
    private CharSequence contents;
    @NotNull
    private final Configuration configuration;
    @Nullable
    private Boolean containsCommentSuppress;
    @NotNull
    public static final String SUPPRESS_XML_COMMENT_PREFIX = "<!--suppress ";
    @NotNull
    public static final String SUPPRESS_JAVA_COMMENT_PREFIX = "noinspection ";
    @Nullable
    private static Set<String> detectorsWarned;

    public Context(@NotNull LintDriver driver, @NotNull Project project, @Nullable Project main, @NotNull File file, @Nullable CharSequence contents) {
        Intrinsics.checkNotNullParameter((Object)driver, (String)"driver");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        this.driver = driver;
        this.project = project;
        this.main = main;
        this.file = file;
        this.contents = contents;
        Configuration configuration = this.getClient().getConfiguration(this.file);
        if (configuration == null) {
            Configuration configuration2 = this.project.getConfiguration(this.driver);
            configuration = configuration2;
            Intrinsics.checkNotNullExpressionValue((Object)configuration2, (String)"project.getConfiguration(driver)");
        }
        this.configuration = configuration;
    }

    public /* synthetic */ Context(LintDriver lintDriver, Project project, Project project2, File file, CharSequence charSequence, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 0x10) != 0) {
            charSequence = null;
        }
        this(lintDriver, project, project2, file, charSequence);
    }

    @NotNull
    public final LintDriver getDriver() {
        return this.driver;
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    @NotNull
    public final Configuration getConfiguration() {
        return this.configuration;
    }

    @NotNull
    public final EnumSet<Scope> getScope() {
        return this.driver.getScope();
    }

    @NotNull
    public final Project getMainProject() {
        boolean forbidden;
        if (this.getForbidMainAccess() && (forbidden = Companion.checkForbidden("context.getMainProject()", this.file, this.driver))) {
            return this.project;
        }
        Project project = this.main;
        if (project == null) {
            project = this.project;
        }
        return project;
    }

    @NotNull
    public final LintClient getClient() {
        return this.driver.getClient();
    }

    @Nullable
    public CharSequence getContents() {
        if (this.contents == null) {
            this.contents = this.driver.getClient().readFile(this.file);
        }
        return this.contents;
    }

    @NotNull
    public final SdkInfo getSdkInfo() {
        SdkInfo sdkInfo = this.project.getSdkInfo();
        Intrinsics.checkNotNullExpressionValue((Object)sdkInfo, (String)"project.getSdkInfo()");
        return sdkInfo;
    }

    @NotNull
    public final Location getLocation(@Nullable Object node, @NotNull LocationType type) {
        Object object;
        block62: {
            JavaContext javaContext;
            block64: {
                JavaContext javaContext2;
                Object object2;
                block66: {
                    block65: {
                        block63: {
                            block57: {
                                JavaContext javaContext3;
                                block59: {
                                    JavaContext javaContext4;
                                    Object object3;
                                    block61: {
                                        block60: {
                                            block58: {
                                                Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
                                                if (node == null) {
                                                    return Location.NONE;
                                                }
                                                object = node;
                                                if (!(object instanceof UElement)) break block57;
                                                if (!(this instanceof JavaContext)) break block58;
                                                javaContext3 = (JavaContext)this;
                                                break block59;
                                            }
                                            object3 = ((UElement)node).getSourcePsi();
                                            if (object3 == null || (object3 = object3.getContainingFile()) == null || (object3 = object3.getVirtualFile()) == null) break block60;
                                            Object it = object3;
                                            boolean bl = false;
                                            File file = VfsUtilCore.virtualToIoFile((VirtualFile)it);
                                            object3 = file;
                                            if (file != null) break block61;
                                        }
                                        object3 = this.file;
                                    }
                                    Intrinsics.checkNotNullExpressionValue((Object)object3, (String)"node.sourcePsi?.containi\u2026}\n                ?: file");
                                    Object file = object3;
                                    JavaContext $this$getLocation_u24lambda_u241 = javaContext4 = new JavaContext(this.driver, this.project, this.main, (File)file);
                                    boolean bl = false;
                                    $this$getLocation_u24lambda_u241.setUastParser($this$getLocation_u24lambda_u241.getClient().getUastParser($this$getLocation_u24lambda_u241.getProject()));
                                    javaContext3 = javaContext4;
                                }
                                JavaContext context2 = javaContext3;
                                return switch (WhenMappings.$EnumSwitchMapping$0[type.ordinal()]) {
                                    case 1 -> context2.getLocation((UElement)node);
                                    case 2 -> {
                                        if (node instanceof UCallExpression) {
                                            yield context2.getCallLocation((UCallExpression)node, true, true);
                                        }
                                        yield context2.getUastParser().getLocation(context2, (UElement)node);
                                    }
                                    case 3 -> context2.getNameLocation((UElement)node);
                                    case 4 -> context2.getCallLocation((UCallExpression)node, false, true);
                                    case 5 -> context2.getCallLocation((UCallExpression)node, true, false);
                                    case 6 -> throw new IllegalStateException((type + " not supported for " + node.getClass()).toString());
                                    default -> throw new NoWhenBranchMatchedException();
                                };
                            }
                            if (!(object instanceof PsiElement)) break block62;
                            if (!(this instanceof JavaContext)) break block63;
                            javaContext = (JavaContext)this;
                            break block64;
                        }
                        object2 = ((PsiElement)node).getContainingFile();
                        if (object2 == null || (object2 = object2.getVirtualFile()) == null) break block65;
                        Object it = object2;
                        boolean bl = false;
                        File file = VfsUtilCore.virtualToIoFile((VirtualFile)it);
                        object2 = file;
                        if (file != null) break block66;
                    }
                    object2 = this.file;
                }
                Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"node.containingFile?.vir\u2026ualToIoFile(it) } ?: file");
                Object file = object2;
                JavaContext $this$getLocation_u24lambda_u243 = javaContext2 = new JavaContext(this.driver, this.project, this.main, (File)file);
                boolean bl = false;
                $this$getLocation_u24lambda_u243.setUastParser($this$getLocation_u24lambda_u243.getClient().getUastParser($this$getLocation_u24lambda_u243.getProject()));
                javaContext = javaContext2;
            }
            JavaContext context3 = javaContext;
            return switch (WhenMappings.$EnumSwitchMapping$0[type.ordinal()]) {
                case 1 -> context3.getLocation((PsiElement)node);
                case 2 -> context3.getLocation((PsiElement)node);
                case 3 -> context3.getNameLocation((PsiElement)node);
                case 4, 5 -> context3.getLocation((PsiElement)node);
                case 6 -> throw new IllegalStateException((type + " not supported for " + node.getClass()).toString());
                default -> throw new NoWhenBranchMatchedException();
            };
        }
        if (object instanceof Node) {
            XmlContext xmlContext;
            if (this.getClient().isMergeManifestNode((Node)node)) {
                com.android.utils.Pair<File, ? extends Node> source;
                if (Intrinsics.areEqual((Object)((Node)node).getNodeName(), (Object)"application")) {
                    Node node2 = ((Node)node).getParentNode();
                    if (Intrinsics.areEqual((Object)(node2 != null ? node2.getNodeName() : null), (Object)"manifest")) {
                        return this.findNodeInProject((Node)node, type);
                    }
                }
                if ((source = this.getClient().findManifestSourceNode((Node)node)) != null && source.getSecond() != node) {
                    if (Intrinsics.areEqual((Object)source.getFirst(), (Object)this.file)) {
                        return this.getLocation(source.getSecond(), type);
                    }
                    Document doc = ((Node)node).getOwnerDocument();
                    Object object4 = source.getFirst();
                    Intrinsics.checkNotNullExpressionValue((Object)object4, (String)"source.first");
                    File file = (File)object4;
                    Intrinsics.checkNotNullExpressionValue((Object)doc, (String)"doc");
                    XmlContext xmlContext2 = new XmlContext(this.driver, this.project, this.main, file, null, null, doc);
                    return xmlContext2.getLocation(source.getSecond(), type);
                }
            }
            String string = this.file.getPath();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"file.path");
            if (!StringsKt.endsWith$default((String)string, (String)".xml", (boolean)false, (int)2, null)) {
                return this.findNodeInProject((Node)node, type);
            }
            if (this instanceof XmlContext) {
                xmlContext = (XmlContext)this;
            } else {
                Document doc = ((Node)node).getOwnerDocument();
                Object object5 = doc.getUserData(File.class.getName());
                File file = object5 instanceof File ? (File)object5 : null;
                if (file == null) {
                    File file2;
                    Object object6 = doc.getUserData(PsiFile.class.getName());
                    PsiFile psiFile = object6 instanceof PsiFile ? (PsiFile)object6 : null;
                    if (psiFile != null && (psiFile = psiFile.getVirtualFile()) != null) {
                        PsiFile it = psiFile;
                        boolean bl = false;
                        file2 = VfsUtilCore.virtualToIoFile((VirtualFile)it);
                    } else {
                        file2 = file = null;
                    }
                    if (file2 == null) {
                        List<File> list2 = this.project.getManifestFiles();
                        Intrinsics.checkNotNullExpressionValue(list2, (String)"project.getManifestFiles()");
                        File file3 = (File)CollectionsKt.firstOrNull(list2);
                        if (file3 == null) {
                            file3 = this.project.dir;
                        }
                        Intrinsics.checkNotNullExpressionValue((Object)file3, (String)"project.getManifestFiles\u2026stOrNull() ?: project.dir");
                        return Location.Companion.create(file3);
                    }
                }
                File file4 = file;
                Intrinsics.checkNotNullExpressionValue((Object)doc, (String)"doc");
                xmlContext = new XmlContext(this.driver, this.project, this.main, file4, null, null, doc);
            }
            XmlContext context4 = xmlContext;
            return switch (WhenMappings.$EnumSwitchMapping$0[type.ordinal()]) {
                case 2 -> context4.getLocation((Node)node);
                case 1 -> {
                    if (node instanceof Element) {
                        yield context4.getElementLocation((Element)node);
                    }
                    yield context4.getLocation((Node)node);
                }
                case 3 -> context4.getNameLocation((Node)node);
                case 6 -> {
                    if (node instanceof Attr) {
                        yield context4.getValueLocation((Attr)node);
                    }
                    yield context4.getLocation((Node)node);
                }
                case 4, 5 -> throw new IllegalStateException((type + " not supported for " + node.getClass()).toString());
                default -> throw new NoWhenBranchMatchedException();
            };
        }
        if (object instanceof LintTomlValue) {
            Location location2;
            switch (WhenMappings.$EnumSwitchMapping$0[type.ordinal()]) {
                case 2: {
                    location2 = ((LintTomlValue)node).getFullLocation();
                    break;
                }
                case 3: {
                    location2 = ((LintTomlValue)node).getKeyLocation();
                    if (location2 != null) break;
                    location2 = ((LintTomlValue)node).getLocation();
                    break;
                }
                case 1: {
                    location2 = ((LintTomlValue)node).getLocation();
                    break;
                }
                default: {
                    location2 = ((LintTomlValue)node).getLocation();
                }
            }
            return location2;
        }
        if (object instanceof ClassNode) {
            if (this instanceof ClassContext) {
                return ((ClassContext)this).getLocation((ClassNode)node);
            }
            throw new IllegalStateException("Can only get ClassNode locations on a ClassContext".toString());
        }
        if (object instanceof AbstractInsnNode) {
            if (this instanceof ClassContext) {
                return ((ClassContext)this).getLocation((AbstractInsnNode)node);
            }
            throw new IllegalStateException("Can only get AbstractInsnNode locations on a ClassContext".toString());
        }
        if (this instanceof GradleContext) {
            return ((GradleContext)this).getLocation(node);
        }
        return Location.Companion.create(this.file);
    }

    public static /* synthetic */ Location getLocation$default(Context context2, Object object, LocationType locationType, int n, Object object2) {
        if (object2 != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: getLocation");
        }
        if ((n & 2) != 0) {
            locationType = LocationType.DEFAULT;
        }
        return context2.getLocation(object, locationType);
    }

    /*
     * WARNING - void declaration
     */
    private final Location findNodeInProject(Node node, LocationType type) {
        Element element;
        Node node2 = node;
        Element element2 = node2 instanceof Element ? (Element)node : (element = node2 instanceof Attr ? ((Attr)node).getOwnerElement() : null);
        if (element != null) {
            void $this$filterTo$iv$iv;
            void $this$filter$iv;
            Object object = new Project[]{this.project};
            Sequence sequence = SequencesKt.sequenceOf((Object[])object);
            List<Project> list2 = this.project.allLibraries;
            Intrinsics.checkNotNullExpressionValue(list2, (String)"project.allLibraries");
            object = list2;
            Sequence sequence2 = sequence;
            boolean $i$f$filter = false;
            Iterator<File> iterator = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                Project it = (Project)element$iv$iv;
                boolean bl = false;
                if (!(!it.isExternalLibrary())) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            Sequence projects = SequencesKt.plus((Sequence)sequence2, (Iterable)((List)destination$iv$iv));
            for (Project p : projects) {
                for (File manifest : p.getManifestFiles()) {
                    try {
                        Document document;
                        Node sourceNode;
                        XmlParser xmlParser = this.getClient().getXmlParser();
                        Intrinsics.checkNotNullExpressionValue((Object)manifest, (String)"manifest");
                        if (xmlParser.parseXml(manifest) == null || (sourceNode = (Node)Lint.matchXmlElement(element, document)) == null || sourceNode == element) continue;
                        Document doc = node.getOwnerDocument();
                        Intrinsics.checkNotNullExpressionValue((Object)p, (String)"p");
                        Intrinsics.checkNotNullExpressionValue((Object)doc, (String)"doc");
                        XmlContext xmlContext = new XmlContext(this.driver, p, this.main, manifest, null, null, doc);
                        return xmlContext.getLocation(sourceNode, type);
                    }
                    catch (Exception exception) {
                    }
                }
            }
        }
        List<File> list3 = this.project.getManifestFiles();
        Intrinsics.checkNotNullExpressionValue(list3, (String)"project.getManifestFiles()");
        File file = (File)CollectionsKt.firstOrNull(list3);
        if (file == null) {
            file = this.project.dir;
        }
        Intrinsics.checkNotNullExpressionValue((Object)file, (String)"project.getManifestFiles\u2026stOrNull() ?: project.dir");
        return Location.Companion.create(file);
    }

    public final boolean isEnabled(@NotNull Issue issue) {
        Intrinsics.checkNotNullParameter((Object)issue, (String)"issue");
        return this.configuration.isEnabled(issue);
    }

    @JvmOverloads
    public void report(@NotNull Issue issue, @NotNull Location location2, @NotNull String message2, @Nullable LintFix quickfixData) {
        Intrinsics.checkNotNullParameter((Object)issue, (String)"issue");
        Intrinsics.checkNotNullParameter((Object)location2, (String)"location");
        Intrinsics.checkNotNullParameter((Object)message2, (String)"message");
        Incident incident = new Incident(issue, location2, message2, quickfixData);
        LintClient.report$default(this.driver.getClient(), this, incident, null, 4, null);
    }

    public static /* synthetic */ void report$default(Context context2, Issue issue, Location location2, String string, LintFix lintFix, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: report");
        }
        if ((n & 8) != 0) {
            lintFix = null;
        }
        context2.report(issue, location2, string, lintFix);
    }

    public final void report(@NotNull Incident incident) {
        Intrinsics.checkNotNullParameter((Object)incident, (String)"incident");
        LintClient.report$default(this.driver.getClient(), this, incident, null, 4, null);
    }

    public final boolean isGlobalAnalysis() {
        return this.driver.isGlobalAnalysis();
    }

    public final void report(@NotNull Incident incident, @NotNull Constraint constraint2) {
        Intrinsics.checkNotNullParameter((Object)incident, (String)"incident");
        Intrinsics.checkNotNullParameter((Object)constraint2, (String)"constraint");
        this.getClient().report(this, incident, constraint2);
    }

    public final void report(@NotNull Incident incident, @NotNull LintMap map) {
        Intrinsics.checkNotNullParameter((Object)incident, (String)"incident");
        Intrinsics.checkNotNullParameter((Object)map, (String)"map");
        this.getClient().report(this, incident, map);
    }

    @NotNull
    public final PartialResult getPartialResults(@NotNull Issue issue) {
        Intrinsics.checkNotNullParameter((Object)issue, (String)"issue");
        return this.getClient().getPartialResults(this.project, issue);
    }

    @NotNull
    public final Configuration findConfiguration(@NotNull File file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        ConfigurationHierarchy configurations = this.driver.getClient().getConfigurations();
        File dir = file.getParentFile();
        Object object = ConfigurationHierarchy.getConfigurationForFolder$default(configurations, dir, null, 2, null);
        if (object == null) {
            Context $this$findConfiguration_u24lambda_u246 = this;
            boolean bl = false;
            Project project = $this$findConfiguration_u24lambda_u246.driver.findProjectFor(file);
            Object object2 = project;
            if (object2 == null || (object2 = ((Project)object2).getConfiguration($this$findConfiguration_u24lambda_u246.driver)) == null) {
                object2 = $this$findConfiguration_u24lambda_u246.configuration;
            }
            object = object2;
            Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"project?.getConfiguration(driver) ?: configuration");
        }
        return object;
    }

    public final void log(@Nullable Throwable exception, @Nullable String format, Object ... args) {
        Intrinsics.checkNotNullParameter((Object)args, (String)"args");
        this.driver.getClient().log(exception, format, Arrays.copyOf(args, args.length));
    }

    public final int getPhase() {
        return this.driver.getPhase();
    }

    public final void requestRepeat(@NotNull Detector detector, @Nullable EnumSet<Scope> scope) {
        Intrinsics.checkNotNullParameter((Object)detector, (String)"detector");
        this.driver.requestRepeat(detector, scope);
    }

    @Nullable
    protected String getSuppressCommentPrefix() {
        String path2 = this.file.getPath();
        Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"path");
        if (StringsKt.endsWith$default((String)path2, (String)".java", (boolean)false, (int)2, null) || StringsKt.endsWith$default((String)path2, (String)".gradle", (boolean)false, (int)2, null) || StringsKt.endsWith$default((String)path2, (String)".kts", (boolean)false, (int)2, null)) {
            return SUPPRESS_JAVA_COMMENT_PREFIX;
        }
        if (StringsKt.endsWith$default((String)path2, (String)".xml", (boolean)false, (int)2, null)) {
            return SUPPRESS_XML_COMMENT_PREFIX;
        }
        if (StringsKt.endsWith$default((String)path2, (String)".cfg", (boolean)false, (int)2, null) || StringsKt.endsWith$default((String)path2, (String)".pro", (boolean)false, (int)2, null)) {
            return "#suppress ";
        }
        return null;
    }

    public final boolean containsCommentSuppress() {
        if (this.containsCommentSuppress == null) {
            CharSequence contents;
            this.containsCommentSuppress = false;
            String prefix = this.getSuppressCommentPrefix();
            if (prefix != null && (contents = this.getContents()) != null) {
                this.containsCommentSuppress = CharSequences.indexOf((CharSequence)contents, (CharSequence)prefix) != -1;
            }
        }
        Boolean bl = this.containsCommentSuppress;
        Intrinsics.checkNotNull((Object)bl);
        return bl;
    }

    public final boolean isSuppressedWithComment(int startOffset, @NotNull Issue issue) {
        Intrinsics.checkNotNullParameter((Object)issue, (String)"issue");
        String string = this.getSuppressCommentPrefix();
        if (string == null) {
            return false;
        }
        String prefix = string;
        CharSequence charSequence = this.getContents();
        if (charSequence == null) {
            charSequence = "";
        }
        String string2 = Companion.getSuppressionDirective(prefix, charSequence, startOffset);
        if (string2 == null) {
            return false;
        }
        String line = string2;
        return Companion.isSuppressedWithComment(line, issue);
    }

    private final boolean getForbidMainAccess() {
        return this.driver.getMode() == LintDriver.DriverMode.ANALYSIS_ONLY;
    }

    @JvmOverloads
    public final void report(@NotNull Issue issue, @NotNull Location location2, @NotNull String message2) {
        Intrinsics.checkNotNullParameter((Object)issue, (String)"issue");
        Intrinsics.checkNotNullParameter((Object)location2, (String)"location");
        Intrinsics.checkNotNullParameter((Object)message2, (String)"message");
        Context.report$default(this, issue, location2, message2, null, 8, null);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010#\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\r\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\f\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J \u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u00042\u0006\u0010\u000b\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u000eJ\"\u0010\u000f\u001a\u0016\u0012\u0004\u0012\u00020\u0004\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00120\u0011\u0018\u00010\u00102\u0006\u0010\r\u001a\u00020\u000eJ \u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00142\u0006\u0010\u0018\u001a\u00020\u0004H\u0002J \u0010\u0019\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0018\u001a\u00020\u00042\u0006\u0010\u001a\u001a\u00020\u00162\u0006\u0010\u001b\u001a\u00020\u0014J\u0018\u0010\u001c\u001a\u00020\t2\u0006\u0010\u001d\u001a\u00020\u00042\u0006\u0010\u001e\u001a\u00020\u001fH\u0002J\u0018\u0010\u001c\u001a\u00020\t2\u0006\u0010\u001d\u001a\u00020\u00042\u0006\u0010 \u001a\u00020\u0012H\u0007J \u0010!\u001a\u00020\t2\u0006\u0010\u001d\u001a\u00020\u00042\u0006\u0010\"\u001a\u00020\u00042\u0006\u0010#\u001a\u00020\u0014H\u0002J\u0010\u0010$\u001a\u00020\t2\u0006\u0010%\u001a\u00020&H\u0002J\u0018\u0010'\u001a\u00020\t2\u0006\u0010\u001d\u001a\u00020\u00042\u0006\u0010(\u001a\u00020\u0004H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0006\u001a\n\u0012\u0004\u0012\u00020\u0004\u0018\u00010\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006)"}, d2={"Lcom/android/tools/lint/detector/api/Context$Companion;", "", "()V", "SUPPRESS_JAVA_COMMENT_PREFIX", "", "SUPPRESS_XML_COMMENT_PREFIX", "detectorsWarned", "", "checkForbidden", "", "methodName", "file", "Ljava/io/File;", "driver", "Lcom/android/tools/lint/client/api/LintDriver;", "findCallingDetector", "Lkotlin/Pair;", "", "Lcom/android/tools/lint/detector/api/Issue;", "findPrefixOnPreviousLine", "", "contents", "", "lineStart", "prefix", "getSuppressionDirective", "source", "startOffset", "isSuppressedWithComment", "line", "category", "Lcom/android/tools/lint/detector/api/Category;", "issue", "isWord", "word", "index", "isWordDelimiter", "c", "", "lineContainsId", "id", "lint-api"})
    @SourceDebugExtension(value={"SMAP\nContext.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Context.kt\ncom/android/tools/lint/detector/api/Context$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,776:1\n1747#2,3:777\n1603#2,9:781\n1855#2:790\n1856#2:792\n1612#2:793\n1045#2:794\n1#3:780\n1#3:791\n*S KotlinDebug\n*F\n+ 1 Context.kt\ncom/android/tools/lint/detector/api/Context$Companion\n*L\n572#1:777,3\n686#1:781,9\n686#1:790\n686#1:792\n686#1:793\n688#1:794\n686#1:791\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @Nullable
        public final String getSuppressionDirective(@NotNull String prefix, @NotNull CharSequence source, int startOffset) {
            Intrinsics.checkNotNullParameter((Object)prefix, (String)"prefix");
            Intrinsics.checkNotNullParameter((Object)source, (String)"source");
            if (startOffset <= 0) {
                return null;
            }
            if (startOffset >= source.length()) {
                return null;
            }
            int lineStart = StringsKt.lastIndexOf$default((CharSequence)source, (char)'\n', (int)startOffset, (boolean)false, (int)4, null) + 1;
            if (lineStart <= 1) {
                return null;
            }
            int index = this.findPrefixOnPreviousLine(source, lineStart, prefix);
            if (index != -1 && index + prefix.length() < lineStart) {
                return ((Object)source.subSequence(index + prefix.length(), lineStart)).toString();
            }
            return null;
        }

        @VisibleForTesting
        public final boolean isSuppressedWithComment(@NotNull String line, @NotNull Issue issue) {
            Intrinsics.checkNotNullParameter((Object)line, (String)"line");
            Intrinsics.checkNotNullParameter((Object)issue, (String)"issue");
            List<String> list2 = issue.getAliases();
            if (list2 != null) {
                boolean bl;
                block5: {
                    List<String> aliases = list2;
                    boolean bl2 = false;
                    Iterable $this$any$iv = aliases;
                    boolean $i$f$any = false;
                    if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                        bl = false;
                    } else {
                        for (Object element$iv : $this$any$iv) {
                            String alias = (String)element$iv;
                            boolean bl3 = false;
                            if (!Companion.lineContainsId(line, alias)) continue;
                            bl = true;
                            break block5;
                        }
                        bl = false;
                    }
                }
                if (bl) {
                    return true;
                }
            }
            return this.lineContainsId(line, issue.getId()) || this.lineContainsId(line, "all") || this.isSuppressedWithComment(line, issue.getCategory());
        }

        private final boolean isSuppressedWithComment(String line, Category category) {
            return this.lineContainsId(line, category.getName()) || this.lineContainsId(line, category.getFullName()) || category.getParent() != null && this.isSuppressedWithComment(line, category.getParent());
        }

        private final boolean lineContainsId(String line, String id) {
            for (int index = 0; index < line.length(); index += id.length()) {
                if ((index = StringsKt.indexOf((CharSequence)line, (String)id, (int)index, (boolean)true)) == -1) {
                    return false;
                }
                if (!this.isWord(line, id, index)) continue;
                return true;
            }
            return false;
        }

        private final boolean isWord(String line, String word, int index) {
            int end = index + word.length();
            if (end < line.length() && !this.isWordDelimiter(line.charAt(end))) {
                return false;
            }
            if (index > 0 && !this.isWordDelimiter(line.charAt(index - 1))) {
                int prefixStart = index - 11;
                return index >= 11 && StringsKt.regionMatches$default((String)line, (int)prefixStart, (String)"AndroidLint", (int)0, (int)11, (boolean)false, (int)16, null) && (prefixStart == 0 || this.isWordDelimiter(line.charAt(prefixStart - 1)));
            }
            return true;
        }

        private final boolean isWordDelimiter(char c) {
            return !Character.isJavaIdentifierPart(c);
        }

        private final int findPrefixOnPreviousLine(CharSequence contents, int lineStart, String prefix) {
            char first = prefix.charAt(0);
            boolean seenNonWhitespace = false;
            for (int offset = lineStart - 2; offset >= 0; --offset) {
                char c = contents.charAt(offset);
                if (seenNonWhitespace && c == '\n') {
                    return -1;
                }
                if (!seenNonWhitespace && !Character.isWhitespace(c)) {
                    seenNonWhitespace = true;
                }
                if (c != first || !CharSequences.regionMatches((CharSequence)contents, (int)offset, (CharSequence)prefix, (int)0, (int)prefix.length())) continue;
                return offset;
            }
            return -1;
        }

        /*
         * WARNING - void declaration
         */
        public final boolean checkForbidden(@NotNull String methodName, @NotNull File file, @Nullable LintDriver driver) {
            Intrinsics.checkNotNullParameter((Object)methodName, (String)"methodName");
            Intrinsics.checkNotNullParameter((Object)file, (String)"file");
            LintDriver lintDriver = driver;
            if (lintDriver == null && (lintDriver = (LintDriver)CollectionsKt.firstOrNull(LintDriver.Companion.getCurrentDrivers())) == null) {
                return true;
            }
            LintDriver currentDriver = lintDriver;
            if (currentDriver.getMode() == LintDriver.DriverMode.ANALYSIS_ONLY) {
                Set warnings;
                Iterable it;
                Pair<String, List<Issue>> pair = this.findCallingDetector(currentDriver);
                if (pair == null) {
                    return false;
                }
                Pair<String, List<Issue>> pair2 = pair;
                String detector = (String)pair2.component1();
                List issues = (List)pair2.component2();
                Set set = detectorsWarned;
                if (set == null) {
                    HashSet hashSet;
                    it = hashSet = new HashSet();
                    boolean bl = false;
                    detectorsWarned = it;
                    set = hashSet;
                }
                if ((warnings = set).add(detector)) {
                    String string;
                    void $this$sortedBy$iv;
                    void $this$mapNotNullTo$iv$iv;
                    Iterable $this$mapNotNull$iv;
                    StringBuilder stack = new StringBuilder();
                    LintDriver.Companion.appendStackTraceSummary(new RuntimeException(), stack, 1, 20);
                    it = issues;
                    boolean $i$f$mapNotNull = false;
                    LintClient.Companion companion = $this$mapNotNull$iv;
                    Collection destination$iv$iv = new ArrayList();
                    boolean $i$f$mapNotNullTo = false;
                    void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
                    boolean $i$f$forEach = false;
                    Iterator iterator = $this$forEach$iv$iv$iv.iterator();
                    while (iterator.hasNext()) {
                        Object element$iv$iv$iv;
                        Object element$iv$iv = element$iv$iv$iv = iterator.next();
                        boolean bl = false;
                        Issue it2 = (Issue)element$iv$iv;
                        boolean bl2 = false;
                        Vendor vendor = it2.getVendor();
                        if (vendor == null) {
                            IssueRegistry issueRegistry = it2.getRegistry();
                            vendor = issueRegistry != null ? issueRegistry.getVendor() : null;
                        }
                        if (vendor == null) continue;
                        Vendor it$iv$iv = vendor;
                        boolean bl3 = false;
                        destination$iv$iv.add(it$iv$iv);
                    }
                    $this$mapNotNull$iv = CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
                    boolean $i$f$sortedBy22 = false;
                    List vendors = CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

                        public final int compare(T a, T b) {
                            Vendor it = (Vendor)a;
                            boolean bl = false;
                            Comparable comparable = (Comparable)((Object)it.getIdentifier());
                            it = (Vendor)b;
                            Comparable comparable2 = comparable;
                            bl = false;
                            return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Comparable)((Object)it.getIdentifier())));
                        }
                    });
                    if (!((Collection)issues).isEmpty()) {
                        StringBuilder sb = new StringBuilder();
                        sb.append("\nIssue Vendors:\n");
                        for (Vendor vendor : vendors) {
                            String it3;
                            if (vendor.getVendorName() != null) {
                                boolean bl = false;
                                sb.append("Vendor: " + it3 + "\n");
                            }
                            if (vendor.getIdentifier() != null) {
                                boolean bl = false;
                                sb.append("Identifier: " + it3 + "\n");
                            }
                            if (vendor.getContact() != null) {
                                boolean bl = false;
                                sb.append("Contact: " + it3 + "\n");
                            }
                            if (vendor.getFeedbackUrl() != null) {
                                boolean bl = false;
                                sb.append("Feedback: " + it3 + "\n");
                            }
                            sb.append("\n");
                        }
                        string = sb.toString();
                    } else {
                        string = "";
                    }
                    String $i$f$sortedBy22 = string;
                    Intrinsics.checkNotNullExpressionValue((Object)$i$f$sortedBy22, (String)"if (issues.isNotEmpty())\u2026         \"\"\n            }");
                    String vendorString = $i$f$sortedBy22;
                    Object object = driver;
                    if (object == null || (object = ((LintDriver)object).getClient()) == null || (object = ((LintClient)object).getClientDisplayName()) == null) {
                        object = LintClient.Companion.getClientName();
                    }
                    String message2 = StringsKt.trimIndent((String)("\n                        The lint detector\n                            `" + detector + "`\n                        called `" + methodName + "` during module analysis.\n\n                        This does not work correctly when running in " + (String)object + ".\n\n                        In particular, there may be false positives or false negatives because\n                        the lint check may be using the minSdkVersion or manifest information\n                        from the library instead of any consuming app module.\n\n                        Contact the vendor of the lint issue to get it fixed/updated (if\n                        known, listed below), and in the meantime you can try to work around\n                        this by disabling the following issues:\n\n                        " + CollectionsKt.joinToString$default((Iterable)issues, (CharSequence)",", null, null, (int)0, null, (Function1)checkForbidden.message.1.INSTANCE, (int)30, null) + "\n                        ")) + "\n" + vendorString + "Call stack: " + stack;
                    companion = LintClient.Companion;
                    LintClient lintClient = currentDriver.getClient();
                    Issue issue = IssueRegistry.LINT_ERROR;
                    Location location2 = Location.Companion.create(file);
                    LintClient.Companion.report$default(companion, lintClient, issue, message2, null, null, null, null, null, null, null, null, currentDriver, location2, 2040, null);
                }
                return true;
            }
            return false;
        }

        @Nullable
        public final Pair<String, List<Issue>> findCallingDetector(@NotNull LintDriver driver) {
            StackTraceElement callerCaller;
            Intrinsics.checkNotNullParameter((Object)driver, (String)"driver");
            Throwable throwable = new Throwable().fillInStackTrace();
            StackTraceElement[] frames = throwable.getStackTrace();
            if (frames.length >= 4 && (Intrinsics.areEqual((Object)(callerCaller = frames[3]).getMethodName(), (Object)"beforeCheckEachProject") || Intrinsics.areEqual((Object)callerCaller.getMethodName(), (Object)"afterCheckEachProject"))) {
                return null;
            }
            Intrinsics.checkNotNullExpressionValue((Object)throwable, (String)"throwable");
            Pair<String, List<Issue>> result = LintDriver.Companion.getAssociatedDetector(throwable, driver);
            if (result != null) {
                return result;
            }
            Intrinsics.checkNotNullExpressionValue((Object)frames, (String)"frames");
            for (StackTraceElement element : frames) {
                String detectorClass = element.getClassName();
                Intrinsics.checkNotNullExpressionValue((Object)detectorClass, (String)"detectorClass");
                if (StringsKt.startsWith$default((String)detectorClass, (String)"com.android.tools.lint.", (boolean)false, (int)2, null) && !StringsKt.startsWith$default((String)detectorClass, (String)"com.android.tools.lint.checks.", (boolean)false, (int)2, null)) continue;
                return new Pair((Object)detectorClass, LintDriver.Companion.getDetectorIssues(detectorClass, driver));
            }
            return new Pair((Object)"unknown detector", (Object)CollectionsKt.emptyList());
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 6, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[LocationType.values().length];
            try {
                nArray[LocationType.DEFAULT.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[LocationType.ALL.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[LocationType.NAME.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[LocationType.CALL_WITH_ARGUMENTS.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[LocationType.CALL_WITH_RECEIVER.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[LocationType.VALUE.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

